/*
* @category    Formulario Tipo Horarios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winConsultoriosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Consultorios ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winConsultorio',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmConsultorio',
                padding: 10,
                items: [
                    {
                        html:'<img src="../../../resources/varios/hospital.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIPS',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuario',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIdConsultorio',
                                value: 0
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Descripción',
                                name: 'strDescripcion',
                                allowBlank: false,
                                emptyText: 'Digite la Descripcón del Consultorio - Ubicación',
                                id: 'strDescripcion'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Usuario',
                                name: 'sysUsuario',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Fecha Modificación',
                                name: 'sysFechaAct',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysFechaAct'
                            }
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_AdicionarHorario',
                            id: 'btn_AdicionarHorario'
                        },
                        {
                            xtype: 'button',
                            text: 'Modificar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_ModificarHorario',
                            id: 'btn_ModificarHorario'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            ref: '../btn_SalirHorario',
                            id: 'btn_SalirHorario'
                        }
                    ]
                }
            }
        ];
        winConsultoriosUi.superclass.initComponent.call(this);
    }
});
