/*
* @category    Formulario Filtro Busqueda Conceptos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFilterConceptosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: BUSCAR CONCEPTOS ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winFilterConceptos',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmFilterConceptos',
                padding: 10,
                items: [
                    {
                        html:'<img src="../../../resources/varios/search.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tipo Estudio',
                                anchor: '100%',
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                emptyText: 'Seleccionar...!',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreTipoEstudio',
                                forceSelection: false,
                                allowBlank: true,
                                id: 'strqryTipoEstudioConcepto'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tipo Registro',
                                anchor: '100%',
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                emptyText: 'Seleccionar...!',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                store: 'StoreTipoRegistroConcepto',
                                forceSelection: false,
                                allowBlank: true,
                                id: 'strqryTipoRegistroConcepto'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Clasificación',
                                anchor: '100%',
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                emptyText: 'Seleccionar...!',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                store: 'StoreClasificacionConcepto',
                                forceSelection: false,
                                allowBlank: true,
                                id: 'strqryClasificaoConcepto'
                            },
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Aplicar Búsqueda',
                            iconCls: 'btnFiltro',
                            id: 'btn_FiltroProfe'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Cancelar',
                            iconCls: 'btnCancelar',
                            id: 'btn_CancelFiltroProfe'
                        }
                    ]
                }
            }
        ];
        winFilterConceptosUi.superclass.initComponent.call(this);
    }
});
