/*
* @category    Formulario Conceptos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winConceptosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Conceptos ::.',
    width: 900,
    height: 600,
    modal: true,
    closable: false,
    id: 'winConceptos',
    initComponent: function() {
        this.items = [
            {
                xtype: 'tabpanel',
                id: 'tbOpcionesConceptos',
                activeTab: 0,
                height: 570,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Datos Básicos',
                        items:[
                            {
                                xtype: 'form',
                                frame: true,
                                anchor: '100%',
                                autoScroll: true,
                                id: 'frmConceptos',
                                padding: 10,
                                height: 540,
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: '',
                                        layout: 'form',
                                        border: false,
                                        collapseFirst: false,
                                        collapsible: false,
                                        animCollapse: false,
                                        titleCollapse: false,
                                        width: 830,
                                        autoHeight: true,
                                        id: 'fs0',
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                border: false,
                                                labelWidth: 100,
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'intIdProced',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'intUsuario',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strTipoCodificacion',
                                                        value: "CUPS"
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        frame: true,
                                                        fieldLabel: 'Codigo Interno',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 115,
                                                                maxLength: 20,
                                                                allowBlank: false,
                                                                emptyText: 'Codigo',
                                                                id: 'strCodProced'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCUPS',
                                                                value: 'CUPS:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 110,
                                                                maxLength: 20,
                                                                allowBlank: false,
                                                                emptyText: 'CUPS',
                                                                id: 'strCUPSCodigo'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysTipoRegistro',
                                                                value: 'Tipo Registro:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 135,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccione...!',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                store: 'StoreTipoRegistroConcepto',
                                                                forceSelection: false,
                                                                allowBlank: false,
                                                                id: 'intTipoRegProced'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysUtilización',
                                                                value: 'Utilización:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccione...!',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                store: 'StoreUtilizacionConcepto',
                                                                forceSelection: false,
                                                                allowBlank: false,
                                                                id: 'strUtilizacion'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysPOS',
                                                                value: '  POS:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                labelStyle: 'color: Brown;',
                                                                anchor: '100%',
                                                                value: 'true',
                                                                id: 'bolPOS'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        frame: true,
                                                        fieldLabel: 'Descripción',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                width: 485,
                                                                fieldLabel: 'Descripción',
                                                                allowBlank: false,
                                                                emptyText: 'Digite la Descripcón del Concepto',
                                                                id: 'strDesProced'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCBARRAS',
                                                                value: 'C/Barras:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 160,
                                                                allowBlank: true,
                                                                id: 'strCodigoBarras'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        frame: true,
                                                        fieldLabel: 'Tipo Estudio',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 205,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccione...!',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                store: 'StoreTipoEstudio',
                                                                forceSelection: false,
                                                                allowBlank: false,
                                                                id: 'intIdTipoEstudio'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysNivel',
                                                                value: 'Nivel:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 40,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccione...!',
                                                                valueField: 'Codigo',
                                                                displayField: 'Codigo',
                                                                store: 'StoreNivelConcepto',
                                                                forceSelection: false,
                                                                allowBlank: false,
                                                                id: 'intNivelProced'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysQX',
                                                                value: 'Es Qx?:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                labelStyle: 'color: Brown;',
                                                                anchor: '100%',
                                                                value: 'true',
                                                                tooltip: 'Es Quirurgico',
                                                                id: 'bolEsCX'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysMX',
                                                                value: 'Es Mx?:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                labelStyle: 'color: Brown;',
                                                                anchor: '100%',
                                                                value: 'true',
                                                                toolTip: 'Es Medicamento',
                                                                id: 'bolEsMX'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAnatomo',
                                                                value: 'Es Anatomopatológico?:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                labelStyle: 'color: Brown;',
                                                                anchor: '100%',
                                                                value: 'true',
                                                                id: 'bolEsAnatomo'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysLAB',
                                                                value: 'Es Laboratorio?:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                labelStyle: 'color: Brown;',
                                                                anchor: '100%',
                                                                value: 'true',
                                                                id: 'bolEsLab'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Preparación Especial',
                                                        allowBlank: true,
                                                        emptyText: 'Digite la información de la preparación especial para la prestación del servicio',
                                                        id: 'strPreparacionEspecial'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        frame: true,
                                                        fieldLabel: 'Archivo Externo',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysPrefijo',
                                                                value: 'Prefijo:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 65,
                                                                //maxLength: 5,
                                                                allowBlank: true,
                                                                id: 'strPrefijoArchivo'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysArchivo',
                                                                value: 'Archivo:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 543,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccione...!',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                store: 'StoreArchivosAnexosConceptos',
                                                                forceSelection: false,
                                                                allowBlank: true,
                                                                id: 'strArchivoPlantilla'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        frame: true,
                                                        fieldLabel: 'Cantidad Máxima',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 0,
                                                                width: 30,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intCantidadMaxSol'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysDiasReq',
                                                                value: 'Días Requeridos:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 0,
                                                                width: 30,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intMinDiasSol'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysNumeralPyP',
                                                                value: 'Numeral PyP:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 90,
                                                                allowBlank: true,
                                                                id: 'strNumeralPyP'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysNumeralOdo',
                                                                value: 'Numeral Odontología:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 90,
                                                                allowBlank: true,
                                                                id: 'strNumeralNumeralODO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCosto',
                                                                value: 'Costo:'
                                                            },
                                                            {
                                                                xtype: 'numericfield',
                                                                currencySymbol: "$",
                                                                width: 116,
                                                                useThousandSeparator: true,
                                                                alwaysDisplayDecimals: true,
                                                                thousandSeparator: ',',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                labelStyle: '',
                                                                value: 0,
                                                                id: 'intVlrCosto'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        html:'<hr>',border: false
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Quirurgico',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 830,
                                        autoHeight: true,
                                        id: 'fsQx',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysUVR',
                                                        value: 'UVR:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'intUVR'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysGrupoQX',
                                                        value: 'Grupo Qx:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'intGrupoQx'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Medicamentos',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 830,
                                        autoHeight: true,
                                        id: 'fsMx',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                fieldLabel: 'Codigo Ministerio',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        anchor: '100%',
                                                        id: 'strCodMxMinisterio'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCUM',
                                                        value: 'Codigo CUM:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strCodigoCUM'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysINVIMA',
                                                        value: 'Registro INVIMA:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strRegistroINVIMA'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Principio Activo',
                                                anchor: '100%',
                                                triggerAction: 'all',
                                                mode: 'local',
                                                typeAhead: true,
                                                emptyText: 'Seleccione...!',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                store: 'StoreMxPrincipioActivo',
                                                forceSelection: false,
                                                allowBlank: true,
                                                value: 1,
                                                id: 'intPrincipioActivo'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Presentación',
                                                anchor: '100%',
                                                triggerAction: 'all',
                                                mode: 'local',
                                                typeAhead: true,
                                                emptyText: 'Seleccione...!',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                store: 'StoreMxPresentacion',
                                                forceSelection: false,
                                                allowBlank: true,
                                                value: 1,
                                                id: 'intPresentacion'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Forma Farmac.',
                                                anchor: '100%',
                                                triggerAction: 'all',
                                                mode: 'local',
                                                typeAhead: true,
                                                emptyText: 'Seleccione...!',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                store: 'StoreMxFormaFarmaceutica',
                                                forceSelection: false,
                                                allowBlank: true,
                                                value: 1,
                                                id: 'intFormaFarmaceutica'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                fieldLabel: 'Concentración',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        width: 175,
                                                        listWidth: 350,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        emptyText: 'Seleccione...!',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        store: 'StoreMxConcentracion',
                                                        forceSelection: false,
                                                        allowBlank: true,
                                                        value: 1,
                                                        id: 'intConcentracion'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysUnidadMed',
                                                        value: 'Unidad Medida:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 170,
                                                        listWidth: 350,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        emptyText: 'Seleccione...!',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        store: 'StoreMxUnidadMedida',
                                                        forceSelection: false,
                                                        allowBlank: true,
                                                        value: 1,
                                                        id: 'intUnidadMedida'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysDosis',
                                                        value: 'Dosis Máxima Paciente:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        minValue: 0,
                                                        value: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: false,
                                                        id: 'intDosisMaxPac'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Laboratorio',
                                                anchor: '100%',
                                                triggerAction: 'all',
                                                mode: 'local',
                                                typeAhead: true,
                                                emptyText: 'Seleccione...!',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                store: 'StoreMxLaboratorio',
                                                forceSelection: false,
                                                allowBlank: true,
                                                value: 1,
                                                id: 'intLaboratorio'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Laboratorio Clínico',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 830,
                                        autoHeight: true,
                                        id: 'fsLab',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                fieldLabel: 'Interpretación',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        allowBlank: true,
                                                        width: 620,
                                                        id: 'strLabInterpretacion'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysPrintInterpreta',
                                                        value: 'Imprimir:'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        labelStyle: 'color: Brown;',
                                                        anchor: '100%',
                                                        id: 'bolLabPrintInterpretacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                fieldLabel: 'Técnica',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        allowBlank: true,
                                                        width: 620,
                                                        id: 'strLabTecnica'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysPrintInterpreta',
                                                        value: 'Imprimir:'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        labelStyle: 'color: Brown;',
                                                        anchor: '100%',
                                                        id: 'bolLabPrintTecnica'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                fieldLabel: 'Otros',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        allowBlank: true,
                                                        width: 620,
                                                        id: 'strLabOtros'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysPrintInterpreta',
                                                        value: 'Imprimir:'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        labelStyle: 'color: Brown;',
                                                        anchor: '100%',
                                                        id: 'bolLabPrintOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'checkbox',
                                                anchor: '100%',
                                                fieldLabel: 'Formato 2 Columnas',
                                                id: 'bolLabFormato2Cols'
                                            }
                                        ]
                                    }
                                ],
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_AdicionarItemFrm'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_ModificarItemFrm'
                                        }
                                    ]
                                }
                            }
                        ]
                    }/*,
                    {
                        xtype: 'panel',
                        title: 'Plantilla Resultados Laboratorio Clínico',
                        items:[
                        ]
                    }*/
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirItemFrm'
                        }
                    ]
                }
            }
        ];
        winConceptosUi.superclass.initComponent.call(this);
    }
});
