/*
* @category    Formulario Lotes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winLotesUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Lotes ::.',
    width: 600,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winLotesUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmLotes',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdLote',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIdProcedLote',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioLote',
                                value: 0
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                fieldLabel: 'Nro Lote',
                                name: 'strLote',
                                allowBlank: false,
                                id: 'strLote'
                            },
                            {
                                xtype: 'datefield',
                                fieldLabel: 'Fecha Vencimiento',
                                width: 110,
                                name: 'fecFecVencimiento',
                                allowBlank: false,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecFecVencimiento'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AdicionarLote',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmLotes').getForm();
                                    if (frm.isValid()){
                                        frm.submit({
                                            url: '../../controlador/inventario/controlador_inventario.php',
                                            params: {
                                                task: 'ADD_LOTE',
                                                pEmpresa: ID_EMPRESA,
                                                pIPS: ID_IPS,
                                                pUsuario: ID_USUARIO,
                                                pConcepto: Ext.getCmp('intIdProcedLote').getValue(),
                                                pLote: QuitarAcentosMayusculas(Ext.getCmp('strLote').getValue()),
                                                pVencimiento: Ext.getCmp('fecFecVencimiento').getValue().format("Y-m-d")
                                            },
                                            success: function(res,req)
                                            {
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        Ext.getCmp('gridLotesxConcepto').store.reload();
                                                        Ext.getCmp('winLotesUi').close();
                                                        Ext.MessageBox.show({
                                                            title: 'Lotes',
                                                            msg: 'Se Adiciono el Lote con Exito.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'Lotes',
                                                            msg: 'Ocurrio un error al adicionar el lote o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos adicionar el lote en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Los campos son Requeridos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirLote',
                            listeners: {
                                click: function(){
                                    Ext.getCmp('winLotesUi').close();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winLotesUi.superclass.initComponent.call(this);
    }
});
