/*
* @category    Formulario Grid Maestro Conceptos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmMaestroConceptosUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Maestro Conceptos ::.',
    id: 'winFrmMaestroConceptos',
    closable:false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    layout: 'fit',
    initComponent: function() {
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };

        function DescripcionConcepto(val, x, store){
            var html = '<table><tr><td>'+val+'</td></tr></table>';
            return html;
        }

        Ext.apply(Ext.form.VTypes,{
            exclusionNotZero: function(val, field){
                try{
                    if (val < 1){
                        return false;
                    } else {
                        field.clearInvalid();
                        return true;
                    }
                }catch(e){
                    return false;
                }
            },
            exclusionNotZeroText: 'No puede tener valor cero!'
        });
        
        var mybbar = new utilBbarUi();
        var stGrid = new StoreGridMaestroConceptos();
        
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'hidden',
                id: 'sysTipoEstudioConcepto',
                value: "Todos"
            },
            {
                xtype: 'hidden',
                id: 'sysTipoRegistroConcepto',
                value: 'Todos'
            },
            {
                xtype: 'hidden',
                id: 'sysClasificaoConcepto',
                value: 'Todos'
            },
            {
                xtype: 'grid',
                id: 'gridFormulario',
                store: stGrid,
                anchor: "100%",
                height: 430,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'IdProced',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'IdProced',
                        width: 10,
                        hidden: true,
                        hideable: false
                    },{
                        header: 'Tipo Estudio',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'TipoEstudio',
                        width: 10,
                        hidden: true,
                        hideable: false
                    },{
                        header: 'Tipo Registro',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'fTipoRegistro',
                        width: 10,
                        hidden: true,
                        hideable: false
                    },{
                        header: 'Clasificacion',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'fClasificacion',
                        width: 10,
                        hidden: true,
                        hideable: false
                    },{
                        header: 'Codigo',
                        dataIndex: 'CodProced',
                        sortable: true,
                        locked: true,
                        width: 120
                    },{
                        header: 'CUPS',
                        dataIndex: 'CUPSCodigo',
                        sortable: true,
                        locked: true,
                        width: 120
                    },{
                        header: 'Descripción',
                        dataIndex: 'DesProced',
                        sortable: true,
                        locked: true,
                        renderer: DescripcionConcepto,
                        width: 650
                    },{
                        header: 'Nivel',
                        dataIndex: 'NivelProced',
                        sortable: true,
                        locked: true,
                        width: 40
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                iconCls:'icon-grid',
                view: new Ext.grid.GroupingView({
                //view: new Ext.ux.grid.LockingGridView({
                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                    getRowClass: function(record, index, rowParams, store){
                        var estado = record.data.Activo;
                        switch (estado)
                        {
                            case "NO":
                                return 'NoActivo';
                                break;
                            default:
                                break;
                        }
                    }
                }),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'cycle',
                                prependText: 'Vista por: ',
                                iconCls: 'btnGrouping',
                                showText: true,
                                items: [
                                    {
                                        xtype: 'menucheckitem',
                                        id: 'btnGrouping1',
                                        text: 'Tipo Estudio',
                                        checked: true
                                    },
                                    {
                                        xtype: 'menucheckitem',
                                        id: 'btnGrouping2',
                                        text: 'Tipo Clasificación'
                                    },
                                    {
                                        xtype: 'menucheckitem',
                                        id: 'btnGrouping3',
                                        text: 'Tipo Registro'
                                    }
                                ]
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Adicionar',
                                iconCls: 'btnAddRow',
                                ref: '../btnAddItemGrid',
                                id: 'btnAddItemGrid'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Modificar',
                                iconCls: 'btnEditRow',
                                ref: '../btnEditItemGrid',
                                id: 'btnEditItemGrid'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar',
                                iconCls: 'btnDelRow',
                                ref: '../btnDelItemGrid',
                                id: 'btnDelItemGrid'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Búsqueda Avanzada',
                                iconCls: 'btnFiltro',
                                ref: '../btnFilterItemGrid',
                                id: 'btnFilterItemGrid'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnNoFiltro',
                                text: 'Quitar Búsqueda Avanzada',
                                ref: '../btnNoFilterItemGrid',
                                id: 'btnNoFilterItemGrid'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            new Ext.app.SearchField({
                                id: 'qryConceptos',
                                store: stGrid,
                                emptyText: 'Escriba el criterio que desea buscar',
                                width: 120
                            })
                        ]
                    },
                bbar: new Ext.PagingToolbar({
                    pageSize: 15,
                    store: stGrid,
                    displayInfo: true
                })
            }
        ];
        winFrmMaestroConceptosUi.superclass.initComponent.call(this);
    }
});
