/*
* @category    Programacion Eventos Formulario Clientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmClientes = Ext.extend(winFrmClientesUi, {
    initComponent: function() {
        winFrmClientes.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        ID_CONSULTORIO = el.getValue();
        this.title = NOM_APLICACION + " .:: Maestro Clientes, Proveedores, Terceros ::.";
        
        ID_PLAN_SELECCIONADO = 0;
        NOM_PLAN_SELECCIONADO = " ";
        ID_CLIENTE_EDIT = 0;
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        Ext.getCmp('gridFormulario').store.load({params: {query: null, pEmpresa: ID_EMPRESA, start: 0, limit: 15}});
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnAddItemGrid = Ext.getCmp('btnAddItemGrid').on("click",this.AddItemGrid,this);
        var btnDelItemGrid = Ext.getCmp('btnDelItemGrid').on("click",this.DelItemGrid,this);
        var btnEditItemGrid = Ext.getCmp('btnEditItemGrid').on("click",this.EditItemGrid,this);

        //var btnExcelItems = Ext.getCmp('btnExcelItems').on("click",this.ExcelGrid,this);
        //var btnImprimirItems = Ext.getCmp('btnImprimirItems').on("click",this.ImprimirGrid,this);
        Ext.getCmp('gridFormulario').store.setBaseParam('pEmpresa', ID_EMPRESA);
        
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    AddItemGrid: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddClientes";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            var winClientes = new winClientesUi();
            winClientes.title = NOM_APLICACION + ' .::Adicionar Clientes::.';
            Ext.getCmp('btn_AdicionarItemFrm').setVisible(true);
            Ext.getCmp('btn_ModificarItemFrm').setVisible(false);
            Ext.getCmp('bolActivo').setValue("true");
            Ext.getCmp('intUsuario').setValue(ID_USUARIO);
            Ext.getCmp('intPrestador').setValue(ID_EMPRESA);
            Ext.getCmp('tbOpcionesProfesionales').setVisible(false);
            
            var btn_AdicionarItemFrm = Ext.getCmp('btn_AdicionarItemFrm').on("click",this.GuardarItem,this);
            var btn_SalirItemFrm = Ext.getCmp('btn_SalirItemFrm').on("click",this.CerrarVentana,this);
            winClientes.show();
        }
    },
    GuardarItem: function(){ //ok
        Ext.Msg.show({
            title: 'Guardar Clientes, Proveedores, Terceros',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR","SI","winClientesUi","frmClientes","../../controlador/clientes/controlador_clientes2013.php","gridFormulario");
                }
            }
        });
    },
    EditItemGrid: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditClientes";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - Modificar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
                ID_CLIENTE_EDIT = selections[0].json.idrecord;
                var winClientes = new winClientesUi();
                winClientes.title = NOM_APLICACION + ' .::Modificar Clientes::.';
                Ext.getCmp('btn_AdicionarItemFrm').setVisible(false);
                Ext.getCmp('btn_ModificarItemFrm').setVisible(true);
                Ext.getCmp('intUsuario').setValue(ID_USUARIO);
                Ext.getCmp('intIdCliente').setValue(selections[0].json.IdCliente);
                Ext.getCmp('intPrestador').setValue(selections[0].json.Prestador);
                
                Ext.getCmp('strCodigo').setValue(PonerAcentosMayusculas(selections[0].json.Codigo));
                Ext.getCmp('strCodigoRapido').setValue(PonerAcentosMayusculas(selections[0].json.CodRapido));
                Ext.getCmp('strTipoCliente').setValue(selections[0].json.Tipo);
                Ext.getCmp('strClaseCliente').setValue(selections[0].json.Clase);
                Ext.getCmp('strTdoc').setValue(selections[0].json.Tdoc);
                Ext.getCmp('strDocumento').setValue(PonerAcentosMayusculas(selections[0].json.Documento));
                Ext.getCmp('strDigitover').setValue(selections[0].json.Digitover);
                Ext.getCmp('strCodigoSUPERSALUD').setValue(PonerAcentosMayusculas(selections[0].json.CodigoSUPERSALUD));
                Ext.getCmp('strTipoAfiliado').setValue(selections[0].json.TipoAfiliado);
                Ext.getCmp('strDescripcion').setValue(PonerAcentosMayusculas(selections[0].json.Descripcion));
                Ext.getCmp('strDescripcionFac').setValue(PonerAcentosMayusculas(selections[0].json.DescripcionFac));
                Ext.getCmp('strDireccion').setValue(PonerAcentosMayusculas(selections[0].json.Direccion));
                Ext.getCmp('strTelefono').setValue(PonerAcentosMayusculas(selections[0].json.Telefono));
                Ext.getCmp('strEmail').setValue(PonerAcentosMayusculas(selections[0].json.Email));
                
                if (selections[0].json.FacturarPaciente == "1")
                    Ext.getCmp('bolFacturarPaciene').setValue("true");
                else
                    Ext.getCmp('bolFacturarPaciene').setValue(null);
                
                if (selections[0].json.FacturarParticular == "1")
                    Ext.getCmp('bolFacturarParticular').setValue("true");
                else
                    Ext.getCmp('bolFacturarParticular').setValue(null);
                
                if (selections[0].json.RecaudoAutomaticoParticulares == "1")
                    Ext.getCmp('bolRdoAutomaticoParticular').setValue("true");
                else
                    Ext.getCmp('bolRdoAutomaticoParticular').setValue(null);
                
                if (selections[0].json.FacturarCopagos == "1")
                    Ext.getCmp('bolFacturarCopagos').setValue("true");
                else
                    Ext.getCmp('bolFacturarCopagos').setValue(null);

                if (selections[0].json.CopagoDigitado == "1")
                    Ext.getCmp('bolCopagoDigitado').setValue("true");
                else
                    Ext.getCmp('bolCopagoDigitado').setValue(null);
                
                if (selections[0].json.UsaListadoAtencion == "1")
                    Ext.getCmp('bolUsaListadoAtencion').setValue("true");
                else
                    Ext.getCmp('bolUsaListadoAtencion').setValue(null);
                
                if (selections[0].json.AtenderFueraListado == "1")
                    Ext.getCmp('bolAtenderFueraListado').setValue("true");
                else
                    Ext.getCmp('bolAtenderFueraListado').setValue(null);
                
                if (selections[0].json.UsaMultas == "1")
                    Ext.getCmp('bolUsaMultas').setValue("true");
                else
                    Ext.getCmp('bolUsaMultas').setValue(null);
                
                if (selections[0].json.UsaAuditoria == "1")
                    Ext.getCmp('bolUsaAuditoria').setValue("true");
                else
                    Ext.getCmp('bolUsaAuditoria').setValue(null);
                
                if (selections[0].json.RequiereAutorizacion == "1")
                    Ext.getCmp('bolRequiereAutorizacion').setValue("true");
                else
                    Ext.getCmp('bolRequiereAutorizacion').setValue(null);
                
                if (selections[0].json.RecaudoMedicamentos == "1")
                    Ext.getCmp('bolRecaudoMedicamentos').setValue("true");
                else
                    Ext.getCmp('bolRecaudoMedicamentos').setValue(null);
                
                if (selections[0].json.RecaudoRemisiones == "1")
                    Ext.getCmp('bolRecaudoRemisiones').setValue("true");
                else
                    Ext.getCmp('bolRecaudoRemisiones').setValue(null);
                
                if (selections[0].json.RecaudoOrdenamientos == "1")
                    Ext.getCmp('bolRecaudoOrdenamientos').setValue("true");
                else
                    Ext.getCmp('bolRecaudoOrdenamientos').setValue(null);
                
                if (selections[0].json.Activo == "SI")
                    Ext.getCmp('bolActivo').setValue("true");
                else
                    Ext.getCmp('bolActivo').setValue(null);
                
                Ext.getCmp('gridPlanesCliente').store.load({
                    params: {
                        pidCliente: selections[0].json.IdCliente
                    }
                });
                
                Ext.getCmp('gridContratoCliente').store.load({
                    params: {
                        pCliente: selections[0].json.IdCliente
                    }
                });
                   
                Ext.getCmp('gridIPSCliente').store.load({
                    params: {
                        pCliente: selections[0].json.IdCliente
                    }
                });
                
                Ext.getCmp('gridTarifasCliente').store.load({
                    params: {
                        pCliente: selections[0].json.IdCliente
                    }
                });
                
                var btn_ModificarItemFrm = Ext.getCmp('btn_ModificarItemFrm').on("click",this.ModificarItem,this);
                var btn_SalirItemFrm = Ext.getCmp('btn_SalirItemFrm').on("click",this.CerrarVentana,this);
                var btnAddPlan = Ext.getCmp('btnAddPlan').on("click",this.AdiconarItemGridPlan,this);
                var btnEditPlan = Ext.getCmp('btnEditPlan').on("click",this.EditItemGridPlan,this);
                var btnDelPlan = Ext.getCmp('btnDelPlan').on("click",this.DelItemGridPlan,this);
                var gridPlanesCliente = Ext.getCmp('gridPlanesCliente').on("rowclick",this.SeleccionarPlanesCliente,this);
                var btnAddSubPlan = Ext.getCmp('btnAddSubPlan').on("click",this.AdiconarItemGridSubPlan,this);
                var btnEditSubPlan = Ext.getCmp('btnEditSubPlan').on("click",this.EditItemGridSubPlan,this);
                var btnDelSubPlan = Ext.getCmp('btnDelSubPlan').on("click",this.DelItemGridSubPlan,this);
                var btnAddContrato = Ext.getCmp('btnAddContrato').on("click",this.AdiconarItemGridContrato,this);
                var btnEditContrato = Ext.getCmp('btnEditContrato').on("click",this.EditItemGridContrato,this);
                var btnDelContrato = Ext.getCmp('btnDelContrato').on("click",this.DelItemGridContrato,this);
                var btnAddIPS = Ext.getCmp('btnAddIPS').on("click",this.AdicionarItemGridIPS,this);
                var btnDelIPS = Ext.getCmp('btnDelIPS').on("click",this.DelItemGridIPS,this);
                var btnAddTarifa = Ext.getCmp('btnAddTarifa').on("click",this.AdicionarItemGridTarifa,this);
                var btnDelTarifa = Ext.getCmp('btnDelTarifa').on("click",this.DelItemGridTarifa,this);
                var btnUpdateTarifa = Ext.getCmp('btnUpdateTarifa').on("click",this.UpdateMatrizTarifa,this);
                
                Ext.getCmp('tbMatrizAuditoria').disable();
                Ext.getCmp('tbMatrizAuditoria').setVisible(false);
                Ext.getCmp('tbProveedores').disable();
                
                winClientes.show();
            }
        }
    },
    UpdateMatrizTarifa: function(){
        Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro de usar esta opcion? Recuerde que esta opción permite actualizar nuevamente la matriz de tarifas, esto puede tomar unos minutos. Se recomienda que mientras el proceso termina nadie este trabajando en el sistema',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        Ext.Ajax.request(
                        {
                            url: '../../controlador/manualtarifario/controlador_manualtarifario.php',
                            waitMsg: 'Actualizando Matriz de Tarifas.......!',
                            params:{
                                task: 'TARIFAS_ACTUALIZAR_MATRIZ',
                                pCliente: Ext.getCmp('intIdCliente').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                Ext.MessageBox.show({
                                    title: 'eOfiClinic',
                                    msg: 'Se Actualio la matriz con exito.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.INFO
                                });
                            },
                            failure: function(response,options){
                                /*Ext.MessageBox.show({
                                    title: 'Error Conexión',
                                    msg: 'No podemos realizar la accion en estos momentos y/o No se pudo establecer conexión con el servidor',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });*/
                                Ext.MessageBox.show({
                                    title: 'eOfiClinic',
                                    msg: 'Se Actualio la matriz con exito.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.INFO
                                });
                            },
                            scope:this 
                        });
                    }
                }
            });
    },
    ModificarItem: function(){ //0k
        Ext.Msg.show({
            title: 'Guardar Clientes, Proveedores, Terceros',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR","SI","winClientesUi","frmClientes","../../controlador/clientes/controlador_clientes2013.php","gridFormulario");
                }
            }
        });
    },
    DelItemGrid: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelClientes";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Profesionales',
                    msg: 'Esta Seguro que Desea Eliminar el Cliente ' + PonerAcentosMayusculas(selections[0].json.Descripcion) + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/clientes/controlador_clientes.php",{task: "ELIMINAR", pidCliente: selections[0].json.IdCliente}, 'gridFormulario')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    SeleccionarPlanesCliente: function(grid, fila, e){ // ok
         var selections = grid.selModel.getSelections();
         Ext.getCmp('gridSubPlanesCliente').store.load({
            params: {
                pPlan: selections[0].json.IdPlan
            }
        });
        ID_PLAN_SELECCIONADO = selections[0].json.IdPlan;
        NOM_PLAN_SELECCIONADO = PonerAcentosMayusculas(selections[0].json.Descripcion);
    },
    AdiconarItemGridPlan: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddPlan_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - Plan - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('intIdCliente').getValue() == 0 && Ext.getCmp('intIdCliente').getValue() == null)
            {
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El cliente no ha sido creado o no esta disponible',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }else{
                var winAddClientePlan = new winAddClientePlanUi();
                winAddClientePlan.title = NOM_APLICACION + ' .::Asociar Planes::.';
                Ext.getCmp('btnModificarPlan').setVisible(false);
                Ext.getCmp('btnGuardarPlan').setVisible(true);
                var btnGuardarPlan = Ext.getCmp('btnGuardarPlan').on("click",this.GuardarGridPlan,this);
                Ext.getCmp('IdClienteGridPlan').setValue(Ext.getCmp('intIdCliente').getValue());
                Ext.getCmp('bolActivoGridPlan').setValue(true);
                Ext.getCmp('intidUsuarioGridPlan').setValue(ID_USUARIO);
                winAddClientePlan.show();
            }
        }
    },
    EditItemGridPlan: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditPlan_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - Plan - Modificar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridPlanesCliente').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridPlanesCliente').selModel.getSelections();
                var winAddClientePlan = new winAddClientePlanUi();
                winAddClientePlan.title = NOM_APLICACION + ' .::Asociar Planes::.';
                Ext.getCmp('btnModificarPlan').setVisible(true);
                Ext.getCmp('btnGuardarPlan').setVisible(false);
                var btnModificarPlan = Ext.getCmp('btnModificarPlan').on("click",this.ModificarGridPlan,this);
                
                Ext.getCmp('IdClienteGridPlan').setValue(selections[0].json.IdCliente);
                Ext.getCmp('IdPlanGridPlan').setValue(selections[0].json.IdPlan);
                Ext.getCmp('strDescripcionGridPlan').setValue(PonerAcentosMayusculas(selections[0].json.Descripcion));
                Ext.getCmp('strCodRapidoGridPlan').setValue(PonerAcentosMayusculas(selections[0].json.CodRapido));
                if(selections[0].json.ExentoCobro == "SI"){
                    Ext.getCmp('bolExentoGridPlan').setValue(true);
                }
                if(selections[0].json.Activo == "SI"){
                    Ext.getCmp('bolActivoGridPlan').setValue(true);
                }
                if(selections[0].json.AsignarCita == "SI"){
                    Ext.getCmp('bolAsignarCitaGridPlan').setValue(true);
                }
                Ext.getCmp('intidUsuarioGridPlan').setValue(ID_USUARIO);
                winAddClientePlan.show();
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'Debe seleccionar un Plan',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    GuardarGridPlan: function(){ //ok
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea guardar la información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR_GRID_PLANES","SI","winAddClientePlanUi","frmAddClientePlan","../../controlador/clientes/controlador_clientes2013.php","gridPlanesCliente");
                }
            }
        });
    },
    ModificarGridPlan: function(){ //ok
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea guardar la información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR_GRID_PLANES","SI","winAddClientePlanUi","frmAddClientePlan","../../controlador/clientes/controlador_clientes2013.php","gridPlanesCliente");
                }
            }
        });
    },
    DelItemGridPlan: function(){ //ok
        //Eliminar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelPlan_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - Plan - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridPlanesCliente').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridPlanesCliente').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Planes',
                    msg: 'Esta Seguro que Desea Eliminar el Plan ' + PonerAcentosMayusculas(selections[0].json.Descripcion) + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/clientes/controlador_clientes.php",{task: "ELIMINAR_GRID_PLANES", pCliente: selections[0].json.IdCliente, pPlan: selections[0].json.IdPlan}, 'gridPlanesCliente')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    AdiconarItemGridSubPlan: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddSubPlan_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - SubPlan - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('intIdCliente').getValue() == 0 || Ext.getCmp('intIdCliente').getValue() == null || ID_PLAN_SELECCIONADO == 0)
            {
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El Cliente y/o Plan no ha sido creado o no esta disponible',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }else{
                var winAddClienteSubPlan = new winAddClienteSubPlanUi();
                winAddClienteSubPlan.title = NOM_APLICACION + ' .::Asociar SubPlanes al PLAN: ' + NOM_PLAN_SELECCIONADO + '::.';
                Ext.getCmp('btnModificarSubPlan').setVisible(false);
                Ext.getCmp('btnGuardarSubPlan').setVisible(true);
                var btnGuardarPlan = Ext.getCmp('btnGuardarSubPlan').on("click",this.GuardarGridSubPlan,this);
                Ext.getCmp('intIdPlanGridSubPlan').setValue(ID_PLAN_SELECCIONADO);
                Ext.getCmp('bolActivoGridSubPlan').setValue(true);
                Ext.getCmp('intidUsuarioGridSubPlan').setValue(ID_USUARIO);
                winAddClienteSubPlan.show();
            }
        }
    },
    GuardarGridSubPlan: function(){ //ok
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea guardar la información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR_GRID_SUBPLANES","SI","winAddClienteSubPlanUi","frmAddClienteSubPlan","../../controlador/clientes/controlador_clientes2013.php","gridSubPlanesCliente");
                }
            }
        });
    },
    EditItemGridSubPlan: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditSubPlan_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - SubPlan - Modificar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridSubPlanesCliente').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridSubPlanesCliente').selModel.getSelections();
                var winAddClienteSubPlan = new winAddClienteSubPlanUi();
                winAddClienteSubPlan.title = NOM_APLICACION + ' .::Modificar SubPlanes al PLAN: ' + NOM_PLAN_SELECCIONADO + '::.';
                Ext.getCmp('btnModificarSubPlan').setVisible(true);
                Ext.getCmp('btnGuardarSubPlan').setVisible(false);
                var btnModificarSubPlan = Ext.getCmp('btnModificarSubPlan').on("click",this.ModificarGridSubPlan,this);
                Ext.getCmp('intIdPlanGridSubPlan').setValue(selections[0].json.IdPlan);
                Ext.getCmp('intIdSubPlanGridSubPlan').setValue(selections[0].json.IdSubPlan);
                Ext.getCmp('intidUsuarioGridSubPlan').setValue(ID_USUARIO);
                
                Ext.getCmp('strCodRapidoGridSubPlan').setValue(PonerAcentosMayusculas(selections[0].json.CodRapido));
                Ext.getCmp('strDescripcionGridSubPlan').setValue(PonerAcentosMayusculas(selections[0].json.Descripcion));
                
                if(selections[0].json.FacturarProcOdo == "SI"){
                    Ext.getCmp('bolFacturarProcOdoGridSubPlan').setValue(true);
                }
                
                if(selections[0].json.FacturarProcMed == "SI"){
                    Ext.getCmp('bolFacturarProcMedGridSubPlan').setValue(true);
                }
                
                if(selections[0].json.FacturarActPyP == "SI"){
                    Ext.getCmp('bolFacturarActPyPGridSubPlan').setValue(true);
                }
                
                if(selections[0].json.FacturarActMed == "SI"){
                    Ext.getCmp('bolFacturarActMedGridSubPlan').setValue(true);
                }
                if(selections[0].json.AsignarCita == "SI"){
                    Ext.getCmp('bolAsignarCitaGridSubPlan').setValue(true);
                }
                if(selections[0].json.Activo == "SI"){
                    Ext.getCmp('bolActivoGridSubPlan').setValue(true);
                }
                winAddClienteSubPlan.show();
                
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'Debe seleccionar un Plan',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    ModificarGridSubPlan: function(){ //ok
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea guardar la información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR_GRID_SUBPLANES","SI","winAddClienteSubPlanUi","frmAddClienteSubPlan","../../controlador/clientes/controlador_clientes2013.php","gridSubPlanesCliente");
                }
            }
        });
    },
    DelItemGridSubPlan: function(){ //ok
        //Eliminar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelSubPlan_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - SubPlan - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridSubPlanesCliente').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridSubPlanesCliente').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Planes',
                    msg: 'Esta Seguro que Desea Eliminar el SubPlan ' + PonerAcentosMayusculas(selections[0].json.Descripcion) + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/clientes/controlador_clientes.php",{task: "ELIMINAR_GRID_SUBPLANES", pPlan: selections[0].json.IdPlan, pSubPlan: selections[0].json.IdSubPlan}, 'gridSubPlanesCliente')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    AdiconarItemGridContrato: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddContrato_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - Contrato - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('intIdCliente').getValue() == 0 || Ext.getCmp('intIdCliente').getValue() == null)
            {
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El Cliente no ha sido creado o no esta disponible',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }else{
                var winAddContrato = new winAddContratoUi();
                winAddContrato.title = NOM_APLICACION + ' .::Asociar Contratos::.';
                Ext.getCmp('btnModificarContrato').setVisible(false);
                Ext.getCmp('btnGuardarContrato').setVisible(true);
                var btnGuardarContrato = Ext.getCmp('btnGuardarContrato').on("click",this.GuardarGridContrato,this);
                Ext.getCmp('IdIdClienteGrid').setValue(Ext.getCmp('intIdCliente').getValue());
                Ext.getCmp('bolActivoGrid').setValue(true);
                Ext.getCmp('intidUsuarioGrid').setValue(ID_USUARIO);
                winAddContrato.show();
            }
        }
    },
    GuardarGridContrato: function(){ //ok
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea guardar la información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR_GRID_CONTRATOS","SI","winAddContratoUi","frmAddContrato","../../controlador/clientes/controlador_clientes2013.php","gridContratoCliente");
                }
            }
        });
    },
    EditItemGridContrato: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditContrato_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - Contrato - Modificar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridContratoCliente').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridContratoCliente').selModel.getSelections();
                var winAddContrato = new winAddContratoUi();
                winAddContrato.title = NOM_APLICACION + ' .::Modificar Contratos::.';
                Ext.getCmp('btnModificarContrato').setVisible(true);
                Ext.getCmp('btnGuardarContrato').setVisible(false);
                var btnModificarContrato = Ext.getCmp('btnModificarContrato').on("click",this.ModificarGridContrato,this);
                Ext.getCmp('IdIdClienteGrid').setValue(selections[0].json.IdCliente);
                Ext.getCmp('IdIdContratoGrid').setValue(selections[0].json.IdContrato);
                Ext.getCmp('intidUsuarioGrid').setValue(ID_USUARIO);
                Ext.getCmp('strCodRapidoContratoGrid').setValue(PonerAcentosMayusculas(selections[0].json.CodRapido));
                Ext.getCmp('strNroContratoGrid').setValue(PonerAcentosMayusculas(selections[0].json.NroContrato));
                Ext.getCmp('strDescripcionGrid').setValue(PonerAcentosMayusculas(selections[0].json.Descripcion));
                Ext.getCmp('fecFecDesdeGrid').setValue(selections[0].json.FecDesde);
                Ext.getCmp('fecFecHastaGrid').setValue(selections[0].json.FecHasta);
                Ext.getCmp('intVlrTotalGrid').setValue(selections[0].json.VlrTotal);
                Ext.getCmp('intVlrAlertaGrid').setValue(selections[0].json.VlrAlerta);
                Ext.getCmp('intDiasVenceFacGrid').setValue(selections[0].json.DiasVenceFac);
                if(selections[0].json.AsignarCita == "SI"){
                    Ext.getCmp('bolAsignarCitaGrid').setValue(true);
                }
                if(selections[0].json.Activo == "SI"){
                    Ext.getCmp('bolActivoGrid').setValue(true);
                }
                winAddContrato.show();
                
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'Debe seleccionar un Contrato',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    ModificarGridContrato: function(){ //ok
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea guardar la información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR_GRID_CONTRATOS","SI","winAddContratoUi","frmAddContrato","../../controlador/clientes/controlador_clientes2013.php","gridContratoCliente");
                }
            }
        });
    },
    DelItemGridContrato: function(){ //ok
        //Eliminar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelContrato_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - Contrato - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridContratoCliente').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridContratoCliente').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Planes',
                    msg: 'Esta Seguro que Desea Eliminar el Contrato ' + PonerAcentosMayusculas(selections[0].json.NroContrato) + ' - ' + PonerAcentosMayusculas(selections[0].json.Descripcion) + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/clientes/controlador_clientes.php",{task: "ELIMINAR_GRID_CONTRATOS", pCliente: selections[0].json.IdCliente, pContrato: selections[0].json.IdContrato}, 'gridContratoCliente')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    AdicionarItemGridIPS: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddIPS_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - IPS - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('intIdCliente').getValue() == 0 || Ext.getCmp('intIdCliente').getValue() == null)
            {
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El Cliente no ha sido creado o no esta disponible',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }else{
                var winAddClienteIPS = new winAddClienteIPSUi();
                winAddClienteIPS.title = NOM_APLICACION + ' .::Asociar IPS::.';
                Ext.getCmp('btnModificarIPS').setVisible(false);
                Ext.getCmp('btnGuardarIPS').setVisible(true);
                var btnGuardarIPS = Ext.getCmp('btnGuardarIPS').on("click",this.GuardarGridIPS,this);
                var sysSede = Ext.getCmp('sysSede').on("change",this.ValidarSede,this);
                Ext.getCmp('IdClienteGridIPS').setValue(Ext.getCmp('intIdCliente').getValue());
                Ext.getCmp('bolActivoGridIPS').setValue(true);
                Ext.getCmp('intidUsuarioGridIPS').setValue(ID_USUARIO);
                Ext.getCmp('sysSede').store.load({
                    params: {
                        pEmpresa: ID_EMPRESA
                    }
                });
                winAddClienteIPS.show();
            }
        }
    },
    ValidarSede: function( f, newvalue, oldvalue ){
        if(newvalue != null && newvalue != "" && newvalue != oldvalue){
            Ext.getCmp('intidIPSGridIPS').store.load({
                params: {
                    pSede: newvalue
                },
                callback: function(r,o,s){
                    Ext.getCmp('intidIPSGridIPS').enable();
                }
             });
        }
    },
    GuardarGridIPS: function(){ //ok
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea guardar la información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("ASOCIAR_GRID_IPS","SI","winAddClienteIPSUi","frmAddClienteIPS","../../controlador/clientes/controlador_clientes.php","gridIPSCliente");
                }
            }
        });
    },
    DelItemGridIPS: function(){ //ok
        //Eliminar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelIPS_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - IPS - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridIPSCliente').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridIPSCliente').selModel.getSelections();
                Ext.Msg.show({
                    title: 'IPS',
                    msg: 'Esta Seguro que Desea Eliminar el Contrato ' + PonerAcentosMayusculas(selections[0].json.Descripcion) + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/clientes/controlador_clientes.php",{task: "DESASOCIAR_GRID_IPS", pCliente: selections[0].json.IdCliente, pIPS: selections[0].json.IdSede}, 'gridIPSCliente')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    
    
    AdicionarItemGridTarifa: function(){ //ok
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddTarifas_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - Tarifas - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('intIdCliente').getValue() == 0 || Ext.getCmp('intIdCliente').getValue() == null)
            {
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El Cliente no ha sido creado o no esta disponible',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }else{
                var winAddClienteTarifas = new winAddClienteTarifasUi();
                winAddClienteTarifas.title = NOM_APLICACION + ' .::Asociar Tarifas::.';
                Ext.getCmp('fsTarifaTipoEstudio').setVisible(false);
                Ext.getCmp('fsTarifaConcepto').setVisible(false);
                Ext.getCmp('intIdPrestadorGridTarifa').setValue(ID_EMPRESA);
                Ext.getCmp('intIdClienteGridTarifa').setValue(Ext.getCmp('intIdCliente').getValue());
                Ext.getCmp('bolActivoGridTarifa').setValue(true);
                Ext.getCmp('intidUsuarioGridTarifa').setValue(ID_USUARIO);
                var btnGuardarTarifa = Ext.getCmp('btnGuardarTarifa').on("click",this.GuardarGridTarifa,this);
                Ext.getCmp('btnModificarTarifa').setVisible(false);
                Ext.getCmp('btnGuardarTarifa').setVisible(true);
                Ext.getCmp('intIdPlanGridTarifa').store.load({
                    params:{
                        pCliente: Ext.getCmp('intIdCliente').getValue()
                    },
                    callback: function(){
                        winAddClienteTarifas.show();
                    }
                });
            }
        }
    },
    GuardarGridTarifa: function(){ //ok
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea guardar la información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("ASOCIAR_GRID_TARIFAS","SI","winAddClienteTarifasUi","frmAddClienteTarifas","../../controlador/clientes/controlador_clientes.php","gridTarifasCliente");
                }
            }
        });
    },
    DelItemGridTarifa: function(){ //ok
        //Eliminar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelTarifas_Cliente";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Clientes - IPS - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridTarifasCliente').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridTarifasCliente').selModel.getSelections();
                Ext.Msg.show({
                    title: 'IPS',
                    msg: 'Esta Seguro que Desea Eliminar la Tarifa?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/clientes/controlador_clientes.php",{task: "DESASOCIAR_GRID_TARIFAS", pRegistroTarifa: selections[0].json.IdRegistroTarifa}, 'gridTarifasCliente')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    
    CerrarVentana: function(){
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winClientesUi').close();
                }
            }
        });
    }
});


function fnEliminarRegistros(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
