/*
* @category    Formulario Adicionar Tarifas x Cliente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddClienteTarifasUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Tarifas - Clientes ::.',
    width: 900,
    height: 320,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddClienteTarifasUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                height: 280,
                id: 'frmAddClienteTarifas',
                padding: 10,
                labelWidth: 210,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intIdPrestadorGridTarifa'
                    },
                    {
                        xtype: 'hidden',
                        id: 'intIdClienteGridTarifa'
                    },
                    {
                        xtype: 'hidden',
                        id: 'intidUsuarioGridTarifa'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Plan',
                        anchor: '100%',
                        listWidth: 450,
                        allowBlank: true,
                        mode: 'local',
                        store: 'StoreClientesPlan',
                        valueField: 'IdPlan',
                        displayField: 'Descripcion',
                        typeAhead: true,
                        triggerAction: 'all',
                        typeAheadDelay: 50,
                        emptyText: 'Selecione Plan....',
                        forceSelection: true,
                        id: 'intIdPlanGridTarifa',
                        listeners:{
                            select : function(cmb, rec, idx){
                                Ext.getCmp('intIdSubPlanGridTarifa').setValue(null);
                                Ext.getCmp('intIdSubPlanGridTarifa').store.load({
                                    params: {
                                        pPlan: 0
                                    }
                                });
                                if (cmb.getValue() != null && cmb.getValue() != ""){
                                     Ext.getCmp('intIdSubPlanGridTarifa').store.load({
                                         params: {
                                            pPlan: cmb.getValue()
                                         },
                                         callback: function(){
                                            Ext.getCmp('intIdSubPlanGridTarifa').enable();
                                         }
                                     });
                                }
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'SubPlan',
                        anchor: '100%',
                        disabled: true,
                        listWidth: 450,
                        allowBlank: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        store: 'StoreClienteSubplan',
                        displayField: 'Descripcion',
                        valueField: 'IdSubPlan',
                        mode: 'local',
                        emptyText: 'Selecione Sub Plan....',
                        forceSelection: true,
                        id: 'intIdSubPlanGridTarifa'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Establecer Tarifa por Tipo de Estudio',
                        width: 90,
                        allowBlank: false,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        store: 'StoreSiNo',
                        triggerAction: 'all',
                        displayField: 'Descripcion',
                        valueField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        id: 'sysTarifaxTipoEstudioGridTarifa',
                        listeners:{
                            select : function(cmb, rec, idx){
                                if (cmb.getValue() != null && cmb.getValue() != ""){
                                    Ext.getCmp('intIdTipoEstudioGridTarifa').setValue(null);
                                    Ext.getCmp('IdManualTarifarioGridTarifa').setValue(null);
                                    Ext.getCmp('intAjusteGridTarifa').setValue(null);
                                    Ext.getCmp('sysCodConcepto').setValue(null);
                                    Ext.getCmp('sysDesConcepto').setValue(null);
                                    Ext.getCmp('intIdProcedimiento').setValue(null);
                                    Ext.getCmp('intVlrTarifaGridTarifa').setValue(null);
                                    if(cmb.getValue()== "SI"){
                                        Ext.getCmp('intIdTipoEstudioGridTarifa').allowBlank = false;
                                        Ext.getCmp('IdManualTarifarioGridTarifa').allowBlank = false;
                                        Ext.getCmp('intAjusteGridTarifa').allowBlank = false;
                                        Ext.getCmp('sysCodConcepto').allowBlank = true;
                                        Ext.getCmp('sysDesConcepto').allowBlank = true;
                                        Ext.getCmp('intIdProcedimiento').allowBlank = true;
                                        Ext.getCmp('intVlrTarifaGridTarifa').allowBlank = true;
                                        Ext.getCmp('fsTarifaTipoEstudio').setVisible(true);
                                        Ext.getCmp('fsTarifaConcepto').setVisible(false);
                                    }else{
                                        Ext.getCmp('intIdTipoEstudioGridTarifa').allowBlank = true;
                                        Ext.getCmp('IdManualTarifarioGridTarifa').allowBlank = true;
                                        Ext.getCmp('intAjusteGridTarifa').allowBlank = true;
                                        Ext.getCmp('sysCodConcepto').allowBlank = false;
                                        Ext.getCmp('sysDesConcepto').allowBlank = false;
                                        Ext.getCmp('intIdProcedimiento').allowBlank = false;
                                        Ext.getCmp('intVlrTarifaGridTarifa').allowBlank = false;
                                        Ext.getCmp('fsTarifaTipoEstudio').setVisible(false);
                                        Ext.getCmp('fsTarifaConcepto').setVisible(true);
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'fieldset',
                        anchor: '100%',
                        labelWidth: 100,
                        title: 'Tarifa por Tipo de Estudio',
                        id: 'fsTarifaTipoEstudio',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tipo de Estudio',
                                anchor: '100%',
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreTipoEstudio',
                                forceSelection: true,
                                allowBlank: true,
                                id: 'intIdTipoEstudioGridTarifa'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Manual tarifario',
                                anchor: '100%',
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreManualTarifario',
                                forceSelection: true,
                                allowBlank: true,
                                id: 'IdManualTarifarioGridTarifa'
                            },
                            {
                                xtype: 'numberfield',
                                anchor: '20%',
                                fieldLabel: 'Ajuste',
                                allowBlank: true,
                                decimalPrecision: 2,
                                id: 'intAjusteGridTarifa'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        anchor: '100%',
                        labelWidth: 100,
                        title: 'Tarifa por Concepto',
                        id: 'fsTarifaConcepto',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                fieldLabel: 'Concepto',
                                items: [
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Concepto',
                                        id: 'btnSearchConcepto_conceptos',
                                        handler:function(){
                                            buscarconceptoBasico('Search');
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        readOnly: true,
                                        width: 96,
                                        allowBlank: true,
                                        style: 'color: #0000cc; font-weight: bold;',
                                        id: 'sysCodConcepto'
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        allowBlank: true,
                                        width: 580,
                                        height: 50,
                                        fieldLabel: 'Descripción',
                                        style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                        id: 'sysDesConcepto'
                                    }
                                ]
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIdProcedimiento'
                            },
                            {
                                xtype: 'numericfield',
                                currencySymbol: "$",
                                useThousandSeparator: true,
                                alwaysDisplayDecimals: true,
                                thousandSeparator: ',',
                                minValue: 0,
                                fieldLabel: 'Vlr Tarifa',
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'intVlrTarifaGridTarifa'
                            }
                        ]
                    },
                    {
                        xtype: 'hidden',
                        value: "1",
                        id: 'bolActivoGridTarifa'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarTarifa'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnModificarTarifa'
                        }
                    ]
                }
            }
        ];
        winAddClienteTarifasUi.superclass.initComponent.call(this);
    }
});
