/*
* @category    Formulario Lotes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winProgramasUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Programa de Atención ::.',
    width: 600,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winProgramasUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmCambiarPrograma',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'sysCASPrograma',
                                value: 0
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Programa Actual',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysNomPrograma'
                            },
                            {
                                html: '<hr>'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Cambiar por este',
                                anchor: '100%',
                                allowBlank: false,
                                store: 'StoreProgramaPYP',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'IdPrograma',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Programa....',
                                submitValue: true,
                                id: 'sysPrograma'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Cambiar Programa',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmCambiarPrograma').getForm();
                                    if (frm.isValid()){
                                        frm.submit({
                                            url: '../../controlador/asistencial/cambiar_programa.php',
                                            params: {
                                                task: 'CHANGE',
                                                pEmpresa: ID_EMPRESA,
                                                pIPS: ID_IPS,
                                                pUsuario: ID_USUARIO,
                                                pCAS: Ext.getCmp('sysCASPrograma').getValue(),
                                                pPrograma: Ext.getCmp('sysPrograma').getValue()
                                            },
                                            success: function(res,req){
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        Ext.MessageBox.show({
                                                            title: 'Cambiar Programa',
                                                            msg: 'Se cambio el programa con exito.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                        Ext.getCmp('winProgramasUi').close();
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'OfiClinic',
                                                            msg: 'Ocurrio un error al cambiar el programa o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos cambiar el programa en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Los campos son Requeridos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirLote',
                            listeners: {
                                click: function(){
                                    Ext.getCmp('winProgramasUi').close();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winProgramasUi.superclass.initComponent.call(this);
    }
});
