/*
* @category    Formulario Barra de Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var xbtnValidarDoc = new btnValidarDoc({
    id: 'btnValidarDoc',
    ref: '../../../../../../btnValidarDoc'
});

winBaraServiciosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©      .:: Barra de Servicios ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winBaraServicios',
    initComponent: function() {
        
        var stGridProfesionalesCitas = new StoreGridProfesionalesCitas();
        var stGridConsultoriosCitas = new StoreGridConsultoriosCitas();
        var stGridAgendasDisponiblesCitas = new StoreGridDiasDispCitas();
        var stGridHoarariosxAgendaDisponiblesCitas = new StoreGridHoarariosxAgendaDisponiblesCitas();
        var stGridCitasxLegalizar = new StoreGridCitasxLegalizar();
        var stGridOtrosPagosxLegalizar = new StoreGridOtrosPagosxLegalizar();
        var stGridCitasxActivar = new StoreGridCitasxActivar();
        
        var controlCampos = false;
        
        function renderFechaAgenda(value, p, record){
            return String.format(
                value + ' - ' + FormatoFechaLarga(value),
                value);
        }
        
        function renderCitaObservacionesPlantilla(value, p, record){
            return String.format(
                '<table border="0"><tr><td><b>{0}</b></td></tr><tr><td>{1}</td></tr></table>',
                value, record.data.citaObservacionesPlantilla);
        }
        
        var xg = Ext.grid;
               
        var chkColumnSeleccionarHorario = new xg.CheckColumn({
           header: ' ',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarHorario',
           value: false,
           width: 10
        });
        
        var chkColumnActivarCita = new xg.CheckColumn({
           header: ' ',
           dataIndex: 'Seleccionar',
           id: 'chkColumnActivarCita',
           value: false,
           width: 10
        });
        
        var strcitaInfoAdd = new Ext.form.TextField();
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        //Store Locales
        var dataModulos = [
            [1,'Nro. 1'],
            [2,'Nro. 2'],
            [3,'Nro. 3 - Preferencial'],
            [4,'Nro. 4']
        ];
        var stModulos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stModulos.loadData(dataModulos);
        
        var dataFormaSolicitaCita = [
            ['TELEFONICA'],
            ['PRESENCIAL'],
            ['CORREO ELECTRONICO']
        ];
        var stFormaSolicitaCita = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stFormaSolicitaCita.loadData(dataFormaSolicitaCita);
        
        this.items = [
            {
                xtype: 'tabpanel',
                //width: 990,
                anchor: '99%',
                height: 585,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Identificación del Servicio',
                        height: 441,
                        width: 951,
                        frame: true,
                        border: false,
                        autoScroll: true, 
                        id: 'fichaDatos',
                        tbar: [
                            {
                                html: '<img src="../../../resources/botones/triage.png" />&nbsp;&nbsp;-&nbsp;&nbsp;'
                            },
                            {
                                html: 'Turnero: '
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Modulo:',
                                width: 70,
                                allowBlank: false,
                                store: stModulos,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysModuloNro'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnAdd',
                                text: 'Siguiente',
                                listeners: {
                                    click: function(){
                                        if(parseInt(Ext.getCmp('sysModuloNro').getValue()) > 0){
                                            Ext.Ajax.request({
                                                waitMsg: 'Por favor Espere...',
                                                url: "../../controlador/turnero/controlador_turnero.php",
                                                params: {
                                                    task: "SIGUIENTE",
                                                    pModulo: Ext.getCmp('sysModuloNro').getValue(),
                                                    pUsuario: ID_USUARIO
                                                },
                                                success: function(response){
                                                    var result = response.responseText;
                                                    if (result > 0){
                                                        var html = '<h1 style="color: #2E2EFE; font-size: 14px;">Turno Nro. ' + result  + '</h1>';
                                                        Sexy.info(html);
                                                    }
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'textfield',
                                width: 30,
                                id: 'sysNroTurno'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnActualizarGrid',
                                text: 'Reiniciar Turnero',
                                listeners: {
                                    click: function(){
                                        if(parseInt(Ext.getCmp('sysModuloNro').getValue()) > 0){
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea reiniciar el turnero?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        var wTurno = 0;
                                                        if(Ext.getCmp('sysNroTurno').getValue() !== "" && Ext.getCmp('sysNroTurno').getValue() !== null){
                                                            wTurno = Ext.getCmp('sysNroTurno').getValue();
                                                        }
                                                        Ext.Ajax.request({
                                                            waitMsg: 'Por favor Espere...',
                                                            url: "../../controlador/turnero/controlador_turnero.php",
                                                            params: {
                                                                task: "REINICIAR",
                                                                pModulo: Ext.getCmp('sysModuloNro').getValue(),
                                                                pTurno: wTurno
                                                            },
                                                            success: function(response){
                                                                alert("Se reinicio el turnero");
                                                            }
                                                        });
                                                    }
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ],
                        items: [
                            {
                                xtype: 'form',
                                title: '',
                                padding: 5,
                                border: false,
                                id: 'frmPacienteBarraServicios',
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Paciente',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 949,
                                        autoHeight: true,
                                        id: 'fsPaciente',
                                        layoutConfig: {
                                            columns: 4
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTdoc',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo Doc ID',
                                                        anchor: '100%',
                                                        name: 'cbTdoc',
                                                        allowBlank: false,
                                                        store: 'StoreTdocPac',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Tipo Documento....',
                                                        mode: 'local',
                                                        triggerAction: 'all',
                                                        forceSelection: true,
                                                        id: 'strTdoc_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 269,
                                                border: false,
                                                id: 'pnDocID',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Documento ID',
                                                                name: 'txtDocID',
                                                                allowBlank: false,
                                                                //anchor: '100%',
                                                                width: 170,
                                                                id: 'strdocpac_citas'
                                                                
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Paciente',
                                                                id: 'btnBuscarPacienteRadica'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnUsrVerifica',
                                                                tooltip: 'Verificar Paciente en el Listado de Atención',
                                                                ref: '../../../../btnVerificaPacienteListado',
                                                                id: 'btnVerificaPacienteListado'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnRadicar',
                                                                tooltip: 'Verificar Estado Actual del Paciente',
                                                                listeners: {
                                                                    click: function(){
                                                                         if(parseInt(Ext.getCmp('intIdPaciente_citas').getValue()) !== 0){
                                                                            verInfoActividadesxPaciente(Ext.getCmp('intIdPaciente_citas').getValue(),PonerAcentosMayusculas(Ext.getCmp('strTdoc_citas').getValue() + " " + Ext.getCmp('strdocpac_citas').getValue() + " - " + Ext.getCmp('strNom1_citas').getValue() + " " + Ext.getCmp('strNom2_citas').getValue() + " " + Ext.getCmp('strApe1_citas').getValue() + " " + Ext.getCmp('strApe2_citas').getValue()) + " - Genero: " + Ext.getCmp('strgenero_citas').getValue() + " - Edad: " + Ext.getCmp('strEdad_citas').getValue());
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnRegimen',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Régimen / Tipo Usuario',
                                                        anchor: '100%',
                                                        name: 'cbRegimen',
                                                        allowBlank: false,
                                                        store: 'StoreTipoRegimen',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Régimen/Tipo Usuario....',
                                                        forceSelection: true,
                                                        //value: '1 - Contributivo',
                                                        listWidth: 350,
                                                        id: 'strRegimen_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 172,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnGenero',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Genero',
                                                        anchor: '100%',
                                                        name: 'cbGenero',
                                                        allowBlank: false,
                                                        store: 'StoreGenero',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Genero....',
                                                        forceSelection: true,
                                                        id: 'strgenero_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnApe1',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Apellido',
                                                        anchor: '100%',
                                                        name: 'txtApe1',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: false,
                                                        id: 'strApe1_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnApe2',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '2do Apellido',
                                                        anchor: '100%',
                                                        name: 'txtApe2',
                                                        style: 'text-transform:uppercase;',
                                                        id: 'strApe2_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                id: 'pnNom1',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Nombre',
                                                        anchor: '100%',
                                                        name: 'txtNom1',
                                                        allowBlank: false,
                                                        style: 'text-transform:uppercase;',
                                                        id: 'strNom1_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 172,
                                                id: 'pnNom2',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '2do Nombre',
                                                        anchor: '100%',
                                                        name: 'txtNom2',
                                                        style: 'text-transform:uppercase;',
                                                        id: 'strNom2_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 146,
                                                border: false,
                                                id: 'pnFecNac',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Nacimiento',
                                                        anchor: '100%',
                                                        name: 'txtFecNac',
                                                        allowBlank: false,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecFecNac_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnEdad',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Edad Actual',
                                                        anchor: '100%',
                                                        name: 'txtEdad',
                                                        readOnly: true,
                                                        style: 'color: blue;text-align:center',
                                                        disabled: true,
                                                        id: 'strEdad_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 386,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnDeptoMuni',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Municipio - Departamento',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreDeptoMuni',
                                                        valueField: 'IdDeptoMunicipio',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Municipio - Departamento....',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        id: 'strDeptoMuni_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 928,
                                                border: false,
                                                colspan: 4,
                                                height: 54,
                                                id: 'pnDatDirTel',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                        anchor: '100%',
                                                        id: 'composDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtDireccion',
                                                                allowBlank: false,
                                                                emptyText: 'Dirección....',
                                                                style: 'text-transform:uppercase;',
                                                                width: 250,
                                                                id: 'strDireccion_citas'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTel1',
                                                                allowBlank: false,
                                                                emptyText: 'Teléfono',
                                                                width: 160,
                                                                id: 'strTel1_citas'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTel2',
                                                                emptyText: 'Teléfono (Otro - Cel.)',
                                                                width: 160,
                                                                minLength: 10,
                                                                minLengthText: 'Numero Telefono Incorrecto', 
                                                                maxLength: 10,
                                                                maxLengthText: 'Numero Telefono Incorrecto',
                                                                allowBlank: false,
                                                                id: 'strTel2_citas'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                flex: 1,
                                                                fieldLabel: 'Zona',
                                                                store: 'StoreZonaResidencia',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                name: 'cbZona',
                                                                emptyText: 'Zona....',
                                                                allowBlank: false,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                width: 80,
                                                                value: 'Urbana',
                                                                triggerAction: 'all',
                                                                id: 'strZona_citas'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtEmail',
                                                                vtype: 'email',
                                                                emptyText: 'Email....',
                                                                width: 147,
                                                                id: 'strEmail_citas'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                tooltip: 'Limpiar Datos del Paciente',
                                                                iconCls: 'btnLimpiar',
                                                                id: 'btnLimpiarPac_citas'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                tooltip: 'Crear Datos del Paciente',
                                                                iconCls: 'btnGuardar',
                                                                id: 'btnGuardarPac_citas'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTafiliado',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Afiliado',
                                                        anchor: '100%',
                                                        name: 'cbTafiliado',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreTipoAfiliado',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Tipo de Afiliado....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        tpl: '',
                                                        id: 'strTafiliado_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTafiliacion',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Parentesco',
                                                        anchor: '100%',
                                                        name: 'cbParentesco',
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreParentesco',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        emptyText: 'Seleccione Parentesco....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        disabled: true,
                                                        id: 'strParentesco_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 213,
                                                border: false,
                                                id: 'pnRango',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Rango Salarial',
                                                        anchor: '100%',
                                                        name: 'cbRango',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreRangoSal',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Rango Salarial....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><p style="font-size: 12; color: #AA0033">Valor: $ {VlrCuotaModeradora}</p><p style="font-size: 11; color: #0000EE ">Porcentaje: {txtPorcentaje} %</p><p style="font-size: 10; color: #33373d">{Observaciones}</p><hr /></div></tpl>',
                                                        itemSelector: 'div.cbRango',
                                                        listWidth: 450,
                                                        autoHeight: true,
                                                        id: 'strRango_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 170,
                                                border: false,
                                                id: 'pnEstado',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Estado - Listado Atención',
                                                        anchor: '100%',
                                                        name: 'cbEstado',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreEstadoLA',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        emptyText: 'Estado Actual....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        disabled: true,
                                                        autoSelect: false,
                                                        id: 'strEstado_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdEmpresa',
                                                id: 'sysIdEmpresa',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdSede',
                                                id: 'sysIdSede',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdIPS',
                                                id: 'sysIdIPS',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdPaciente',
                                                id: 'intIdPaciente_citas',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExcento',
                                                id: 'sysExento',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtTutela',
                                                id: 'sysTutela',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtClieteLA',
                                                id: 'sysClienteLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPlanLA',
                                                id: 'sysPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtSubPlanLA',
                                                id: 'sysSubPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPacienteValido',
                                                id: 'sysPacienteValido',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Cliente y del Solicitante',
                                        layout: 'table',
                                        width: 949,
                                        autoHeight: true,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsCliente',
                                        layoutConfig: {
                                            columns: 8
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnCliete',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Cliente',
                                                        anchor: '100%',
                                                        name: 'cbCliente',
                                                        allowBlank: true,
                                                        store: 'StoreCliente',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdCliente',
                                                        emptyText: 'Selecione Cliente....',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        listWidth: 450,
                                                        typeAhead: true,
                                                        autoSelect: false,
                                                        typeAheadDelay: 50,
                                                        submitValue: true,
                                                        enableKeyEvents: true,
                                                        triggerAction: 'all',
                                                        id: 'sysCliente'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnPlan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Plan',
                                                        anchor: '100%',
                                                        name: 'cbPlan',
                                                        allowBlank: true,
                                                        mode: 'local',
                                                        store: 'StoreClientesPlan',
                                                        valueField: 'IdPlan',
                                                        displayField: 'Descripcion',
                                                        typeAhead: true,
                                                        triggerAction: 'all',
                                                        disabled: true,
                                                        typeAheadDelay: 50,
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Plan....',
                                                        forceSelection: true,
                                                        id: 'sysPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnSubplan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sub Plan',
                                                        anchor: '100%',
                                                        name: 'cbSubplan',
                                                        allowBlank: true,
                                                        disabled: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteSubplan',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdSubPlan',
                                                        mode: 'local',
                                                        emptyText: 'Selecione Sub Plan....',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        ref: '../../../../../fSubPlan',
                                                        id: 'sysSubPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 6,
                                                border: false,
                                                width: 350,
                                                colspan: 2,
                                                id: 'pnContrato',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Contrato',
                                                        anchor: '50%',
                                                        name: 'cbContrato',
                                                        allowBlank: true,
                                                        disabled: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteContrato',
                                                        valueField: 'IdContrato',
                                                        displayField: 'Contrato',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Contrato....',
                                                        forceSelection: true,
                                                        ref: '../../../../../fContrato',
                                                        id: 'sysContrato'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnPrograma',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Programa',
                                                        anchor: '100%',
                                                        name: 'cbPrograma',
                                                        allowBlank: true,
                                                        store: 'StorePrograma',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'IdPrograma',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Programa....',
                                                        submitValue: true,
                                                        id: 'sysPrograma'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnProgramaTipoAtencion',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        disabled: true,
                                                        fieldLabel: 'Tipo de Atención',
                                                        anchor: '100%',
                                                        name: 'cbProgramaTipoAtencion',
                                                        allowBlank: true,
                                                        store: 'StoreProgramaTipoAtencion',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Programa....',
                                                        submitValue: true,
                                                        id: 'sysProgramaTipoAtencion'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysHorasPrograma',
                                                        value: 1
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                colspan: 2,
                                                border: false,
                                                iconCls: '',
                                                id: 'pnAutorizacion',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Autorización',
                                                        anchor: '100%',
                                                        name: 'txtAutorizacion',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: true,
                                                        disabled: true,
                                                        id: 'sysAutorizacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 150,
                                                colspan: 2,
                                                border: false,
                                                id: 'pnFecSol',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Solicitud',
                                                        anchor: '100%',
                                                        name: 'txtFecSol',
                                                        allowBlank: true,
                                                        style: 'text-align:center;',
                                                        emptyText: '(dia/mes/año) ',
                                                        value: new Date().format('d/m/Y'),
                                                        id: 'sysFecSol'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 750,
                                                colspan: 8,
                                                id: 'pnProfesional',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Profesional / IPS  Solicitante',
                                                                name: 'cbProfeSol',
                                                                allowBlank: true,
                                                                store: 'StoreProfeSol',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                emptyText: 'Seleccione Profesional / IPS Solicitante....',
                                                                valueField: 'idProfeSolicitante',
                                                                displayField: 'Descripcion',
                                                                width: 300,
                                                                listWidth: 450,
                                                                submitValue: true,
                                                                id: 'sysProfeSol'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnDoctor',
                                                                tooltip: 'Adicionar Profesional / IPS Solicitante',
                                                                id: 'btnAddProfeSol'
                                                            }
                                                        ]
                                                    }
                                                 ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaListado',
                                                id: 'sysUsaListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtAtenderFueraListado',
                                                id: 'sysAtenderFueraListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtRequiereAutorizacion',
                                                id: 'sysRequiereAutorizacion',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtFacturarParticular',
                                                id: 'sysFacturarParticular',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtMaxCopago',
                                                id: 'sysMaxCopago',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'sysFacturarCopagos',
                                                id: 'sysFacturarCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'sysCopagoDigitado',
                                                id: 'sysCopagoDigitado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'sysvlrCuotaModeradoraIndicada',
                                                id: 'sysvlrCuotaModeradoraIndicada',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'sysPorCopagos',
                                                id: 'sysPorCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaAuditoria',
                                                id: 'sysUsaAuditoria',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtFinalidad',
                                                id: 'sysFinalidad',
                                                value: '10'
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExento',
                                                id: 'sysExentoPrograma',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'hidden',
                                        name: 'txtCas',
                                        id: 'sysCas',
                                        value: 0
                                    }
                                ]
                            } // fin formulario
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Asignación de Citas',
                        height: 441,
                        width: 951,
                        layout: 'fit',
                        id: 'fichaAsignacionCita',
                        listeners:{
                            beforeshow : function(){
                                if(Ext.getCmp('sysCliente').getValue() != null && Ext.getCmp('sysCliente').getValue() != "" && Ext.getCmp('intIdPaciente_citas').getValue() != 0){
                                    var idInfoPac = Ext.getCmp('strNom1_citas').getValue() + " " + Ext.getCmp('strNom2_citas').getValue() +  " " + Ext.getCmp('strApe1_citas').getValue() + " " + Ext.getCmp('strApe2_citas').getValue() + " - CLIENTE: " + Ext.getCmp('sysCliente').getRawValue();
                                    Ext.getCmp('systxtIdPac').setValue("Paciente: " + idInfoPac);
                                }else{
                                    var html = '<table><tr><td width="50"><img src="../../../resources/varios/alert.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #ff9900; font-size: 14px;">Barra de Servicios:</h1><br/><p style="color: #003333;font-weight: bold;">Antes de asignar una cita usted debe:</p></br>';
                                    html += '<strong><ul>';
                                    html += '<li>Crear o Seleccionar un Paciente</li>';
                                    html += '<li>Seleccionar un Cliente - Plan - SubPlan</li>';
                                    html += '<li>Seleccionar Tipo de Afiliación</li>';
                                    html += '<li>Seleccionar Tipo de Afiliado</li>';
                                    html += '<li>Seleccionar un Programa</li>';
                                    html += '<li>Seleccionar una Finalidad</li>';
                                    html += '</ul></strong></td><td width="70">&nbsp</td></tr></table>'
                                    Sexy.info(html);
                                }
                                Ext.Ajax.request({
                                    waitMsg: 'Por favor Espere...',
                                    url: "../../controlador/agendas/controlador_asignarcitas201601.php",
                                    params: {
                                        task: "VERIFIVAR_ULTIMACITA",
                                        pPaciente: Ext.getCmp('intIdPaciente_citas').getValue(),
                                        pPrograma: Ext.getCmp('sysPrograma').getValue()
                                    },
                                    success: function(response){
                                        var result = response.responseText;
                                        if (parseInt(result) > 0){
                                            Ext.getCmp('btnSearchConcepto_Citas').enable();
                                            SI_ASIGNAR_CITAS = 1;
                                        }else{
                                            SI_ASIGNAR_CITAS = 0;
                                            Ext.MessageBox.show({
                                                title: 'OfiClinic',
                                                msg: 'No podemos asignar la cita en este momento al paciente seleccionado, por favor verificar el historial de asignacion de citas.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                            Ext.getCmp('btnSearchConcepto_Citas').disable();
                                        }
                                    }
                                });
                            }
                        },
                        tbar: [
                            {
                                html: 'Forma Asignacion de la Cita:&nbsp;&nbsp;'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Forma Asignacion de la Cita:',
                                width: 140,
                                allowBlank: false,
                                store: stFormaSolicitaCita,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysFormaAsignacionCita'
                            },
                            {
                                html: '&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;&nbsp;Fecha Para la Cual el Paciente Quiere la Cita?&nbsp;&nbsp;'
                            },
                            {
                                xtype: 'datefield',
                                anchor: '100%',
                                allowBlank: false,
                                style: 'text-align:center;',
                                emptyText: '(dia/mes/año) ',
                                //value: new Date().format('d/m/Y'),
                                id: 'sysFecCitaPaciente'
                            }
                        ],
                        items: [
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '99%',
                                frame: true,
                                border: false,
                                id: 'infoPac_Citas',
                                items: [
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtIdPac',
                                        style: 'text-transform:uppercase; color: #610B0B; font-size: 13px; font-weight: bold;',
                                        value: 'Paciente:'
                                    },
                                    {
                                        html:'<hr>',
                                        border: false
                                    },
                                    {
                                        xtype: 'compositefield',
                                        fieldLabel: 'Concepto',
                                        anchor: '100%',
                                        padding: 5,
                                        items: [
                                            {
                                                xtype: 'displayfield',
                                                value: 'Concepto:'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Concepto',
                                                id: 'btnSearchConcepto_Citas'
                                            },
                                            {
                                                xtype: 'textfield',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                style: 'color: #0000cc; font-weight: bold;',
                                                id: 'fCodConcepto'
                                            },
                                            {
                                                xtype: 'textarea',
                                                flex: 1,
                                                readOnly: true,
                                                width: 750,
                                                height: 40,
                                                style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                                id: 'fDesConcepto'
                                            },
                                            {
                                                xtype: 'hidden',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                style: 'color: #0000cc; font-weight: bold;',
                                                id: 'fVlrUnitario'
                                            },
                                            {
                                                xtype: 'hidden',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                id: 'fidConcepto'
                                            },
                                            {
                                                xtype: 'hidden',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                id: 'strTipoRegistroDetalle'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        fieldLabel: '',
                                        anchor: '100%',
                                        padding: 5,
                                        id: 'sysFSolicitanteControl',
                                        items: [
                                            {
                                                html: '- Profesional Solicitante: '
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'cbProfeSolCitaControl',
                                                allowBlank: true,
                                                store: 'StoreProfeSol',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                emptyText: 'Seleccione Profesional....',
                                                valueField: 'idProfeSolicitante',
                                                displayField: 'Descripcion',
                                                width: 300,
                                                listWidth: 450,
                                                submitValue: true,
                                                id: 'sysProfeSolCitaControl'
                                            },
                                            {
                                                html: ' - Fecha Solicitud Orden: '
                                            },
                                            {
                                                xtype: 'datefield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                //value: new Date().format('d/m/Y'),
                                                id: 'sysFecSolCitaControl'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>'
                                    },
                                    {
                                        xtype: 'container',
                                        width: 965,
                                        height: 410,
                                        layout: 'table',
                                        layoutConfig: {
                                            columns: 3
                                        },
                                        items: [
                                            {
                                                xtype: 'grid',
                                                id: 'gridDiasAgendaCitas',
                                                store: stGridAgendasDisponiblesCitas,
                                                width: 300,
                                                height: 400,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                title: 'Dias Disponibles',
                                                stripeRows: true,
                                                columns: [
                                                    {
                                                        header: 'Fecha',
                                                        readOnly: true,
                                                        sortable: true,
                                                        dataIndex: 'agendaFecha',
                                                        renderer: renderFechaAgenda,
                                                        width: 265
                                                    },
                                                    {
                                                        header: 'Citas',
                                                        readOnly: true,
                                                        sortable: true,
                                                        width: 40,
                                                        dataIndex: 'Disponibles'
                                                    }
                                                ],
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                iconCls:'icon-fechas',
                                                viewConfig: {
                                                    forceFit:true
                                                },
                                                columnLines: true,
                                                tbar:{
                                                    items: [
                                                        {
                                                            xtype: 'button',
                                                            iconCls: 'btnActualizarGrid',
                                                            text: 'Actualizar',
                                                            tooltip: 'Actualizar',
                                                            id: 'btnDiasDisp201601'
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                xtype: 'grid',
                                                id: 'gridProfesionalesCitas',
                                                store: stGridProfesionalesCitas,
                                                width: 250,
                                                height: 400,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                title: 'Profesionales:',
                                                columns: [
                                                    {
                                                        header: 'profesionalID',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'profesionalID',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'Profesional',
                                                        readOnly: true,
                                                        sortable: true,
                                                        dataIndex: 'profesionalDescripcion',
                                                        width: 210
                                                    }
                                                ],
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                iconCls:'icon-profesionales',
                                                viewConfig: {
                                                    forceFit:true
                                                },
                                                columnLines: true,
                                                tbar:{
                                                    items: [
                                                        {
                                                            xtype: 'button',
                                                            iconCls: 'btnImprimir',
                                                            text: 'Imprimir',
                                                            tooltip: 'Imprimir Agenda',
                                                            id: 'btnImpAgenda_citas'
                                                        },
                                                        '->',
                                                        {
                                                            xtype: 'button',
                                                            iconCls: 'btnAgendasBloqueada',
                                                            text: 'Ver Bloqueadas',
                                                            tooltip: 'Verificar las Agendas Bloqueadas por Usuario',
                                                            id: 'btnVarAgendaBloqueada_citas'
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                xtype: 'editorgrid',
                                                id: 'gridHorariosAgendasCitas',
                                                store: stGridHoarariosxAgendaDisponiblesCitas,
                                                width: 415,
                                                height: 400,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                stripeRows: true,
                                                clicksToEdit: 1,
                                                title: 'Horarios Disponibles por Agenda',
                                                cm: new xg.ColumnModel([
                                                    chkColumnSeleccionarHorario,
                                                    {
                                                        header: 'Codigo',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'citaID',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'Descripción del Horario',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'citaDescripcion',
                                                        renderer: renderCitaObservacionesPlantilla,
                                                        width: 200
                                                    },
                                                    {
                                                        header: 'Información Adicional de la Cita',
                                                        readOnly: false,
                                                        sortable: false,
                                                        dataIndex: 'citaInfoAdd',
                                                        editor: strcitaInfoAdd,
                                                        width: 200
                                                    }
                                                ]),
                                                plugins: [chkColumnSeleccionarHorario],
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                iconCls:'icon-horarios',
                                                viewConfig: {
                                                    forceFit:true
                                                },
                                                listeners:{
                                                    beforeedit : function(e){
                                                        if(e.record.get('Estado')=== "i"){
                                                            return false;
                                                        }
                                                    }
                                                },
                                                columnLines: true,
                                                tbar:{
                                                    items: [
                                                        {
                                                            html:'<b style="color: #ff3333;">A Solicitud del Usuario:</b>&nbsp;&nbsp;&nbsp;',
                                                            border: false
                                                        },
                                                        {
                                                            xtype: 'checkbox',
                                                            anchor: '100%',
                                                            value: 'true',
                                                            id: 'bolAsignaCitasSolicitudUsuario'
                                                        },
                                                        {
                                                            html:'<b style="color: blue;">&nbsp;&nbsp;&nbsp; - EXENTO:</b>&nbsp;&nbsp;&nbsp;',
                                                            border: false
                                                        },
                                                        {
                                                            xtype: 'checkbox',
                                                            anchor: '100%',
                                                            value: 'true',
                                                            id: 'bolMarcaExento'
                                                        },
                                                        {
                                                            xtype: 'tbfill'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Asignar Cita',
                                                            iconCls: 'btnAsignarCita',
                                                            id: 'btnCitasAsignarCita'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        }
                                                    ]
                                                },
                                                bbar:{
                                                    items: [
                                                        {
                                                            html:'Observaciones:&nbsp;&nbsp;&nbsp;',
                                                            border: false
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 440,
                                                            maxLength: 150,
                                                            allowBlank: true,
                                                            emptyText: 'Observaciones',
                                                            id: 'strObservacionesCita'
                                                        }
                                                    ]
                                                }
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Legalización de Citas',
                        height: 240,
                        width: 951,
                        layout: 'fit',
                        id: 'fichaLegalizacionCita',
                        listeners:{
                            beforeshow : function(){
                                if(Ext.getCmp('intIdPaciente_citas').getValue() != 0){
                                    var idInfoPac = Ext.getCmp('strTdoc_citas').getValue() + "-" + Ext.getCmp('strdocpac_citas').getValue() + " " + Ext.getCmp('strNom1_citas').getValue() + " " + Ext.getCmp('strNom2_citas').getValue() +  " " + Ext.getCmp('strApe1_citas').getValue() + " " + Ext.getCmp('strApe2_citas').getValue();
                                    Ext.getCmp('systxtIdPac1').setValue("Paciente: " + idInfoPac);
                                }else{
                                    var html = '<table><tr><td width="50"><img src="../../../resources/varios/alert.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #ff9900; font-size: 14px;">Barra de Servicios:</h1><br/><p style="color: #003333;font-weight: bold;">Antes de realizar operaciones con citas usted debe:</p></br>';
                                    html += '<strong><ul>';
                                    html += '<li>Seleccionar un Paciente</li>';
                                    html += '</ul></strong></td><td width="70">&nbsp</td></tr></table>'
                                    Sexy.info(html);
                                }
                            }
                        },
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasAsignadas',
                                    text: 'Ver Historial Citas',
                                    tooltip: 'Ver Historial de Citas Asignadas por Paciente',
                                    id: 'btnVerHistorialCitas_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasCanceladas',
                                    text: 'Ver Historial Cancelaciones',
                                    tooltip: 'Ver Historial de Citas Canceladas por Paciente',
                                    id: 'btnVerHistorialCanceladas_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasInasistencia',
                                    text: 'Ver Historial Inasistencias',
                                    tooltip: 'Ver Historial de Citas Inasistidas por Paciente',
                                    id: 'btnVerHistorialInasistencia_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '99%',
                                frame: true,
                                border: false,
                                id: 'infoPac_Citas1',
                                items: [
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtIdPac1',
                                        style: 'text-transform:uppercase; color: #610B0B; font-size: 13px; font-weight: bold;',
                                        value: 'Paciente:'
                                    },
                                    {
                                        html:'<hr>',
                                        border: false
                                    },
                                    {
                                        xtype: 'grid',
                                        id: 'gridLegalizarCitas',
                                        store: stGridCitasxLegalizar,
                                        anchor: "100%",
                                        height: 480,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        stripeRows: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                header: 'CAS',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'CAS',
                                                width: 100,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Fecha',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'FechaCita',
                                                width: 80,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Hora',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAgenda',
                                                width: 110,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Hora Estimada',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAtencion',
                                                width: 80,
                                                hideable: false
                                            },
                                            {
                                                header: 'Profesional',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Profesional',
                                                width: 280,
                                                hideable: false
                                            },
                                            {
                                                header: 'Ubicacion',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Ubicacion',
                                                width: 220,
                                                hideable: false
                                            },
                                            {
                                                header: 'Cliente',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Cliente',
                                                width: 250,
                                                hideable: false
                                            },
                                            {
                                                header: 'Actividad',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Actividad',
                                                width: 280,
                                                hideable: false
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                        view: new Ext.ux.grid.LockingGridView(),
                                        columnLines: true,
                                        tbar:{
                                            items: [
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    iconCls: 'btnCitasLegalizacion',
                                                    text: 'Ver Historial Legalizaciones',
                                                    tooltip: 'Ver Historial de Citas Legalizadas por Paciente',
                                                    id: 'btnHistorialLegalizaciones_citas'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Citas Pendientes por Legalizar',
                                                    iconCls: 'btnCitasBuscar',
                                                    id: 'btnCitasxLegalizar'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        bbar:{
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Legalizar Cita',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Legalizar la Cita Seleccionada',
                                                    id: 'btnLegalizarCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Cancelar Cita',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Cancelar la Cita Seleccionada',
                                                    id: 'btnCancelarCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Marcar Cita Inasistente',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Marcar Inasistente la Cita Seleccionada',
                                                    id: 'btnInasistenciaCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Legalización de Copagos, Multas, Otros',
                        height: 240,
                        width: 951,
                        layout: 'fit',
                        id: 'fichaLegalizacionOtros',
                        listeners:{
                            beforeshow : function(){
                                if(Ext.getCmp('intIdPaciente_citas').getValue() != 0){
                                    var idInfoPac = Ext.getCmp('strTdoc_citas').getValue() + "-" + Ext.getCmp('strdocpac_citas').getValue() + " " + Ext.getCmp('strNom1_citas').getValue() + " " + Ext.getCmp('strNom2_citas').getValue() +  " " + Ext.getCmp('strApe1_citas').getValue() + " " + Ext.getCmp('strApe2_citas').getValue();
                                    Ext.getCmp('systxtIdPacOtros').setValue("Paciente: " + idInfoPac);
                                }else{
                                    var html = '<table><tr><td width="50"><img src="../../../resources/varios/alert.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #ff9900; font-size: 14px;">Barra de Servicios:</h1><br/><p style="color: #003333;font-weight: bold;">Antes de realizar operaciones con otros pagos, usted debe:</p></br>';
                                    html += '<strong><ul>';
                                    html += '<li>Seleccionar un Paciente</li>';
                                    html += '</ul></strong></td><td width="70">&nbsp</td></tr></table>';
                                    Sexy.info(html);
                                }
                            }
                        },
                        items: [
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '99%',
                                frame: true,
                                border: false,
                                id: 'infoPac_Otros1',
                                items: [
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtIdPacOtros',
                                        style: 'text-transform:uppercase; color: #610B0B; font-size: 13px; font-weight: bold;',
                                        value: 'Paciente:'
                                    },
                                    {
                                        html:'<hr>',
                                        border: false
                                    },
                                    {
                                        xtype: 'grid',
                                        id: 'gridLegalizarOtros',
                                        store: stGridOtrosPagosxLegalizar,
                                        anchor: "100%",
                                        height: 480,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        stripeRows: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                header: 'CAS',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'CAS_REF',
                                                width: 100,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Fecha',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Fecha',
                                                width: 80,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Cliente',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'NomCliente',
                                                width: 250,
                                                hideable: false
                                            },
                                            {
                                                header: 'Concepto',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Concepto',
                                                width: 380,
                                                hideable: false
                                            },
                                            {
                                                header: 'Valor',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'VlrConcepto',
                                                width: 130,
                                                renderer:  Ext.util.Format.Currency,
                                                align: 'right',
                                                hideable: false
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                        view: new Ext.ux.grid.LockingGridView(),
                                        columnLines: true,
                                        tbar:{
                                            items: [
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    iconCls: 'btnCitasLegalizacion',
                                                    text: 'Ver Historial Pagos',
                                                    tooltip: 'Ver Historial de Otros Pagos por Paciente',
                                                    id: 'btnHistorialLegalizaciones_otros'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Pagos Pendientes por Legalizar',
                                                    iconCls: 'btnCitasBuscar',
                                                    id: 'btnPagosxLegalizar'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        bbar:{
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Legalizar Pago',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Legalizar el Pago Seleccionado',
                                                    id: 'btnLegalizarPago'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Detalle del Copago por Legalizar',
                                                    iconCls: 'btnCitasBuscar',
                                                    id: 'btnViewPagosxLegalizar'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        autoHeight: true,
                        anchor: '99%',
                        frame: true,
                        border: false,
                        title: 'Activacion de Citas',
                        items: [
                            {
                                xtype: 'editorgrid',
                                id: 'gridCitasxActivar',
                                store: stGridCitasxActivar,
                                anchor: '99%',
                                height: 500,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                clicksToEdit: 1,
                                title: 'Citas Para Hoy',
                                cm: new xg.ColumnModel([
                                    chkColumnActivarCita,
                                    {
                                        header: 'CAS',
                                        readOnly: true,
                                        sortable: true,
                                        dataIndex: 'CAS',
                                        width: 70
                                    },
                                    {
                                        header: 'Fecha',
                                        readOnly: true,
                                        sortable: true,
                                        dataIndex: 'infoPaciente',
                                        width: 210
                                    },
                                    {
                                        header: 'Hora',
                                        readOnly: true,
                                        sortable: true,
                                        width: 90,
                                        dataIndex: 'DesImprime'
                                    },
                                    {
                                        header: 'Profesional',
                                        readOnly: true,
                                        sortable: true,
                                        width: 170,
                                        dataIndex: 'Profesional'
                                    },
                                    {
                                        header: 'Programa',
                                        readOnly: true,
                                        sortable: true,
                                        width: 170,
                                        dataIndex: 'Programa'
                                    }
                                ]),
                                plugins: [chkColumnActivarCita],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                iconCls:'icon-fechas',
                                viewConfig: {
                                    forceFit:true, 
                                    getRowClass: function(record, index) {
                                        switch(record.get('Exento')){
                                            case "1":
                                                if(record.get('Programa') === "LEGALIZACION CONTROLES ODONTOLOGIA"){
                                                    return 'Amarillo';
                                                }else{
                                                    return 'Apto';
                                                }
                                                break;
                                            case "0":
                                                if(record.get('YaLegalizado') == "1"){
                                                    return 'Apto';
                                                }else{
                                                    return 'Rojo';
                                                }
                                                break;
                                            default:
                                                return 'Rojo';
                                                break;
                                        }
                                    }
                                },
                                columnLines: true,
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnAceptar',
                                            text: 'Activar Cita',
                                            tooltip: 'Activar Cita',
                                            listeners: {
                                                click: function(){
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta seguro que desea activar la cita?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn=="yes"){
                                                                var parametrosCitasActivarSel = "";
                                                                var citasseleccionadas = false;
                                                                Ext.getCmp('gridCitasxActivar').store.filterBy(function(record,id){
                                                                    return record.get('Seleccionar') == true;
                                                                });
                                                                Ext.getCmp('gridCitasxActivar').store.each(function(record){
                                                                    citasseleccionadas = true;
                                                                    if(record.get('YaLegalizado') == "1"){
                                                                        parametrosCitasActivarSel = parametrosCitasActivarSel + record.get('CAS') + "¬";
                                                                    }
                                                                });
                                                                if (citasseleccionadas == false){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'Debe seleccionar al menos una cita para poder realizar la activacion',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    Ext.getCmp('gridCitasxActivar').store.load();
                                                                }else{
                                                                    Ext.Ajax.request({
                                                                        waitMsg: 'Por favor Espere...',
                                                                        url: "../../controlador/agendas/controlador_asignarcitas201601.php",
                                                                        params: {
                                                                            task: "ACTIVAR_CITAS",
                                                                            pInfoCita: parametrosCitasActivarSel
                                                                        },
                                                                        success: function(response){
                                                                            var result = response.responseText;
                                                                            if (result > 0){
                                                                                Ext.getCmp('gridCitasxActivar').store.load();
                                                                                Ext.MessageBox.show({
                                                                                    title: 'OfiClinic',
                                                                                    msg: 'Se activo la cita con exito.',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.INFO
                                                                                });
                                                                            }else{
                                                                                Ext.MessageBox.show({
                                                                                    title: 'Error',
                                                                                    msg: 'ERROR DE COMUNICACION, La Cita quedo mal activada por favor vuelva a intentarlo.',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                                Ext.getCmp('gridCitasxActivar').store.load();
                                                                            }
                                                                        },
                                                                        failure: function(response){
                                                                            var result = response.responseText;
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error Base Datos',
                                                                                msg: 'No podemos activar las citas en estos momentos',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                            Ext.getCmp('gridCitasxActivar').store.load();
                                                                        }
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        },
                                        '->',
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnActualizarGrid',
                                            text: 'Actualizar',
                                            tooltip: 'Actualizar',
                                            listeners: {
                                                click: function(){
                                                    Ext.getCmp('gridCitasxActivar').store.load();
                                                }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    //value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                Ext.getCmp('sysProfeSolCitaControl').allowBlank = true;
                Ext.getCmp('sysFecSolCitaControl').allowBlank = true;
                Ext.getCmp('sysFSolicitanteControl').setDisabled(true);
            }}
        }); 
        winBaraServiciosUi.superclass.initComponent.call(this);
    }
});
