/*
* @category    Programacion Eventos Formulario Radicacion de Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
var CodFrm = "BS00001";
var ID_EMPRESA;
var ID_SEDE;
var ID_IPS;
var ID_USUARIO;
var SI_ASIGNAR_CITAS;
var xCAS; 
var paso1 = false;
var paso2 = false;
var paso3 = false;
var paso4 = false;
var paso5 = false;
MaximizarVentana();
winBaraServicios = Ext.extend(winBaraServiciosUi, {
    initComponent: function() {
        SI_ASIGNAR_CITAS = 1;
        SI_CONTROL_SOLICITANTE = 0;
        SI_ASIGNAR_CITAS_SOL = 1;
        CREAR_PACIENTE = 0;
        ID_PROFESIONAL_SELECCIONADO = 0;
        ID_CONSULTORIO_SELECCIONADO = 0;
        NOM_PROFESIONAL_SELECCIONADO = "";
        NOM_CONSULTORIO_SELECCIONADO = "";
        FECHA_SELECCIONADA = "";
        AGENDA_SELECCIONADA = 0;
        BD_MULTIPRESTADOR = "NA";
        WINCLOSE = 0;
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('IdMunicipio');
        ID_MUNICIPIO = el.getValue();
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        stCliente = new StoreCliente();
        //stCliente.load({params:{pSede:ID_SEDE,pEmpresa:ID_EMPRESA}});
        stCliente.load({params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}});
        winBaraServicios.superclass.initComponent.call(this);
        
        CODBLOQUEOAGENDA = "USR:"+ID_USUARIO + ID_EMPRESA + ID_IPS + ID_SEDE + Math.round(Math.random()*100000000);
         
        controlViwInasistencia = setTimeout(function(){viewInasistencia();}, 60000);
        
        Ext.getCmp('sysClienteLA').setValue(0);
        Ext.getCmp('sysPlanLA').setValue(0);
        Ext.getCmp('sysSubPlanLA').setValue(0);
        Ext.getCmp('sysPacienteValido').setValue(0);
        Ext.getCmp('sysIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('sysIdSede').setValue(ID_SEDE);
        Ext.getCmp('sysIdIPS').setValue(ID_IPS);
        Ext.getCmp('btnGuardarPac_citas').setVisible(true);
        this.setPagePosition((screen.width - 1004)/2, 5);
        this.fNomEmpresa.setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        this.fNomSede.setValue("SEDE: " + Ext.get('nomsede').getValue());
        this.fNomIPS.setValue("IPS: " + Ext.get('nomips').getValue());
        this.fNomUSR.setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        this.title = Ext.get('ofiversion').getValue() + " - [Barra de Servicios]";
        el = Ext.get('FecSistema');
        //Ext.getCmp('fecFecNac_citas').setMaxValue(el.getValue());
        el = Ext.get('FecControl');
        
        var fCliente = Ext.getCmp('sysCliente').on("select",this.CargaCbPlan,this);
        var fsysPrograma = Ext.getCmp('sysPrograma').on("select",this.CargaTiposAtencionPrograma,this);
        var fsysProgramaTipoAtencion = Ext.getCmp('sysProgramaTipoAtencion').on("select",this.CargaHorasTipoAtencion,this);
        var fCliente1 = Ext.getCmp('sysCliente').on("change",this.ChangeCargaCbPlan,this);
        var fPlan = Ext.getCmp('sysPlan').on("select",this.CargaCbSubPlan,this);
        var fPlan1 = Ext.getCmp('sysPlan').on("change",this.ChangeCargaCbSubPlan,this);
        var fRegimen = Ext.getCmp('strRegimen_citas').on("select",this.ValidarRegimen,this);
        var fTafiliado = Ext.getCmp('strTafiliado_citas').on("select",this.ValidarParentesco,this);
        var fFecNac = Ext.getCmp('fecFecNac_citas').on("Blur",this.MostrarEdad,this);
        var btnGuardarPac_citas = Ext.getCmp('btnGuardarPac_citas').on("click",this.CrearInfoPaciente,this);
        var btnVarAgendaBloqueada_citas = Ext.getCmp('btnVarAgendaBloqueada_citas').on("click",this.VerAgendasBloqueadas,this);
        var btnImpAgenda_citas = Ext.getCmp('btnImpAgenda_citas').on("click",this.PrintAgenda,this);
        //var btnAsignarSesiones_citas = Ext.getCmp('btnAsignarSesiones_citas').on("click",this.AsignarCitasSesiones,this);
        var btnLimpiarPac_citas = Ext.getCmp('btnLimpiarPac_citas').on("click",this.LimpiarFormularioPaciente,this);
        var btnSearchConcepto_Citas = Ext.getCmp('btnSearchConcepto_Citas').on("click",this.BuscarConceptoCitas,this);
        
        var btnAyuda = this.btnAyuda.on("click",this.LlamarAyuda,this);
        var btnSalir = this.btnSalir.on("click",this.Salir, this);
        var btnVerificaPacienteListado = Ext.getCmp('btnVerificaPacienteListado').on("click",this.VerificaListado,this);
        var btnCitasAsignarCita = Ext.getCmp('btnCitasAsignarCita').on("click",this.AsignarCitas,this);
        var btnCitasxLegalizar = Ext.getCmp('btnCitasxLegalizar').on("click",this.CitasxLegalizar,this);
        var btnPagosxLegalizar = Ext.getCmp('btnPagosxLegalizar').on("click",this.PagosxLegalizar,this);
        var btnVerHistorialCitas_citas = Ext.getCmp('btnVerHistorialCitas_citas').on("click",this.HistorialCitasAsignadas,this);
        var btnVerHistorialCanceladas_citas = Ext.getCmp('btnVerHistorialCanceladas_citas').on("click",this.HistorialCitasCanceladas,this);
        var btnVerHistorialInasistencia_citas = Ext.getCmp('btnVerHistorialInasistencia_citas').on("click",this.HistorialCitasInasistencia,this);
        var btnVerHistorialLegalizacion_citas = Ext.getCmp('btnHistorialLegalizaciones_citas').on("click",this.HistorialCitasLegalizadas,this);
        var btnCancelarCita = Ext.getCmp('btnCancelarCita').on("click",this.CancelarCita,this);
        var btnInasistenciaCita = Ext.getCmp('btnInasistenciaCita').on("click",this.InasistenciaCita,this);
        var btnBuscarPacienteRadica = Ext.getCmp('btnBuscarPacienteRadica').on("click",this.BuscarPaciente,this);
        
        var gridProfesionalesCitas = Ext.getCmp('gridProfesionalesCitas').on("rowclick",this.SeleccionarProfesionalCita,this);
        //var gridConsultoriosCitas = Ext.getCmp('gridConsultoriosCitas').on("rowclick",this.SeleccionarFechasCita,this);
        var gridDiasAgendaCitas = Ext.getCmp('gridDiasAgendaCitas').on("rowclick",this.SeleccionarAgendasCita,this);
        
        var strdocpac_citas_special = Ext.getCmp('strdocpac_citas').on("specialkey",this.ValidarNumeroDocumentoPacSK,this);
        var strRango_citas =  Ext.getCmp('strRango_citas').on("select",this.SelectRangoSalarial,this);
        
        var btnLegalizarCita = Ext.getCmp('btnLegalizarCita').on("click",this.LegalizarCita,this);
        var btnAddProfeSol = Ext.getCmp('btnAddProfeSol').on("click",this.CrearProfesionalSolicitante,this);
        
        var btnLegalizarPago = Ext.getCmp('btnLegalizarPago').on("click",this.LegalizarPago,this);
        var btnHistorialLegalizaciones_otros = Ext.getCmp('btnHistorialLegalizaciones_otros').on("click",this.HistorialOtrosPagos,this);
        var btnViewPagosxLegalizar = Ext.getCmp('btnViewPagosxLegalizar').on("click",this.VerDetalleCopago,this);
        var btnDiasDisp201601 = Ext.getCmp('btnDiasDisp201601').on("click",this.fnDiasDisp201601,this);
        
        this.BorrarTmpConceptos();
        Ext.getCmp('strDeptoMuni_citas').setValue(ID_MUNICIPIO);
    },
    fnDiasDisp201601: function(){
        Ext.getCmp('gridDiasAgendaCitas').store.reload();
        Ext.getCmp('gridProfesionalesCitas').store.removeAll();
        Ext.getCmp('gridHorariosAgendasCitas').store.removeAll();
        //RAFEL
    },
    VerDetalleCopago: function(){
        if(Ext.getCmp('gridLegalizarOtros').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridLegalizarOtros').selModel.getSelections();
            xCAS = selections[0].json.CAS_REF;
            var winFrmDetalleCopagos = new winFrmDetalleCopagosUi();
            Ext.getCmp('gridVerDetalleCopagos').store.setBaseParam("task", "VER_DETALLE_COPAGOS");
            Ext.getCmp('gridVerDetalleCopagos').store.setBaseParam("pCAS", xCAS);
            Ext.getCmp('gridVerDetalleCopagos').store.load();
            winFrmDetalleCopagos.show();
        }else{
            Ext.MessageBox.show({
                title: 'Copagos',
                msg: 'Debe seleccionar un CAS para poder visualizar el detalle del copago.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    CrearProfesionalSolicitante: function() {
        var winProfeSol = new winProfeSolUi();
        winProfeSol.title = 'eOfiClinic .::Adicionar Profesional Solicitante::.';
        Ext.getCmp('btn_AdicionarProfeSol').setVisible(true);
        Ext.getCmp('btn_ModificarProfeSol').setVisible(false);
        Ext.getCmp('sysUsuario').setVisible(false);
        Ext.getCmp('sysFechaAct').setVisible(false);
        Ext.getCmp('intUsuario').setValue(ID_USUARIO);
        winProfeSol.show();
    },
    CargaTiposAtencionPrograma: function(cmb, rec, idx) {
        Ext.getCmp('sysProgramaTipoAtencion').clearValue();
        Ext.getCmp('sysProgramaTipoAtencion').store.removeAll(true);

        Ext.getCmp('sysProgramaTipoAtencion').store.load({
            params: { 'pPrograma': cmb.getValue() }
        });
        Ext.getCmp('sysProgramaTipoAtencion').enable();
        Ext.getCmp('gridHorariosAgendasCitas').store.load();
    },
    CargaHorasTipoAtencion: function(cmb, rec, idx) {
        if(rec.data.NroHoras == "" || rec.data.NroHoras == 0 || rec.data.NroHoras == null){
            Ext.getCmp('sysHorasPrograma').setValue(1);
        }else{
            Ext.getCmp('sysHorasPrograma').setValue(rec.data.NroHoras);
        }
        Ext.getCmp('gridHorariosAgendasCitas').store.load();
    },
    ChangeCargaCbSubPlan: function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('sysSubPlan').store.removeAll(true);
            Ext.getCmp('sysSubPlan').setValue(null);
            Ext.getCmp('sysSubPlan').disable();
        }
    },
    ChangeCargaCbPlan: function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('sysPlan').store.removeAll(true);
            Ext.getCmp('sysSubPlan').store.removeAll(true);
            Ext.getCmp('sysContrato').store.removeAll(true);
            Ext.getCmp('sysPlan').setValue(null);
            Ext.getCmp('sysSubPlan').setValue(null);
            Ext.getCmp('sysContrato').setValue(null);
            Ext.getCmp('sysPlan').disable();
            Ext.getCmp('sysSubPlan').disable();
            Ext.getCmp('sysContrato').disable();
        }
    },
    BuscarPaciente: function(){
        buscarpaciente("BarraServiciosIPS");
    },
    AsignarCitasSesiones: function(){
        if(Ext.getCmp('gridProfesionalesCitas').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridProfesionalesCitas').selModel.getSelections();
            ID_PROFESIONAL_SELECCIONADO = 0;
            ID_PROFESIONAL_SELECCIONADO = selections[0].json.profesionalID;
            NOM_PROFESIONAL_SELECCIONADO = "";
            NOM_PROFESIONAL_SELECCIONADO = PonerAcentosMayusculas(selections[0].json.profesionalDescripcion);
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea bloquear el profesional y asignar citas para sesiones con el profesional seleccionado?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        Ext.Ajax.request({
                            waitMsg: 'Por favor Espere...',
                            url: "../../controlador/agendas/controlador_asignarcitas.php",
                            params: {
                                task: "BLOQUEAR_CITAS",
                                pEmpresa: ID_EMPRESA,
                                pIPS: ID_IPS,
                                pProfesional: selections[0].json.profesionalID,
                                pUsuario: ID_USUARIO,
                                pCodBloqueo: CODBLOQUEOAGENDA
                            },
                            success: function(response)
                            {
                                var winasignasesiones = new winAsignarCitasSesionesUi();
                                winasignasesiones.title = Ext.getCmp('systxtIdPac').getValue();
                                Ext.getCmp('gridHorariosAgendasSesiones').title = "Profesional: " + NOM_PROFESIONAL_SELECCIONADO;
                                winasignasesiones.show();
                            }
                        });
                    }
                }
            });
        }
    },
    HistorialOtrosPagos: function(){
        var winFrmHistorialOtrosPagos = new winFrmHistorialOtrosPagosUi();
        Ext.getCmp('gridHistorialOtrosPagos').store.setBaseParam("task", "HISTORIAL_OTROS_PAGOS");
        Ext.getCmp('gridHistorialOtrosPagos').store.setBaseParam("pEmpresa", ID_EMPRESA);
        Ext.getCmp('gridHistorialOtrosPagos').store.setBaseParam("pIPS", ID_IPS);
        Ext.getCmp('gridHistorialOtrosPagos').store.setBaseParam("pSede", ID_SEDE);
        Ext.getCmp('gridHistorialOtrosPagos').store.setBaseParam("pPaciente", Ext.getCmp('intIdPaciente_citas').getValue());
        Ext.getCmp('gridHistorialOtrosPagos').store.load({
            params: {
                start: 0,
                limit: 15
            }
        });
        winFrmHistorialOtrosPagos.show();
    },
    HistorialCitasLegalizadas: function(){
        var winFrmHistorialLegalizaciones = new winFrmHistorialLegalizacionesUi();
        winFrmHistorialLegalizaciones.setTitle("OfiClinic© Web..! .:: Historial de Legalizaciones ::.");
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("task", "HISTORIAL_CITAS_LEGALIZADAS");
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pEmpresa", ID_EMPRESA);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pIPS", ID_IPS);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pSede", ID_SEDE);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pPaciente", Ext.getCmp('intIdPaciente_citas').getValue());
        Ext.getCmp('gridHistorialCitas').store.load({
            params: {
                start: 0,
                limit: 15
            }
        });
        winFrmHistorialLegalizaciones.show();
    },
    LegalizarCita: function(){
        if(Ext.getCmp('gridLegalizarCitas').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridLegalizarCitas').selModel.getSelections();
            abrir_ventana("../../../app/frm/radicacionservicios/frmradicacionservicios.php?Legalizar="+selections[0].json.CAS,"ofiClinic");
        }
    },
    LegalizarPago: function(){
        if(Ext.getCmp('gridLegalizarOtros').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridLegalizarOtros').selModel.getSelections();
            xIdPago = selections[0].json.idConceptoCobro;
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea legalizar ' + selections[0].json.Concepto +  ', por valor a pagar de: $ ' + selections[0].json.VlrConcepto,
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn === "yes"){
                        Ext.Ajax.request({
                            url: '../../controlador/radicacionservicios/legalizacioncas.php',
                            params:{
                                PROCESO: 'LegalizarCopagosOdo',
                                pIdCobro: selections[0].json.idConceptoCobro,
                                pCAS: selections[0].json.CAS_REF,
                                pEmpresa: ID_EMPRESA,
                                pIPS: selections[0].json.IPS,
                                pUsuario: ID_USUARIO,
                                pVltTotal: selections[0].json.VlrConcepto,
                                pVlrIVA: 0,
                                pVlrCM: 0,
                                pVlrCOP: 0,
                                pVlrDescuentos: 0,
                                pVlrNeto: selections[0].json.VlrConcepto,
                                pCliente: selections[0].json.Cliente
                            },
                            success: function(response,options){
                                var NroDocumento = response.responseText;
                                if (NroDocumento > 0){
                                    Ext.Ajax.request({
                                        url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                        params:{
                                            PROCESO: 'GenerarDocumentoCopagoOdo',
                                            pDocumentoFac: NroDocumento,
                                            pIdCobro: selections[0].json.idConceptoCobro,
                                            pCAS: selections[0].json.CAS_REF,
                                            pPaciente: selections[0].json.Paciente,
                                            pEmpresa: ID_EMPRESA,
                                            pIPS: selections[0].json.IPS,
                                            pUsuario: ID_USUARIO,
                                            pVltTotal: selections[0].json.VlrConcepto,
                                            pVlrIVA: 0,
                                            pVlrCM: 0,
                                            pVlrCOP: 0,
                                            pVlrDescuentos: 0,
                                            pVlrNeto: selections[0].json.VlrConcepto,
                                            pCliente: selections[0].json.Cliente
                                        },
                                        success: function(response,options){
                                            Ext.getCmp('gridLegalizarOtros').store.load({
                                                params: {
                                                    pEmpresa: ID_EMPRESA,
                                                    pSede: ID_SEDE,
                                                    pIPS: ID_IPS,
                                                    pPaciente: Ext.getCmp('intIdPaciente_citas').getValue()
                                                }
                                            });
                                            Ext.MessageBox.show({
                                                title: 'eOfiClinic',
                                                msg: 'Se Legalizo con Exito el recaudo del copago, por favor verifique el historial de pagos para realizar la impresion del recibo.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.INFO
                                            });
                                        },scope:this
                                    });
                                }
                            },
                            failure: function(response,options){
                                Ext.MessageBox.show({
                                    title: 'eOfiClinic',
                                    msg: 'Ocurrio un error al legalizar el copago o no se pudo establecer conexión con el servidor.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            },
                            scope:this
                        });
                    }
                }
            });
        }
    },
    LiquidarOrden: function(){
        //if(parseInt(Ext.getCmp('fCas').getValue()) !== 0 && parseInt(Ext.getCmp('fModificaCAS').getValue()) === 1 && parseInt(Ext.getCmp('fYaLegalizado').getValue()) === 0){
        if(parseInt(Ext.getCmp('fCas').getValue()) !== 0 && parseInt(Ext.getCmp('fModificaCAS').getValue()) === 1){
            var stliquida = new StoreLiquidacionCAS();
            stliquida.load({
                params: {
                    pCAS: Ext.getCmp('fCas').getValue(),
                    PROCESO: "VerLiquidacion"
                },
                callback: function(r,o,s){
                    Ext.getCmp('sysVlrTotal_estudios').setValue(stliquida.getAt(0).get('vlrTotal'));
                    Ext.getCmp('sysVlrIVA_estudios').setValue(stliquida.getAt(0).get('vlrIVA'));
                    Ext.getCmp('sysVlrCM_estudios').setValue(stliquida.getAt(0).get('vlrCM'));
                    Ext.getCmp('sysVlrCopago_estudios').setValue(stliquida.getAt(0).get('vlrCOP'));
                    Ext.getCmp('sysVlrDescuentos_estudios').setValue(stliquida.getAt(0).get('vlrDescuentos'));
                    Ext.getCmp('sysVlrNeto_estudios').setValue(stliquida.getAt(0).get('vlrNeto'));
                    Ext.getCmp('fYaLiquidado').setValue(1);
                    
                    //Ext.getCmp('fExento').setValue(1);
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Orden de Servicio no esta disponible y no podemos realizar la liquidación',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    BorrarTmpConceptos: function(){
        /*Ext.Ajax.request(
        {
            url: '../../controlador/conceptos/deltmpconceptos.php',
            params:{
                pNomTabla: "USR_" + ID_USUARIO
            },
            failure: function(response,options){
                Ext.MessageBox.show({
                    title: 'Cargando Matriz de Conceptos',
                    msg: 'Ocurrio un error al al cargar la matriz de conceptos o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            },
            scope:this
        });*/
    },
    InasistenciaCita: function(){
        if(Ext.getCmp('gridLegalizarCitas').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridLegalizarCitas').selModel.getSelections();
            xCAS = selections[0].json.CAS;
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea marcar inasistente la cita Nro. ' + xCAS + ' ?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        var winInasistenciaCitas = new winInasistenciaCitaUi();
                        Ext.getCmp('sysEmpresa').setValue(ID_EMPRESA);
                        Ext.getCmp('sysIPS').setValue(ID_IPS);
                        Ext.getCmp('sysCAS').setValue(xCAS);
                        Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                        Ext.getCmp('sysProfesionalAgenda').setValue(selections[0].json.Profesional);
                        Ext.getCmp('sysConsultorioAgenda').setValue(selections[0].json.Ubicacion);
                        Ext.getCmp('sysFecha').setValue(selections[0].json.FechaCita);
                        Ext.getCmp('sysHora').setValue(selections[0].json.HoraAgenda);
                        winInasistenciaCitas.show();
                    }
                }
            });
        }
    },
    CancelarCita: function(){
        
        if(Ext.getCmp('gridLegalizarCitas').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridLegalizarCitas').selModel.getSelections();
            xCAS = selections[0].json.CAS;
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea cancelar la cita Nro. ' + xCAS + ' ?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        var winCancelaCitas = new winCancelarCitaUi();
                        Ext.getCmp('sysEmpresa').setValue(ID_EMPRESA);
                        Ext.getCmp('sysIPS').setValue(ID_IPS);
                        Ext.getCmp('sysCAS').setValue(xCAS);
                        Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                        Ext.getCmp('sysProfesionalAgenda').setValue(selections[0].json.Profesional);
                        Ext.getCmp('sysConsultorioAgenda').setValue(selections[0].json.Ubicacion);
                        Ext.getCmp('sysFecha').setValue(selections[0].json.FechaCita);
                        Ext.getCmp('sysHora').setValue(selections[0].json.HoraAgenda);
                        winCancelaCitas.show();
                    }
                }
            });
        }
    },
    HistorialCitasInasistencia: function(){
        var winFrmHistorialCitas = new winFrmHistorialCitasUi();
        winFrmHistorialCitas.setTitle("OfiClinic© Web..! .:: Historial de Inasistencia ::.");
        winFrmHistorialCitas.setIconClass("btnCitasInasistencia");
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("task", "HISTORIAL_CITAS_INASISTENCIA");
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pEmpresa", ID_EMPRESA);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pIPS", ID_IPS);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pPaciente", Ext.getCmp('intIdPaciente_citas').getValue());
        Ext.getCmp('gridHistorialCitas').getColumnModel().setColumnHeader(5, "Fecha Marca Inasistencia");
        Ext.getCmp('gridHistorialCitas').getColumnModel().setColumnHeader(6, "Usuario Marca Inasistencia");
        Ext.getCmp('gridHistorialCitas').getColumnModel().setColumnHeader(7, "Motivo Inasistencia");
        Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(8, true);
        Ext.getCmp('idPacienteHistoricoCitasAsignadas').setValue(Ext.getCmp('intIdPaciente_citas').getValue());
        Ext.getCmp('gridHistorialCitas').store.load({
            params: {
                start: 0,
                limit: 15
            }
        });
        winFrmHistorialCitas.show();
    },
    HistorialCitasCanceladas: function(){
        var winFrmHistorialCitas = new winFrmHistorialCitasUi();
        winFrmHistorialCitas.setTitle("OfiClinic© Web..! .:: Historial de Citas Canceladas ::.");
        winFrmHistorialCitas.setIconClass("btnCitasCanceladas");
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("task", "HISTORIAL_CITAS_CANCELADAS");
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pEmpresa", ID_EMPRESA);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pIPS", ID_IPS);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pPaciente", Ext.getCmp('intIdPaciente_citas').getValue());
        Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(8, true);
        Ext.getCmp('idPacienteHistoricoCitasAsignadas').setValue(Ext.getCmp('intIdPaciente_citas').getValue());
        Ext.getCmp('gridHistorialCitas').store.load({
            params: {
                start: 0,
                limit: 15
            }
        });
        winFrmHistorialCitas.show();
    },
    HistorialCitasAsignadas: function(){
        var winFrmHistorialCitas = new winFrmHistorialCitasUi();
        winFrmHistorialCitas.setTitle("OfiClinic© Web..! .:: Historial de Citas Asignadas ::.");
        winFrmHistorialCitas.setIconClass("btnCitasAsignadas");
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("task", "HISTORIAL_CITAS_ASIGNADAS");
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pEmpresa", ID_EMPRESA);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pIPS", ID_IPS);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pPaciente", Ext.getCmp('intIdPaciente_citas').getValue());
        Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(5, true);
        Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(6, true);
        Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(7, true);
        Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(8, true);
        Ext.getCmp('idPacienteHistoricoCitasAsignadas').setValue(Ext.getCmp('intIdPaciente_citas').getValue());
        Ext.getCmp('gridHistorialCitas').store.load({
            params: {
                start: 0,
                limit: 15
            }
        });
        winFrmHistorialCitas.show();
    },
    CitasxLegalizar: function(){
        if (Ext.getCmp('intIdPaciente_citas').getValue() != 0)
        {
            Ext.getCmp('gridLegalizarCitas').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pSede: ID_SEDE,
                    pIPS: ID_IPS,
                    pPaciente: Ext.getCmp('intIdPaciente_citas').getValue()
                }
            });
        }
    },
    PagosxLegalizar: function(){
        if (Ext.getCmp('intIdPaciente_citas').getValue() != 0){
            Ext.Msg.wait('Cargando Información del Paciente... por favor espere!');
            Ext.Ajax.request({
                waitMsg: 'Por favor Espere...',
                url: "../../controlador/asistencial/controlador_odontologia.php",
                params: {
                    task: "GENERAR_COPAGOSxLEGALIZAR",
                    pUsuario: ID_USUARIO,
                    pPaciente: Ext.getCmp('intIdPaciente_citas').getValue()
                },
                success: function(response){
                    var result = response.responseText;
                    if (result > 0){
                        Ext.Ajax.request({
                            waitMsg: 'Por favor Espere...',
                            url: "../../controlador/asistencial/controlador_odontologia.php",
                            params: {
                                task: "GENERAR_MULTASxLEGALIZAR",
                                pUsuario: ID_USUARIO,
                                pPaciente: Ext.getCmp('intIdPaciente_citas').getValue()
                            },
                            success: function(response){
                                Ext.MessageBox.hide();
                                var result = response.responseText;
                                if (result > 0){
                                    Ext.getCmp('gridLegalizarOtros').store.load({
                                        params: {
                                            pEmpresa: ID_EMPRESA,
                                            pSede: ID_SEDE,
                                            pIPS: ID_IPS,
                                            pPaciente: Ext.getCmp('intIdPaciente_citas').getValue()
                                        }
                                    });
                                }else{
                                    Ext.MessageBox.show({
                                        title: 'Error',
                                        msg: 'ERROR DE COMUNICACION, vuelva a intentarlo.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            },
                            failure: function(response){
                                Ext.MessageBox.hide();
                                var result = response.responseText;
                                Ext.MessageBox.show({
                                    title: 'Error Base Datos',
                                    msg: 'No podemos verificar los copagos a pagar en estos momentos',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'ERROR DE COMUNICACION, vuelva a intentarlo.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                },
                failure: function(response){
                    Ext.MessageBox.hide();
                    var result = response.responseText;
                    Ext.MessageBox.show({
                        title: 'Error Base Datos',
                        msg: 'No podemos verificar los copagos a pagar en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            });
            
        }
    },
    AsignarCitas: function(){
        var Celular = Ext.getCmp('strTel2_citas').getValue();
        var nro_cel = Celular.length;
        if (nro_cel != 10){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'El Numero de Celular no es correcto.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            SI_ASIGNAR_CITAS = 1;
            if(SI_CONTROL_SOLICITANTE == "1"){
                if(Ext.getCmp('sysProfeSolCitaControl').getValue() != null && Ext.getCmp('sysFecSolCitaControl').getValue() != null){
                    SI_ASIGNAR_CITAS = 1;
                    SI_ASIGNAR_CITAS_SOL = 1;
                }else{
                    SI_ASIGNAR_CITAS_SOL = 0;
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Los campos de profesional solicitante y fecha de solicitud de la autorizacion son requeridos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }else{
                SI_ASIGNAR_CITAS_SOL = 1;
            }
            if(parseInt(SI_ASIGNAR_CITAS) === 1){ 
                var parametrosCitasSeleccionadas = "";
                var SolicitudUsuaio = (Ext.getCmp('bolAsignaCitasSolicitudUsuario').getValue()==true)?'1':'0';
                var grupoCita = 0;
                if (Ext.getCmp('sysFecCitaPaciente').getValue() != null && Ext.getCmp('sysFecCitaPaciente').getValue() != "" && Ext.getCmp('sysFormaAsignacionCita').getValue() != null && Ext.getCmp('sysFormaAsignacionCita').getValue() != "" && Ext.getCmp('sysCliente').getValue() != null && Ext.getCmp('sysCliente').getValue() != "" && Ext.getCmp('intIdPaciente_citas').getValue() != 0 && Ext.getCmp('sysPlan').getValue() != null && Ext.getCmp('sysPlan').getValue() != "" && Ext.getCmp('sysSubPlan').getValue() != null && Ext.getCmp('sysSubPlan').getValue() != "" && Ext.getCmp('fCodConcepto').getValue() != null && Ext.getCmp('fCodConcepto').getValue() != "" && Ext.getCmp('strTafiliado_citas').getValue() != null && Ext.getCmp('strTafiliado_citas').getValue() != "" && Ext.getCmp('strRegimen_citas').getValue() != null && Ext.getCmp('strRegimen_citas').getValue() != "" && Ext.getCmp('sysPrograma').getValue() != null && Ext.getCmp('sysPrograma').getValue() != "" && Ext.getCmp('sysFinalidad').getValue() != null && Ext.getCmp('sysFinalidad').getValue() != "" && SI_ASIGNAR_CITAS_SOL == "1"){
                    Ext.Msg.show({
                        title: 'eOfiClinic',
                        msg: 'Esta seguro que desea asignar la cita?',
                        buttons: Ext.Msg.YESNO,
                        icon: Ext.Msg.QUESTION,
                        fn: function(btn)
                        {
                            if(btn=="yes")
                            {
                                var citasseleccionadas = false;
                                Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                    return record.get('Seleccionar') == true;
                                });
                                Ext.getCmp('gridHorariosAgendasCitas').store.each(function(record){
                                    grupoCita = record.get('GrupoCita');
                                });
                                Ext.getCmp('gridHorariosAgendasCitas').store.clearFilter();
                                if(grupoCita != 0){
                                    Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                        return record.get('GrupoCita') == grupoCita;
                                    });
                                    Ext.getCmp('gridHorariosAgendasCitas').store.each(function(record){
                                        citasseleccionadas = true;
                                        parametrosCitasSeleccionadas = parametrosCitasSeleccionadas + record.get('citaID') + "^" + record.get('citaInfoAdd') + "^" + record.get('TipoHorario') + "¬";
                                    });
                                }
                                if (citasseleccionadas == false)
                                {
                                    Ext.MessageBox.show({
                                        title: 'Error',
                                        msg: 'Debe seleccionar al menos una cita para poder realizar la asignación',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }else{
                                    Ext.Ajax.request({
                                        waitMsg: 'Por favor Espere...',
                                        url: "../../controlador/agendas/controlador_asignarcitas202001.php",
                                        params: {
                                            task: "ASIGNAR_CITAS",
                                            pEmpresa: ID_EMPRESA,
                                            pSede: ID_SEDE, 
                                            pIPS: ID_IPS, 
                                            pConsultorio: ID_CONSULTORIO_SELECCIONADO,
                                            pProfesionalCita: ID_PROFESIONAL_SELECCIONADO,
                                            pUsuario: ID_USUARIO,
                                            pPaciente: Ext.getCmp('intIdPaciente_citas').getValue(),
                                            pIdProced: Ext.getCmp('fidConcepto').getValue(),
                                            pCodProced: Ext.getCmp('fCodConcepto').getValue(),
                                            pDesProced: QuitarAcentosTxtMayusculas(Ext.getCmp('fDesConcepto').getValue()),
                                            pTarifaProced: Ext.getCmp('fVlrUnitario').getValue(),
                                            pCodCliente: Ext.getCmp('sysCliente').getValue(),
                                            pDesCliente: QuitarAcentosTxtMayusculas(Ext.getCmp('sysCliente').getRawValue()),
                                            pCodPlan: Ext.getCmp('sysPlan').getValue(),
                                            pDesPlan: QuitarAcentosTxtMayusculas(Ext.getCmp('sysPlan').getRawValue()),
                                            pCodSubPlan: Ext.getCmp('sysSubPlan').getValue(),
                                            pDesSubPlan: QuitarAcentosTxtMayusculas(Ext.getCmp('sysSubPlan').getRawValue()),
                                            pContrato: Ext.getCmp('sysContrato').getValue(),
                                            pUsuarioAsigna: ID_USUARIO,
                                            pObservaciones: QuitarAcentosTxtMayusculas(Ext.getCmp('strObservacionesCita').getValue()),
                                            pSolicitudUsuario: SolicitudUsuaio,
                                            pFechaCita: FECHA_SELECCIONADA,
                                            pTipoAfiliacion: Ext.getCmp('strTafiliado_citas').getValue(),
                                            pTipoAfiliado: Ext.getCmp('strRegimen_citas').getValue(),
                                            pParentesco: Ext.getCmp('strParentesco_citas').getValue(),
                                            pRangoSalarial: Ext.getCmp('strRango_citas').getValue(),
                                            pEstadoListado: Ext.getCmp('strEstado_citas').getValue(),
                                            pEdadPaciente: QuitarAcentosTxtMayusculas(Ext.getCmp('strEdad_citas').getValue()),
                                            pDeptoMuniciPaciente: Ext.getCmp('strDeptoMuni_citas').getValue(),
                                            pPrograma: Ext.getCmp('sysPrograma').getValue(),
                                            pFinalidad: Ext.getCmp('sysFinalidad').getValue(),
                                            pFacturarParticular: Ext.getCmp('sysFacturarParticular').getValue(),
                                            pFacturarCopagos: Ext.getCmp('sysFacturarCopagos').getValue(),
                                            pCopagoDigitado: Ext.getCmp('sysCopagoDigitado').getValue(),
                                            pPorCopagos: Ext.getCmp('sysPorCopagos').getValue(),
                                            pMaxCopago: Ext.getCmp('sysMaxCopago').getValue(),
                                            pvlrCuotaModeradoraIndicada: Ext.getCmp('sysvlrCuotaModeradoraIndicada').getValue(),
                                            pExento: Ext.getCmp('sysExento').getValue(),
                                            pTutela: Ext.getCmp('sysTutela').getValue(),
                                            pProfeSol: Ext.getCmp('sysProfeSol').getValue(),
                                            pAutorizacion: Ext.getCmp('sysAutorizacion').getValue(),
                                            pFechaSol: Ext.getCmp('sysFecSol').getValue(),
                                            pMarcaExento: Ext.getCmp('bolMarcaExento').getValue(),
                                            pFecCitaPaciente: Ext.getCmp('sysFecCitaPaciente').getValue(),
                                            pFormaAsignacionCita: Ext.getCmp('sysFormaAsignacionCita').getValue(),
                                            pProfeSolicitaControl: Ext.getCmp('sysProfeSolCitaControl').getValue(),
                                            pFechaSolicitaControl: Ext.getCmp('sysFecSolCitaControl').getValue(),
                                            pInfoCita: parametrosCitasSeleccionadas
                                        },
                                        success: function(response)
                                        {
                                            var result = response.responseText;
                                            if (result > 0)
                                            {
                                                Ext.getCmp('sysHorasPrograma').setValue(1);
                                                Ext.getCmp('sysCliente').clearValue();
                                                Ext.getCmp('sysPlan').clearValue();
                                                Ext.getCmp('sysSubPlan').clearValue();
                                                Ext.getCmp('sysContrato').clearValue();
                                                Ext.getCmp('sysCliente').setValue(null);
                                                Ext.getCmp('sysPlan').setValue(null);
                                                Ext.getCmp('sysSubPlan').setValue(null);
                                                Ext.getCmp('sysContrato').setValue(null);
                                                Ext.getCmp('fCodConcepto').setValue(null);
                                                Ext.getCmp('fDesConcepto').setValue(null);
                                                Ext.getCmp('fVlrUnitario').setValue(null);
                                                Ext.getCmp('fidConcepto').setValue(null);
                                                Ext.getCmp('strObservacionesCita').setValue(null);
                                                Ext.getCmp('bolAsignaCitasSolicitudUsuario').setValue(null);
                                                Ext.getCmp('bolMarcaExento').setValue(null);
                                                Ext.getCmp('gridDiasAgendaCitas').store.removeAll();
                                                Ext.getCmp('gridProfesionalesCitas').store.removeAll();
                                                Ext.getCmp('gridHorariosAgendasCitas').store.removeAll();
                                                //Ext.getCmp('gridHorariosAgendasCitas').store.load();
                                                Ext.Ajax.request(
                                                {
                                                    waitMsg: 'Por favor Espere...',
                                                    url: '../../controlador/agendas/controlador_asignarcitas.php',
                                                    params:{
                                                        task: "AGENDAS_DESBLOQUEAR",
                                                        pUsuario: ID_USUARIO,
                                                        pIPS: ID_IPS
                                                    },
                                                    scope:this
                                                });
                                                var html = '<table><tr><td width="50"><img src="../../../resources/varios/citas.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #2E2EFE; font-size: 14px;">Asignación de Citas:</h1><br/><p style="color: #003333;font-weight: bold;">Se Asigno la Cita Nro. ' + result  + '</p></br>';
                                                html += '<br/><p style="color: #003333;font-weight: bold;">Profesional: ' + NOM_PROFESIONAL_SELECCIONADO +'</p>';
                                                html += '<p style="color: #003333;font-weight: bold;">Ubicación: ' + NOM_CONSULTORIO_SELECCIONADO +'</p>';
                                                html += '<p style="color: #003333;font-weight: bold;">Fecha: ' + FECHA_SELECCIONADA +'</p>';
                                                html += '</td><td width="70">&nbsp</td></tr></table>';
                                                Sexy.info(html);
                                                
                                                Ext.getCmp('sysProfeSolCitaControl').setValue(null);
                                                Ext.getCmp('sysFecSolCitaControl').setValue(null);
                                                Ext.getCmp('sysProfeSolCitaControl').allowBlank = true;
                                                Ext.getCmp('sysFecSolCitaControl').allowBlank = true;
                                                Ext.getCmp('sysProfeSolCitaControl').clearInvalid();
                                                Ext.getCmp('sysFecSolCitaControl').clearInvalid(); 
                                                Ext.getCmp('sysFSolicitanteControl').setDisabled(true);
                                                SI_CONTROL_SOLICITANTE = 0;
                                                SI_ASIGNAR_CITAS_SOL = 0;
                                                
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'ERROR DE COMUNICACION, La Cita quedo mal asignada por favor limpie el formulario y vuelva a intentarlo.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        },
                                        failure: function(response){
                                            var result = response.responseText;
                                            Ext.MessageBox.show({
                                                title: 'Error Base Datos',
                                                msg: 'No podemos asignar las citas en estos momentos',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    });
                                }
                            }
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Verifique que los campos obligatorios estan diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El paciente tiene multas por inasistencia a odontología, No se puede asignar citas hasta que realice el pago correspondiente.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    BuscarConceptoCitas: function(){
        buscarconcepto('BarraServiciosMP2016', 'NO','NO','NO','SI','gridDiasAgendaCitas','CITAS', Ext.getCmp('sysCliente').getValue(), Ext.getCmp('sysPlan').getValue(), Ext.getCmp('sysSubPlan').getValue());
    },
    LimpiarFormularioPaciente: function(){
        Ext.Msg.show({
            title: 'Limpiar Formulario',
            msg: 'Esta seguro que desea limpiar el formulario y borrar la información de identificaciíon del servicio',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    Ext.getCmp('frmPacienteBarraServicios').getForm().reset();
                    Ext.getCmp('sysHorasPrograma').setValue(1);
                    Ext.getCmp('sysPlan').store.removeAll(true);
                    Ext.getCmp('sysSubPlan').store.removeAll(true);
                    Ext.getCmp('sysContrato').store.removeAll(true);
                    Ext.getCmp('sysCliente').clearValue();
                    Ext.getCmp('sysPlan').clearValue();
                    Ext.getCmp('sysSubPlan').clearValue();
                    Ext.getCmp('sysContrato').clearValue();
                    Ext.getCmp('systxtIdPac').setValue(null);
                    Ext.getCmp('sysCliente').setValue(null);
                    Ext.getCmp('sysPlan').setValue(null);
                    Ext.getCmp('sysSubPlan').setValue(null);
                    Ext.getCmp('sysContrato').setValue(null);
                    Ext.getCmp('btnGuardarPac_citas').setTooltip('Crear Datos del Paciente');
                    CREAR_PACIENTE = 0;
                    SI_ASIGNAR_CITAS = 1;
                    paso1 = false;
                    Ext.getCmp('sysClienteLA').setValue(0);
                    Ext.getCmp('sysPlanLA').setValue(0);
                    Ext.getCmp('sysSubPlanLA').setValue(0);
                    Ext.getCmp('sysPacienteValido').setValue(0);
                    Ext.getCmp('strDeptoMuni_citas').setValue(ID_MUNICIPIO);
                    stCliente.load({params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}});
                    Ext.getCmp('sysPrograma').store.removeAll();
                }
            }
        });
    },
    PrintAgenda: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "PrintAgenda_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Agendas - Imprimir:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if (AGENDA_SELECCIONADA != 0)
            {
                //location.href='../../controlador/agendas/agenda_print.php?pEmpresa='+ID_EMPRESA+'&pFiltroAgenda=s&pAgenda=' + AGENDA_SELECCIONADA;
                window.open ('../../controlador/agendas/agenda_print.php?pEmpresa='+ID_EMPRESA+'&pFiltroAgenda=s&pAgenda=' + AGENDA_SELECCIONADA,"Imprimir Agenda");
                AGENDA_SELECCIONADA = 0;
            }else{
                Ext.MessageBox.show({
                    title: 'Imprimir Agenda',
                    msg: 'Debe seleccionar una fecha de agenda para imprimir.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    VerAgendasBloqueadas: function(){
        var winAgendaBloquadaxProfe = new winAgendaBloquadaxProfeUi();
        Ext.getCmp('gridAgendasBloqueadas').store.load({
            params: {
                pIPS: ID_IPS,
                pProfesional: ID_PROFESIONAL_SELECCIONADO,
                pConsultorio: ID_CONSULTORIO_SELECCIONADO
            }
        });
        Ext.getCmp('nomProfesionalAgenda').setValue(NOM_PROFESIONAL_SELECCIONADO);
        Ext.getCmp('nomConsultorioAgenda').setValue(NOM_CONSULTORIO_SELECCIONADO);
        
        winAgendaBloquadaxProfe.show();
    },
    ValidarNumeroDocumentoPacSK: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
            Ext.getCmp('sysPacienteValido').setValue(0);
            Ext.getCmp('strgenero_citas').setValue("");
            Ext.getCmp('strApe1_citas').setValue("");
            Ext.getCmp('strApe2_citas').setValue("");
            Ext.getCmp('strNom1_citas').setValue("");
            Ext.getCmp('strNom2_citas').setValue("");
            Ext.getCmp('strEdad_citas').setValue("");
            Ext.getCmp('strDeptoMuni_citas').setValue("");
            Ext.getCmp('strDireccion_citas').setValue("");
            Ext.getCmp('strZona_citas').setValue("");
            Ext.getCmp('strTel1_citas').setValue("");
            Ext.getCmp('strTel2_citas').setValue("");
            Ext.getCmp('strEmail_citas').setValue("");
            Ext.getCmp('fecFecNac_citas').setValue("");
            Ext.getCmp('strEdad_citas').setValue("");
            Ext.getCmp('strRegimen_citas').setValue(1);
            Ext.getCmp('strTafiliado_citas').setValue("");
            Ext.getCmp('strParentesco_citas').setValue("");
            Ext.getCmp('strRango_citas').setValue("");
            Ext.getCmp('strEstado_citas').setValue("");
            Ext.getCmp('sysPacienteValido').setValue(0);
            Ext.getCmp('sysPrograma').store.removeAll();
            Ext.Msg.wait('Cargando Información del Paciente... por favor espere!');
            Ext.Ajax.request(
            {
                url: '../../controlador/pacientes/pacientes_cargardatos.php',
                params:{
                    pTdoc: Ext.getCmp('strTdoc_citas').getValue(),
                    pDocumento: f.getValue()
                },
                success: function(response,options)
                {
                    var el = Ext.get('response'); // get the LOG
                    var Respuesta = response.responseText;
                    var Contenido = Respuesta.split('^');
                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                        Ext.Msg.hide();
                        Ext.getCmp('intIdPaciente_citas').setValue(0);
                        verListadoAtencion(Ext.getCmp('sysIdEmpresa').getValue(),Ext.getCmp('sysIdSede').getValue(),Ext.getCmp('sysIdIPS').getValue(), Ext.getCmp('strTdoc_citas').getValue(), Ext.getCmp('strdocpac_citas').getValue(),true,Ext.getCmp('intIdPaciente_citas').getValue(),"BarraServicios");
                        if (Ext.getCmp('sysAtenderFueraListado').getValue() == 1)
                            Ext.getCmp('sysPacienteValido').setValue(1);
                    } else {
                        Ext.getCmp('intIdPaciente_citas').setValue(Contenido[0]);
                        Ext.getCmp('strTdoc_citas').setValue(Contenido[1]);
                        Ext.getCmp('strgenero_citas').setValue(Contenido[9]);
                        Ext.getCmp('strApe1_citas').setValue(PonerAcentosMayusculas(Contenido[3]));
                        Ext.getCmp('strApe2_citas').setValue(PonerAcentosMayusculas(Contenido[4]));
                        Ext.getCmp('strNom1_citas').setValue(PonerAcentosMayusculas(Contenido[5]));
                        Ext.getCmp('strNom2_citas').setValue(PonerAcentosMayusculas(Contenido[6]));
                        Ext.getCmp('strEdad_citas').setValue(Contenido[8]);
                        Ext.getCmp('strDeptoMuni_citas').setValue(Contenido[15]);
                        Ext.getCmp('strDireccion_citas').setValue(PonerAcentosMayusculas(Contenido[10]));
                        Ext.getCmp('strZona_citas').setValue(Contenido[11]);
                        Ext.getCmp('strTel1_citas').setValue(PonerAcentosMayusculas(Contenido[12]));
                        //Ext.getCmp('strTel2_citas').setValue(PonerAcentosMayusculas(Contenido[13]));
                        Ext.getCmp('strEmail_citas').setValue(PonerAcentosMayusculas(Contenido[14]));
                        if (Contenido[7] != null && Contenido[7] != "")
                        {
                            var xfecnac = Array();
                            xfecnac = Contenido[7].split('-');
                            var dianac = xfecnac[0];
                            var mesnac = (xfecnac[1].length < 2)?'0':'';
                            mesnac += xfecnac[1];
                            var anonac = xfecnac[2];
                            Ext.getCmp('fecFecNac_citas').setValue(dianac + "-" + mesnac + "-" + anonac);
                            Ext.getCmp('strEdad_citas').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fecFecNac_citas').getValue().format('Y/m/d')));
                        }
                        verInfoActividadesxPaciente(Ext.getCmp('intIdPaciente_citas').getValue(),PonerAcentosMayusculas(Ext.getCmp('strTdoc_citas').getValue() + " " + Ext.getCmp('strdocpac_citas').getValue() + " - " + Ext.getCmp('strNom1_citas').getValue() + " " + Ext.getCmp('strNom2_citas').getValue() + " " + Ext.getCmp('strApe1_citas').getValue() + " " + Ext.getCmp('strApe2_citas').getValue()) + " - Genero: " + Ext.getCmp('strgenero_citas').getValue() + " - Edad: " + Ext.getCmp('strEdad_citas').getValue());
                        CREAR_PACIENTE = 1;
                        Ext.getCmp('btnGuardarPac_citas').setTooltip('Actualizar Datos del Paciente');
                        Ext.getCmp('sysPrograma').store.load({
                            params:{
                                pPaciente: Ext.getCmp('intIdPaciente_citas').getValue()
                            }
                        });
                        Ext.Ajax.request(
                        {
                            url: '../../controlador/pacientes/pacientes_sedeips.php',
                            params:{
                                pPaciente: Ext.getCmp('intIdPaciente_citas').getValue(),
                                pIPS: Ext.getCmp('sysIdIPS').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null)
                                    if (Ext.getCmp('sysAtenderFueraListado').getValue() == 1)
                                        Ext.getCmp('sysPacienteValido').setValue(1);
                                else
                                    Ext.getCmp('sysPacienteValido').setValue(1);
                            },
                            failure: function(response,options){
                                if (Ext.getCmp('sysAtenderFueraListado').getValue() == 1)
                                    Ext.getCmp('sysPacienteValido').setValue(1);
                            },
                            scope:this 
                        });
                        /*
                        Ext.Ajax.request({
                            url: '../../controlador/pacientes/pacientes_cargardatos_add.php',
                            params:{
                                pEmpresa: ID_EMPRESA,
                                pPaciente: Ext.getCmp('intIdPaciente_citas').getValue()
                            },
                            success: function(response,options)
                            {
                                var el = Ext.get('response'); // get the LOG
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                    Ext.Msg.hide();
                                } else {
                                    //OJO
                                    /*
                                     * estudios.Paciente, 0
estudios.CAS, 1
estudios.Cliente, 2
estudios.Plan, 3
estudios.Subplan, 4
estudios.Contrato, 5
estudios.FechaEstudio, 6
estudios.FechaToma, 7
estudios.ProfesionalSolicitante, 8
estudios.TipoAfiliacion, 9
estudios.TipoAfiliado, 10
estudios.Parentesco, 11
estudios.RangoSalarial, 12
estudios.EstadoListado,
estudios.SemanasCotizadas
                                     
                                    Ext.getCmp('sysCliente').setValue(Contenido[2]);
                                    Ext.getCmp('sysContrato').store.load({
                                        params: {
                                            'pCliente': Contenido[2]
                                        },
                                        callback: function(){
                                            Ext.getCmp('sysContrato').setValue(Contenido[5]);
                                            Ext.getCmp('sysContrato').enable();
                                        }
                                    });
                                    Ext.getCmp('sysPlan').store.load({
                                        params: {
                                            'pCliente': Contenido[2]
                                        },
                                        callback: function(){
                                            Ext.getCmp('sysPlan').setValue(Contenido[3]);
                                            Ext.getCmp('sysPlan').enable();
                                            Ext.getCmp('sysSubPlan').store.load({
                                                params: {
                                                    'pPlan': Ext.getCmp('sysPlan').getValue()
                                                },
                                                callback: function(){
                                                    Ext.getCmp('sysSubPlan').setValue(Contenido[4]);
                                                    Ext.getCmp('sysSubPlan').enable();
                                                }
                                            });
                                        }
                                    });
                                    Ext.getCmp('strTafiliado_citas').setValue(Contenido[10]);
                                    Ext.getCmp('strParentesco_citas').setValue(Contenido[11]);
                                    Ext.getCmp('strRango_citas').setValue(Contenido[12]);
                                    Ext.getCmp('sysProfeSol').setValue(Contenido[8]);
                                    //sysPrograma
                                }
                            }
                        });
                        */
                        Ext.Msg.hide();
                        if (Ext.getCmp('sysUsaListado').getValue() == "1"){
                            verListadoAtencion(Ext.getCmp('sysIdEmpresa').getValue(),Ext.getCmp('sysIdSede').getValue(),Ext.getCmp('sysIdIPS').getValue(), Ext.getCmp('strTdoc_citas').getValue(), Ext.getCmp('strdocpac_citas').getValue(),true,Ext.getCmp('intIdPaciente_citas').getValue(),"BarraServicios");
                        }
                    }
                },
                failure: function(response,options){
                    var el = Ext.get('response');
                    alert("error al comunicarse con el servidor.");
                },
                scope:this //bind the callbacks
            });
        }
    },
    
    SeleccionarAgendasCita: function(grid, fila, e){
        /*var selections = grid.selModel.getSelections();
        FECHA_SELECCIONADA = selections[0].json.agendaFecha;
        AGENDA_SELECCIONADA = selections[0].json.agendaID;
        Ext.getCmp('gridHorariosAgendasCitas').store.load({
           params: {
               pAgenda: selections[0].json.agendaID,
               pCodBloqueo: CODBLOQUEOAGENDA,
               pUsuario: ID_USUARIO,
               pNroHoras: Ext.getCmp('sysHorasPrograma').getValue()
           },
           callback: function(){
                Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                    return record.get('MostrarGrupoCita') == true;
                });
            }
       });*/
        //alert("Selecciono Fecha");
        var selections = grid.selModel.getSelections();
        FECHA_SELECCIONADA = selections[0].json.agendaFecha;
        Ext.getCmp('gridProfesionalesCitas').store.load({
           params: {
               pIPS: ID_IPS,
               pFecha: selections[0].json.agendaFecha,
               pProced: Ext.getCmp('fidConcepto').getValue(),
               pCodBloqueo: CODBLOQUEOAGENDA,
               pUsuario: ID_USUARIO
           }
        });
        Ext.getCmp('gridProfesionalesCitas').store.removeAll();
        Ext.getCmp('gridHorariosAgendasCitas').store.removeAll();
    },
    SeleccionarFechasCita: function(grid, fila, e){
         var selections = grid.selModel.getSelections();
         Ext.getCmp('gridDiasAgendaCitas').store.load({
            params: {
                pIPS: ID_IPS,
                pProfesional: ID_PROFESIONAL_SELECCIONADO,
                pConsultorio: selections[0].json.Codigo,
                pCodBloqueo: CODBLOQUEOAGENDA
            }
        });
        ID_CONSULTORIO_SELECCIONADO = selections[0].json.Codigo;
        NOM_CONSULTORIO_SELECCIONADO = "";
        NOM_CONSULTORIO_SELECCIONADO = selections[0].json.Descripcion;
        Ext.getCmp('gridHorariosAgendasCitas').store.load();
    },
    SeleccionarProfesionalCita: function(grid, fila, e){
         var selections = grid.selModel.getSelections();
        AGENDA_SELECCIONADA = selections[0].json.agendaID;
        ID_CONSULTORIO_SELECCIONADO = selections[0].json.idConsultorio;
        NOM_CONSULTORIO_SELECCIONADO = "";
        NOM_CONSULTORIO_SELECCIONADO = selections[0].json.Ubicacion;
        ID_PROFESIONAL_SELECCIONADO = 0;
        ID_PROFESIONAL_SELECCIONADO = selections[0].json.profesionalID;
        NOM_PROFESIONAL_SELECCIONADO = "";
        NOM_PROFESIONAL_SELECCIONADO = selections[0].json.profesionalDescripcion;
        Ext.getCmp('gridHorariosAgendasCitas').store.removeAll();
        Ext.getCmp('gridHorariosAgendasCitas').store.load({
           params: {
               pAgenda: selections[0].json.agendaID,
               pCodBloqueo: CODBLOQUEOAGENDA,
               pUsuario: ID_USUARIO,
               pNroHoras: Ext.getCmp('sysHorasPrograma').getValue()
           },
           callback: function(){
                Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                    return record.get('MostrarGrupoCita') == true;
                });
            }
       });
        
    },
    CrearInfoPaciente: function(){
         Ext.Msg.show({
            title: 'Guardar Datos del Paciente',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if (CREAR_PACIENTE == 0){
                        //Crear Paciente
                        fnGuardarRegistros("INSERTAR","NO","winBaraServicios","frmPacienteBarraServicios","../../controlador/pacientes/controlador_pacientes.php","NA","NA","intIdPaciente_citas","NO","NO");
                    }else{
                        //Modificar Paciente
                        fnGuardarRegistros("MODIFICAR","NO","winBaraServicios","frmPacienteBarraServicios","../../controlador/pacientes/controlador_pacientes1701.php","NA","NA","NA","NO","NO");
                    }
                }
            }
        });
    },
    GuardarDatosBasicos: function(){
        var frm = Ext.getCmp('frmRadica').getForm();
        if ( frm.isValid() )
        {
            if (Ext.getCmp('fPacienteValido').getValue() == 1 && !paso1)
            {
                Ext.Msg.show({
                    title: 'Radicar Servicios',
                    msg: 'Esta seguro que desea Radicar la información básica del servicio',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            Ext.Msg.wait('Guardando Radicación de Servicios... por favor espere!');
                            Ext.Ajax.request(
                            {
                                waitMsg: 'Por favor Espere...',
                                url: '../../controlador/radicacionservicios/guardar_datosbasicos1701.php',
                                params:{
                                    PROCESO: 'GuardarDatosBasicos',
                                    pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                    pTDoc: Ext.getCmp('fTdoc').getValue(),
                                    pDocID: Ext.getCmp('fDocID').getValue(),
                                    pRegimen: Ext.getCmp('fRegimen').getValue(),
                                    pGenero: Ext.getCmp('fGenero').getValue(),
                                    pApe1: QuitarAcentosTxtMayusculas(Ext.getCmp('fApe1').getValue().toUpperCase()),
                                    pApe2: QuitarAcentosTxtMayusculas(Ext.getCmp('fApe2').getValue().toUpperCase()),
                                    pNom1: QuitarAcentosTxtMayusculas(Ext.getCmp('fNom1').getValue().toUpperCase()),
                                    pNom2: QuitarAcentosTxtMayusculas(Ext.getCmp('fNom2').getValue().toUpperCase()),
                                    pFecNac: Ext.getCmp('fFecNac').getValue().format("Y-m-d"),
                                    pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                    pDireccion: QuitarAcentosTxtMayusculas(Ext.getCmp('fDireccion').getValue().toUpperCase()),
                                    pTel1: QuitarAcentosTxtMayusculas(Ext.getCmp('fTel1').getValue().toUpperCase()),
                                    pTel2: QuitarAcentosTxtMayusculas(Ext.getCmp('fTel2').getValue().toUpperCase()),
                                    pZona: Ext.getCmp('fZona').getValue(),
                                    pEmail: QuitarAcentosTxtMayusculas(Ext.getCmp('fEmail').getValue()),
                                    pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                    pParentesco: Ext.getCmp('fParentesco').getValue(),
                                    pRango: Ext.getCmp('fRango').getValue(),
                                    pEstado: Ext.getCmp('fEstado').getValue(),
                                    pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                    pIdSede: Ext.getCmp('fIdSede').getValue(),
                                    pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                    pUsuario: Ext.get('idusuario').getValue()
                                },
                                success: function(response,options)
                                {
                                    var Respuesta = response.responseText;
                                    var Contenido = Respuesta.split('^');
                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                        Ext.getCmp('fIdPaciente').setValue(0);
                                        Ext.Msg.hide();
                                        Ext.MessageBox.show({
                                            title: 'Guardando Paciente',
                                            msg: 'Ocurrio un error al guardar la información del paciente o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    } else {
                                        Ext.getCmp('fIdPaciente').setValue(Contenido[0]);
                                        Ext.Ajax.request(
                                        {
                                            url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
                                            params:{
                                                PROCESO: 'AsociarPacienteIPS',
                                                pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                                pIdIPS: Ext.getCmp('fIdIPS').getValue()
                                            },
                                            success: function(response,options){
                                                var Respuesta1 = response.responseText;
                                                var Contenido1 = Respuesta.split('^');
                                                if(Contenido1[0]=="" || Contenido1[0]== "{success:false}" || Contenido1[0]== null){
                                                    Ext.getCmp('fIdPaciente').setValue(0);
                                                    Ext.Msg.hide();
                                                    Ext.MessageBox.show({
                                                        title: 'Guardando Paciente',
                                                        msg: 'Ocurrio un error al asociar el paciente a la IPS o no se pudo establecer conexión con el servidor.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                } else {
                                                    Ext.Ajax.request(
                                                    {
                                                        waitMsg: 'Por favor Espere...',
                                                        url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
                                                        params:{
                                                            PROCESO: 'GenerarCAS',
                                                            pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                                            pRegimen: Ext.getCmp('fRegimen').getValue(),
                                                            pEdad: Ext.getCmp('fEdad').getValue(),
                                                            pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                                            pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                                            pParentesco: Ext.getCmp('fParentesco').getValue(),
                                                            pRango: Ext.getCmp('fRango').getValue(),
                                                            pEstado: Ext.getCmp('fEstado').getValue(),
                                                            pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                                            pIdSede: Ext.getCmp('fIdSede').getValue(),
                                                            pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                                            pExento: Ext.getCmp('fExento').getValue(),
                                                            pTutela: Ext.getCmp('fTutela').getValue(),
                                                            pCliente: Ext.getCmp('fCliente').getValue(),
                                                            pPlan: Ext.getCmp('fPlan').getValue(),
                                                            pSubPlan: Ext.getCmp('fSubPlan').getValue(),
                                                            pContrato: Ext.getCmp('fContrato').getValue(),
                                                            pUsaListado: Ext.getCmp('fUsaListado').getValue(),
                                                            pAtenderFueraListado: Ext.getCmp('fAtenderFueraListado').getValue(),
                                                            pRequiereAutorizacion: Ext.getCmp('fRequiereAutorizacion').getValue(),
                                                            pFacturarParticular: Ext.getCmp('fFacturarParticular').getValue(),
                                                            pFacturarCopagos: Ext.getCmp('sysFacturarCopagos').getValue(),
                                                            pCopagoDigitado: Ext.getCmp('sysCopagoDigitado').getValue(),
                                                            pPorCopagos: Ext.getCmp('sysPorCopagos').getValue(),
                                                            pFecSol: Ext.getCmp('fFecSol').getValue().format("Y-m-d"),
                                                            pAutorizacion: Ext.getCmp(PonerAcentosMayusculas('fAutorizacion').getValue().toUpperCase()),
                                                            pFinalidad: Ext.getCmp('fFinalidad').getValue(),
                                                            pExentoPrograma: Ext.getCmp('fExentoPrograma').getValue(),
                                                            pUsuario: Ext.get('idusuario').getValue()
                                                        },
                                                        success: function(response,options){
                                                            var Respuesta1 = response.responseText;
                                                            var Contenido1 = Respuesta1.split('^');
                                                            if(Contenido1[0]=="" || Contenido1[0]== "{success:false}" || Contenido1[0]== null){
                                                                Ext.getCmp('fIdPaciente').setValue(0);
                                                                Ext.Msg.hide();
                                                                Ext.MessageBox.show({
                                                                    title: 'Guardando Estudio',
                                                                    msg: 'Ocurrio un error al generar el numero de CAS o no se pudo establecer conexión con el servidor.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            } else {
                                                                Ext.Msg.hide();
                                                                Ext.Msg.show({
                                                                    title: 'Generar Radicación de Servicios',
                                                                    msg: 'Se Genero la Radicacón de Servicios Nro: ' + Contenido1[0],
                                                                    buttons: Ext.Msg.OK,
                                                                    icon: Ext.MessageBox.INFO
                                                                });
                                                                Ext.getCmp('fCas').setValue(Contenido1[0]);
                                                                Ext.getCmp('fNroCAS').setValue("CAS Nro: " + Contenido1[0]);
                                                                Ext.getCmp('fFecRadicado').setValue(Contenido1[1]);
                                                                paso1 = true;
                                                            }
                                                        },
                                                        failure: function(response,options){
                                                            Ext.Msg.hide();
                                                            Ext.MessageBox.show({
                                                                title: 'Guardando Estudio',
                                                                msg: 'Ocurrio un error al generar el numero de CAS o no se pudo establecer conexión con el servidor.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        },
                                                        scope:this
                                                    });
                                                }
                                            },
                                            failure: function(response,options){
                                                Ext.Msg.hide();
                                                Ext.MessageBox.show({
                                                    title: 'Guardando Paciente',
                                                    msg: 'Ocurrio un error al asociar el paciente a la IPS o no se pudo establecer conexión con el servidor.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            },
                                            scope:this
                                        });
                                    }
                                },
                                failure: function(response,options){
                                    Ext.Msg.hide();
                                    Ext.MessageBox.show({
                                        title: 'Generar Radicación de Servicios',
                                        msg: 'Error al Generar Nro de Radicación de Servicios, los campos son requeridos o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                },
                                scope:this
                            });
                        }
                    }
                });
            }else{
                Ext.getCmp('fIdPaciente').setValue(Contenido[0]);
                alert(Contenido[0]);
                Ext.Msg.show({
                    title: 'Radicar Servicios - [Datos Básicos]',
                    msg: 'El paciente selccionado no pertenece a la IPS y no esta autorizado para este cliente atender fuera del listado de atención!',
                    buttons: Ext.Msg.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.Msg.show({
                title: 'Radicar Servicios - [Datos Básicos]',
                msg: 'Existen campos obligatorios que están vacios..!',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    VerificaListado: function(){
        if (Ext.getCmp('strTdoc_citas').getValue() == "" || Ext.getCmp('strTdoc_citas').getValue() == null || Ext.getCmp('strdocpac_citas').getValue() == "" || Ext.getCmp('strdocpac_citas').getValue() == null)
        {
            Ext.Msg.show({
                title: 'Verificación del Listado de Atención',
                msg: 'Debe ingresar los datos de tipo de documento y numero de documento del paciente.',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        } else {
            verListadoAtencion(Ext.getCmp('sysIdEmpresa').getValue(),Ext.getCmp('sysIdSede').getValue(),Ext.getCmp('sysIdIPS').getValue(), Ext.getCmp('strTdoc_citas').getValue(), Ext.getCmp('strdocpac_citas').getValue(),false,Ext.getCmp('intIdPaciente_citas').getValue(),"BarraServicios");
        }
    },
    Salir: function(){
        Ext.Msg.show({
            title: 'Salir',
            msg: 'Esta seguro que desea salir del sistema de radicación de servicios',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    Ext.Ajax.request(
                    {
                        url: '../../controlador/agendas/controlador_asignarcitas.php',
                        params:{
                            task: "AGENDAS_DESBLOQUEAR",
                            pUsuario: ID_USUARIO,
                            pIPS: ID_IPS
                        },
                        success: function(res,req)
                        {
                            window.close();
                        },
                        scope:this
                    });
                }
            }
        });
    },
    LlamarAyuda : function(){
        MostrarAyuda(CodFrm);
    },
    MostrarEdad: function(f) {
        Ext.getCmp('strEdad_citas').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),f.getValue().format('Y/m/d')));
    },
    SelectRangoSalarial: function(cmb, rec, idx) {
        Ext.getCmp('sysPorCopagos').setValue(rec.data.Porcentaje);
        Ext.getCmp('sysMaxCopago').setValue(rec.data.TopeEvento);
        Ext.getCmp('sysvlrCuotaModeradoraIndicada').setValue(rec.data.VlrCuotaModeradora);
    },
    ValidarParentesco: function(cmb, rec, idx) {
        if (cmb.getValue() != "C" && cmb.getValue() != "N"){
            Ext.getCmp('strParentesco_citas').enable();
            Ext.getCmp('strParentesco_citas').allowBlank = false;
        }else{
            Ext.getCmp('strParentesco_citas').clearValue();
            Ext.getCmp('strParentesco_citas').allowBlank = true;
            Ext.getCmp('strParentesco_citas').disable();
        }
    },
    ValidarRegimen: function(cmb, rec, idx) {
        Ext.getCmp('strTafiliado_citas').clearValue();
        Ext.getCmp('strTafiliado_citas').store.removeAll(true);
        Ext.getCmp('strTafiliado_citas').store.load({
            params: { 'pRegimen': cmb.getValue() }
        });
        Ext.getCmp('strRango_citas').clearValue();
        Ext.getCmp('strRango_citas').store.removeAll(true);
        Ext.getCmp('strRango_citas').store.load({
            params: { 'pRegimen': cmb.getValue() }
        });
    },
    CargaCbPlan: function(cmb, rec, idx) {
        
        
        Ext.getCmp('sysUsaListado').setValue(rec.data.UsaListadoAtencion);
        Ext.getCmp('sysAtenderFueraListado').setValue(rec.data.AtenderFueraListado);
        Ext.getCmp('sysRequiereAutorizacion').setValue(rec.data.RequiereAutorizacion);
        if (Ext.getCmp('sysAtenderFueraListado').getValue() == 1 && Ext.getCmp('sysPacienteValido').getValue() == 0)
            Ext.getCmp('sysPacienteValido').setValue(1);
        if (rec.data.RequiereAutorizacion == "1"){
            Ext.getCmp('sysAutorizacion').enable();
            Ext.getCmp('sysAutorizacion').allowBlank = false;
        }else{
            Ext.getCmp('sysAutorizacion').allowBlank = true;
            Ext.getCmp('sysAutorizacion').setValue(null);
            Ext.getCmp('sysAutorizacion').clearInvalid();
            Ext.getCmp('sysAutorizacion').disable();
        }
        Ext.getCmp('sysFacturarParticular').setValue(rec.data.FacturarParticular);
        Ext.getCmp('sysFacturarCopagos').setValue(rec.data.FacturarCopagos);
        Ext.getCmp('sysCopagoDigitado').setValue(rec.data.CopagoDigitado);
        
        
        Ext.Ajax.request(
        {
            waitMsg: 'Por favor Espere...',
            url: '../../controlador/conceptos/matrizconceptosxcliente.php',
            params:{
                pIdTabla: "USR_" + ID_USUARIO,
                pCliente: cmb.getValue(),
                pIPS: ID_IPS,
                pEsParticular: rec.data.FacturarParticular,
                pUsaAuditoria: rec.data.UsaAuditoria
            },
            callback: function(){
                Ext.Msg.hide();
            },
            failure: function(response,options){
                Ext.Msg.hide();
                Ext.MessageBox.show({
                    title: 'Cargando Matriz de Conceptos',
                    msg: 'Ocurrio un error al al cargar la matriz de conceptos o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            },
            scope:this
        });
        
        Ext.getCmp('sysPlan').clearValue();
        Ext.getCmp('sysSubPlan').clearValue();
        Ext.getCmp('sysContrato').clearValue();
        Ext.getCmp('sysPlan').store.removeAll(true);
        Ext.getCmp('sysSubPlan').store.removeAll(true);
        Ext.getCmp('sysContrato').store.removeAll(true);
        Ext.getCmp('sysPlan').setValue(null);
        Ext.getCmp('sysSubPlan').setValue(null);
        Ext.getCmp('sysContrato').setValue(null);
        if (Ext.getCmp('sysPlanLA').getValue() == 0)
        {
            Ext.getCmp('sysPlan').store.load({
                params: { 'pCliente': cmb.getValue() }
            });
        }
        Ext.getCmp('sysPlan').enable();
        Ext.getCmp('sysContrato').store.load({
            params: { 'pCliente': cmb.getValue() }
        });
        Ext.getCmp('sysContrato').enable();
        if (Ext.getCmp('sysClienteLA').getValue() == 0)
            Ext.getCmp('strEstado_citas').clearValue();
        if (Ext.getCmp('sysUsaListado').getValue() == "1"){
            Ext.getCmp('strEstado_citas').enable();
            Ext.getCmp('strEstado_citas').allowBlank = false;
        } else {
            Ext.getCmp('strEstado_citas').disable();
            Ext.getCmp('strEstado_citas').allowBlank = true;
        }
    },
    CargaCbSubPlan: function(cmb, rec, idx) {
        Ext.getCmp('sysSubPlan').clearValue();
        Ext.getCmp('sysSubPlan').store.removeAll(true);
        Ext.getCmp('sysSubPlan').setValue(null);
        if (Ext.getCmp('sysSubPlanLA').getValue() == 0)
        {
           Ext.getCmp('sysSubPlan').store.load({
                params: { 'pPlan': cmb.getValue() }
            });
        }
        Ext.getCmp('sysSubPlan').enable();
    }
});


function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                Ext.Msg.hide();
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarPac_citas').setVisible(false);
                                Ext.getCmp('btnModificarPac_citas').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.Msg.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
function viewInasistencia(){
    if(WINCLOSE == 0){
        WINCLOSE = 1;
        verInfoAlertas();
    }
    controlViwInasistencia = setTimeout(function(){viewInasistencia();}, 60000);
}