/*
* @category    Formulario Inasistencia Cita
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winInasistenciaCitaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Inasistencia Cita ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winInasistenciaCita',
    initComponent: function() {
        
        var StoreMotivoInasiste = new Ext.data.Store({
            id: 'StoreMotivoInasiste',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/combobox/cbmotivocancelainasiste.php',
                method: 'POST'
            }),
            loadMask: {msg:"Cargando Registros, por favor espere..."},
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'rows',
                totalProperty: 'total',
                id: 'id'
              },[
                {name: 'Descripcion', type: 'string', mapping: 'Descripcion'}
             ])
        });
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmInansistenciaCita',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/agendainasistencia.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 'NA',
                        fieldLabel: 'Pantalla',
                        id: 'sysPantalla'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPS'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuario'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCAS'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgenda'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Consultorio',
                        id: 'sysConsultorioAgenda'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Fecha',
                        id: 'sysFecha'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Hora',
                        id: 'sysHora'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' '
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Motivo',
                        name: 'Motivo',
                        anchor: '100%',
                        allowBlank: false,
                        store: StoreMotivoInasiste,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione el Motivo de la Inasistencia...',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: false,
                        id: 'strMotivo'
                    }/*
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Motivo',
                        name: 'strMotivo',
                        maxLength: 250,
                        allowBlank: false,
                        emptyText: 'Digite el Motivo de la Inasistencia...!',
                        id: 'strMotivo'
                    }*/
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Inasistencia Cita',
                            iconCls: 'btnInasistencia',
                            id: 'btnInasistencia_Cita',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmInansistenciaCita').getForm();
                                    if (frm.isValid())
                                    {
                                        frm.submit({
                                            url: '../../controlador/agendas/controlador_asignarcitas.php',
                                            params: {
                                                task: 'INASISTENCIA_CITAS',
                                                pCAS: Ext.getCmp('sysCAS').getValue(),
                                                pEmpresa: Ext.getCmp('sysEmpresa').getValue(),
                                                pIPS: Ext.getCmp('sysIPS').getValue(),
                                                pMotivo: QuitarAcentosMayusculas(Ext.getCmp('strMotivo').getValue()),
                                                pUsuario: Ext.getCmp('sysUsuario').getValue()
                                            },
                                            success: function(res,req)
                                            {
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        switch (Ext.getCmp('sysPantalla').getValue())
                                                        {
                                                            case "AgendaCitas":
                                                                Ext.getCmp('gridFormulario').store.reload();
                                                                break;
                                                            default:
                                                                Ext.getCmp('gridLegalizarCitas').store.reload();
                                                                break;
                                                        }
                                                        Ext.getCmp('winInasistenciaCita').close();
                                                        Ext.MessageBox.show({
                                                            title: 'Inasistencia Citas',
                                                            msg: 'Se Marco Como Inasistente a la Cita con Exito.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'Inasistencia Citas',
                                                            msg: 'Ocurrio un error al marcar inasistente la cita o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos Marcar Inasistente la Cita en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El Motivo de la Inasistencia es Requerido',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winInasistenciaCitaUi.superclass.initComponent.call(this);
    }
});
