
/*
* @category    Formulario Agendas Bloqueadas x Profesional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAgendaBloquadaxProfeUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Agendas Bloquedas por Profesional ::.',
    width: 730,
    autoHeight: true,
    modal: true,
    closable: true,
    frame: true,
    padding: 10,
    layout: 'form',
    id: 'winAgendaBloquadaxProfe',
    initComponent: function() {
        
        var xg = Ext.grid;
        var st = new StoreAgendasBloqueadas();
        
        this.items = [
            {
                xtype: 'panel',
                layout: 'form',
                border: false,
                frame: true,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/agendablock.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'nomProfesionalAgenda'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Consultorio',
                        id: 'nomConsultorioAgenda'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' '
                    },
                    {
                        xtype: 'grid',
                        id: 'gridAgendasBloqueadas',
                        store: st,
                        anchor: "100%",
                        height: 390,
                        border: false,
                        frame: true,
                        loadMask: true,
                        stripeRows: true,
                        cm: new xg.ColumnModel([
                            {
                                header: 'Fecha Bloqueada',
                                dataIndex: 'agendaFecha',
                                readOnly: true,
                                width: 150,
                                hideable: false
                            },{
                                header: 'Usuario Quien Tiene Bloqueada la Agenda',
                                dataIndex: 'agendaUsuario',
                                readOnly: true,
                                sortable: false,
                                width: 300,
                                hideable: false
                            }
                        ]),
                        iconCls:'icon-grid',
                        viewConfig: {
                            forceFit:true
                        },
                        columnLines: true
                    }
                ]
            }
        ];
        winAgendaBloquadaxProfeUi.superclass.initComponent.call(this);
    }
});
