/*
* @category    Formulario Grid Historial de Otros Pagos Pendientes 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmViewPagosPendientesUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Detalle del Copago ::.',
    id: 'winFrmViewPagosPendientes',
    closable: true,
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    modal: true,
    y:120,
    layout: 'fit',
    initComponent: function() {
        
        var stGridOtrosPagosxLegalizar = new StoreGridOtrosPagosxLegalizar();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        
        Ext.util.Format.Currency = function(v){
            return FormatoMoneda(v);
        };
        
        function DescripcionActividad(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return record.get('CodProced') + " - " + record.get('DesProced');
	}
         
        this.items = [
            {
                xtype: 'hidden',
                value: 0,
                id: 'intIdPacienteConsulta'
            },
            {
                xtype: 'grid',
                id: 'gridLegalizarOtrosHC',
                store: stGridOtrosPagosxLegalizar,
                anchor: "100%",
                height: 480,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'CAS',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'CAS_REF',
                        width: 100,
                        hideable: false,
                        locked: true
                    },
                    {
                        header: 'Fecha',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Fecha',
                        width: 80,
                        hideable: false,
                        locked: true
                    },
                    {
                        header: 'Cliente',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'NomCliente',
                        width: 250,
                        hideable: false
                    },
                    {
                        header: 'Concepto',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Concepto',
                        width: 380,
                        hideable: false
                    },
                    {
                        header: 'Valor',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'VlrConcepto',
                        width: 130,
                        renderer:  Ext.util.Format.Currency,
                        align: 'right',
                        hideable: false
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.ux.grid.LockingGridView(),
                columnLines: true,
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Pagos Pendientes por Legalizar',
                            iconCls: 'btnCitasBuscar',
                            listeners: {
                                click: function(){
                                    Ext.getCmp('gridLegalizarOtrosHC').store.load({
                                        params: {
                                            pEmpresa: ID_EMPRESA,
                                            pSede: ID_SEDE,
                                            pIPS: ID_IPS,
                                            pPaciente: Ext.getCmp('intIdPacienteConsulta').getValue()
                                        }
                                    });
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                }/*,
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Detalle del Copago por Legalizar',
                            iconCls: 'btnCitasBuscar',
                            id: 'btnViewPagosxLegalizar'
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                }*/
            }
        ];
        winFrmViewPagosPendientesUi.superclass.initComponent.call(this);
    }
});
