/*
* @category    Formulario Grid Historial de Legalizaciones 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmHistorialLegalizacionesUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Historial de Legalizaciones ::.',
    id: 'winFrmHistorialLegalizaciones',
    closable: true,
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    modal: true,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var stGrid = new StoreGridHistorialLegalizaciones();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        function VerMotivoCancela(value,metaData){
            metaData.attr = 'style="white-space:normal; color:#8A0808"';
            return value;
	}
        this.items = [
            {
                xtype: 'grid',
                id: 'gridHistorialCitas',
                store: stGrid,
                anchor: "100%",
                border: false,
                frame: true,
                stripeRows: true,
                columns:[
                    {
                        xtype: 'gridcolumn',
                        header: 'Nro Autorización',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'NroAutorizacion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha',
                        sortable: false,
                        width: 90,
                        dataIndex: 'FechaDocumento'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Prefijo',
                        sortable: false,
                        width: 90,
                        dataIndex: 'Prefijo'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Nro',
                        sortable: false,
                        width: 90,
                        dataIndex: 'NroDocumento'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Vlr Legalizado',
                        sortable: false,
                        width: 130,
                        renderer:  Ext.util.Format.Currency,
                        dataIndex: 'VlrNeto'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Tipo Legalización',
                        sortable: false,
                        width: 290,
                        dataIndex: 'TipoLegalizacion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario Quien Legalizo',
                        sortable: false,
                        width: 210,
                        dataIndex: 'UsuarioLegalizo'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'CAS',
                        sortable: false,
                        width: 120,
                        dataIndex: 'CAS'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción Cita',
                        sortable: false,
                        width: 200,
                        dataIndex: 'HoraAgenda'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Profesional',
                        sortable: false,
                        width: 250,
                        dataIndex: 'Profesional'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Ubicación',
                        sortable: false,
                        width: 250,
                        dataIndex: 'Ubicacion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Actividad Programada',
                        sortable: false,
                        width: 250,
                        dataIndex: 'Actividad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cliente',
                        sortable: false,
                        width: 250,
                        dataIndex: 'Cliente'
                    }
                ],   
                view: new Ext.grid.GroupingView({
                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
                }),
                columnLines: true,
                bbar: new Ext.PagingToolbar({
                    pageSize: 15,
                    store: stGrid,
                    displayInfo: true
                })
            }
        ];
        winFrmHistorialLegalizacionesUi.superclass.initComponent.call(this);
            
    }
});
