/*
* @category    Formulario Grid Historial de Otros Pagos Realizados 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmHistorialOtrosPagosUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Historial de Pagos Realizados ::.',
    id: 'winFrmHistorialOtrosPagos',
    closable: true,
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    modal: true,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var stGrid = new StoreGridHistorialOtrosPagos();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        function DescripcionDocumentoMC(val, x, store){
            return store.data.Prefijo + " - " + store.data.NroDocumento;
        }
        
        this.items = [
            {
                xtype: 'grid',
                id: 'gridHistorialOtrosPagos',
                store: stGrid,
                anchor: "100%",
                border: false,
                frame: true,
                stripeRows: true,
                columns:[
                    {
                        header: 'Fecha',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'FechaDocumento',
                        width: 80,
                        hideable: false,
                        locked: true
                    },
                    {
                        header: 'Cliente',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'NomCliente',
                        width: 250,
                        hideable: false
                    },
                    {
                        header: 'Concepto',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Concepto',
                        width: 360,
                        hideable: false
                    },
                    {
                        header: 'Documento',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'NroDocumento',
                        renderer: DescripcionDocumentoMC,
                        width: 110,
                        hideable: false
                    },
                    {
                        header: 'Valor',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'VlrConcepto',
                        width: 130,
                        renderer:  Ext.util.Format.Currency,
                        align: 'right',
                        hideable: false
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Detalle del Copago',
                            iconCls: 'btnCitasBuscar',
                            listeners: {
                                click: function(){
                                    if(parseInt(Ext.getCmp('gridHistorialOtrosPagos').selModel.getCount()) === 1){
                                        var selections = Ext.getCmp('gridHistorialOtrosPagos').selModel.getSelections();
                                        xCAS = selections[0].json.CAS_REF;
                                        var winFrmDetalleCopagos = new winFrmDetalleCopagosUi();
                                        Ext.getCmp('gridVerDetalleCopagos').store.setBaseParam("task", "VER_DETALLE_COPAGOS");
                                        Ext.getCmp('gridVerDetalleCopagos').store.setBaseParam("pCAS", xCAS);
                                        Ext.getCmp('gridVerDetalleCopagos').store.load();
                                        winFrmDetalleCopagos.show();
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'eOfiClinic',
                                            msg: 'Debe seleccionar solo un documento.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imprimir Documento',
                            iconCls: 'btnImprimir',
                            id: 'btnImprimirDocumentoOtroPago',
                            listeners: {
                                click: function(){
                                    if(parseInt(Ext.getCmp('gridHistorialOtrosPagos').selModel.getCount()) === 1){
                                        var selections = Ext.getCmp('gridHistorialOtrosPagos').selModel.getSelections();
                                        window.open('../../../app/controlador/legalizaciones/print_mc_otroscopago.php?pCAS='+selections[0].json.CAS+'&pPaciente='+selections[0].json.Paciente+'&pCliente='+selections[0].json.NomCliente+'&pPrefijo='+selections[0].json.Prefijo+'&pNroDocumento='+selections[0].json.NroDocumento+'&pFechaDocumento='+selections[0].json.FechaDocumento+'&pConcepto='+selections[0].json.Concepto+'&pVlrTotal='+selections[0].json.VlrConcepto+'&pVlrIVA=0&pVlrCuotaModeradora=0&pVlrCopagos=0&pVlrDescuentos=0&pVlrNeto='+selections[0].json.VlrConcepto+'&pUsuarioFactura=1',"MOVIMIENTO DE CAJA");
                                        
                                        //window.open('../../../app/controlador/legalizaciones/print_mc_copago.php?pCAS='+selections[0].json.CAS+'&pPaciente='+selections[0].json.Paciente+'&pCliente='+selections[0].json.Cliente+'&pPlan='+selections[0].json.Plan+'&pSubPlan='+selections[0].json.SubPlan+'&pTipoLegalizacion='+selections[0].json.TipoLegalizacion+'&pPrefijo='+selections[0].json.Prefijo+'&pNroDocumento='+selections[0].json.NroDocumento+'&pFechaDocumento='+selections[0].json.FechaDocumento+'&pNroResolucion='+selections[0].json.NroResolucion+'&pFechaVencimiento='+selections[0].json.FechaVencimiento+'&pConcepto='+selections[0].json.Concepto+'&pVlrTotal='+selections[0].json.VlrTotal+'&pVlrIVA='+selections[0].json.VlrIVA+'&pVlrCuotaModeradora='+selections[0].json.VlrCuotaModeradora+'&pVlrCopagos='+selections[0].json.VlrCopagos+'&pVlrDescuentos='+selections[0].json.VlrDescuentos+'&pVlrNeto='+selections[0].json.VlrNeto
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'eOfiClinic',
                                            msg: 'Debe seleccionar solo un documento.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                }
            }
        ];
        winFrmHistorialOtrosPagosUi.superclass.initComponent.call(this);
    }
});
