/*
* @category    Formulario Grid Historial de Citas 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmHistorialCitasUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Historial de Citas ::.',
    id: 'winFrmHistorialCitas',
    closable: true,
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    modal: true,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var stGrid = new StoreGridHistorialCitas();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        
        function VerMotivoCancela(value,metaData){
            metaData.attr = 'style="white-space:normal; color:#8A0808"';
            return value;
	}
        
        /*var linkButton = new Ext.LinkButton({
            id: 'grid-excel-button',
            //iconCls: 'btnExcel',
            text: 'Exportar'
        });
        
        this.linkButton.getEl().child('a', true).href = 'data:application/vnd.ms-excel;base64,' +
        Base64.encode(Ext.getCmp('gridHistorialCitas').getExcelXml());
        */
        this.items = [
            {
                xtype: 'hidden',
                id: 'idPacienteHistoricoCitasAsignadas'
            },
            {
                xtype: 'grid',
                id: 'gridHistorialCitas',
                store: stGrid,
                anchor: "100%",
                height: 450,
                border: false,
                frame: true,
                stripeRows: true,
                columns:[
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'idPaciente',
                        id: 'idPacienteHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha',
                        sortable: false,
                        width: 90,
                        dataIndex: 'FecCita',
                        renderer: Ext.util.Format.dateRenderer('d/m/Y'),
                        id: 'FecCitaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción Cita',
                        sortable: false,
                        width: 200,
                        dataIndex: 'DesCita',
                        id: 'DesCitaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Info Add Cita',
                        sortable: false,
                        width: 100,
                        dataIndex: 'DescAdiHora',
                        id: 'DescAdiHoraHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'CAS',
                        sortable: true,
                        width: 100,
                        dataIndex: 'CAS',
                        id: 'CASHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Cancelación',
                        sortable: false,
                        width: 110,
                        dataIndex: 'FechaCancela',
                        id: 'FechaCancelaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario Quien Cancela',
                        sortable: false,
                        width: 150,
                        dataIndex: 'UsuarioCancela',
                        id: 'UsuarioCancelaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Motivo Cancelación',
                        sortable: false,
                        width: 250,
                        renderer: VerMotivoCancela,
                        dataIndex: 'MotivoCancela',
                        id: 'MotivoCancelaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario Quien Marca Inasistencia',
                        sortable: false,
                        width: 150,
                        dataIndex: 'UsuarioInasistencia',
                        id: 'UsuarioInasistenciaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Profesional',
                        sortable: false,
                        width: 250,
                        dataIndex: 'Profesional',
                        id: 'ProfesionalHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Ubicación',
                        sortable: false,
                        width: 250,
                        dataIndex: 'Ubicacion',
                        id: 'UbicacionHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Actividad Programada',
                        sortable: false,
                        width: 250,
                        dataIndex: 'DescProcedimiento',
                        id: 'DescProcedimientoHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cliente',
                        sortable: false,
                        width: 250,
                        dataIndex: 'Cliente',
                        id: 'ClienteHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario Quien Asigno',
                        sortable: false,
                        width: 150,
                        dataIndex: 'UsuarioAsigna',
                        id: 'UsuarioAsignoHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Asignación',
                        sortable: false,
                        width: 120,
                        dataIndex: 'FecAsigna',
                        id: 'FechaAsignaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Observaciones',
                        sortable: false,
                        width: 250,
                        dataIndex: 'ObservacionesAsigna',
                        id: 'ObservacionesHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Oportunidad',
                        sortable: false,
                        width: 100,
                        dataIndex: 'Oportunidad',
                        id: 'OportunidadHistorialCitas'
                    }
                ],   
                columnLines: true,
                /*tbar: new Ext.Toolbar({
                    buttons: [linkButton]
                }),*/
                tbar:{
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'button',
                            text: 'Recordatorio Cita',
                            iconCls: 'btnImprimir',
                            listeners: {
                                click : function() {
                                    var Registros;
                                    Registros = Ext.getCmp('gridHistorialCitas').selModel.getCount();
                                    if(Registros > 0){
                                        var selections = Ext.getCmp('gridHistorialCitas').selModel.getSelections();
                                        var wInfoPac = "";
                                        try {
                                            var campo = Ext.getCmp('systxtIdPac');
                                            if ( campo !== null ) {
                                                wInfoPac = Ext.getCmp('systxtIdPac').getValue();
                                            }
                                        }catch(ex){
                                        }
                                        try {
                                            var campo = Ext.getCmp('systxtIdPac1');
                                            if ( campo !== null ) {
                                                wInfoPac = Ext.getCmp('systxtIdPac1').getValue();
                                            }
                                        }catch(ex){
                                        }
                                        window.open ("../../controlador/agendas/printrecordatoriocita.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + wInfoPac + "&pCAS=" + selections[0].json.CAS + "&pProfesional=" + selections[0].json.Profesional + "&pFecha=" + selections[0].json.FecCita + "&pHora=" + selections[0].json.DesCita + "&pHoraAdd=" + selections[0].json.DescAdiHora + "&pConcepto=" + selections[0].json.DescProcedimiento + "&pEntidad=" + selections[0].json.Cliente + "&pUsuario=" + selections[0].json.UsuarioAsigna + "&pFecAsigna=" + selections[0].json.FecAsigna,"Recordatorio Cita");
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Debe seleccionar un registro',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Asitencia a Cita',
                            iconCls: 'btnImprimir',
                            listeners: {
                                click : function() {
                                    var Registros;
                                    Registros = Ext.getCmp('gridHistorialCitas').selModel.getCount();
                                    if(Registros > 0){
                                        var selections = Ext.getCmp('gridHistorialCitas').selModel.getSelections();
                                        var wInfoPac = "";
                                        try {
                                            var campo = Ext.getCmp('systxtIdPac');
                                            if ( campo !== null ) {
                                                wInfoPac = Ext.getCmp('systxtIdPac').getValue();
                                            }
                                        }catch(ex){
                                        }
                                        try {
                                            var campo = Ext.getCmp('systxtIdPac1');
                                            if ( campo !== null ) {
                                                wInfoPac = Ext.getCmp('systxtIdPac1').getValue();
                                            }
                                        }catch(ex){
                                        }
                                        Ext.Ajax.request({
                                            url: '../../controlador/pacientes/savehuella.php',
                                            params:{
                                                pPaciente: selections[0].json.idPaciente
                                            }
                                        });
                                        window.open ("../../controlador/agendas/printasistenciacita.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + wInfoPac + "&pCAS=" + selections[0].json.CAS + "&pProfesional=" + selections[0].json.Profesional + "&pFecha=" + selections[0].json.FecCita + "&pHora=" + selections[0].json.DesCita + "&pHoraAdd=" + selections[0].json.DescAdiHora + "&pConcepto=" + selections[0].json.DescProcedimiento + "&pEntidad=" + selections[0].json.Cliente + "&pUsuario=" + selections[0].json.UsuarioAsigna + "&pFecAsigna=" + selections[0].json.FecAsigna + "&pIdPac=" + selections[0].json.idPaciente,"Recordatorio Cita");
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Debe seleccionar un registro',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {   
                            xtype: 'tbfill'
                        },
                        'Desde: ',
                        {
                            xtype: 'datefield',
                            fieldLabel: 'Desde',
                            anchor: '24%',
                            emptyText: '(dia/mes/año)',
                            style: 'text-align:center;',
                            allowBlank: false,
                            //value:  Ext.get('fecDesde').getValue(),
                            id: 'DesdeHistorialCitas'
                        },
                        ' - Hasta: ',
                        {
                            xtype: 'datefield',
                            fieldLabel: 'Hasta',
                            anchor: '24%',
                            emptyText: '(dia/mes/año)',
                            style: 'text-align:center;',
                            allowBlank: false,
                            //value:  Ext.get('fecHasta').getValue(),
                            id: 'HastaHistorialCitas'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnActualizarGrid',
                            listeners: {
                                click : function() {
                                    if(Ext.getCmp('DesdeHistorialCitas').getValue() !== "" && Ext.getCmp('DesdeHistorialCitas').getValue() !== null && Ext.getCmp('HastaHistorialCitas').getValue() !== "" && Ext.getCmp('HastaHistorialCitas').getValue() !== null){
                                        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pDesde", Ext.getCmp('DesdeHistorialCitas').getValue().format('Y/m/d'));
                                        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pHasta", Ext.getCmp('HastaHistorialCitas').getValue().format('Y/m/d'));
                                        Ext.getCmp('gridHistorialCitas').store.load();
                                    }else{
                                        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pDesde", null);
                                        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pHasta", null);
                                        Ext.getCmp('gridHistorialCitas').store.load();
                                    }
                                    
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imprimir Citas Asignadas',
                            iconCls: 'btnImprimir',
                            listeners: {
                                click : function() {
                                    var pDesde = null;
                                    var pHasta = null;
                                    if(Ext.getCmp('DesdeHistorialCitas').getValue() !== "" && Ext.getCmp('DesdeHistorialCitas').getValue() !== null && Ext.getCmp('HastaHistorialCitas').getValue() !== "" && Ext.getCmp('HastaHistorialCitas').getValue() !== null){
                                        pDesde = Ext.getCmp('DesdeHistorialCitas').getValue().format('Y/m/d');
                                        pHasta = Ext.getCmp('HastaHistorialCitas').getValue().format('Y/m/d');
                                    }
                                    window.open ("../../controlador/agendas/infcitasasignadas.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('idPacienteHistoricoCitasAsignadas').getValue() + "&pDesde=" + pDesde + "&pHasta=" + pHasta,"Historico Asignacion de Citas x Paciente");
                                }
                            }
                        }
                    ]
                },
                bbar: new Ext.PagingToolbar({
                    pageSize: 15,
                    store: stGrid,
                    displayInfo: true
                })
            }
        ];
        winFrmHistorialCitasUi.superclass.initComponent.call(this);
            
    }
});
