/*
* @category    Formulario Asignar Citas Sesiones
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAsignarCitasSesionesUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Asignar Citas ::.',
    width: 970,
    height: 580,
    modal: true,
    closable: false,
    padding: 10,
    layout: 'form',
    id: 'winAsignarCitasSesiones',
    initComponent: function() {
        
        var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Citas Disponibles..."});
        myMask.show();
        
        var xg = Ext.grid;
        
        function InfoObsCita(value, p, record){
            var html = '<table><tr><td style="font-size:9px;">'+record.get('infoPaciente')+'</td></tr><tr><td style="color: blue;font-size:9px;">' + record.get('citaInfoAdd') + '</td></tr><tr><td style="color: red;font-size:9px;">' + record.get('infoObservaciones') + '</td></tr></table>';
            return html;
        }
        
        var chkColumnSeleccionarHorarioSecciones = new xg.CheckColumn({
            header: ' ',
            dataIndex: 'Seleccionar',
            name: 'SelectHorario',
            id: 'chkColumnSeleccionarHorarioSecciones',
            value: false,
            width: 10
        });
        
        var strcitaInfoAdd = new Ext.form.TextField();
        
        var st = new StoreGridHoarariosxAgendaDisponiblesSesiones();
        st.load({
            params: {
                pIPS: ID_IPS,
                pProfesional: ID_PROFESIONAL_SELECCIONADO,
                pCodBloqueo: CODBLOQUEOAGENDA
            }
        });
        
        this.bbar = [
            '->',
            {
                xtype: 'button',
                text: 'Salir',
                iconCls: 'btnSalir',
                listeners: {
                    click : function() {
                        Ext.Msg.show({
                            title: 'eOfiClinic',
                            msg: 'Esta seguro que desea cerrar la ventana?',
                            buttons: Ext.Msg.YESNO,
                            icon: Ext.Msg.QUESTION,
                            fn: function(btn)
                            {
                                if(btn=="yes")
                                {
                                    Ext.Ajax.request({
                                        waitMsg: 'Por favor Espere...',
                                        url: "../../controlador/agendas/controlador_asignarcitas.php",
                                        params: {
                                            task: "DESBLOQUEAR_CITAS",
                                            pIPS: ID_IPS,
                                            pUsuario: ID_USUARIO
                                        },
                                        success: function(response)
                                        {
                                            Ext.getCmp('winAsignarCitasSesiones').close();
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            }
        ];
        
        this.items = [
            {
                xtype: 'numberfield',
                minValue: 1,
                fieldLabel: 'Cantidad Sesiones',
                decimalPrecision: 0,
                allowBlank: false,
                value: 1,
                width: 50,
                id: 'intCantidadSesiones'
            },
            {
                xtype: 'editorgrid',
                id: 'gridHorariosAgendasSesiones',
                store: st,
                anchor: "100%",
                height: 460,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                clicksToEdit: 1,
                loadMask: true,
                title: 'Horarios Disponibles por Agenda',
                cm: new xg.ColumnModel([
                    chkColumnSeleccionarHorarioSecciones,
                    {
                        header: 'Codigo',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'citaID',
                        width: 1,
                        hidden: true,
                        hideable: false
                    },
                    {
                        header: 'Fecha',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'fecAgenda',
                        width: 120
                    },
                    {
                        header: 'Ubicación',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Consultorio',
                        width: 120
                    },
                    {
                        header: 'Descripción del Horario',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'citaDescripcion',
                        width: 200
                    },
                    {
                        header: 'Información Adicional de la Cita',
                        readOnly: false,
                        sortable: false,
                        dataIndex: 'citaInfoAdd',
                        editor: strcitaInfoAdd,
                        renderer: InfoObsCita,
                        width: 200
                    }
                ]),
                plugins: [chkColumnSeleccionarHorarioSecciones],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                listeners:{
                    beforeedit : function(e){
                        if(e.record.get('CAS')!="" && e.record.get('CAS')!=null && e.record.get('CAS')!=0){
                            return false;
                        }
                    }
                },
                iconCls:'icon-horarios',
                viewConfig: {
                    forceFit:true
                },
                columnLines: true,
                tbar:{
                    items: [
                        {
                            html:'<b style="color: #ff3333;">A Solicitud del Usuario:</b>&nbsp;&nbsp;&nbsp;',
                            border: false
                        },
                        {
                            xtype: 'checkbox',
                            anchor: '100%',
                            value: 'true',
                            id: 'bolAsignaCitasSolicitudUsuarioSesiones'
                        },
                        {
                            html:'<b style="color: blue;">&nbsp;&nbsp;&nbsp; - EXENTO:</b>&nbsp;&nbsp;&nbsp;',
                            border: false
                        },
                        {
                            xtype: 'checkbox',
                            anchor: '100%',
                            value: 'true',
                            id: 'bolMarcaExentoSesiones'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Asignar Citas Seleccionadas',
                            iconCls: 'btnAsignarCita',
                            id: 'btnCitasAsignarSesiones',
                            listeners:{
                                click: function(){
                                    var cantcitasseleccionadas = 0;
                                    Ext.getCmp('gridHorariosAgendasSesiones').store.filterBy(function(record,id){
                                        return record.get('Seleccionar') == true;
                                    });
                                    Ext.getCmp('gridHorariosAgendasSesiones').store.each(function(record){
                                        cantcitasseleccionadas += 1;
                                    });
                                    if (cantcitasseleccionadas != Ext.getCmp('intCantidadSesiones').getValue())
                                    {
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El número de citas seleccionadas: (' + cantcitasseleccionadas + '), no coincide con el total de sesiones digitadas',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                        Ext.getCmp('gridHorariosAgendasSesiones').store.filterBy(function(record,id){
                                            return true;
                                        });
                                    }else{
                                        var parametrosCitasSeleccionadas = "";
                                        var SolicitudUsuaio = (Ext.getCmp('bolAsignaCitasSolicitudUsuarioSesiones').getValue()==true)?'1':'0';
                                        var MarcaExento = (Ext.getCmp('bolMarcaExentoSesiones').getValue()==true)?'1':'0';
                                        if (Ext.getCmp('sysCliente').getValue() != null && Ext.getCmp('sysCliente').getValue() != "" && Ext.getCmp('intIdPaciente_citas').getValue() != 0 && Ext.getCmp('sysPlan').getValue() != null && Ext.getCmp('sysPlan').getValue() != "" && Ext.getCmp('sysSubPlan').getValue() != null && Ext.getCmp('sysSubPlan').getValue() != "" && Ext.getCmp('fCodConcepto').getValue() != null && Ext.getCmp('fCodConcepto').getValue() != "" && Ext.getCmp('strTafiliado_citas').getValue() != null && Ext.getCmp('strTafiliado_citas').getValue() != "" && Ext.getCmp('strRegimen_citas').getValue() != null && Ext.getCmp('strRegimen_citas').getValue() != "" && Ext.getCmp('sysPrograma').getValue() != null && Ext.getCmp('sysPrograma').getValue() != "" && Ext.getCmp('sysFinalidad').getValue() != null && Ext.getCmp('sysFinalidad').getValue() != "")
                                        {
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea asignar las citas seleccionadas?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn)
                                                {
                                                    if(btn=="yes")
                                                    {
                                                        Ext.MessageBox.wait('Asignando Citas Seleccionadas......');
                                                        var citasseleccionadas = false;
                                                        Ext.getCmp('gridHorariosAgendasSesiones').store.filterBy(function(record,id){
                                                            return record.get('Seleccionar') == true;
                                                        });
                                                        Ext.getCmp('gridHorariosAgendasSesiones').store.each(function(record){
                                                            if(record.get('CAS') == "" || record.get('CAS') == " " || record.get('CAS') == null){
                                                                citasseleccionadas = true;
                                                                parametrosCitasSeleccionadas = QuitarAcentosMayusculas(parametrosCitasSeleccionadas + record.get('idAgenda') +  "^" + record.get('idConsultorio') +  "^" + record.get('fecAgenda') +  "^" + record.get('citaID') + "^" + record.get('citaInfoAdd') + "^" + record.get('TipoHorario') + "¬");
                                                            }
                                                        });
                                                        Ext.Ajax.request({
                                                            waitMsg: 'Por favor Espere...',
                                                            url: "../../controlador/agendas/controlador_asignarcitas.php",
                                                            params: {
                                                                task: "ASIGNAR_CITAS_SESIONES",
                                                                pEmpresa: ID_EMPRESA,
                                                                pSede: ID_SEDE, 
                                                                pIPS: ID_IPS, 
                                                                //pConsultorio: ID_CONSULTORIO_SELECCIONADO,
                                                                pProfesionalCita: ID_PROFESIONAL_SELECCIONADO,
                                                                pUsuario: ID_USUARIO,
                                                                pPaciente: Ext.getCmp('intIdPaciente_citas').getValue(),
                                                                pIdProced: Ext.getCmp('fidConcepto').getValue(),
                                                                pCodProced: QuitarAcentosMayusculas(Ext.getCmp('fCodConcepto').getValue()),
                                                                pDesProced: QuitarAcentosMayusculas(Ext.getCmp('fDesConcepto').getValue()),
                                                                pTarifaProced: Ext.getCmp('fVlrUnitario').getValue(),
                                                                pCodCliente: Ext.getCmp('sysCliente').getValue(),
                                                                pDesCliente: QuitarAcentosMayusculas(Ext.getCmp('sysCliente').getRawValue()),
                                                                pCodPlan: Ext.getCmp('sysPlan').getValue(),
                                                                pDesPlan: QuitarAcentosMayusculas(Ext.getCmp('sysPlan').getRawValue()),
                                                                pCodSubPlan: Ext.getCmp('sysSubPlan').getValue(),
                                                                pDesSubPlan: QuitarAcentosMayusculas(Ext.getCmp('sysSubPlan').getRawValue()),
                                                                pContrato: Ext.getCmp('sysContrato').getValue(),
                                                                pUsuarioAsigna: ID_USUARIO,
                                                                pObservaciones: QuitarAcentosMayusculas(Ext.getCmp('strObservacionesCitaSesiones').getValue()),
                                                                pSolicitudUsuario: SolicitudUsuaio,
                                                                //pFechaCita: FECHA_SELECCIONADA,
                                                                pTipoAfiliacion: Ext.getCmp('strTafiliado_citas').getValue(),
                                                                pTipoAfiliado: Ext.getCmp('strRegimen_citas').getValue(),
                                                                pParentesco: Ext.getCmp('strParentesco_citas').getValue(),
                                                                pRangoSalarial: Ext.getCmp('strRango_citas').getValue(),
                                                                pEstadoListado: Ext.getCmp('strEstado_citas').getValue(),
                                                                pEdadPaciente: Ext.getCmp('strEdad_citas').getValue(),
                                                                pDeptoMuniciPaciente: Ext.getCmp('strDeptoMuni_citas').getValue(),
                                                                pPrograma: Ext.getCmp('sysPrograma').getValue(),
                                                                pFinalidad: Ext.getCmp('sysFinalidad').getValue(),
                                                                pFacturarParticular: Ext.getCmp('sysFacturarParticular').getValue(),
                                                                pFacturarCopagos: Ext.getCmp('sysFacturarCopagos').getValue(),
                                                                pCopagoDigitado: Ext.getCmp('sysCopagoDigitado').getValue(),
                                                                pPorCopagos: Ext.getCmp('sysPorCopagos').getValue(),
                                                                pMaxCopago: Ext.getCmp('sysMaxCopago').getValue(),
                                                                pvlrCuotaModeradoraIndicada: Ext.getCmp('sysvlrCuotaModeradoraIndicada').getValue(),
                                                                pExento: Ext.getCmp('sysExento').getValue(),
                                                                pTutela: Ext.getCmp('sysTutela').getValue(),
                                                                pProfeSol: Ext.getCmp('sysProfeSol').getValue(),
                                                                pAutorizacion: QuitarAcentosMayusculas(Ext.getCmp('sysAutorizacion').getValue()),
                                                                pFechaSol: Ext.getCmp('sysFecSol').getValue(),
                                                                pMarcaExento: MarcaExento,
                                                                pInfoCita: parametrosCitasSeleccionadas
                                                            },
                                                            success: function(response)
                                                            {
                                                                var result = response.responseText;
                                                                if (result > 0)
                                                                {
                                                                    Ext.getCmp('sysCliente').clearValue();
                                                                    Ext.getCmp('sysPlan').clearValue();
                                                                    Ext.getCmp('sysSubPlan').clearValue();
                                                                    Ext.getCmp('sysContrato').clearValue();
                                                                    Ext.getCmp('sysCliente').setValue(null);
                                                                    Ext.getCmp('sysPlan').setValue(null);
                                                                    Ext.getCmp('sysSubPlan').setValue(null);
                                                                    Ext.getCmp('sysContrato').setValue(null);
                                                                    Ext.getCmp('fCodConcepto').setValue(null);
                                                                    Ext.getCmp('fDesConcepto').setValue(null);
                                                                    Ext.getCmp('fVlrUnitario').setValue(null);
                                                                    Ext.getCmp('fidConcepto').setValue(null);
                                                                    Ext.getCmp('strObservacionesCita').setValue(null);
                                                                    Ext.getCmp('bolAsignaCitasSolicitudUsuario').setValue(null);
                                                                    Ext.getCmp('bolMarcaExento').setValue(null);
                                                                    Ext.getCmp('gridProfesionalesCitas').store.load();
                                                                    Ext.getCmp('gridConsultoriosCitas').store.load();
                                                                    Ext.getCmp('gridDiasAgendaCitas').store.load();
                                                                    Ext.getCmp('gridHorariosAgendasCitas').store.load();
                                                                    Ext.Ajax.request(
                                                                    {
                                                                        url: '../../controlador/agendas/controlador_asignarcitas.php',
                                                                        params:{
                                                                            task: "AGENDAS_DESBLOQUEAR",
                                                                            pUsuario: ID_USUARIO,
                                                                            pIPS: ID_IPS
                                                                        },
                                                                        scope:this
                                                                    });
                                                                    var html = '<table><tr><td width="50"><img src="../../../resources/varios/citas.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #2E2EFE; font-size: 14px;">Asignación de Citas:</h1><br/><p style="color: #003333;font-weight: bold;">Se Asignaron las Citas Seleccionadas.</p></br>';
                                                                    html += '<br/><p style="color: #003333;font-weight: bold;">Profesional: ' + NOM_PROFESIONAL_SELECCIONADO +'</p>';
                                                                    html += '</td><td width="70">&nbsp</td></tr></table>';
                                                                    Ext.MessageBox.hide();
                                                                    Sexy.info(html);
                                                                    Ext.getCmp('winAsignarCitasSesiones').close();
                                                                }else{
                                                                    Ext.MessageBox.hide();
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'ERROR DE COMUNICACION, La Cita quedo mal asignada por favor limpie el formulario y vuelva a intentarlo.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            },
                                                            failure: function(response){
                                                                var result = response.responseText;
                                                                Ext.MessageBox.hide();
                                                                Ext.MessageBox.show({
                                                                    title: 'Error Base Datos',
                                                                    msg: 'No podemos asignar las citas en estos momentos',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        });
                                                    }else{
                                                        Ext.getCmp('gridHorariosAgendasSesiones').store.filterBy(function(record,id){
                                                            return true;
                                                        });
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Verifique que los campos obligatorios estan diligenciados.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                            Ext.getCmp('gridHorariosAgendasSesiones').store.filterBy(function(record,id){
                                                return true;
                                            });
                                        }
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            html:'Observaciones:&nbsp;&nbsp;&nbsp;',
                            border: false
                        },
                        {
                            xtype: 'textfield',
                            width: 440,
                            maxLength: 150,
                            allowBlank: true,
                            emptyText: 'Observaciones',
                            id: 'strObservacionesCitaSesiones'
                        }
                    ]
                },
                listeners: {
                    viewready: function() {
                        myMask.hide();
                    }
                }
            }
        ];
        winAsignarCitasSesionesUi.superclass.initComponent.call(this);
    }
});
