/*
* @category    Formulario Asignar Citas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAsignarCitaManualUi = Ext.extend(Ext.Window, {
    title: 'OfiMedical .:: Asignar Cita Asotranscal ::.',
    width: 1014,
    //autoHeight: true,
    height: 600,
    modal: true,
    closable: true,
    autoScroll: true,
    frame: true,
    id: 'winAsignarCitaManualUi',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        wCAS = 0;
        var stConceptosPaqueteServicios = new StoreConceptosxPaquete();
        var xg = Ext.grid;
               
        var chkColumnSeleccionarConcepto = new xg.CheckColumn({
           header: ' ',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarConcepto',
           value: false,
           width: 10
        });
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        var intVlrTarifaConcepto = new Ext.form.NumberField({
            minValue: 0,
            decimalPrecision: 0,
            allowBlank: false
        });
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                id: 'frmPacientesCitaManual',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intIdPaciente',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPacienteValido',
                        value: 0
                    },
                    {
                        xtype: 'panel',
                        title: 'Datos del Paciente',
                        layout: 'table',
                        collapseFirst: false,
                        border: true,
                        anchor: '100%',
                        autoHeight: true,
                        id: 'fsPaciente',
                        layoutConfig: {
                            columns: 4
                        },
                        items: [
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 221,
                                border: false,
                                id: 'pnTdoc',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Doc ID',
                                        anchor: '100%',
                                        name: 'cbTdoc',
                                        allowBlank: false,
                                        store: 'StoreTdocPac',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Tipo Documento....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'strTdoc'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 269,
                                border: false,
                                id: 'pnDocID',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Documento ID',
                                                name: 'txtDocID',
                                                allowBlank: false,
                                                width: 200,
                                                id: 'strDocID'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Paciente',
                                                id: 'btnBuscarPacienteAgendaManual'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 172,
                                border: false,
                                colspan: 2,
                                id: 'pnGenero',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Genero',
                                        anchor: '100%',
                                        name: 'cbGenero',
                                        allowBlank: false,
                                        store: 'StoreGenero',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        emptyText: 'Seleccione Genero....',
                                        forceSelection: true,
                                        id: 'strGenero'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 271,
                                border: false,
                                id: 'pnApe1',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '1er Apellido',
                                        anchor: '100%',
                                        name: 'txtApe1',
                                        style: 'text-transform:uppercase;',
                                        allowBlank: false,
                                        id: 'strApe1'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 271,
                                border: false,
                                id: 'pnApe2',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '2do Apellido',
                                        anchor: '100%',
                                        name: 'txtApe2',
                                        style: 'text-transform:uppercase;',
                                        id: 'strApe2'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 215,
                                border: false,
                                id: 'pnNom1',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '1er Nombre',
                                        anchor: '96%',
                                        name: 'txtNom1',
                                        allowBlank: false,
                                        style: 'text-transform:uppercase;',
                                        id: 'strNom1'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                border: false,
                                width: 230,
                                id: 'pnNom2',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '2do Nombre',
                                        anchor: '78%',
                                        name: 'txtNom2',
                                        style: 'text-transform:uppercase;',
                                        id: 'strNom2'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 146,
                                border: false,
                                id: 'pnFecNac',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha Nacimiento',
                                        anchor: '100%',
                                        name: 'txtFecNac',
                                        allowBlank: true,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFecNac'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 271,
                                border: false,
                                id: 'pnEdad',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Edad Actual',
                                        anchor: '100%',
                                        name: 'txtEdad',
                                        readOnly: true,
                                        allowBlank: true,
                                        style: 'color: blue;text-align:center',
                                        id: 'strEdad'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 396,
                                border: false,
                                colspan: 2,
                                id: 'pnDeptoMuni',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Municipio - Departamento - Residencia',
                                        anchor: '99%',
                                        name: 'cbDeptoMuni',
                                        allowBlank: false,
                                        store: 'StoreDeptoMuni',
                                        valueField: 'IdDeptoMunicipio',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Municipio - Departamento....',
                                        mode: 'local',
                                        listWidth: 450,
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        id: 'strDeptoMuni'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 958,
                                border: false,
                                colspan: 4,
                                height: 54,
                                id: 'pnDatDirTel',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                        anchor: '100%',
                                        id: 'composDatDirTel',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'txtDireccion',
                                                allowBlank: false,
                                                emptyText: 'Dirección....',
                                                style: 'text-transform:uppercase;',
                                                width: 280,
                                                id: 'strDireccion'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'txtTel1',
                                                allowBlank: false,
                                                emptyText: 'Teléfono',
                                                width: 160,
                                                id: 'strTel1'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'txtTel2',
                                                emptyText: 'Teléfono (Otro - Cel.)',
                                                width: 160,
                                                id: 'strTel2'
                                            },
                                            {
                                                xtype: 'combo',
                                                flex: 1,
                                                fieldLabel: 'Zona',
                                                store: 'StoreZonaResidencia',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                name: 'cbZona',
                                                emptyText: 'Zona....',
                                                allowBlank: false,
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                width: 80,
                                                value: 'Urbana',
                                                triggerAction: 'all',
                                                id: 'strZona'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'txtEmail',
                                                vtype: 'email',
                                                emptyText: 'Email....',
                                                width: 220,
                                                id: 'strEmail'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ],
                        tbar:{
                            items: [
                                {
                                    xtype: 'button',
                                    text: 'Nuevo Paciente',
                                    iconCls: 'btnNuevo',
                                    id: 'btnNuevoAgendaManual'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Guardar',
                                    iconCls: 'btnGuardar',
                                    id: 'btn_AdicionarItemAgendaManual'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Modificar',
                                    iconCls: 'btnGuardar',
                                    id: 'btn_ModificarItemAgendaManual'
                                }
                            ]
                        }
                    }
                ]
            },
            {
                xtype: 'panel',
                title: 'Cliente y Concepto para Agendar',
                layout: 'form',
                padding: 10,
                anchor: '99%',
                autoHeight: true,
                frame: true,
                border: true,
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Asignar Cita',
                            iconCls: 'btnAsignarCita',
                            id: 'btn_AsignarCitaItemAgendaManual'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            html: '&nbsp;&nbsp;&nbsp;&nbsp;'
                        }
                    ]
                },
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        id: 'composDatClientex',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Cliente',
                                width: 300,
                                allowBlank: false,
                                store: 'StoreCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Cliente....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intClienteAsignaCita'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Plan:'
                            },
                            {
                                xtype: 'combo',
                                width: 235,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClientesPlan',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdPlan',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Plan....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intClientePlanAsignaCita'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'SubPlan:'
                            },
                            {
                                xtype: 'combo',
                                width: 215,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClienteSubplan',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdSubPlan',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Plan....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intClienteSubPlanAsignaCita'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Paquete',
                                width: 680,
                                allowBlank: false,
                                store: 'StorePaqueteServicios',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intIdPaqueteServicio',
                                listeners:{
                                    select : function(cmb, rec, idx){
                                        if (cmb.getValue() === null || cmb.getValue() === ""){
                                            Ext.getCmp('gridConceptosPaqueteServicios').store.load({
                                                params: {
                                                    pPaquete: 0
                                                }
                                            });
                                        }else{
                                            Ext.getCmp('gridConceptosPaqueteServicios').store.load({
                                                params: {
                                                    pPaquete: cmb.getValue()
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                html: 'Proceso S.O:'
                            },
                            {
                                xtype: 'combo',
                                width: 70,
                                allowBlank: false,
                                store: 'StoreSiNo',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                value: 'NO',
                                id: 'strEsSO',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        if(cmb.getValue() === "SI"){
                                            Ext.getCmp('fsTrabajador').setDisabled(false);
                                        }else{
                                            Ext.getCmp('fsTrabajador').setDisabled(true);
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'IDENTIFICACION DEL TRABAJADOR',
                        layout: 'form',
                        collapsible: true,
                        titleCollapse: true,
                        anchor: '99%',
                        autoHeight: true,
                        disabled: true,
                        id: 'fsTrabajador',
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Numero de Personas a Cargo',
                                allowBlank: true,
                                value: 0,
                                width: 100,
                                id: 'strNroPersonasCargoProceso'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                fieldLabel: 'Cargo que Asipiara',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        width: 300,
                                        id: 'strCargoAspiraProceso'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sys_1a',
                                        value: 'Empresa:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 335,
                                        allowBlank: true,
                                        emptyText: 'Empresa Aspira',
                                        id: 'strEmpresaAspiraProceso'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                fieldLabel: 'Cargo Actual',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        width: 300,
                                        value: "NO APLICA",
                                        id: 'strCargoEmpresaActualProceso'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sys_1b',
                                        value: 'Empresa:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 175,
                                        allowBlank: true,
                                        value: "NO APLICA",
                                        emptyText: 'Empresa Actual',
                                        id: 'strEmpresaActualProceso'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sys_1c',
                                        value: 'Sede:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 110,
                                        allowBlank: true,
                                        id: 'strNomSedeEmpresaActualProceso'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                fieldLabel: 'Antigudad',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'displayfield',
                                        id: 'sys_1e',
                                        value: 'En el Cargo Actual:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        width: 100,
                                        emptyText: 'Años',
                                        id: 'strAntiguedadCargoActualProceso'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sys_1f',
                                        value: 'En el Oficio:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        width: 100,
                                        emptyText: 'Años',
                                        id: 'strAntiguedadOficioProceso'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Examen',
                                        width: 100,
                                        listWidth: 150,
                                        name: 'TIPO EXAMEN',
                                        allowBlank: true,
                                        store: 'StoreTipoExamenSaludOcupacional',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strTipoExamenProceso'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sys1',
                                        value: 'EPS:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 180,
                                        listWidth: 500,
                                        name: 'EPS',
                                        allowBlank: true,
                                        store: 'StoreSGSSEPS',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        value: 'NO APLICA',
                                        id: 'strEPSProceso'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sys2',
                                        value: 'PENSION:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 125,
                                        listWidth: 500,
                                        name: 'PENSION',
                                        allowBlank: true,
                                        store: 'StoreSGSSPENSION',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        value: 'NO APLICA',
                                        id: 'strPENSIONProceso'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sys3',
                                        value: 'ARL:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 140,
                                        listWidth: 500,
                                        name: 'ARP',
                                        allowBlank: true,
                                        store: 'StoreSGSSARP',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        value: 'DESCONOCIDO',
                                        id: 'strARPProceso'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                fieldLabel: 'Tipo Vinculación',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 315,
                                        allowBlank: true,
                                        store: 'StoreTipoVinculacionContrato',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        id: 'strTipoVinculacionContratoProceso'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sys_1g',
                                        value: 'Turno:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 315,
                                        allowBlank: true,
                                        store: 'StoreTurnoLaboral',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        id: 'strTurnoProceso'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'editorgrid',
                        id: 'gridConceptosPaqueteServicios',
                        store: stConceptosPaqueteServicios,
                        anchor: "100%",
                        height: 205,
                        border: false,
                        frame: true,
                        loadMask: true,
                        stripeRows: true,
                        clicksToEdit: 1,
                        title: 'Conceptos - Procedimientos',
                        cm: new xg.ColumnModel([
                            chkColumnSeleccionarConcepto,
                            {
                                header: 'IdPaqueteServicio',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'IdPaqueteServicio',
                                width: 1,
                                hidden: true,
                                hideable: false
                            },
                            {
                                header: 'IdProcedimiento',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'IdProcedimiento',
                                width: 1,
                                hidden: true,
                                hideable: false
                            },
                            {
                                header: 'CodProced',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'CodProced',
                                width: 1,
                                hidden: true,
                                hideable: false
                            },
                            {
                                header: 'Descripción',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'DesProced',
                                width: 700
                            },
                            {
                                header: 'Tarifa',
                                readOnly: false,
                                sortable: false,
                                dataIndex: 'VlrTarifa',
                                renderer:  Ext.util.Format.Currency,
                                editor: intVlrTarifaConcepto,
                                align: 'right',
                                width: 150
                            }
                        ]),
                        plugins: [chkColumnSeleccionarConcepto],
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        viewConfig: {
                            forceFit:true
                        },
                        columnLines: true
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'timefield',
                                fieldLabel: 'Hora Cita',
                                width: 90,
                                allowBlank: false,
                                forceSelection: false,
                                minValue: '06:00 AM',
                                maxValue: '09:00 PM',
                                emptyText: 'p.e. 07:00',
                                //format:'H:i',
                                id: 'strHoraCita'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Información Adicional Cita:'
                            },
                            {
                                xtype: 'textfield',
                                width: 150,
                                allowBlank: true,
                                id: 'strInfoAddHoraCita'
                            },
                            {
                                html:'<b style="color: #ff3333;">Fecha de la Cita a Solicitud del Usuario:</b>&nbsp;',
                                border: false
                            },
                            {
                                xtype: 'checkbox',
                                anchor: '100%',
                                value: 'true',
                                id: 'bolAsignaCitasSolicitudUsuario'
                            }
                        ]
                    }
                ]
            }
        ];
        winAsignarCitaManualUi.superclass.initComponent.call(this);
    }
});
