
/*
* @category    Formulario Grid Agenda Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmVerAgendaUi = Ext.extend(Ext.Window, {
    //title: 'OfiClinic© Web..! .:: Agenda por Profesional ::.',
    id: 'winFrmVerAgenda',
    closable:false,
    draggable : false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    padding: 5,
    maximized: true,
    frame: true,
    layout: 'form',
    initComponent: function() {
        var dataTiempoCita = [
            [1,'5 Minutos'],
            [2,'10 Minutos'],
            [3,'15 Minutos'],
            [4,'20 Minutos'],
            [6,'30 Minutos'],
            [8,'40 Minutos'],
            [9,'45 Minutos'],
            [12,'1 Hora'],
            [18,'1 Hora y Media'],
            [24,'2 Horas']
        ];
        var stTiempoCita = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTiempoCita.loadData(dataTiempoCita);
        
        var stGridHoarariosxAgendaDisponiblesCitas = new StoreGridHoarariosxAgendaDisponiblesCitas();
        
        var xg = Ext.grid;
        var strcitaInfoAdd = new Ext.form.TextField();
        var chkColumnSeleccionarHorario = new xg.CheckColumn({
            header: ' ',
            dataIndex: 'Seleccionar',
            id: 'chkColumnSeleccionarHorario',
            value: false,
            width: 10
        });
        function renderCitaObservacionesPlantilla(value, p, record){
            return String.format(
                '<table border="0"><tr><td><b>{0}</b></td></tr><tr><td>{1}</td></table>',
                value, record.data.citaObservacionesPlantilla);
        }
        
        function VerHora(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return value + '<br><span style="color: darkblue; font-weight:bold; text-align:center;">' + record.get('HoraCitaInfAdd');
	}
        function VerDescripcion(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        function VerPaciente(value, metaData, record, rowIndex, colIndex, store){  
            var observaEstado = "";
            if(record.get('EstadoReg')=='C'){
                observaEstado = '</br></br><span style="color: #002953; font-weight:bolder;">Cita Cancelada: ' + record.get('ObservacionesEstado') + '</span>';
            }
            if(record.get('EstadoReg')=='I'){
                observaEstado = '</br></br><span style="color: #002953; font-weight:bolder;">Cita Inasistente: ' + record.get('ObservacionesEstado') + '</span>';
            }
            metaData.attr = 'style="white-space:normal"';  
            return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br></br><span style="color:brown;">Telefonos: ' + record.get('Telefono') + ' - ' + record.get('Telefono1') + '</span>' + observaEstado;  
        }
        
        function VerCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('DescAdiHora');  
        }
        
        function VerCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('Cliente') + '</br>' + record.get('Actividad') + '</br>Programa: ' + record.get('Programa');  
        }
        var stGridCitasxLegalizar = new StoreGridCitasManualxLegalizar();
        var mybbar = new utilBbarUi();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'tabpanel',
                //width: 990,
                height: screen.height,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Asignación de Citas',
                        height: screen.height-240,
                        //width: 951,
                        frame: true,
                        border: false,
                        layout: 'form',
                        id: 'fichaDatos',
                        autoScroll: true,
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Profesional',
                                allowBlank: true,
                                store: 'StoreProfesionales',
                                forceSelection: true,
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                emptyText: 'Seleccione Profesional....',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                anchor: '100%',
                                submitValue: true,
                                id: 'sysProfeAgendaCitasManual',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        if(Ext.getCmp('sysProfeAgendaCitasManual').getValue() !== "" && Ext.getCmp('sysProfeAgendaCitasManual').getValue() !== null && Ext.getCmp('sysFechaAgendaCitasManual').getValue() !== "" && Ext.getCmp('sysFechaAgendaCitasManual').getValue() !== null && Ext.getCmp('intDuracionCita').getValue() !== "" && Ext.getCmp('intDuracionCita').getValue() !== null){
                                            Ext.getCmp('gridHorariosAgendasCitas').store.removeAll();
                                            Ext.getCmp('gridHorariosAgendasCitas').store.load({
                                               params: {
                                                   pProfesional: Ext.getCmp('sysProfeAgendaCitasManual').getValue(),
                                                   pFecha: Ext.getCmp('sysFechaAgendaCitasManual').getValue(),
                                                   pUsuario: ID_USUARIO,
                                                   pNroHoras: Ext.getCmp('intDuracionCita').getValue()
                                               },
                                               callback: function(){
                                                    Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                                        return record.get('MostrarGrupoCita') == true;
                                                    });
                                                }
                                           });
                                       }
                                    }
                                }
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha Agenda',
                                        width: 120,
                                        allowBlank: false,
                                        style: 'text-align:center;',
                                        emptyText: '(dia/mes/año) ',
                                        id: 'sysFechaAgendaCitasManual',
                                        listeners: {
                                            select: function(cmb, rec, idx) {
                                                if(Ext.getCmp('sysProfeAgendaCitasManual').getValue() !== "" && Ext.getCmp('sysProfeAgendaCitasManual').getValue() !== null && Ext.getCmp('sysFechaAgendaCitasManual').getValue() !== "" && Ext.getCmp('sysFechaAgendaCitasManual').getValue() !== null && Ext.getCmp('intDuracionCita').getValue() !== "" && Ext.getCmp('intDuracionCita').getValue() !== null){
                                                    Ext.getCmp('gridHorariosAgendasCitas').store.removeAll();
                                                    Ext.getCmp('gridHorariosAgendasCitas').store.load({
                                                       params: {
                                                           pProfesional: Ext.getCmp('sysProfeAgendaCitasManual').getValue(),
                                                           pFecha: Ext.getCmp('sysFechaAgendaCitasManual').getValue(),
                                                           pUsuario: ID_USUARIO,
                                                           pNroHoras: Ext.getCmp('intDuracionCita').getValue()
                                                       },
                                                       callback: function(){
                                                            Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                                                return record.get('MostrarGrupoCita') == true;
                                                            });
                                                        }
                                                   });
                                               }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Duracion'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 120,
                                        allowBlank: false,
                                        store: stTiempoCita,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Tiempo....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'intDuracionCita',
                                        listeners: {
                                            select: function(cmb, rec, idx) {
                                                if(Ext.getCmp('sysProfeAgendaCitasManual').getValue() !== "" && Ext.getCmp('sysProfeAgendaCitasManual').getValue() !== null && Ext.getCmp('sysFechaAgendaCitasManual').getValue() !== "" && Ext.getCmp('sysFechaAgendaCitasManual').getValue() !== null && Ext.getCmp('intDuracionCita').getValue() !== "" && Ext.getCmp('intDuracionCita').getValue() !== null){
                                                    Ext.getCmp('gridHorariosAgendasCitas').store.removeAll();
                                                    Ext.getCmp('gridHorariosAgendasCitas').store.load({
                                                       params: {
                                                           pProfesional: Ext.getCmp('sysProfeAgendaCitasManual').getValue(),
                                                           pFecha: Ext.getCmp('sysFechaAgendaCitasManual').getValue(),
                                                           pUsuario: ID_USUARIO,
                                                           pNroHoras: Ext.getCmp('intDuracionCita').getValue()
                                                       },
                                                       callback: function(){
                                                            Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                                                return record.get('MostrarGrupoCita') == true;
                                                            });
                                                        }
                                                   });
                                               }
                                            }
                                        }
                                    },
                                    {
                                        html: '+ Info Cita:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: true,
                                        id: 'strInfoAddHoraCita'
                                    },
                                    {
                                        html:'<b style="color: #ff3333;">Fecha Cita a Solicitud Paciente:</b>&nbsp;',
                                        border: false
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'true',
                                        id: 'bolAsignaCitasSolicitudUsuario'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Cliente',
                                        width: 297,
                                        allowBlank: false,
                                        store: 'StoreCliente',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Cliente....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'intClienteAsignaCita',
                                        listeners: {
                                            select: function(cmb, rec, idx) {
                                                if(cmb.getValue() == null || cmb.getValue() == ""){
                                                    Ext.getCmp('intClientePlanAsignaCita').store.removeAll(true);
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').store.removeAll(true);
                                                    Ext.getCmp('intClienteContratoAsignaCita').store.removeAll(true);
                                                    Ext.getCmp('intProcedAsignaCita').store.removeAll();
                                                    Ext.getCmp('intClientePlanAsignaCita').setValue(null);
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').setValue(null);
                                                    Ext.getCmp('intProcedAsignaCita').setValue(null);
                                                    Ext.getCmp('intClientePlanAsignaCita').disable();
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').disable();
                                                    Ext.getCmp('intClienteContratoAsignaCita').disable();

                                                }else{
                                                    Ext.getCmp('intClientePlanAsignaCita').store.removeAll(true);
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').store.removeAll(true);
                                                    Ext.getCmp('intClienteContratoAsignaCita').store.removeAll(true);
                                                    Ext.getCmp('intProcedAsignaCita').store.removeAll();
                                                    Ext.getCmp('intProcedAsignaCita').setValue(null);
                                                    Ext.getCmp('intProcedAsignaCita').store.load({
                                                        params:{
                                                            pIPS: ID_IPS,
                                                            pCliente: cmb.getValue()
                                                        }
                                                    });
                                                    Ext.getCmp('intClientePlanAsignaCita').setValue(null);
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').setValue(null);
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').disable();
                                                    Ext.getCmp('intClientePlanAsignaCita').store.load({
                                                        params:{
                                                            pCliente: cmb.getValue()
                                                        },
                                                        callback: function(){
                                                            Ext.getCmp('intClientePlanAsignaCita').enable();
                                                        }
                                                    });
                                                    Ext.getCmp('intClienteContratoAsignaCita').store.load({
                                                        params:{
                                                            pCliente: cmb.getValue()
                                                        },
                                                        callback: function(){
                                                            Ext.getCmp('intClienteContratoAsignaCita').enable();
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Plan:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 145,
                                        listWidth: 250,
                                        allowBlank: false,
                                        disabled: true,
                                        store: 'StoreClientesPlan',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'IdPlan',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Plan....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'intClientePlanAsignaCita',
                                        listeners: {
                                            select: function(cmb, rec, idx) {
                                                if(cmb.getValue() == null || cmb.getValue() == ""){
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').store.removeAll(true);
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').setValue(null);
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').disable();
                                                }else{
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').store.removeAll(true);
                                                    Ext.getCmp('intClienteSubPlanAsignaCita').store.load({
                                                        params:{
                                                            pPlan: cmb.getValue()
                                                        },
                                                        callback: function(){
                                                            Ext.getCmp('intClienteSubPlanAsignaCita').enable();
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'SubPlan:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 145,
                                        listWidth: 250,
                                        allowBlank: false,
                                        disabled: true,
                                        store: 'StoreClienteSubplan',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'IdSubPlan',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Plan....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'intClienteSubPlanAsignaCita'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Contrato:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 133,
                                        listWidth: 250,
                                        allowBlank: false,
                                        disabled: true,
                                        store: 'StoreClienteContrato',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'IdContrato',
                                        displayField: 'Contrato',
                                        emptyText: 'Seleccione Contrato....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'intClienteContratoAsignaCita'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Concepto',
                                anchor: '100%',
                                allowBlank: false,
                                store: 'StoreConceptosCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><span style="font-size: 12; color: #AA0033">Codigo: {CUPSCodigo}</span><br/><span style="font-size: 12; color: #0000EE ">Tarifa: {Tarifa}</span><br/><span style="font-size: 12; color: #0B6121;">Tarifa: {Tarifa2}</span><hr /></div></tpl>',
                                emptyText: 'Seleccione Concepto....',
                                itemSelector: 'div.cbRango',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intProcedAsignaCita'
                            },
                            {
                                xtype: 'panel',
                                title: 'Informacion Adicional para Asignar Cita',
                                layout: 'table',
                                collapseFirst: false,
                                border: true,
                                anchor: '100%',
                                autoHeight: true,
                                frame: true,
                                layoutConfig: {
                                    columns: 2
                                },
                                items: [
                                    {
                                        xtype: 'panel',
                                        title: 'Paciente',
                                        layout: 'form',
                                        border: true,
                                        width: 495,
                                        //anchor: '50%',
                                        height: 370,
                                        frame: true,
                                        items:[
                                            {
                                                xtype: 'form',
                                                frame: true,
                                                height: 350,
                                                anchor: '100%',
                                                autoScroll: true,
                                                id: 'frmPacientesCitaManual',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'intIdPaciente',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysPacienteValido',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo Doc ID',
                                                        width: 230,
                                                        name: 'cbTdoc',
                                                        allowBlank: false,
                                                        store: 'StoreTdocPac',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Tipo Documento....',
                                                        mode: 'local',
                                                        triggerAction: 'all',
                                                        forceSelection: true,
                                                        //value: 'AS',
                                                        //rawValue: 'AS - Adulto sin identificación',
                                                        //value: 'AS - Adulto sin identificación',
                                                        id: 'strTdoc'/*,
                                                        listeners: {
                                                            change: function(t, newValue, oldValue){
                                                                switch(newValue){
                                                                    case "AS":
                                                                        Ext.getCmp('strDocID').allowBlank = true;
                                                                        Ext.getCmp('strDocID').clearInvalid();
                                                                        Ext.getCmp('strDocID').setValue(null);
                                                                        Ext.getCmp('strDocID').setDisabled(true); 
                                                                        break;
                                                                    case "MS":
                                                                        Ext.getCmp('strDocID').allowBlank = true;
                                                                        Ext.getCmp('strDocID').clearInvalid();
                                                                        Ext.getCmp('strDocID').setValue(null);
                                                                        Ext.getCmp('strDocID').setDisabled(true); 
                                                                        break;
                                                                    default:
                                                                        Ext.getCmp('strDocID').allowBlank = false;
                                                                        Ext.getCmp('strDocID').setDisabled(false); 
                                                                        break;
                                                                }
                                                            }
                                                        }*/
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        anchor: '100%',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Documento ID',
                                                                name: 'txtDocID',
                                                                allowBlank: false,
                                                                //disabled: true,
                                                                width: 200,
                                                                id: 'strDocID'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Paciente',
                                                                id: 'btnBuscarPacienteAgendaManual'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Genero',
                                                        //anchor: '100%',
                                                        width: 230,
                                                        name: 'cbGenero',
                                                        allowBlank: false,
                                                        store: 'StoreGenero',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Genero....',
                                                        forceSelection: true,
                                                        id: 'strGenero'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        anchor: '100%',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Apellido',
                                                                width: 140,
                                                                name: 'txtApe1',
                                                                style: 'text-transform:uppercase;',
                                                                allowBlank: false,
                                                                id: 'strApe1'
                                                            },
                                                            {
                                                                html: '2do Apellido:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                //fieldLabel: '2do Apellido',
                                                                width: 141,
                                                                name: 'txtApe2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strApe2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        anchor: '100%',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Nombre',
                                                                width: 140,
                                                                name: 'txtNom1',
                                                                allowBlank: false,
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom1'
                                                            },
                                                            {
                                                                html: '2do Nombre:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                //fieldLabel: '2do Nombre',
                                                                width: 140,
                                                                name: 'txtNom2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        anchor: '100%',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Fecha Nacimiento',
                                                                width: 130,
                                                                name: 'txtFecNac',
                                                                allowBlank: false,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFecNac'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 225,
                                                                name: 'txtEdad',
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                style: 'color: blue;text-align:center',
                                                                id: 'strEdad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Municipio',
                                                        anchor: '100%',
                                                        name: 'cbDeptoMuni',
                                                        allowBlank: false,
                                                        store: 'StoreDeptoMuni',
                                                        valueField: 'IdDeptoMunicipio',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        id: 'strDeptoMuni'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Direccion',
                                                        name: 'txtDireccion',
                                                        allowBlank: true,
                                                        style: 'text-transform:uppercase;',
                                                        anchor: '100%',
                                                        id: 'strDireccion'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Telefono',
                                                        name: 'txtTel1',
                                                        allowBlank: false,
                                                        anchor: '100%',
                                                        id: 'strTel1'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'txtTel2',
                                                        fieldLabel: 'Otro - Cel.',
                                                        anchor: '100%',
                                                        id: 'strTel2'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        anchor: '100%',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                flex: 1,
                                                                fieldLabel: 'Zona',
                                                                store: 'StoreZonaResidencia',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                name: 'cbZona',
                                                                emptyText: 'Zona....',
                                                                allowBlank: false,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                width: 80,
                                                                value: 'Urbana',
                                                                triggerAction: 'all',
                                                                id: 'strZona'
                                                            },
                                                            {
                                                                html: 'Email:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtEmail',
                                                                vtype: 'email',
                                                                emptyText: 'Email....',
                                                                width: 245,
                                                                id: 'strEmail'
                                                            }
                                                        ]
                                                    }
                                                ],
                                                tbar:{
                                                    items: [
                                                        {
                                                            xtype: 'button',
                                                            text: 'Nuevo Paciente',
                                                            iconCls: 'btnNuevo',
                                                            id: 'btnNuevoAgendaManual'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'tbfill'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Guardar',
                                                            iconCls: 'btnGuardar',
                                                            id: 'btn_AdicionarItemAgendaManual'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Modificar',
                                                            iconCls: 'btnGuardar',
                                                            id: 'btn_ModificarItemAgendaManual'
                                                        }
                                                    ]
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        title: 'Citas Disponibles',
                                        layout: 'form',
                                        border: true,
                                        width: 485,
                                        //anchor: '50%',
                                        height: 370,
                                        frame: true,
                                        items:[
                                            {
                                                xtype: 'editorgrid',
                                                id: 'gridHorariosAgendasCitas',
                                                store: stGridHoarariosxAgendaDisponiblesCitas,
                                                //store: stTiempoCita,
                                                anchor: "100%",
                                                height: 350,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                stripeRows: true,
                                                clicksToEdit: 1,
                                                cm: new xg.ColumnModel([
                                                    chkColumnSeleccionarHorario,
                                                    {
                                                        header: 'Codigo',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'citaID',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'Descripción del Horario',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'citaDescripcion',
                                                        renderer: renderCitaObservacionesPlantilla,
                                                        width: 200
                                                    }
                                                ]),
                                                plugins: [chkColumnSeleccionarHorario],
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                iconCls:'icon-horarios',
                                                viewConfig: {
                                                    forceFit:true
                                                },
                                                listeners:{
                                                    beforeedit : function(e){
                                                        if(e.record.get('Estado')=== "i"){
                                                            return false;
                                                        }
                                                    }
                                                },
                                                columnLines: true,
                                                tbar:{
                                                    items: [
                                                        {
                                                            xtype: 'tbfill'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Asignar Cita',
                                                            iconCls: 'btnAsignarCita',
                                                            id: 'btn_AsignarCitaItemAgendaManual'
                                                        }
                                                    ]
                                                }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'grid',
                                title: 'Citas Asignadas',
                                id: 'gridFormularioCitasManual',
                                store: 'StoreProfesionalesAgendaManual',
                                layout: 'fit',
                                anchor: "100%",
                                height: screen.height-250,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    new Ext.grid.RowNumberer(),
                                    {
                                        header: 'CAS',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'CAS',
                                        width: 100,
                                        align: 'center',
                                        hideable: false
                                    },
                                    {
                                        header: 'Hora',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'HoraCita',
                                        renderer: VerHora,
                                        width: 110,
                                        align: 'center',
                                        hideable: false
                                    },
                                    {
                                        header: 'Paciente',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Paciente',
                                        width: 350,
                                        renderer: VerPaciente,
                                        hideable: false
                                    },
                                    {
                                        header: 'Cliente',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Cliente',
                                        renderer: VerDescripcion,
                                        width: 260,
                                        hideable: false
                                    },
                                    {
                                        header: 'Actividad Agendada',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'DesProced',
                                        renderer: VerDescripcion,
                                        width: 290,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.ux.grid.LockingGridView({
                                    getRowClass: function(record, index, rowParams, store){
                                        var estado = record.data.EstadoCon;
                                        switch(estado){
                                            case "C":
                                                return "Apto";
                                                break;
                                            case "A":
                                                return "Triage3";
                                                break;
                                            default:
                                                return "NoActivo";
                                                break;
                                        }
                                    }
                                }),
                                columnLines: true,
                                tbar:
                                    {
                                        xtype: 'toolbar',
                                        items: [
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'cycle',
                                                prependText: 'Vista por: ',
                                                iconCls: 'btnBuscar',
                                                showText: true,
                                                id: 'btnViewAsignarCitasManual',
                                                items: [
                                                    {
                                                        text:'Citas Asignadas',
                                                        checked:true
                                                    },
                                                    {
                                                        text:'Citas Canceladas'
                                                    },
                                                    {
                                                        text:'Citas Inasistentes'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Actualizar Agenda',
                                                iconCls: 'btnActualizarGrid',
                                                tooltip: 'Actualizar Agenda',
                                                id: 'btnActualizarAgendaCitasManual'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'tbfill'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Cancelar Cita',
                                                iconCls: 'btnAsignarCita',
                                                tooltip: 'Cancelar la Cita Seleccionada',
                                                id: 'btnCancelarCitasManual'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Marcar Cita Inasistente',
                                                iconCls: 'btnAsignarCita',
                                                tooltip: 'Marcar Inasistente la Cita Seleccionada',
                                                id: 'btnInasistenciaCitasManual'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Imprimir Agenda',
                                                iconCls: 'btnImprimir',
                                                tooltip: 'Imprimir Agenda',
                                                id: 'btnPrintAgendaCitasManual'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            }
                                        ]
                                    }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Legalizar Citas',
                        height: screen.height-240,
                        //width: 951,
                        frame: true,
                        border: false,
                        layout: 'fit',
                        id: 'fichaLegaliza',
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasAsignadas',
                                    text: 'Ver Historial Citas',
                                    tooltip: 'Ver Historial de Citas Asignadas por Paciente',
                                    id: 'btnVerHistorialCitas_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasCanceladas',
                                    text: 'Ver Historial Cancelaciones',
                                    tooltip: 'Ver Historial de Citas Canceladas por Paciente',
                                    id: 'btnVerHistorialCanceladas_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasInasistencia',
                                    text: 'Ver Historial Inasistencias',
                                    tooltip: 'Ver Historial de Citas Inasistidas por Paciente',
                                    id: 'btnVerHistorialInasistencia_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '99%',
                                frame: true,
                                border: false,
                                id: 'infoPac_Citas1',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        id: 'intPacienteLegalizacion',
                                        value: 0
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'displayfield',
                                                value: 'Paciente:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 800,
                                                readOnly: true,
                                                allowBlank: true,
                                                emptyText: 'Debe Buscar Paciente....',
                                                id: 'sysPacienteLegalizacion'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Paciente',
                                                id: 'btnBuscarPacienteLegalizacion'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip: 'Limpiar Datos del Paciente',
                                                iconCls: 'btnLimpiar',
                                                id: 'btnLimpiarPacienteLegalizacion'
                                            }
                                        ]
                                    },
                                    {
                                        html:'<hr>',
                                        border: false
                                    },
                                    {
                                        xtype: 'grid',
                                        id: 'gridLegalizarCitas',
                                        store: stGridCitasxLegalizar,
                                        anchor: "100%",
                                        height: 450,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        stripeRows: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                header: 'CAS',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'CAS',
                                                width: 100,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Fecha',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'FechaCita',
                                                width: 80,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Hora',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAgenda',
                                                width: 110,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Hora Estimada',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAtencion',
                                                width: 80,
                                                hideable: false
                                            },
                                            {
                                                header: 'Profesional',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Profesional',
                                                width: 280,
                                                hideable: false
                                            },
                                            {
                                                header: 'Cliente',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Cliente',
                                                width: 250,
                                                hideable: false
                                            },
                                            {
                                                header: 'Actividad',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Actividad',
                                                width: 280,
                                                hideable: false
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                        view: new Ext.ux.grid.LockingGridView(),
                                        columnLines: true,
                                        tbar:{
                                            items: [
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    iconCls: 'btnCitasLegalizacion',
                                                    text: 'Ver Historial Legalizaciones',
                                                    tooltip: 'Ver Historial de Citas Legalizadas por Paciente',
                                                    id: 'btnHistorialLegalizaciones_citas'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Citas Pendientes por Legalizar',
                                                    iconCls: 'btnCitasBuscar',
                                                    id: 'btnCitasxLegalizar'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        bbar:{
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Legalizar Cita',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Legalizar la Cita Seleccionada',
                                                    id: 'btnLegalizarCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Cancelar Cita',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Cancelar la Cita Seleccionada',
                                                    id: 'btnCancelarCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Marcar Cita Inasistente',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Marcar Inasistente la Cita Seleccionada',
                                                    id: 'btnInasistenciaCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        winFrmVerAgendaUi.superclass.initComponent.call(this);
    }
});








