/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerAgenda = Ext.extend(winFrmVerAgendaUi, {
    initComponent: function() {
        winFrmVerAgenda.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        el = Ext.get('IdMunicipio');
        ID_MUNICIPIO = el.getValue();
        
        CODPROCED_SELECCIONADO = "NA";
        DESPROCED_SELECCIONADO = "NA";
        TARPROCED_SELECCIONADO = 0;
        MONEDA_SELECCIONADO = 0;
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        /*Ext.getCmp('intProcedAsignaCita').store.load({
            params:{
                pIPS: ID_IPS,
                pCliente: 1
            }
        });*/
        
        Ext.getCmp('btn_ModificarItemAgendaManual').setVisible(false);
        var btn_AsignarCitaItemAgendaManual = Ext.getCmp('btn_AsignarCitaItemAgendaManual').on("click",this.AsignarCitaAgendaManual,this);
        var fFecNac = Ext.getCmp('fecFecNac').on("Blur",this.MostrarEdadAgendaManual,this);
        var btnNuevoAgendaManual = Ext.getCmp('btnNuevoAgendaManual').on("click",this.NuevoPacienteAgendaManual,this);
        var btnBuscarPacienteAgendaManual = Ext.getCmp('btnBuscarPacienteAgendaManual').on("click",this.BuscarPacienteAgendaManual,this);
        var btn_AdicionarItemAgendaManual = Ext.getCmp('btn_AdicionarItemAgendaManual').on("click",this.GuardarItemAgendaManual,this);
        var btn_ModificarItemAgendaManual = Ext.getCmp('btn_ModificarItemAgendaManual').on("click",this.ModificarItemAgendaManual,this);
        var intProcedAsignaCita = Ext.getCmp('intProcedAsignaCita').on("select",this.SelectIdProced,this);
        Ext.getCmp('strDeptoMuni').setValue(ID_MUNICIPIO);
            
        var sysProfeAgendaCitasManual = Ext.getCmp('sysProfeAgendaCitasManual').on("select",this.CargaNuloDetalleAgendaCitasManual,this);
        var sysFechaAgenda = Ext.getCmp('sysFechaAgendaCitasManual').on("select",this.CargaDetalleAgendaCitasManual,this);
        var btnCancelarCitaManual = Ext.getCmp('btnCancelarCitasManual').on("click",this.CancelarCita,this);
        var btnCancelarCita = Ext.getCmp('btnCancelarCita').on("click",this.CancelarCita1,this);
        var btnInasistenciaCitasManual = Ext.getCmp('btnInasistenciaCitasManual').on("click",this.InasistenciaCita,this);
        var btnInasistenciaCita = Ext.getCmp('btnInasistenciaCita').on("click",this.InasistenciaCita1,this);
        var btnActualizarAgenda = Ext.getCmp('btnActualizarAgendaCitasManual').on("click",this.ActualizarAgenda,this);
        var btnViewAsignarCitasManual = Ext.getCmp('btnViewAsignarCitasManual').on("change",this.ViewAgendaCitasManual,this);

        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
        var btnPrintAgendaCitasManual = Ext.getCmp('btnPrintAgendaCitasManual').on("click",this.ImprimirAgendaManual, this);
        var btnBuscarPacienteLegalizacion = Ext.getCmp('btnBuscarPacienteLegalizacion').on("click",this.BuscarPacienteLegaliza,this);
        var btnVerHistorialCitas_citas = Ext.getCmp('btnVerHistorialCitas_citas').on("click",this.HistorialCitasAsignadas,this);
        var btnVerHistorialCanceladas_citas = Ext.getCmp('btnVerHistorialCanceladas_citas').on("click",this.HistorialCitasCanceladas,this);
        var btnVerHistorialInasistencia_citas = Ext.getCmp('btnVerHistorialInasistencia_citas').on("click",this.HistorialCitasInasistencia,this);
        var btnVerHistorialLegalizacion_citas = Ext.getCmp('btnHistorialLegalizaciones_citas').on("click",this.HistorialCitasLegalizadas,this);
        var btnCitasxLegalizar = Ext.getCmp('btnCitasxLegalizar').on("click",this.CitasxLegalizar,this);
        var btnLimpiarPacienteLegalizacion = Ext.getCmp('btnLimpiarPacienteLegalizacion').on("click",this.LimpiarDatosPaciente,this);
        var btnLegalizarCita = Ext.getCmp('btnLegalizarCita').on("click",this.LegalizarCita,this);
    },
    LegalizarCita: function(){
        if(Ext.getCmp('gridLegalizarCitas').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridLegalizarCitas').selModel.getSelections();
            abrir_ventana("../../../app/frm/radicacionservicios/frmradicacionservicios.php?Legalizar="+selections[0].json.CAS,"ofiClinic");
        }
    },
    InasistenciaCita1: function(){
        if(Ext.getCmp('gridLegalizarCitas').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridLegalizarCitas').selModel.getSelections();
            xCAS = selections[0].json.CAS;
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'ATENCIÓN: Recuerde Actualizar la Agenda para estar seguro que desea marcar inasistente la cita Nro. ' + xCAS + ' ?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        var winInasistenciaCitas = new winInasistenciaCitaUi();
                        Ext.getCmp('sysIdAgendaManualInasistencia').setValue(selections[0].json.IdAgendaManual);
                        Ext.getCmp('sysUsuarioAgendaManualInasistencia').setValue(ID_USUARIO);
                        Ext.getCmp('sysProfesionalAgendaManualInasistencia').setValue(selections[0].json.Profesional);
                        Ext.getCmp('sysFechaAgendaManualInasistencia').setValue(selections[0].json.FechaCita);
                        Ext.getCmp('sysHoraAgendaManualInasistencia').setValue(selections[0].json.HoraAgenda);
                        Ext.getCmp('sysCASAgendaManualInasistencia').setValue(selections[0].json.CAS);
                        winInasistenciaCitas.show();
                    }
                }
            });
        }
    },
    CancelarCita1: function(){
        if(Ext.getCmp('gridLegalizarCitas').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridLegalizarCitas').selModel.getSelections();
            xCAS = selections[0].json.CAS;
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea cancelar la cita Nro. ' + xCAS + ' ?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        var winCancelaCitas = new winCancelarCitaUi();
                        Ext.getCmp('sysIdAgendaManual').setValue(selections[0].json.IdAgendaManual);
                        Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                        Ext.getCmp('sysProfesionalAgenda').setValue(PonerAcentosMayusculas(selections[0].json.Profesional));
                        Ext.getCmp('sysFecha').setValue(selections[0].json.FechaCita);
                        Ext.getCmp('sysHora').setValue(selections[0].json.HoraAgenda);
                        Ext.getCmp('sysCASAgendaManualCancela').setValue(selections[0].json.CAS);
                        winCancelaCitas.show();
                    }
                }
            });
        }
    },
    LimpiarDatosPaciente: function(){
        Ext.getCmp('intPacienteLegalizacion').setValue(0);
        Ext.getCmp('sysPacienteLegalizacion').setValue(null);
        Ext.getCmp('gridLegalizarCitas').store.load({
            params: {
                pEmpresa: ID_EMPRESA,
                pSede: ID_SEDE,
                pIPS: ID_IPS,
                pPaciente: 0
            }
        });
    },
    CitasxLegalizar: function(){
        if (Ext.getCmp('intPacienteLegalizacion').getValue() != 0)
        {
            Ext.getCmp('gridLegalizarCitas').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pSede: ID_SEDE,
                    pIPS: ID_IPS,
                    pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue()
                }
            });
        }
    },
    HistorialCitasLegalizadas: function(){
        if (Ext.getCmp('intPacienteLegalizacion').getValue() != 0){
            var winFrmHistorialLegalizaciones = new winFrmHistorialLegalizacionesUi();
            winFrmHistorialLegalizaciones.setTitle("OfiClinic© Web..! .:: Historial de Legalizaciones ::.");
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("task", "HISTORIAL_CITAS_LEGALIZADAS_MANUAL");
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pEmpresa", ID_EMPRESA);
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pIPS", ID_IPS);
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pSede", ID_SEDE);
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pPaciente", Ext.getCmp('intPacienteLegalizacion').getValue());
            Ext.getCmp('gridHistorialCitas').store.load({
                params: {
                    start: 0,
                    limit: 15
                }
            });
            winFrmHistorialLegalizaciones.show();
        }
    },
    HistorialCitasInasistencia: function(){
        if (Ext.getCmp('intPacienteLegalizacion').getValue() != 0){
            var winFrmHistorialCitas = new winFrmHistorialCitasUi();
            winFrmHistorialCitas.setTitle("OfiClinic© Web..! .:: Historial de Inasistencia ::.");
            winFrmHistorialCitas.setIconClass("btnCitasInasistencia");
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("task", "HISTORIAL_CITAS_INASISTENCIA_MANUAL");
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pEmpresa", ID_EMPRESA);
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pIPS", ID_IPS);
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pPaciente", Ext.getCmp('intPacienteLegalizacion').getValue());
            Ext.getCmp('gridHistorialCitas').getColumnModel().setColumnHeader(5, "Fecha Marca Inasistencia");
            Ext.getCmp('gridHistorialCitas').getColumnModel().setColumnHeader(6, "Usuario Marca Inasistencia");
            Ext.getCmp('gridHistorialCitas').getColumnModel().setColumnHeader(7, "Motivo Inasistencia");
            Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(8, true);
            Ext.getCmp('idPacienteHistoricoCitasAsignadas').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
            Ext.getCmp('gridHistorialCitas').store.load({
                params: {
                    start: 0,
                    limit: 15
                }
            });
            winFrmHistorialCitas.show();
        }
    },
    HistorialCitasCanceladas: function(){
        if (Ext.getCmp('intPacienteLegalizacion').getValue() != 0){
            var winFrmHistorialCitas = new winFrmHistorialCitasUi();
            winFrmHistorialCitas.setTitle("OfiClinic© Web..! .:: Historial de Citas Canceladas ::.");
            winFrmHistorialCitas.setIconClass("btnCitasCanceladas");
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("task", "HISTORIAL_CITAS_CANCELADAS_MANUAL");
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pEmpresa", ID_EMPRESA);
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pIPS", ID_IPS);
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pPaciente", Ext.getCmp('intPacienteLegalizacion').getValue());
            Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(8, true);
            Ext.getCmp('idPacienteHistoricoCitasAsignadas').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
            Ext.getCmp('gridHistorialCitas').store.load({
                params: {
                    start: 0,
                    limit: 15
                }
            });
            winFrmHistorialCitas.show();
        }
    },
    HistorialCitasAsignadas: function(){
        if (Ext.getCmp('intPacienteLegalizacion').getValue() != 0){
            var winFrmHistorialCitas = new winFrmHistorialCitasUi();
            winFrmHistorialCitas.setTitle("OfiClinic© Web..! .:: Historial de Citas Asignadas ::.");
            winFrmHistorialCitas.setIconClass("btnCitasAsignadas");
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("task", "HISTORIAL_CITAS_ASIGNADAS_MANUAL");
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pEmpresa", ID_EMPRESA);
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pIPS", ID_IPS);
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pPaciente", Ext.getCmp('intPacienteLegalizacion').getValue());
            Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(5, true);
            Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(6, true);
            Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(7, true);
            Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(8, true);
            Ext.getCmp('idPacienteHistoricoCitasAsignadas').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
            Ext.getCmp('gridHistorialCitas').store.load({
                params: {
                    start: 0,
                    limit: 15
                }
            });
            winFrmHistorialCitas.show();
        }
    },
    BuscarPacienteLegaliza: function(){
        buscarpaciente("LegalizaAgendaManual");
    },
    ImprimirAgendaManual: function(){
        if(Ext.getCmp('sysProfeAgendaCitasManual').getValue()!="" && Ext.getCmp('sysProfeAgendaCitasManual').getValue()!=null && Ext.getCmp('sysFechaAgendaCitasManual').getValue()!="" && Ext.getCmp('sysFechaAgendaCitasManual').getValue()!=null){
            window.open ("../../controlador/profesionales/printagendamanual.php?pPrestador=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pProfesional="+Ext.getCmp('sysProfeAgendaCitasManual').getValue()+"&pFecha="+Ext.getCmp('sysFechaAgendaCitasManual').getValue().format("Y-m-d")+"&pEstado=A","Agenda por Profesional");
        }else{
            Ext.MessageBox.show({
                title: 'Imprimir Agenda',
                msg: 'Debe Seleccionar un Profesional y/o Fecha de la Cita',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    SelectIdProced: function(cmb, rec, idx) {
        CODPROCED_SELECCIONADO = rec.data.CodProced;
        DESPROCED_SELECCIONADO = rec.data.Descripcion;
        /*if(parseInt(Ext.getCmp('intMoneda').getValue()) === 1){
            MONEDA_SELECCIONADO = 1;
            TARPROCED_SELECCIONADO = rec.data.VlrTarifa;
        }else{
            MONEDA_SELECCIONADO = 2;
            TARPROCED_SELECCIONADO = rec.data.VlrTarifa2;
        }*/
    },
    AsignarCitaAgendaManual: function(){
        var parametrosCitasSeleccionadas = "";
        var SolicitudUsuaio = (Ext.getCmp('bolAsignaCitasSolicitudUsuario').getValue()==true)?'1':'0';
        var grupoCita = 0;
        //alert("Paciente Valido:" + Ext.getCmp('sysPacienteValido').getValue());
        //alert("Cliente:" + Ext.getCmp('intClienteAsignaCita').getValue());
        //alert("ProcedAsignaCita:" + Ext.getCmp('intProcedAsignaCita').getValue());
        //alert("ProcedAsignaCita:" + Ext.getCmp('intProcedAsignaCita').getValue());
        
        //if (Ext.getCmp('sysPacienteValido').getValue() != 0 && Ext.getCmp('intClienteAsignaCita').getValue() != null && Ext.getCmp('intClienteAsignaCita').getValue() != "" && Ext.getCmp('intProcedAsignaCita').getValue() != null && Ext.getCmp('intProcedAsignaCita').getValue() != "" && Ext.getCmp('intDuracionCita').getValue() != null && Ext.getCmp('intDuracionCita').getValue() != ""  && Ext.getCmp('intMoneda').getValue() != null && Ext.getCmp('intMoneda').getValue() != ""){
        if (Ext.getCmp('sysPacienteValido').getValue() != 0 && Ext.getCmp('intClienteAsignaCita').getValue() != null && Ext.getCmp('intClienteAsignaCita').getValue() != "" && Ext.getCmp('intClientePlanAsignaCita').getValue() != null && Ext.getCmp('intClientePlanAsignaCita').getValue() != "" && Ext.getCmp('intClienteSubPlanAsignaCita').getValue() != null && Ext.getCmp('intClienteSubPlanAsignaCita').getValue() != "" && Ext.getCmp('intClienteContratoAsignaCita').getValue() != null && Ext.getCmp('intClienteContratoAsignaCita').getValue() != "" && Ext.getCmp('intProcedAsignaCita').getValue() != null && Ext.getCmp('intProcedAsignaCita').getValue() != "" && Ext.getCmp('intDuracionCita').getValue() != null && Ext.getCmp('intDuracionCita').getValue() != ""){
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea asignar la cita?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn=="yes"){
                        var citasseleccionadas = false;
                        Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                            return record.get('Seleccionar') == true;
                        });
                        Ext.getCmp('gridHorariosAgendasCitas').store.each(function(record){
                            grupoCita = record.get('GrupoCita');
                        });
                        Ext.getCmp('gridHorariosAgendasCitas').store.clearFilter();
                        if(grupoCita != 0){
                            Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                return record.get('GrupoCita') == grupoCita;
                            });
                            Ext.getCmp('gridHorariosAgendasCitas').store.each(function(record){
                                citasseleccionadas = true;
                                parametrosCitasSeleccionadas = parametrosCitasSeleccionadas + record.get('citaDescripcion') + "^" + record.get('citaID') + "^" + record.get('TipoHorario')  + "^" + record.get('HoraCitaInicio') + "^" + record.get('HoraCitaFin') +   "^" + record.get('intHoraCitaInicio') + "^" + record.get('intHoraCitaFin') +  "¬";
                            });
                        }
                        if (citasseleccionadas == false){
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'Debe seleccionar al menos una cita para poder realizar la asignación',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }else{
                            Ext.Ajax.request({
                                waitMsg: 'Por favor Espere...',
                                url: "../../controlador/profesionales/controlador_profesionales.php",
                                params: {
                                    task: "AGENDA_MANUAL201501_ASIGNARCITA",
                                    pEmpresa: ID_EMPRESA,
                                    pSEDE: ID_SEDE, 
                                    pIPS: ID_IPS, 
                                    pProfesionalCita: Ext.getCmp('sysProfeAgendaCitasManual').getValue(),
                                    pFechaCita: Ext.getCmp('sysFechaAgendaCitasManual').getValue().format('Y-m-d'),
                                    pHoraCitaInfAdd: Ext.getCmp('strInfoAddHoraCita').getValue(),
                                    pPaciente: Ext.getCmp('intIdPaciente').getValue(),
                                    pCliente: Ext.getCmp('intClienteAsignaCita').getValue(),
                                    pPlan: Ext.getCmp('intClientePlanAsignaCita').getValue(),
                                    pSubPlan: Ext.getCmp('intClienteSubPlanAsignaCita').getValue(),
                                    pConcepto: Ext.getCmp('intProcedAsignaCita').getValue(),
                                    pMoneda: 1,
                                    pDuracion: Ext.getCmp('intDuracionCita').getValue(),
                                    pUsuario: ID_USUARIO,
                                    pCodProced: CODPROCED_SELECCIONADO,
                                    pDesProced: DESPROCED_SELECCIONADO,
                                    pTarifaProced: TARPROCED_SELECCIONADO,
                                    pMonedaProced: MONEDA_SELECCIONADO,
                                    pSolicitudUsuario: SolicitudUsuaio,
                                    pInfoCita: parametrosCitasSeleccionadas
                                },
                                success: function(response)
                                {
                                    var result = response.responseText.split("^");
                                    if (result[0] > 0)
                                    {
                                        var html = '<table><tr><td width="50"><img src="../../../resources/varios/citas.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #2E2EFE; font-size: 14px;">Asignación de Citas:</h1><br/><p style="color: #003333;font-weight: bold;">Se Asigno la Cita Nro. ' + result[0]  + '</p></br>';
                                        html += '<br/><p style="color: #003333;font-weight: bold;">Profesional: ' + Ext.getCmp('sysProfeAgendaCitasManual').getRawValue() +'</p>';
                                        html += '<span style="color: #003333;font-weight: bold;">Fecha: ' + Ext.getCmp('sysFechaAgendaCitasManual').getValue().format('d/m/Y') + '&nbsp;</span>';
                                        //html += '<span style="color: #003333;font-weight: bold;">Hora: ' + Ext.getCmp('strHoraCita').getValue() + ' - ' + Ext.getCmp('strInfoAddHoraCita').getValue() + '</span>';
                                        html += '</td><td width="70">&nbsp;</td></tr></table>';
                                        Sexy.info(html);
                                        Ext.getCmp('gridFormularioCitasManual').store.reload();
                                        Ext.getCmp('gridHorariosAgendasCitas').store.removeAll();
                                        //Ext.getCmp('winAsignarCitaManualUi').close();
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'No podemos asignar las citas en estos momentos y/o la hora de la cita ya fue asignada',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                },
                                failure: function(response){
                                    var result = response.responseText;
                                    Ext.MessageBox.show({
                                        title: 'Error Base Datos',
                                        msg: 'Error de conexión - No podemos asignar las citas en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            });
                        }
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Verifique que los campos obligatorios estan diligenciados y/o el paciente este creado.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    CargarConceptosxClienteTarifa: function(cmb, rec, idx) {
        Ext.getCmp('intProcedAsignaCita').store.removeAll(true);
        Ext.getCmp('intProcedAsignaCita').store.load({
           params: {
               pIPS: ID_IPS,
               pCliente: cmb.getValue()
           } 
        });
        if(rec.data.PreparacionEspecial != null && rec.data.PreparacionEspecial != ""){
            Ext.Msg.show({
                title: 'Información',
                msg: rec.data.PreparacionEspecial,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.INFO
            });
        }
    },
    MostrarEdadAgendaManual: function(f) {
        if(f.getValue() !== "" && f.getValue() !== null){
            Ext.getCmp('strEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),f.getValue().format('Y/m/d')));
        }
    },
    NuevoPacienteAgendaManual: function(){
        Ext.Msg.show({
            title: 'Nuevo Registro',
            msg: 'Esta seguro que desea hacer un nuevo registro, si hace este se perdera la información ingresada hasta ahora',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmPacientesCitaManual').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    Ext.getCmp('intIdPaciente').setValue(0);
                    Ext.getCmp('btn_AdicionarItemAgendaManual').setVisible(true);
                    Ext.getCmp('btn_ModificarItemAgendaManual').setVisible(false);
                    Ext.getCmp('strDeptoMuni').setValue(ID_MUNICIPIO);
                }
            }
        });
    },
    BuscarPacienteAgendaManual: function(){
        buscarpacienteagendamanual();
    },
    ModificarItemAgendaManual: function(){ //ok
        Ext.Msg.show({
            title: 'Guardar Pacientes',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistrosAgendaManual("MODIFICAR","NO","winAsignarCitaManualUi","frmPacientesCitaManual","../../controlador/pacientes/controlador_agendamanual.php","NA","NA","NA","NO","NO");
                }
            }
        });
    },
    GuardarItemAgendaManual: function(){ //ok
        Ext.Msg.show({
            title: 'Guardar Pacientes',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn){
                if(btn=="yes"){
                    fnInsertarRegistrosAgendaManual("INSERTAR","SI","winAsignarCitaManualUi","frmPacientesCitaManual","../../controlador/pacientes/controlador_agendamanual.php","NA");
                }
            }
        });
    },
    ViewAgendaCitasManual: function(btn, item){
        var tipoCitas = "A";
        switch(item.text){
            case "Citas Asignadas":
                tipoCitas = "A";
                break;
            case "Citas Canceladas":
                tipoCitas = "C";
                break;
            case "Citas Inasistentes":
                tipoCitas = "I";
                break;
            defalult:
                break;
        }
        Ext.getCmp('gridFormularioCitasManual').store.load({
            params: {
                pPrestador: ID_EMPRESA,
                pIPS: ID_IPS,
                pProfesional: Ext.getCmp('sysProfeAgendaCitasManual').getValue(),
                pFecha: Ext.getCmp('sysFechaAgendaCitasManual').getValue().format("Y-m-d"),
                pEstado: tipoCitas
            }
        });
    },
    CargaDetalleAgendaCitasManual: function(f, d) {
        Ext.getCmp('gridFormularioCitasManual').store.load({
            params: {
                pPrestador: ID_EMPRESA,
                pIPS: ID_IPS,
                pProfesional: Ext.getCmp('sysProfeAgendaCitasManual').getValue(),
                pFecha: d.format("Y-m-d"),
                pEstado: 'A'
            }
        });  
    },
    CargaNuloDetalleAgendaCitasManual: function(cmb, rec, idx) {
        Ext.getCmp('sysFechaAgendaCitasManual').setValue(null);
        Ext.getCmp('gridFormularioCitasManual').store.load({
            params: {
                pPrestador: ID_EMPRESA,
                pIPS: ID_IPS,
                pProfesional: cmb.getValue(),
                pFecha: null,
                pEstado: 'x'
            }
        }); 
    },
    ActualizarAgenda: function(){
        Ext.getCmp('gridFormularioCitasManual').store.reload();
    },
    InasistenciaCita: function(){
        if(Ext.getCmp('gridFormularioCitasManual').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormularioCitasManual').selModel.getSelections();
            if (selections[0].json.EstadoReg == 'A'){
                xCAS = selections[0].json.CAS;
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'ATENCIÓN: Recuerde Actualizar la Agenda para estar seguro que desea marcar inasistente la cita Nro. ' + xCAS + ' ?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            var winInasistenciaCitas = new winInasistenciaCitaUi();
                            Ext.getCmp('sysIdAgendaManualInasistencia').setValue(selections[0].json.IdAgendaManual);
                            Ext.getCmp('sysUsuarioAgendaManualInasistencia').setValue(ID_USUARIO);
                            Ext.getCmp('sysProfesionalAgendaManualInasistencia').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgendaCitasManual').getRawValue()));
                            Ext.getCmp('sysFechaAgendaManualInasistencia').setValue(selections[0].json.FecCita);
                            Ext.getCmp('sysHoraAgendaManualInasistencia').setValue(selections[0].json.HoraCita);
                            Ext.getCmp('sysCASAgendaManualInasistencia').setValue(selections[0].json.CAS);
                            winInasistenciaCitas.show();
                        }
                    }
                });
            }
        }
    },
    CancelarCita: function(){
        if(Ext.getCmp('gridFormularioCitasManual').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormularioCitasManual').selModel.getSelections();
            if (selections[0].json.EstadoReg == 'A'){
                xCAS = selections[0].json.CAS;
                Ext.Ajax.request({
                    url: '../../controlador/profesionales/controlador_profesionales.php',
                    params:{
                        task: 'VERIFICAR_ESTADO_ATENCION',
                        pCAS: xCAS
                    },
                    success: function(response,options){
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        if(Contenido[0] === "{success:false}"){
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al validar el estado de la atencion.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        } else {
                            if(parseInt(Contenido[0], 10) === 1){
                                Ext.MessageBox.show({
                                    title: 'eOfiClinic',
                                    msg: 'La cita ya fue atendida y no se puede cancelar.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }else{
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cancelar la cita Nro. ' + xCAS + ' ?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn){
                                        if(btn=="yes"){
                                            var winCancelaCitas = new winCancelarCitaUi();
                                            Ext.getCmp('sysIdAgendaManual').setValue(selections[0].json.IdAgendaManual);
                                            Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                                            Ext.getCmp('sysProfesionalAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgendaCitasManual').getRawValue()));
                                            Ext.getCmp('sysFecha').setValue(selections[0].json.FecCita);
                                            Ext.getCmp('sysHora').setValue(selections[0].json.HoraCita);
                                            Ext.getCmp('sysCASAgendaManualCancela').setValue(selections[0].json.CAS);
                                            winCancelaCitas.show();
                                        }
                                    }
                                });
                            }
                        }
                    },
                    failure: function(response,options){
                        Ext.MessageBox.show({
                            title: 'Error Conexión',
                            msg: 'No podemos realizar la validacion del estado de la cita y/o No se pudo establecer conexión con el servidor',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    },
                    scope:this 
                });
            }
        }
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});

function fnInsertarRegistrosAgendaManual(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                var Respuesta = req.result.requestedId;
                var Contenido = Respuesta.split('^');
                if(Contenido[0]=="0" || Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                    Ext.getCmp('intIdPaciente').setValue(0);
                    Ext.getCmp('sysPacienteValido').setValue(0);
                    Ext.Msg.hide();
                    Ext.MessageBox.show({
                        title: 'Guardando Paciente',
                        msg: 'Ocurrio un error al guardar la información del paciente o no se pudo establecer conexión con el servidor.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                } else {
                    Ext.getCmp('intIdPaciente').setValue(Contenido[0]);
                    Ext.getCmp('sysPacienteValido').setValue(1);
                    Ext.getCmp('btn_AdicionarItemAgendaManual').setVisible(false);
                    Ext.getCmp('btn_ModificarItemAgendaManual').setVisible(true);
                    Ext.MessageBox.hide();
                    Ext.MessageBox.show({
                        title: 'Guardar',
                        msg: 'Se Guardo la Información con Exito.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

                                                
function fnGuardarRegistrosAgendaManual(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}