/*
* @category    Formulario Ver Evoluciones Observaciones - Hospitalizaciones HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winViewEvolucionObservaHospitalizaHCUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Ver Historial Observacion - Hospitalizacion ::.',
    width: 970,
    height: 605,
    border: false,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winViewEvolucionObservaHospitalizaHC',
    initComponent: function() {
        el = Ext.get('idaplicacion');
        NOMAPLICACION = el.getValue();
        var dataTipoServicio = [
            ['U','OBSERVACION'],
            ['H','HOSPITALIZACION']
        ];
        var stTipoServicio = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTipoServicio.loadData(dataTipoServicio);
        
        var dataTipoNota = [
            ['NOTA MEDICA'],
            ['NOTA ENFERMERIA']
        ];
        var stTipoNota = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoNota.loadData(dataTipoNota);
        
        function VerInfoServicio(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<h3><b>' + value + '</b></h3>' + '<h3>Hora: ' + record.get('HoraApertura') + '</h3></br><h4>' + record.get('Actividad') + '</br><span style="color: darkblue;">Profesional: ' + record.get('NomProfe') + '</span></h4>';  
        }
        
        var viewResumenObservaHospitalizaHC = new Ext.Panel({
            id:'viewResumenObservaHospitalizaHC',
            width: 620,
            height: 465,
            padding: 5,
            autoScroll:true,
            closable:false
        });
        this.tbar = [
            {
                html: 'Servicio:'
            },
            {
                xtype: 'combo',
                anchor: '100%',
                allowBlank: true,
                store: stTipoServicio,
                forceSelection: true,
                triggerAction: 'all',
                mode: 'local',
                typeAhead: true,
                typeAheadDelay: 50,
                emptyText: 'Seleccione ....',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                id: 'sysTipoServicioViewObservaHospitaliza'
            },
            {
                html: ' - Nota:'
            },
            {
                xtype: 'combo',
                anchor: '100%',
                allowBlank: true,
                store: stTipoNota,
                forceSelection: true,
                triggerAction: 'all',
                mode: 'local',
                typeAhead: true,
                typeAheadDelay: 50,
                emptyText: 'Seleccione ....',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                id: 'sysTipoNotaViewObservaHospitaliza'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                iconCls: 'btnActualizarGrid',
                listeners: {
                    click : function() {
                        Ext.getCmp('gridHistorialEvolucionesObservaHospitaliza').store.load({
                            params: {
                                pEmpresa: Ext.getCmp('sysEmpresaViewObservaHospitaliza').getValue(),
                                pPaciente: Ext.getCmp('sysPacienteViewObservaHospitaliza').getValue(),
                                pServicio: Ext.getCmp('sysTipoServicioViewObservaHospitaliza').getValue(),
                                pNota: Ext.getCmp('sysTipoNotaViewObservaHospitaliza').getValue()
                            },
                            callback: function(){
                                Ext.getCmp('viewResumenObservaHospitalizaHC').load({
                                    url: '../../controlador/asistencial/viewnotasobserbahospitaliza.php?pEmpresa=' + ID_EMPRESA + '&pIPS=' + ID_IPS + '&pPaciente=0&pEvolucion=0',
                                    scripts:true,
                                    scope:this,
                                    nocache: false,
                                    text: 'Cargando...'
                                });
                            }
                        });
                    }
                }
            }
        ];
        this.bbar = [
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Imprimir Evolución',
                iconCls: 'btnImprimir',
                listeners: {
                    click : function() {
                        if(Ext.getCmp('gridHistorialEvolucionesObservaHospitaliza').selModel.getCount() === 1){
                            var selections = Ext.getCmp('gridHistorialEvolucionesObservaHospitaliza').selModel.getSelections();
                            window.open ("../../controlador/asistencial/imprimirobservahospitaliza.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
                        }else{
                            Ext.MessageBox.show({
                                title: NOMAPLICACION,
                                msg: 'Debe Seleccionar una Evolución.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Imprimir Toda la Historia',
                iconCls: 'btnImprimir',
                listeners: {
                    click : function() {
                        //window.open ("../../controlador/asistencial/imprimirobservahospitaliza.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=0","Historia Clinica");
                        window.open ("../../controlador/asistencial/imprimirobservahospitaliza.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysPacienteViewObservaHospitaliza').getValue() + "&pEvolucion=0","Historia Clinica");
                    }
                }
            },
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'button',
                text: 'Salir',
                iconCls: 'btnSalir',
                listeners: {
                    click : function() {
                        Ext.getCmp('winViewEvolucionObservaHospitalizaHC').close();
                    }
                }
            }
        ];
        
        this.items = [
            {
                xtype: 'panel',
                title: 'Historial de Evoluciones',
                layout: 'hbox',
                //width: 900,
                anchor: '100%',
                height: 580,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysEmpresaViewObservaHospitaliza'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPacienteViewObservaHospitaliza'
                    },
                    {
                        xtype: 'grid',
                        store: 'StoreGridEvolucionesObservaHospitalizaHC',
                        title: 'Atenciones',
                        width: 320,
                        height: 485,
                        flex: 1,
                        id: 'gridHistorialEvolucionesObservaHospitaliza',
                        columns: [
                            {
                                xtype: 'gridcolumn',
                                header: 'Fecha',
                                sortable: true,
                                width: 120,
                                dataIndex: 'FechaAtencion',
                                renderer: VerInfoServicio,
                                hideable: false
                            }
                        ],
                        viewConfig: {
                            forceFit:true
                        },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true})
                    },
                    viewResumenObservaHospitalizaHC
                ]
            }
        ];
        winViewEvolucionObservaHospitalizaHCUi.superclass.initComponent.call(this);
    }
});
