/*
* @category    Formulario Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winPacientesUi = Ext.extend(Ext.Window, {
    title: 'OfiMedical .:: Pacientes ::.',
    width: 1014,
    height: 600,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winPacientesUi',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        
        wPaciente = 0;
        wCAS = 0;
        
        var picBox = {
            columnWidth: .5,
            bodyStyle: 'padding:0px 0px 0px 40px',
            items: [
                { 
                    xtype: 'box',
                    autoEl: { tag: 'div', style: 'padding-bottom:20px',
                        html: '<img id="pic" src="' + Ext.BLANK_IMAGE_URL + '"/>'
                    }
                }
            ]
        }

        var aPanelPublicidad = new Ext.Panel({
            autoLoad:{url:'../publicidad/frminferior/frmpublicidadinf.php',scripts:true,scope:this},
            id: 'Publicidad',
            title: '',
            border: false,
            autoScroll: false,
            closable: true,
            width: 915,
            height: 155
        });
        
        function DescripcionConducta(val, x, store){
            if(val != null && val != ""){
                var estructurahc = val.split("¬");
                var mostrarHC = "";
                var txtContenido = "";

                for (var i = 0; i < (estructurahc.length-1); i++){
                    var contenidohc = estructurahc[i].split("^~");
                    switch(contenidohc[1]){
                        case "TRUE":
                            txtContenido = "SI";
                            break;

                        case "FALSE":
                            txtContenido = "NO";
                            break;

                        default:
                            txtContenido = contenidohc[1];
                            break;
                    }
                    if(contenidohc[2].substr(0,8) == "CONDUCTA"){
                        mostrarHC = '<table><tr><td style="padding: 1px;">';
                        mostrarHC += txtContenido;
                        mostrarHC += '</td></tr></table>';
                    }
                }
                return mostrarHC;
            }else{
                return "";
            }
        }
        
        function DescripcionMotivoConsulta(val, x, store){
            if(val != null && val != ""){
                var estructurahc = val.split("¬");
                var mostrarHC = "";
                var txtContenido = "";

                for (var i = 0; i < (estructurahc.length-1); i++){
                    var contenidohc = estructurahc[i].split("^~");
                    switch(contenidohc[1]){
                        case "TRUE":
                            txtContenido = "SI";
                            break;

                        case "FALSE":
                            txtContenido = "NO";
                            break;

                        default:
                            txtContenido = contenidohc[1];
                            break;
                    }
                    if(contenidohc[2].substr(0,18) == "MOTIVO DE CONSULTA"){
                        mostrarHC = '<table><tr><td style="padding: 1px;">';
                        mostrarHC += txtContenido;
                        mostrarHC += '</td></tr></table>';
                    }else{
                        if(contenidohc[2].substr(0,7) == "CONTROL"){
                            mostrarHC = '<table><tr><td style="padding: 1px;">';
                            mostrarHC += txtContenido;
                            mostrarHC += '</td></tr></table>';
                        }
                    }
                }
                return mostrarHC;
            }else{
                return "";
            }
        }

        this.items = [
            {
                xtype: 'tabpanel',
                id: 'tbOpcionesPacientes',
                activeTab: 0,
                anchor: '100%',
                height: 570,
                //autoHeight: true,
                border: false,
                items: [
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Datos del Paciente',
                        items:[
                            {
                                xtype: 'form',
                                frame: true,
                                height: 542,
                                //autoHeight: true,
                                anchor: '100%',
                                autoScroll: true,
                                id: 'frmPacientes',
                                fileUpload: true,
                                padding: 10,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        border: false,
                                        labelWidth: 130,
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                id: 'intIdPaciente',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysPacienteValido',
                                                value: 0
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Datos del Paciente',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                width: 915,
                                                height: 380,
                                                id: 'fsPaciente',
                                                layoutConfig: {
                                                    columns: 4
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 221,
                                                        border: false,
                                                        id: 'pnTdoc',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo Doc ID',
                                                                anchor: '100%',
                                                                name: 'cbTdoc',
                                                                allowBlank: false,
                                                                //store: 'StoreTdocPac',
                                                                store: 'StoreTdocPac',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Tipo Documento....',
                                                                mode: 'local',
                                                                triggerAction: 'all',
                                                                forceSelection: true,
                                                                id: 'strTdoc'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 269,
                                                        border: false,
                                                        id: 'pnDocID',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Documento ID',
                                                                        name: 'txtDocID',
                                                                        allowBlank: false,
                                                                        width: 200,
                                                                        id: 'strDocID'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnBuscar',
                                                                        tooltip: 'Buscar Paciente',
                                                                        id: 'btnBuscarPacienteFrm'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 172,
                                                        border: false,
                                                        colspan: 2,
                                                        id: 'pnGenero',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Genero',
                                                                anchor: '100%',
                                                                name: 'cbGenero',
                                                                allowBlank: false,
                                                                store: 'StoreGenero',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                emptyText: 'Seleccione Genero....',
                                                                forceSelection: true,
                                                                id: 'strGenero'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe1',
                                                                style: 'text-transform:uppercase;',
                                                                allowBlank: false,
                                                                id: 'strApe1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strApe2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 215,
                                                        border: false,
                                                        id: 'pnNom1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Nombre',
                                                                anchor: '96%',
                                                                name: 'txtNom1',
                                                                allowBlank: false,
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        border: false,
                                                        width: 145,
                                                        id: 'pnNom2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Nombre',
                                                                anchor: '78%',
                                                                name: 'txtNom2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 146,
                                                        border: false,
                                                        id: 'pnFecNac',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Fecha Nacimiento',
                                                                anchor: '100%',
                                                                name: 'txtFecNac',
                                                                allowBlank: false,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFecNac'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnEdad',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Edad Actual',
                                                                anchor: '100%',
                                                                name: 'txtEdad',
                                                                readOnly: true,
                                                                allowBlank: false,
                                                                style: 'color: blue;text-align:center',
                                                                id: 'strEdad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 366,
                                                        border: false,
                                                        colspan: 2,
                                                        id: 'pnDeptoMuni',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Municipio - Departamento',
                                                                anchor: '93%',
                                                                name: 'cbDeptoMuni',
                                                                allowBlank: false,
                                                                store: 'StoreDeptoMuni',
                                                                valueField: 'IdDeptoMunicipio',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Municipio - Departamento....',
                                                                mode: 'local',
                                                                listWidth: 450,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                id: 'strDeptoMuni'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        height: 54,
                                                        id: 'pnDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                                anchor: '100%',
                                                                id: 'composDatDirTel',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtDireccion',
                                                                        allowBlank: false,
                                                                        emptyText: 'Dirección....',
                                                                        style: 'text-transform:uppercase;',
                                                                        width: 280,
                                                                        id: 'strDireccion'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel1',
                                                                        allowBlank: false,
                                                                        emptyText: 'Teléfono',
                                                                        width: 160,
                                                                        id: 'strTel1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel2',
                                                                        emptyText: 'Teléfono (Otro - Cel.)',
                                                                        width: 160,
                                                                        id: 'strTel2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        fieldLabel: 'Zona',
                                                                        store: 'StoreZonaResidencia',
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        name: 'cbZona',
                                                                        emptyText: 'Zona....',
                                                                        allowBlank: false,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 80,
                                                                        value: 'Urbana',
                                                                        triggerAction: 'all',
                                                                        id: 'strZona'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtEmail',
                                                                        vtype: 'email',
                                                                        emptyText: 'Email....',
                                                                        width: 180,
                                                                        id: 'strEmail'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        autoHeight: true,
                                                        id: 'pnPacEmpresa',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Empresa Donde Trabaja',
                                                                anchor: '100%',
                                                                id: 'composDatEmpresa',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtEmpresaTrabaja',
                                                                        width: 880,
                                                                        id: 'strEmpresaTrabaja'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        height: 54,
                                                        id: 'pnPacOtro',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Estado Civil - Escolaridad - Profesión',
                                                                anchor: '100%',
                                                                id: 'composDatOtro',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        store: 'StoreEstadoCivil',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        emptyText: 'Estado Civil',
                                                                        allowBlank: true,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 120,
                                                                        triggerAction: 'all',
                                                                        id: 'strEstadoCivilPac'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        store: 'StoreEscolaridad',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        emptyText: 'Escolaridad',
                                                                        allowBlank: true,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 180,
                                                                        triggerAction: 'all',
                                                                        id: 'strEscolaridadPac'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        store: 'StoreProfesion',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        emptyText: 'Profesión',
                                                                        allowBlank: true,
                                                                        forceSelection: false,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 570,
                                                                        triggerAction: 'all',
                                                                        id: 'strProfesionPac'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Firma del Paciente',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                width: 915,
                                                autoHeight: true,
                                                id: 'fsFirmaPaciente',
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnCargarFile',
                                                        tooltip: 'Adjuntar Firma',
                                                        id: 'btnAdjuntarFirmaPacienteFrm',
                                                        listeners:{
                                                            click : function(){
                                                                if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
                                                                    var fileAdjuntarFirma = new CargarFirmaPacienteUi();
                                                                    Ext.getCmp('sysPacienteFirma').setValue(Ext.getCmp('intIdPaciente').getValue());
                                                                    fileAdjuntarFirma.show();
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'El Paciente no es valido o no ha sido creado',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    picBox
                                                ]
                                            }
                                            //aPanelPublicidad
                                        ]
                                    }
                                ],
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'button',
                                            text: 'Nuevo',
                                            iconCls: 'btnNuevo',
                                            id: 'btnNuevoFrm'
                                        },
                                        '-',
                                        {
                                            xtype: 'button',
                                            text: 'Imagenes Asociadas',
                                            iconCls: 'btnCargarFoto',
                                            id: 'btnImgxPacFrm1'
                                        },
                                        '-',
                                        {
                                            xtype: 'button',
                                            text: 'Documentos Asociados',
                                            iconCls: 'btnCargarFile',
                                            id: 'btnDocxPacFrm1'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_AdicionarItemFrm'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_ModificarItemFrm'
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Evoluciones',
                        id: 'pntabEvolucion',
                        items:[
                            {
                                xtype: 'hidden',
                                id: 'sysCASRefHC'
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysPacienteRefHC'
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: false,
                                style: 'background:transparent; color: darkblue; font-size:14px; text-align: center; text-transform:uppercase;',
                                width: 972,
                                height: 30,
                                border: false,
                                id: 'sysInfoPaciente'
                            },
                            {
                                xtype: 'grid',
                                id: 'gridFormulario',
                                store: 'StoreGridEvolucionesxPacienteOfimedical',
                                title: '',
                                anchor: "100%",
                                border: false,
                                frame: true,
                                height: 470,
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'IdCliente',
                                        sortable: false,
                                        width: 1,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'IdCliente'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'CAS',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'CAS'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'FechaAtencion'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Cliente',
                                        sortable: false,
                                        width: 200,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Cliente'
                                    },
                                    {
                                        header: 'Motivo de Consulta / Evolución',
                                        dataIndex: 'Evolucion',
                                        renderer: DescripcionMotivoConsulta,
                                        sortable: true,
                                        width: 300,
                                        height: 150
                                    },
                                    {
                                        header: 'Conducta',
                                        dataIndex: 'Evolucion',
                                        renderer: DescripcionConducta,
                                        sortable: true,
                                        width: 290,
                                        height: 150
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'DiagPpal',
                                        sortable: false,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Diagppal'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'DiagRel1',
                                        sortable: false,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Diagprel1'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'DiagRel2',
                                        sortable: false,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Diagprel2'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'DiagRel3',
                                        sortable: false,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Diagprel3'
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                tbar:
                                    {
                                        xtype: 'toolbar',
                                        items: [
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Adicionar Evolución',
                                                iconCls: 'btnAddRow',
                                                id: 'btnAddEvolucionHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Toda la Historia',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintAllHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Evolución',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintEvolucionHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            '->',
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Incapacidad',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintIncapacidadHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Medicamentos',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintMxHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Orden Examenes',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintExamenesHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Remisiones',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintRemiHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            }
                                        ]
                                    }
                            },
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winPacientesUi.superclass.initComponent.call(this);
    }
});
