/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerAgenda = Ext.extend(winFrmVerAgendaUi, {
    initComponent: function() {
        winFrmVerAgenda.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        wURL = "";
        wNomImagen = "";
        winImgxPac = "";
        winDocxPac = "";
        paramOpcion = "Nuevo";
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        Ext.getCmp('sysProfeAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pUsuario: ID_USUARIO
            }
        }); 
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        searchStoreExaCVM = new Ext.data.Store({
            //id: 'dsSolExaIPS002',
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_oficlinic_solexa.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, 
            [
                {name: 'Codigo'},
                {name: 'Descripcion'},
                {name: 'TipoEstudio'},
                {name: 'Tarifa'},
                {name: 'TipoAutoriza'},
                {name: 'EsCX'}
            ])
        });
        
        var sysProfesionalAgenda = Ext.getCmp('sysProfeAgenda').on("select",this.CargaUbicacionAgenda,this);
        var sysUbicacionAgenda = Ext.getCmp('sysUbicacionAgenda').on("select",this.CargaFechasAgenda,this);
        var sysFechaAgenda = Ext.getCmp('sysFechaAgenda').on("select",this.CargaDetalleAgenda,this);
        
        var btnLegalizarCita = Ext.getCmp('btnLegalizarCita').on("click",this.LegalizarCita,this);
        var btnCancelarCita = Ext.getCmp('btnCancelarCita').on("click",this.CancelarCita,this);
        var btnInasistenciaCita = Ext.getCmp('btnInasistenciaCita').on("click",this.InasistenciaCita,this);
        var btnActualizarAgenda = Ext.getCmp('btnActualizarAgenda').on("click",this.ActualizarAgenda,this);
        var btnEvolucionar = Ext.getCmp('btnEvolucionar').on("click",this.EvolucionarPaciente,this);
        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
    },
    LegalizarCita: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.YaLegalizado == '0' && (selections[0].json.MarcaExenta == '1' || selections[0].json.MarcaExenta == 't')){
                xCAS = selections[0].json.CAS;
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea legalizar la cita exenta de pago?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            Ext.Ajax.request(
                            {
                                url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                params:{
                                    PROCESO: 'LegalizarExentaCita',
                                    pCAS: xCAS,
                                    pEmpresa: ID_EMPRESA,
                                    pIPS: ID_IPS,
                                    pUsuario: ID_USUARIO
                                },
                                success: function(response,options)
                                {
                                    var Respuesta = response.responseText;
                                    var Contenido = Respuesta.split('^');
                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                        Ext.MessageBox.show({
                                            title: 'eOfiClinic',
                                            msg: 'Ocurrio un error al legalizar la orden de servicios.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    } else {
                                        Ext.getCmp('gridFormulario').store.reload();
                                    }
                                },
                                failure: function(response,options){
                                    Ext.MessageBox.show({
                                        title: 'eOfiClinic',
                                        msg: 'Ocurrio un error al legalizar la orden de servicios o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                },
                                scope:this
                            });
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'La Cita Ya Esta Legalizada o No Se Marco como Exenta',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    EvolucionarPaciente: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            var wActividad = selections[0].json.Actividad;
            //if (parseInt(selections[0].json.YaLegalizado) === 1 || wActividad.indexOf("ODONTOLO") > 0){
            if (selections[0].json.YaLegalizado == '1'){
                var winSeleccionPlantillaOpenHC = new winSeleccionPlantillaOpenHCUi();
                Ext.getCmp('sysEmpresaPlantillaHC').setValue(ID_EMPRESA);
                Ext.getCmp('sysSedePlantillaHC').setValue(ID_SEDE);
                Ext.getCmp('sysIPSPlantillaHC').setValue(ID_IPS);
                Ext.getCmp('sysUsuarioPlantillaHC').setValue(ID_USUARIO);
                Ext.getCmp('sysProfesionalPlantillaHC').setValue(Ext.getCmp('sysProfeAgenda').getValue());
                Ext.getCmp('sysPacientePlantillaHC').setValue(selections[0].json.Paciente);
                Ext.getCmp('sysUbicacionPlantillaHC').setValue(Ext.getCmp('sysUbicacionAgenda').getValue());
                Ext.getCmp('sysCASPlantillaHC').setValue(selections[0].json.CAS);
                Ext.getCmp('sysConsecutivoDetalle_HC').setValue(selections[0].json.ConsecutivoDetalle);
                Ext.getCmp('sysNomProfesionalPlantillaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgenda').getRawValue()));
                Ext.getCmp('sysConsultorioPlantillaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysUbicacionAgenda').getRawValue()));
                Ext.getCmp('sysFechaPlantillaHC').setValue(selections[0].json.FechaCita);
                Ext.getCmp('sysHoraPlantillaHC').setValue(selections[0].json.HoraAgenda);
                Ext.getCmp('sysHoraEstimadaPlantillaHC').setValue(selections[0].json.HoraAtencion);
                Ext.getCmp('sysFechaLegalizaPlantillaHC').setValue(selections[0].json.FechaLegaliza);
                Ext.getCmp('sysClientePlantillaHC').setValue(selections[0].json.Cliente);
                Ext.getCmp('sysActividadPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                Ext.getCmp('sysNomPacientePlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + '-' + selections[0].json.Documento + ' ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido));
                Ext.getCmp('sysGeneroPaciente_HC').setValue(selections[0].json.Genero);
                Ext.getCmp('sysEdadPaciente_HC').setValue(selections[0].json.Edad);
                Ext.getCmp('sysFecNacPaciente_HC').setValue(selections[0].json.FecNac);
                Ext.getCmp('sysIdCliente_HC').setValue(selections[0].json.idCliente);
                Ext.getCmp('sysIdPlan_HC').setValue(selections[0].json.idPlan);
                Ext.getCmp('sysIdSubPlan_HC').setValue(selections[0].json.idSubPlan);
                Ext.getCmp('sysIdContrato_HC').setValue(selections[0].json.idContrato);
                                            
                winSeleccionPlantillaOpenHC.show();
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El Paciente: " ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + '", No ha legalizado la cita.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    ActualizarAgenda: function(){
        Ext.getCmp('gridFormulario').store.reload();
    },
    InasistenciaCita: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            //if (selections[0].json.YaLegalizado == '0'){
                xCAS = selections[0].json.CAS;
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'ATENCIÓN: Recuerde Actualizar la Agenda para estar seguro que desea marcar inasistente la cita Nro. ' + xCAS + ' ?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            ScriptMgr.loadJs({
                                scripts : '../../frm_js/barraservicios/wininasistenciacita.ui.js',
                                callback : function(){
                                    var winInasistenciaCitas = new winInasistenciaCitaUi();
                                    Ext.getCmp('sysPantalla').setValue("AgendaCitas");
                                    Ext.getCmp('sysEmpresa').setValue(ID_EMPRESA);
                                    Ext.getCmp('sysIPS').setValue(ID_IPS);
                                    Ext.getCmp('sysCAS').setValue(xCAS);
                                    Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                                    Ext.getCmp('sysProfesionalAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgenda').getRawValue()));
                                    Ext.getCmp('sysConsultorioAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysUbicacionAgenda').getRawValue()));
                                    Ext.getCmp('sysFecha').setValue(selections[0].json.FechaCita);
                                    Ext.getCmp('sysHora').setValue(selections[0].json.HoraAgenda);
                                    winInasistenciaCitas.show();
                                }
                            });
                        }
                    }
                });
            //}
        }
    },
    CancelarCita: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            //if (selections[0].json.YaLegalizado == '0'){
                xCAS = selections[0].json.CAS;
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'ATENCIÓN: Recuerde Actualizar la Agenda para estar seguro que desea cancelar la cita Nro. ' + xCAS + ' ?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            ScriptMgr.loadJs({
                                scripts : '../../frm_js/barraservicios/wincancelacita.ui.js',
                                callback : function(){
                                    var winCancelaCitas = new winCancelarCitaUi();
                                    Ext.getCmp('sysPantalla').setValue("AgendaCitas");
                                    Ext.getCmp('sysEmpresa').setValue(ID_EMPRESA);
                                    Ext.getCmp('sysIPS').setValue(ID_IPS);
                                    Ext.getCmp('sysCAS').setValue(xCAS);
                                    Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                                    Ext.getCmp('sysProfesionalAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgenda').getRawValue()));
                                    Ext.getCmp('sysConsultorioAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysUbicacionAgenda').getRawValue()));
                                    Ext.getCmp('sysFecha').setValue(selections[0].json.FechaCita);
                                    Ext.getCmp('sysHora').setValue(selections[0].json.HoraAgenda);
                                    winCancelaCitas.show();
                                }
                            });
                        }
                    }
                });
            //}
        }
    },
    CargaDetalleAgenda: function(cmb, rec, idx) {
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: cmb.getValue()
            }
        }); 
    },
    CargaFechasAgenda: function(cmb, rec, idx) {
        Ext.getCmp('sysFechaAgenda').clearValue();
        Ext.getCmp('sysFechaAgenda').enable();
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: 0
            }
        }); 
        Ext.getCmp('sysFechaAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pProfesional: Ext.getCmp('sysProfeAgenda').getValue(),
                pConsultorio: cmb.getValue()
            }
        }); 
    },
    CargaUbicacionAgenda: function(cmb, rec, idx) {
        Ext.getCmp('sysUbicacionAgenda').clearValue();
        Ext.getCmp('sysUbicacionAgenda').enable();
        Ext.getCmp('sysFechaAgenda').clearValue();
        Ext.getCmp('sysFechaAgenda').disable();
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: 0
            }
        }); 
        Ext.getCmp('sysUbicacionAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pProfesional: cmb.getValue()
            }
        }); 
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});

