/*
* @category    Formulario Consultar HC Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmConsultarHCxPacienteUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Consultar HC x Paciente ::.',
    id: 'winFrmConsultarHCxPaciente',
    closable:false,
    width:980,
    height:520,
    //autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        stProfesionalesxIPS = new StoreProfesionales();
        function VerHoraLegaliza(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return '<p style="color: red; font-weight:bold; text-decoration:blink; text-align:center;">'+value + '</p>Hora Estimada Atención: </br>' + record.get('HoraAtencion');
	}
        
        function VerPaciente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br>Genero: ' + record.get('Genero') + ' FecNac: ' + record.get('FecNac') + '</br>' + record.get('Edad');  
        }
        
        function VerCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('DescAdiHora');  
        }
        
        function VerCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('Cliente') + '</br>' + record.get('Actividad') + '</br>Programa: ' + record.get('Programa');  
        }
        var stGrid = new StoreGridCitasxEvolucionarxPaciente();
        
        function VerInfoServicio(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            //return '<h3><b>' + value + '</b></h3>' + '</br><h4>' + record.get('Actividad') + '</br><span style="color: darkblue;">Profesional: ' + record.get('NomProfe') + '</span></h4>';  
            return '<table border="0"><tr><td>' + value + '</td></tr><tr><td><span style="color:blue">' + record.get('Actividad') + '</span></br></td></tr><tr><td><span style="color:red">' + record.get('NomProfe') + '</span></br></td></tr><tr><td><span style="color:#61210B">Programa: ' + record.get('Programa') + '</span></td></tr><tr><td><span style="color:#61210B">Plantilla: ' + record.get('NomPlantilla') + '</span></td></tr></table>';
        }
        
        var DetalleResumenHC = new Ext.Panel({
            //autoLoad:{
            //    url: '../../controlador/asistencial/ximprimirhc.php?pEmpresa=' + ID_EMPRESA + '&pIPS=' + ID_IPS + '&pPaciente=' + Ext.getCmp('sysIdPacienteHC').getValue() + '&pEvolucion=' + xConsecutivoHC,
            //    scripts:true,
            //    scope:this
            //},
            id:'DetalleResumenHC',
            width: 645,
            height: 341,
            autoScroll:true,
            closable:false
        });
        
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmConsultarHCxPaciente',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysPacienteSearchHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Paciente',
                                width: 790,
                                readOnly: true,
                                allowBlank: false,
                                emptyText: 'Seleccione Paciente ....',
                                id: 'fPacienteSearchHC'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteUnificaMalo'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'displayfield',
                                fieldLabel: 'Filtro',
                                value: 'Desde:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                id: 'fecDesdeSearchHC'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Hasta:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                id: 'fecHastaSearchHC'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Profesional:'
                            },
                            {
                                xtype: 'combo',
                                width: 392,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                listWidth: 670,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: stProfesionalesxIPS,
                                triggerAction: 'all',
                                mode: 'local',
                                emptyText: 'Seleccione...!',
                                allowBlank: true,
                                id: 'intProfesionalSearchHC'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnFiltro',
                                tooltip: 'Aplicar Filtro',
                                id: 'btnFiltroBuscarHC'
                            }
                        ]
                    },
                    {
                        xtype: 'tabpanel',
                        width: 935,
                        height: 385,
                        border: false,
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evoluciones por Paciente',
                                height: 345,
                                width: 951,
                                frame: true,
                                border: false,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'hbox',
                                        anchor: '100%',
                                        height: 341,
                                        items: [
                                            {
                                                xtype: 'grid',
                                                store: 'StoreGridEvolucionesHC',
                                                title: 'Atenciones',
                                                width: 280,
                                                height: 345,
                                                flex: 1,
                                                id: 'gridFormulario',
                                                columns: [
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Fecha',
                                                        sortable: true,
                                                        anchor: '100%',
                                                        dataIndex: 'FechaAtencion',
                                                        renderer: VerInfoServicio,
                                                        hideable: false
                                                    }
                                                ],
                                                bbar: [
                                                    {
                                                        xtype: 'tbfill'
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Consultar Historia',
                                                        iconCls: 'btnConsultaHC',
                                                        id: 'btnConsultaEvolucionHC'
                                                    }
                                                ],
                                                viewConfig: {
                                                    forceFit:true
                                                }
                                            },
                                            DetalleResumenHC
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Citas No Evolucionadas',
                                height: 241,
                                width: 951,
                                frame: true,
                                border: false,
                                items: [
                                    {
                                        xtype: 'grid',
                                        id: 'gridSinEvolucionar',
                                        store: stGrid,
                                        anchor: "100%",
                                        height: 335,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        stripeRows: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                header: 'CAS',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'CAS',
                                                width: 100,
                                                hideable: false
                                            },
                                            {
                                                header: 'Fecha',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'FechaCita',
                                                renderer: VerCita,
                                                width: 110,
                                                hideable: false
                                            },
                                            {
                                                header: 'Hora',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAgenda',
                                                renderer: VerCita,
                                                width: 110,
                                                hideable: false
                                            },
                                            {
                                                header: 'Hora Legalización',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'FechaLegaliza',
                                                width: 130,
                                                renderer: VerHoraLegaliza,
                                                hideable: false
                                            },
                                            {
                                                header: 'Paciente',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Paciente',
                                                width: 330,
                                                renderer: VerPaciente,
                                                hideable: false
                                            },
                                            {
                                                header: 'Cliente',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Cliente',
                                                width: 250,
                                                renderer: VerCliente,
                                                hideable: false
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                        view: new Ext.ux.grid.LockingGridView(),
                                        columnLines: true
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        winFrmConsultarHCxPacienteUi.superclass.initComponent.call(this);
    }
});
