/*
* @category    Programacion Eventos Formulario Tipo de Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmConsultarHCxPaciente = Ext.extend(winFrmConsultarHCxPacienteUi, {
    initComponent: function() {
        winFrmConsultarHCxPaciente.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnBuscarPacienteUnificaMalo = Ext.getCmp('btnBuscarPacienteUnificaMalo').on("click",this.BuscarPacienteMalo,this);
        var btnFiltroBuscarHC = Ext.getCmp('btnFiltroBuscarHC').on("click",this.AplicarFiltro,this);
        
        var sm_gridservicios = Ext.getCmp('gridHistorialEvoluciones').getSelectionModel();
        sm_gridservicios.on("rowselect",this.UpdateDetalleResumenHC,this);
        
    },
    AplicarFiltro: function(){
        var fecdsd;
        var fechst;
        
        if(Ext.getCmp('fecDesdeSearchHC').getValue()==null || Ext.getCmp('fecDesdeSearchHC').getValue()=="")
            fecdsd = null;
        else
            fecdsd = Ext.getCmp('fecDesdeSearchHC').getValue().format('Y-m-d');
        
        if(Ext.getCmp('fecHastaSearchHC').getValue()==null || Ext.getCmp('fecHastaSearchHC').getValue()=="")
            fechst = null;
        else
            fechst = Ext.getCmp('fecHastaSearchHC').getValue().format('Y-m-d');
        
        Ext.getCmp('gridHistorialEvoluciones').store.load({
            params: {
                pEmpresa: ID_EMPRESA,
                pPaciente: Ext.getCmp('sysPacienteSearchHC').getValue(),
                pProfesional: Ext.getCmp('intProfesionalSearchHC').getValue(),
                pDesde: fecdsd,
                pHasta: fechst
            }
        });
        Ext.getCmp('gridSinEvolucionar').store.load({
            params: {
                pEmpresa: ID_EMPRESA,
                pIPS: ID_IPS,
                pPaciente: Ext.getCmp('sysPacienteSearchHC').getValue(),
                pProfesional: Ext.getCmp('intProfesionalSearchHC').getValue()
            }
        });
        
    },
    BuscarPacienteMalo: function(){
        buscarpaciente("ConsultarHCxPaciente");
    },
    UpdateDetalleResumenHC: function(sm, rowIdx, r) {
        
        var mostrarHC = '<table border="0" width="760" style="font-size:14px; color:#000;">';
        mostrarHC += '<tr>';
        mostrarHC += '<td colspan="2" align="center" style="text-decoration:underline; font-weight:bolder">' + r.data.Actividad + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td colspan="2" align="center">&nbsp;&nbsp;</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td width="150">Paciente:</td>';
        mostrarHC += '<td>' + r.data.TipDoc + ' ' + r.data.Documento + ' - ' + r.data.PrimerNombre + ' ' + r.data.SegundoNombre + ' ' + r.data.PrimerApellido + ' ' + r.data.SegundoApellido + ' Genero: (' + r.data.Genero + ') FechaNac: (' + r.data.FecNac + ')</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Cliente:</td>';
        mostrarHC += '<td>' + r.data.Cliente + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Profesional Tratante:</td>';
        mostrarHC += '<td>' + r.data.NomProfe + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Fecha Atención:</td>';
        mostrarHC += '<td>' + r.data.FechaAtencion + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Hora Atención:</td>';
        mostrarHC += '<td>' + r.data.HoraApertura + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>CAS:</td>';
        mostrarHC += '<td>' + r.data.CAS + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '</table>';
        
        var estructurahc = r.data.Evolucion.split("¬"); 
        mostrarHC += "<hr>"
        for (var i = 0; i < (estructurahc.length-1); i++){ 
            var contenidohc = estructurahc[i].split("^~"); 
            switch(contenidohc[1]){
                case "TRUE":
                    $txtContenido = "SI";
                    break;
                    
                case "FALSE":
                    $txtContenido = "NO";
                    break;
                
                default:
                    $txtContenido = contenidohc[1];
                    break;
            }
            if(contenidohc[2].substr(0,3) == "bTB"){
                mostrarHC += '<p style="text-decoration:underline; font-size:14px; color:#000; font-weight:bolder">' + contenidohc[2].substr(3,contenidohc[2].lenght) + ':</p>';
                mostrarHC += '<table><tr><td style=" padding:20px;">';
            }else{
                if(contenidohc[2].substr(0,3) == "eTB"){
                    mostrarHC += '</td></tr></table>';
                }else{
                    mostrarHC += '<p style="text-decoration:underline; font-size:14px; color:#000; font-weight:bolder">' + contenidohc[2] + ':</p>';
                    mostrarHC += $txtContenido + '</br></br>';
                }
            }
        }
        mostrarHC += '</br>';
        mostrarHC += '<table border="0" width="760" style="font-size:14px; color:#000;">';
        mostrarHC += '<tr>';
        mostrarHC += '<td width="250">Finalidad:</td>';
        mostrarHC += '<td>' + r.data.Finalidad + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Causa Externa:</td>';
        mostrarHC += '<td>' + r.data.CausaExterna + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Tipo Diagnostico:</td>';
        switch(r.data.Tipodiag){
            case "1":
                mostrarHC += '<td>1 - Impresion Diagnostica</td>';
                break;
            case "2":
                mostrarHC += '<td>2 - Confirmado Nuevo</td>';
                break;
            case "3":
                mostrarHC += '<td>3 - Confirmado Repetido</td>';
                break;
            default:
                break;
        }
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Diagnostico Principal:</td>';
        mostrarHC += '<td>' + r.data.Diagppal + ' - ' + r.data.DesDiagPpal + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Diagnostico Relacionado Nro1:</td>';
        mostrarHC += '<td>'  + r.data.Diagrel1 + ' - ' + r.data.DesDiagRel1 + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Diagnostico Relacionado Nro2:</td>';
        mostrarHC += '<td>'  + r.data.DiagRel2 + ' - ' + r.data.DesDiagRel2 + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Diagnostico Relacionado Nro3:</td>';
        mostrarHC += '<td>'  + r.data.DiagRel3 + ' - ' + r.data.DesDiagRel3 + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '</table>';
        Ext.getCmp('DetalleResumenHC').setValue(mostrarHC);
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
    
});

