/*
* @category    Grid Documentos Anexos por Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
        
GridDocumentosAnexosUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        
        var stAnexosxPaciente = new StoreGridAnexosxPaciente();
        function VerInfoAnexo(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<span style="color:blue;"><b>' + record.get('GrupoImagen') + '</span></br>Fecha: </br><b>' + record.get('FechaRegistro') + '</b></br>Notas: </br>' + record.get('NotasImagen');
        }
        
        var viewAnexosPaciente = new Ext.Panel({
            id:'viewAnexosPaciente',
            width: 618,
            height: 320,
            autoScroll:true,
            closable:false,
            items: [
                { 
                    xtype: 'component',
                    html : '<iframe src="" width="100%" height="100%"></iframe>',
                    id: 'sysShowPDFAnexo'
                }
            ]
        });
        
        this.items = [
            {
                xtype: 'panel',
                layout: 'hbox',
                anchor: '100%',
                height: 320,
                items: [
                    {
                        xtype: 'grid',
                        store: stAnexosxPaciente,
                        width: 320,
                        height: 300,
                        flex: 1,
                        id: 'gridDocumentosAnexos',
                        columns: [
                            {
                                xtype: 'gridcolumn',
                                header: 'Descripcion',
                                sortable: true,
                                width: 120,
                                dataIndex: 'Paciente',
                                renderer: VerInfoAnexo,
                                hideable: false
                            }
                        ],
                        viewConfig: {
                            forceFit:true
                        },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        listeners: {
                            rowclick: function(t, rowIndex, e){
                                var selections = Ext.getCmp('gridDocumentosAnexos').selModel.getSelections();
                                if(selections[0].json.RutaAnexo !== "" && selections[0].json.RutaAnexo !== null){
                                    Ext.getCmp('sysShowPDFAnexo').update('<iframe width="98%" height="98%">&nbsp;</iframe>');
                                    Ext.getCmp('sysShowPDFAnexo').update('<iframe src="' + selections[0].json.RutaImagen + '" width="98%" height="98%"></iframe>');
                                }else{
                                    Ext.getCmp('sysShowPDFAnexo').update('<span>Documento No Encontrado...!</span>');
                                }
                            }
                        },
                        tbar:
                            {
                                xtype: 'toolbar',
                                items: [
                                    'Buscar: ',
                                    '->',
                                    new Ext.app.SearchField({
                                        id: 'qryDocumentoAnexo',
                                        store: stAnexosxPaciente,
                                        //ValparamP1: wPaciente,
                                        emptyText: 'Escriba el criterio que desea buscar',
                                        width: 120,
                                        pLoadGrid: false,
                                        pGrid: 'gridDocumentosAnexos'//,
                                        //parrParam: {params:{pPaciente: wPaciente}}
                                    })
                                ]
                            }
                    },
                    viewAnexosPaciente
                ]
            }
        ];
        GridDocumentosAnexosUi.superclass.initComponent.call(this);
    }
});