/*
* @category    Formulario Adicionar Solicitud Consentimeinto Informado
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddVacuna001Ui = Ext.extend(Ext.Window, {
    title: '.:: Vacunacion ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddVacunacion001',
    initComponent: function() {
        
        var searchStoreREPSS = new Ext.data.Store({
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_oficlinic_repss.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ])
        });
        
        var dataDosis = [
            ['UNICA'],
            ['1 DOSIS'],
            ['2 DOSIS'],
            ['3 DOSIS'],
            ['4 DOSIS'],
            ['REFUERZO 1'],
            ['REFUERZO 2'],
            ['ADICIONAL 1'],
            ['ADICIONAL 2']
        ];
        var stDosis = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDosis.loadData(dataDosis);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddVacunacion',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intPacienteVacunacion',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioVacunacion',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASRef',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Concepto',
                                anchor: '100%',
                                allowBlank: false,
                                store: 'StoreVacunacion',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strConceptoVacunacion'
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '96%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha Aplicacion',
                                        name: 'Fecha Aplicacion',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        value: new Date().format('d/m/Y'),
                                        id: 'fecVacunaFechaAplicacion'
                                    },
                                    {
                                        html: 'Dosis'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Dosis',
                                        width: 150,
                                        allowBlank: false,
                                        store: stDosis,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strVacunaDosis'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Busqueda',
                                store: searchStoreREPSS,
                                allowBlank: false,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                typeAhead: false,
                                loadingText: 'Buscando...',
                                width: 490,
                                anchor: '100%',
                                hideTrigger: true,
                                minChars: 4,
                                emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                id: 'intIPSVacuna'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'strVacunaObservaciones'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    guardarVacunacion();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddVacuna001Ui.superclass.initComponent.call(this);
    }
});

function guardarVacunacion(){
    Ext.Msg.show({
        title: 'Guardar Vacuna....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes"){
              var frm = Ext.getCmp('frmAddVacunacion').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/asistencial/evolucionhc2014.php',
                        params: {
                            task: 'GUARDAR_VACUNA',
                            pPaciente: Ext.getCmp('intPacienteVacunacion').getValue(),
                            pVacuna: Ext.getCmp('strConceptoVacunacion').getValue(),
                            pFechaAplicacion: Ext.getCmp('fecVacunaFechaAplicacion').getValue(),
                            pDosis: Ext.getCmp('strVacunaDosis').getValue(),
                            pCASRef: Ext.getCmp('intCASRef').getValue(),
                            pInstitucion: Ext.getCmp('intIPSVacuna').getValue(),
                            pObservacion: Ext.getCmp('strVacunaObservaciones').getValue(),
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Vacuna',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridVacunacion').store.baseParams = {
                                        task: 'VACUNACION_LISTAR',
                                        pPaciente: Ext.getCmp('intPacienteVacunacion').getValue()
                                    };
                                    Ext.getCmp('gridVacunacion').store.load();
                                    Ext.getCmp('winAddVacunacion001').close();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Vacuna',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
        
}