/*
* @category    Solicitud Consentimientos Informados
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

GridVacunacionUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
               
        var stGrid = new StoreGridVacunacion();
        stGrid.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        
        this.items = [
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridVacunacion',
                store: stGrid,
                anchor: "100%",
                height: 290,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([                    
                    {
                        header: 'Fecha',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'FechaAplicacion',
                        align: 'center',
                        width: 104,
                        renderer: Ext.util.Format.dateRenderer('Y-m-d'),
                        hideable: false
                    },
                    {
                        header: 'Biologico',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Biologico',
                        align: 'left',
                        width: 250,
                        hideable: false
                    },
                    {
                        header: 'Dosis',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Dosis',
                        align: 'center',
                        width: 150,
                        hideable: false
                    },
                    {
                        header: 'Institucion',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'PrestadorVacuna',
                        align: 'center',
                        width: 200,
                        hideable: false
                    },
                    {
                        header: 'Observacion',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Observacion',
                        align: 'center',
                        width: 200,
                        hideable: false
                    }
                    
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.ux.grid.LockingGridView(),
                columnLines: true,
                bbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'button',
                            text: 'Actualizar',
                            iconCls: 'btnActualizarGrid',
                            listeners: {
                                click: function(){
                                    try {
                                        var campoIdPaciente = Ext.getCmp('intIdPaciente');
                                        if ( campoIdPaciente !== null ) {
                                            Ext.getCmp('gridVacunacion').store.load({
                                                params: {
                                                    pPaciente: Ext.getCmp('intIdPaciente').getValue()
                                                }
                                            });
                                        }
                                    }catch(ex) {
                                        Ext.getCmp('gridVacunacion').store.reload();
                                    }
                                }
                            }
                        }
                    ]
                }, 
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar',
                                iconCls: 'btnAddRow',
                                listeners: {
                                    click : function() {
                                        try {
                                            var campoIdPaciente = Ext.getCmp('intIdPaciente');
                                            if ( campoIdPaciente !== null ) {
                                                wPaciente = Ext.getCmp('intIdPaciente').getValue();
                                            }
                                        }catch(ex) {
                                            //Ext.getCmp('gridConsentimientosInformadosxPac').store.reload();
                                        }    
                                        if(parseInt(wPaciente) !== 0){
                                            var winAddVacuna001 = new winAddVacuna001Ui();
                                            Ext.getCmp('intPacienteVacunacion').setValue(wPaciente);
                                            Ext.getCmp('intUsuarioVacunacion').setValue(ID_USUARIO);
                                            Ext.getCmp('intCASRef').setValue(Ext.getCmp('sysCASHC').getValue());
                                            winAddVacuna001.show();
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar',
                                iconCls: 'btnDelRow',
                                listeners: {
                                    click : function() {
                                        wUSUARIO = 0;
                                        try {
                                            var campoIdPaciente = Ext.getCmp('sysUsuarioHC');
                                            if ( campoIdPaciente !== null ) {
                                                wUSUARIO = Ext.getCmp('sysUsuarioHC').getValue();
                                            }
                                        }catch(ex) {
                                            wUSUARIO = ID_USUARIO;
                                        }    
                                        if(Ext.getCmp('gridVacunacion').selModel.getCount() === 1){
                                            var selections = Ext.getCmp('gridVacunacion').selModel.getSelections();
                                            if(selections[0].json.CASRef === Ext.getCmp('sysCASHC').getValue()){
                                                Ext.Msg.show({
                                                    title: 'Vacunacion',
                                                    msg: 'Esta Seguro que Desea Eliminar el Registro de la Vacuna' + selections[0].json.Biologico + '?',
                                                    buttons: Ext.Msg.YESNO,
                                                    icon: Ext.Msg.QUESTION,
                                                    fn: function(btn){
                                                        if(btn ==="yes"){
                                                            fnEliminarVacuna("../../controlador/asistencial/evolucionhc2014.php",{task: "ELIMINAR_VACUNA", pConsecutivo: selections[0].json.Consecutivo}, 'gridVacunacion');
                                                        }
                                                    }
                                                });
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'Usted no fue quien realizo este registro, No podemos eliminar los registro en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            '->', 
                            new Ext.app.SearchField({
                                id: 'qryVacunasxPac',
                                store: stGrid,
                                ValparamP1: wPaciente,
                                emptyText: 'Escriba el criterio que desea buscar',
                                width: 120,
                                pLoadGrid: false,
                                pGrid: 'gridVacunacion',
                                parrParam: {params:{pPaciente: wPaciente}}
                            })
                        ]
                    }
            }
        ];
        GridConsentimientosInformadosUi.superclass.initComponent.call(this);
    }
});

function fnEliminarVacuna(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}