/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerAgenda = Ext.extend(winFrmVerAgendaUi, {
    initComponent: function() {
        winFrmVerAgenda.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idprofesionalhc');
        ID_PROFESIONAL_HC = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        objREMADD = "new winSolRemIPS001Ui();";
        objEXAADD = "new winSolExaIPS001Ui();";
        objMXADD = "new winSolMxIPS001Ui();";
        wPaciente = 0;
        wCAS = 0;
        wURL = "";
        wNomImagen = "";
        winImgxPac = "";
        winDocxPac = "";
        paramOpcion = "Nuevo";
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        /*Ext.getCmp('sysProfeAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pUsuario: ID_USUARIO
            }
        });*/ 
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        var sysProfesionalAgenda = Ext.getCmp('sysProfeAgenda').on("select",this.CargaUbicacionAgenda,this);
        var sysUbicacionAgenda = Ext.getCmp('sysUbicacionAgenda').on("select",this.CargaFechasAgenda,this);
        var sysFechaAgenda = Ext.getCmp('sysFechaAgenda').on("select",this.CargaDetalleAgenda,this);
        var btnInasistenciaCita = Ext.getCmp('btnInasistenciaCita').on("click",this.InasistenciaCita,this);
        var btnActualizarAgenda = Ext.getCmp('btnActualizarAgenda').on("click",this.ActualizarAgenda,this);
        var btnEvolucionar = Ext.getCmp('btnEvolucionar').on("click",this.EvolucionarPaciente,this);
        var btnTriage = Ext.getCmp('btnTriage').on("click",this.TriagePaciente,this);
        
        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
        Ext.getCmp('sysProfeAgenda').setValue(ID_PROFESIONAL_HC);
        Ext.getCmp('sysUbicacionAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pProfesional: 0
            }
        }); 
    },
    InasistenciaCita: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            xCAS = selections[0].json.CAS;
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'ATENCIÓN: Recuerde Actualizar la Agenda para estar seguro que desea marcar inasistente la cita Nro. ' + xCAS + ' ?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn === "yes"){
                        ScriptMgr.loadJs({
                            scripts : '../../frm_js/barraservicios/wininasistenciacita.ui.js',
                            callback : function(){
                                var winInasistenciaCitas = new winInasistenciaCitaUi();
                                Ext.getCmp('sysPantalla').setValue("AgendaCitas");
                                Ext.getCmp('sysEmpresa').setValue(ID_EMPRESA);
                                Ext.getCmp('sysIPS').setValue(ID_IPS);
                                Ext.getCmp('sysCAS').setValue(xCAS);
                                Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                                Ext.getCmp('sysProfesionalAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgenda').getRawValue()));
                                Ext.getCmp('sysConsultorioAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysUbicacionAgenda').getRawValue()));
                                Ext.getCmp('sysFecha').setValue(selections[0].json.FechaCita);
                                Ext.getCmp('sysHora').setValue(selections[0].json.HoraAgenda);
                                winInasistenciaCitas.show();
                            }
                        });
                    }
                }
            });
        }
    },
    TriagePaciente: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.YaLegalizado === '1'){
                if(selections[0].json.ClasificaTriage === "" || selections[0].json.ClasificaTriage === "B" || selections[0].json.ClasificaTriage === null){
                    var winHCTRIAGE = new winHCTRIAGEUi();
                    Ext.getCmp('sysYaGuardoHC').setValue(0);
                    Ext.getCmp('sysProfesionalHC').setValue(ID_PROFESIONAL_HC);
                    Ext.getCmp('sysActividadHC').setValue("TRIAGE");
                    Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                    Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                    Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                    Ext.getCmp('sysHoraHC').setValue(new Date().format("h:i:s"));
                    Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                    Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                    Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                    Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                    Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                    Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaCita);
                    Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.idCliente);
                    Ext.getCmp('sysIdPlanHC').setValue(selections[0].json.idPlan);
                    Ext.getCmp('sysIdSubPlanHC').setValue(selections[0].json.idSubPlan);
                    Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
                    winHCTRIAGE.show();
                }else{
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'El Triage del paciente ya fue realizado.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El Paciente: " ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + '", No ha legalizado la cita.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    EvolucionarPaciente: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.YaLegalizado === '1'){
                if(selections[0].json.ClasificaTriage !== "" && selections[0].json.ClasificaTriage !== "B" && selections[0].json.ClasificaTriage !== null){
                    wPaciente = selections[0].json.Paciente;
                    wCAS = selections[0].json.CAS;
                    var winHCUrgencias = new winHCUrgenciasUi();
                    Ext.getCmp('sysYaGuardoHC').setValue(1);
                    Ext.getCmp('sysProfesionalHC').setValue(ID_PROFESIONAL_HC);
                    Ext.getCmp('sysActividadHC').setValue("TRIAGE");
                    Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                    Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                    Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                    Ext.getCmp('sysHoraHC').setValue(new Date().format("h:i:s"));
                    Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                    Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                    Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                    Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                    Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                    Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaCita);
                    Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.idCliente);
                    Ext.getCmp('sysIdPlanHC').setValue(selections[0].json.idPlan);
                    Ext.getCmp('sysIdSubPlanHC').setValue(selections[0].json.idSubPlan);
                    Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
                    Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas("ATENCION CONSULTA PRIORITARIA - URGENCIAS"));
                    Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas("ATENCION CONSULTA PRIORITARIA - URGENCIAS"));
                    Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                    Ext.getCmp('sysProfesionalAgendaHC').setValue();
                    Ext.getCmp('sysIdCodPlantillaHC').setValue(1000);
                    if(selections[0].json.Genero === "M"){
                        Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                        Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
                    }else{
                        Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                        Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
                    }
                    Ext.getCmp('sysFechaNac').setValue(selections[0].json.FecNac);
                    Ext.getCmp('sysEdadHC').setValue(selections[0].json.Edad);
                    Ext.getCmp('sysEdadPacHC').setValue(selections[0].json.Edad);
                    winHCUrgencias.show();
                }else{
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'Se debe realizar primero el Triage.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El Paciente: " ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + '", No ha legalizado la cita.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    CargaDetalleAgenda: function(cmb, rec, idx) {
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: cmb.getValue()
            }
        }); 
    },
    ActualizarAgenda: function(){
        Ext.getCmp('gridFormulario').store.reload();
    },
    CargaFechasAgenda: function(cmb, rec, idx) {
        Ext.getCmp('sysFechaAgenda').clearValue();
        Ext.getCmp('sysFechaAgenda').enable();
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: 0
            }
        }); 
        Ext.getCmp('sysFechaAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pProfesional: Ext.getCmp('sysProfeAgenda').getValue(),
                pConsultorio: cmb.getValue()
            }
        }); 
    },
    CargaUbicacionAgenda: function(cmb, rec, idx) {
        Ext.getCmp('sysUbicacionAgenda').clearValue();
        Ext.getCmp('sysUbicacionAgenda').enable();
        Ext.getCmp('sysFechaAgenda').clearValue();
        Ext.getCmp('sysFechaAgenda').disable();
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: 0
            }
        }); 
        Ext.getCmp('sysUbicacionAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pProfesional: cmb.getValue()
            }
        }); 
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});

