/*
* @category    Fieldset ABC SOCIAL
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsMiniNutricionalUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'EVALUCION MINI NUTRICIONAL',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsMiniNutricional',
    initComponent: function() {
        
        
        var dataApetito = [
            ['Ha comido mucho menos'],
            ['Ha comido menos'],
            ['Ha comido igual']
        ];
        var stApetito = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stApetito.loadData(dataApetito);
       
        
        var dataPerdidaPeso = [
            ['Perdida de peso > 3 kg'],
            ['No lo sabe'],
            ['Perdida de peso entre 1 y 3 kg'],
            ['No ha habido perdida de peso']
        ];
        var stPerdidaPeso = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPerdidaPeso.loadData(dataPerdidaPeso);
       
        
        var dataMovilidad = [
            ['De la cama al sillon'],
            ['Autonomia en el interior'],
            ['Sale del domicilio']
        ];
        var stMovilidad = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stMovilidad.loadData(dataMovilidad);
       
        
        var dataSINO = [
            ['SI'],
            ['NO']
        ];
        var stSINO = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stSINO.loadData(dataSINO);
       
        
        var dataProblemasNeuropsicologico = [
            ['Demencia o Depresion grave'],
            ['Demencia Moderada'],
            ['Sin Problemas Psicologicos']
        ];
        var stProblemasNeuropsicologico = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProblemasNeuropsicologico.loadData(dataProblemasNeuropsicologico);
       
        
        var dataIMC = [
            ['IMC < 19'],
            ['19 < IMC > 21'],
            ['21 < IMC > 23'],
            ['IMC > 23']
        ];
        var stIMC = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stIMC.loadData(dataIMC);
       
        
        var dataComidasCompletas = [
            ['1 Comida'],
            ['2 Comidas'],
            ['3 Comidas']
        ];
        var stComidasCompletas = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stComidasCompletas.loadData(dataComidasCompletas);
       
        
        var dataLiquidos = [
            ['Menos de 3 Vasos'],
            ['de 3 a 5 Vasos'],
            ['Mas de 5 Vasos']
        ];
        var stLiquidos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stLiquidos.loadData(dataLiquidos);
       
        
        var dataFormaAlimentarse = [
            ['Necesita ayuda'],
            ['Se alimenta solo con dificultad'],
            ['Se alimenta solo sin dificultad']
        ];
        var stFormaAlimentarse = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stFormaAlimentarse.loadData(dataFormaAlimentarse);
       
        
        var dataPacienteNutrido = [
            ['Malnutricion grave'],
            ['No lo sabe o malnutricion moderado'],
            ['Sin problemas de Nutricion']
        ];
        var stPacienteNutrido = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPacienteNutrido.loadData(dataPacienteNutrido);
       
        
        var dataCircunferenciaPantorrilla = [
            ['CP < 31'],
            ['CP > 31']
        ];
        var stCircunferenciaPantorrilla = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCircunferenciaPantorrilla.loadData(dataCircunferenciaPantorrilla);
       
        
        var dataCircunferenciaBraquial = [
            ['CB < 21'],
            ['21 < CB > 22'],
            ['CB > 22']
        ];
        var stCircunferenciaBraquial = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCircunferenciaBraquial.loadData(dataCircunferenciaBraquial);
       
        
        var dataEstadoSalud = [
            ['Peor'],
            ['No lo sabe'],
            ['Igual'],
            ['Mejor']
        ];
        var stEstadoSalud = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEstadoSalud.loadData(dataEstadoSalud);
       
        
        this.items = [
            {
                html: 'Responda a la primera parte del cuestionario indicando "Cribaje". Si el puntaje es igual o inferior a 11, complete el cuestionario para obtener una apreciacion precisa del estado nutricional'
            },
            {
                xtype: 'fieldset',
                title: 'CRIBAJE',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 5,
                padding: 7,
                id: 'fsCribaje',
                items: [
                    {
                        html: 'Ha perdido el apetito? Ha comido menos por falta de apetito, problemas digestivos, dificultades de masticacion o deglucion en los ultimos tres meses?'
                    },
                    {
                        xtype: 'combo',
                        name: 'Ha perdido el apetito?',
                        width: 300,
                        allowBlank: true,
                        store: stApetito,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strApetito',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Perdida reciente de peso (<3 meses)'
                    },
                    {
                        xtype: 'combo',
                        name: 'Perdida de Peso',
                        width: 300,
                        allowBlank: true,
                        store: stPerdidaPeso,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strPerdidaPeso',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Movilidad'
                    },
                    {
                        xtype: 'combo',
                        name: 'Movilidad',
                        width: 300,
                        allowBlank: true,
                        store: stMovilidad,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strMovilidad',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Ha tenido una enfermedad aguda o situacion de estres psicologico en los ultimos 3 meses?'
                    },
                    {
                        xtype: 'combo',
                        name: 'Enfermedad Aguda o Estres Psicologico',
                        width: 300,
                        allowBlank: true,
                        store: stSINO,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strEnfermdadAguda',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Problemas Neuropsicologico?'
                    },
                    {
                        xtype: 'combo',
                        name: 'Problemas Neuropsicologico',
                        width: 300,
                        allowBlank: true,
                        store: stProblemasNeuropsicologico,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strProblemasNeuropsicologico',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Indice de Masa Corporal IMC'
                    },
                    {
                        xtype: 'combo',
                        name: 'Indice de Masa Corporal IMC',
                        width: 300,
                        allowBlank: true,
                        store: stIMC,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strIMC',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    }
                ]
            },
            {
                html: '<br><hr><br>'
            },
            {
                xtype: 'numberfield',
                name: 'Puntaje Cribaje',
                fieldLabel: 'Puntaje Cribaje',
                width: 50,
                minValue: 0,
                decimalPrecision: 1,
                allowBlank: true,
                value: 0,
                id: 'intPuntajeCribaje'
            },
            {
                xtype: 'textfield',
                name: 'Puntaje Cribaje',
                fieldLabel: 'Puntaje Cribaje',
                width: 250,
                allowBlank: true,
                id: 'strPuntajeCribaje'
            },
            {
                xtype: 'fieldset',
                title: 'EVALUACION',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 5,
                padding: 7,
                id: 'fsEvaluacion',
                items: [
                    {
                        html: 'El Paciene vive independiente en su domicilio?'
                    },
                    {
                        xtype: 'combo',
                        name: 'El Paciene vive independiente en su domicilio?',
                        width: 300,
                        allowBlank: true,
                        store: stSINO,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strPacienteIndependiente',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Toma mas de tres medicamentos al dia?'
                    },
                    {
                        xtype: 'combo',
                        name: 'Toma mas de tres medicamentos al dia?',
                        width: 300,
                        allowBlank: true,
                        store: stSINO,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strMedicamentosDia',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Ulceras o Lesiones Cutaneas?'
                    },
                    {
                        xtype: 'combo',
                        name: 'Ulceras o Lesiones Cutaneas?',
                        width: 300,
                        allowBlank: true,
                        store: stSINO,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strLesionesCutaneas',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Cuantas Comidas Completas toma al dia?'
                    },
                    {
                        xtype: 'combo',
                        name: 'Cuantas Comidas Completas toma al dia?',
                        width: 300,
                        allowBlank: true,
                        store: stComidasCompletas,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strComidasCompletas',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Consume Paciente',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 5,
                        padding: 7,
                        items: [
                            {
                                html: 'Productos Lacteos al menos una vez al dia?'
                            },
                            {
                                xtype: 'combo',
                                name: 'Consume Lacteos?',
                                width: 300,
                                allowBlank: true,
                                store: stSINO,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strConsumeLacteos',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        MiniNutricional()
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Huevos o legumbres 1 o 2 veces a la semana?'
                            },
                            {
                                xtype: 'combo',
                                name: 'Consume Huevos o Legumbres?',
                                width: 300,
                                allowBlank: true,
                                store: stSINO,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strConsumeHuevos',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        MiniNutricional()
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Carne, Pescado o aves diariamente?'
                            },
                            {
                                xtype: 'combo',
                                name: 'Consume Carne o Pescado?',
                                width: 300,
                                allowBlank: true,
                                store: stSINO,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strConsumeCarne',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        MiniNutricional()
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                        ]
                    },
                    {
                        html: 'Consume frutas o verdudas al menos 2 veces al dia?'
                    },
                    {
                        xtype: 'combo',
                        name: 'Consume frutas o verdudas al menos 2 veces al dia?',
                        width: 300,
                        allowBlank: true,
                        store: stSINO,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strConsumeFrutas',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Cuantos vasos de agua u otros liquidos toma al dia? (agua, zumo, cafe, te, leche, vino, cerveza...)'
                    },
                    {
                        xtype: 'combo',
                        name: 'Cuantos vasos de agua u otros liquidos toma al dia?',
                        width: 300,
                        allowBlank: true,
                        store: stLiquidos,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strConsumeLiquidos',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Forma de Alimentarse'
                    },
                    {
                        xtype: 'combo',
                        name: 'Forma de Alimentarse',
                        width: 300,
                        allowBlank: true,
                        store: stFormaAlimentarse,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strFormaAlimentarse',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Se considera el paciente bien nutrido?'
                    },
                    {
                        xtype: 'combo',
                        name: 'Se considera el paciente bien nutrido?',
                        width: 300,
                        allowBlank: true,
                        store: stPacienteNutrido,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strPacienteNutrido',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'En comparacion con las personas de su edad, como encuentra el paciente su estado de salud?'
                    },
                    {
                        xtype: 'combo',
                        name: 'En comparacion con las personas de su edad, como encuentra el paciente su estado de salud?',
                        width: 300,
                        allowBlank: true,
                        store: stEstadoSalud,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strEstadoSalud',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Circunferencia Braquial (CB en cm)'
                    },
                    {
                        xtype: 'combo',
                        name: 'Circunferencia Braquial',
                        width: 300,
                        allowBlank: true,
                        store: stCircunferenciaBraquial,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strCircunferenciaBraquial',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Circunferencia de la pantorrilla (CP en cm)'
                    },
                    {
                        xtype: 'combo',
                        name: 'Circunferencia de la Pantorrilla',
                        width: 300,
                        allowBlank: true,
                        store: stCircunferenciaPantorrilla,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strCircunferenciaPantorrilla',
                        listeners:{
                            change : function(f,pNew, pOld){
                                MiniNutricional()
                            }
                        }
                    },
                ]
            },
            
            {
                html: '<br><hr><br>'
            },
            {
                xtype: 'numberfield',
                name: 'Puntaje Total',
                fieldLabel: 'Puntaje Total',
                width: 50,
                minValue: 0,
                decimalPrecision: 1,
                allowBlank: true,
                value: 0,
                id: 'intAnexo9PuntajeTotal'
            },
            {
                xtype: 'textfield',
                name: 'Clasificacion',
                fieldLabel: 'Clasificacion',
                width: 250,
                allowBlank: true,
                id: 'strAnexo9PuntajeTotal'
            }
        ];
        fsMiniNutricionalUi.superclass.initComponent.call(this);
    }
});



function MiniNutricional(){

    var pApetito = 0;
    var pPerdidaPeso = 0;
    var pMovilidad = 0;
    var pEnfermdadAguda = 0;
    var pProblemasNeuropsicologico = 0;
    var pIMC = 0;
    var pPacienteIndependiente = 0;
    var pMedicamentosDia = 0;
    var pLesionesCutaneas = 0;
    var pComidasCompletas = 0;
    var pConsumeLacteos = 0;
    var pConsumeHuevos = 0;
    var pConsumeCarne = 0;
    var pConsumeFrutas = 0;
    var pConsumeLiquidos = 0;
    var pFormaAlimentarse = 0;
    var pPacienteNutrido = 0;
    var pEstadoSalud = 0;
    var pCircunferenciaBraquial = 0;
    var pCircunferenciaPantorrilla = 0;
    var pConsumoPaciente = 0;

    if(Ext.getCmp('strPerdidaPeso').getValue() == 'No lo sabe' ){
        pPerdidaPeso = 1;
    }else{
        if(Ext.getCmp('strPerdidaPeso').getValue() == 'Perdida de peso entre 1 y 3 kg' ){
            pPerdidaPeso = 2;
        }else{
             if(Ext.getCmp('strPerdidaPeso').getValue() == 'No ha habido perdida de peso'){
                pPerdidaPeso = 3;
            }else{
                pPerdidaPeso = 0;
            }
        }
    }

    if(Ext.getCmp('strApetito').getValue() == 'Ha comido menos' ){
        pApetito = 1;
    }else{
        if(Ext.getCmp('strApetito').getValue() == 'Ha comido igual' ){
            pApetito = 2;
        }else{
            pApetito = 0;
        }
    }

    if(Ext.getCmp('strMovilidad').getValue() == 'Autonomia en el interior' ){
        pMovilidad = 1;
    }else{
        if(Ext.getCmp('strMovilidad').getValue() == 'Sale del domicilio' ){
            pMovilidad = 2;
        }else{
            pMovilidad = 0;
        }
    }

    if(Ext.getCmp('strProblemasNeuropsicologico').getValue() == 'Demencia Moderada' ){
        pProblemasNeuropsicologico = 1;
    }else{
        if(Ext.getCmp('strProblemasNeuropsicologico').getValue() == 'Sin Problemas Psicologicos' ){
            pProblemasNeuropsicologico = 2;
        }else{
            pProblemasNeuropsicologico = 0;
        }
    }

    if(Ext.getCmp('strIMC').getValue() == '19 < IMC > 21' ){
        pIMC = 1;
    }else{
        if(Ext.getCmp('strIMC').getValue() == '21 < IMC > 23' ){
            pIMC = 2;
        }else{
            if(Ext.getCmp('strIMC').getValue() == 'IMC > 23' ){
                pIMC = 3;
            }else{
                pIMC = 0;
            }
        }
    }

    if(Ext.getCmp('strEstadoSalud').getValue() == 'No lo sabe' ){
        pEstadoSalud = 0.5;
    }else{
        if(Ext.getCmp('strEstadoSalud').getValue() == 'Igual' ){
            pEstadoSalud = 1;
        }else{
            if(Ext.getCmp('strEstadoSalud').getValue() ==  'Mejor' ){
                pEstadoSalud = 2;
            }else{
                pEstadoSalud = 0;
            }
        }
    }

    if(Ext.getCmp('strComidasCompletas').getValue() == '2 Comidas' ){
        pComidasCompletas = 1;
    }else{
        if(Ext.getCmp('strComidasCompletas').getValue() == '3 Comidas' ){
            pComidasCompletas = 2;
        }else{
            pComidasCompletas = 0;
        }
    }

    if(Ext.getCmp('strConsumeLiquidos').getValue() == 'de 3 a 5 Vasos' ){
        pConsumeLiquidos = 0.5;
    }else{
        if(Ext.getCmp('strConsumeLiquidos').getValue() == 'Mas de 5 Vasos' ){
            pConsumeLiquidos = 1;
        }else{
            pConsumeLiquidos = 0;
        }
    }

    if(Ext.getCmp('strFormaAlimentarse').getValue() ==  'Se alimenta solo con dificultad'){
        pFormaAlimentarse = 1;
    }else{
        if(Ext.getCmp('strFormaAlimentarse').getValue() ==  'Se alimenta solo sin dificultad'){
            pFormaAlimentarse = 2;
        }else{
            pFormaAlimentarse = 0;
        }
    }

    if(Ext.getCmp('strPacienteNutrido').getValue() ==  'No lo sabe o malnutricion moderado'){
        pPacienteNutrido = 1;
    }else{
        if(Ext.getCmp('strPacienteNutrido').getValue() ==  'Sin problemas de Nutricion'){
            pPacienteNutrido = 2;
        }else{
            pPacienteNutrido = 0;
        }
    }

    if(Ext.getCmp('strCircunferenciaBraquial').getValue() ==  '21 < CB > 22'){
        pCircunferenciaBraquial = 0.5;
    }else{
        if(Ext.getCmp('strCircunferenciaBraquial').getValue() ==  'CB > 22'){
            pCircunferenciaBraquial = 1;
        }else{
            pCircunferenciaBraquial = 0;
        }
    }

    if(Ext.getCmp('strCircunferenciaPantorrilla').getValue() == 'CP > 31' ){
        pCircunferenciaPantorrilla = 1;
    }else{
        pCircunferenciaPantorrilla = 0;
    }

    if(Ext.getCmp('strEnfermdadAguda').getValue() == 'NO' ){
        pEnfermdadAguda = 1;
    }else{
        pEnfermdadAguda = 0;
    }

    if(Ext.getCmp('strPacienteIndependiente').getValue() == 'SI' ){
        pPacienteIndependiente = 1;
    }else{
        pPacienteIndependiente = 0;
    }

    if(Ext.getCmp('strMedicamentosDia').getValue() == 'NO' ){
        pMedicamentosDia = 1;
    }else{
        pMedicamentosDia = 0;
    }

    if(Ext.getCmp('strLesionesCutaneas').getValue() == 'NO' ){
        pLesionesCutaneas = 1;
    }else{
        pLesionesCutaneas = 0;
    }

    if(Ext.getCmp('strConsumeLacteos').getValue() == 'SI' ){
        pConsumeLacteos = 1;
    }else{
        pConsumeLacteos = 0;
    }

    if(Ext.getCmp('strConsumeHuevos').getValue() == 'SI' ){
        pConsumeHuevos = 1;
    }else{
        pConsumeHuevos = 0;
    }

    if(Ext.getCmp('strConsumeCarne').getValue() == 'SI' ){
        pConsumeCarne = 1;
    }else{
        pConsumeCarne = 0;
    }

    if(Ext.getCmp('strConsumeFrutas').getValue() == 'SI' ){
        pConsumeFrutas = 1;
    }else{
        pConsumeFrutas = 0;
    }

    if(pConsumeLacteos + pConsumeHuevos + pConsumeCarne <= 1){
        pConsumoPaciente = 0;
    }else{
        if(pConsumeLacteos + pConsumeHuevos + pConsumeCarne == 3){
            pConsumoPaciente = 1;
        }else{
            if(pConsumeLacteos + pConsumeHuevos + pConsumeCarne == 2){
                pConsumoPaciente = 0.5;
            }
        }
    }


    Ext.getCmp('intPuntajeCribaje').setValue(pApetito + pPerdidaPeso + pMovilidad + pEnfermdadAguda + pProblemasNeuropsicologico + pIMC)
    
    if(Ext.getCmp('intPuntajeCribaje').getValue() >= 12){
        Ext.getCmp('strPuntajeCribaje').setValue("ESTADO NUTRICIONAL NORMAL");
    }else{
       if(Ext.getCmp('intPuntajeCribaje').getValue() <= 7){
            Ext.getCmp('strPuntajeCribaje').setValue("MALNUTRICION");
        }else{
            Ext.getCmp('strPuntajeCribaje').setValue("RIESGO DE MALNUTRICION");
        }
    }
      
    Ext.getCmp('intAnexo9PuntajeTotal').setValue(pApetito + pPerdidaPeso + pMovilidad + pEnfermdadAguda + pProblemasNeuropsicologico + pIMC + pPacienteIndependiente + pMedicamentosDia + pLesionesCutaneas + pComidasCompletas + pConsumeFrutas + pConsumeLiquidos + pFormaAlimentarse + pPacienteNutrido + pEstadoSalud + pCircunferenciaBraquial + pCircunferenciaPantorrilla + pConsumoPaciente)
    
    if(Ext.getCmp('intPuntajeCribaje').getValue() <= 11){
        Ext.getCmp('fsEvaluacion').setVisible(true);
        if(Ext.getCmp('intAnexo9PuntajeTotal').getValue() >= 24){
            Ext.getCmp('strAnexo9PuntajeTotal').setValue("ESTADO NUTRICIONAL NORMAL");
        }else{
           if(Ext.getCmp('intAnexo9PuntajeTotal').getValue() <= 17){
                Ext.getCmp('strAnexo9PuntajeTotal').setValue("MALNUTRICION");
            }else{
                Ext.getCmp('strAnexo9PuntajeTotal').setValue("RIESGO DE MALNUTRICION");
            }
        }
    }else{
        Ext.getCmp('fsEvaluacion').setVisible(false);
        if(Ext.getCmp('intAnexo9PuntajeTotal').getValue() >= 12){
            Ext.getCmp('strAnexo9PuntajeTotal').setValue("ESTADO NUTRICIONAL NORMAL");
        }else{
           if(Ext.getCmp('intAnexo9PuntajeTotal').getValue() <= 7){
                Ext.getCmp('strAnexo9PuntajeTotal').setValue("MALNUTRICION");
            }else{
                Ext.getCmp('strAnexo9PuntajeTotal').setValue("RIESGO DE MALNUTRICION");
            }
        }
    }
}
