/*
* @category    Fieldset ESCALA AUTOEFICACIA RELACIONADA CON CAIDAS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsEscalaLawtonUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ESCALA DE LAWTON Y BRODY (Actividades cotidianas - nivel instrumental)',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsEscalaLawton',
    initComponent: function() {
        this.tbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Guardar Test',
                iconCls: 'btnGuardar',
                listeners:{
                    click : function(){
                        alert("Guardar Test");
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                xtype: 'panel',
                layout: 'form',
                anchor: '100%',
                padding: 0,
                autoHeight: true,
                labelWidth: 250,
                items: [
                    {
                        xtype: 'radiogroup',
                        allowBlank: false,
                        anchor: '100%',
                        columns: 1,
                        labelStyle: 'font-weight: bold;',
                        fieldLabel: '1. Usar el telefono?',
                        name: '1. Usar el telefono?',
                        id: 'test003UsaTelefono',
                        items: [
                            {boxLabel: 'Lo Usa por iniciativa propia, busca y marca los numero, etc', name: 'strUsarTelefono', inputValue: 'Lo Usa por iniciativa propia, busca y marca los numero, etc'},
                            {boxLabel: 'Es capaz de marcar bien algunos numeros conocidos', name: 'strUsarTelefono', inputValue: 'Es capaz de marcar bien algunos numeros conocidos'},
                            {boxLabel: 'Es capaz de contestar al telefono, pero no de marcar', name: 'strUsarTelefono', inputValue: 'Es capaz de contestar al telefono, pero no de marcar'},
                            {boxLabel: 'No utiliza el telefono en Absoluto', name: 'strUsarTelefono', inputValue: 'No utiliza el telefono en Absoluto'}
                        ],
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalcularTest003();
                            }
                        }
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'radiogroup',
                        allowBlank: false,
                        anchor: '100%',
                        columns: 1,
                        labelStyle: 'font-weight: bold;',
                        fieldLabel: '2. Ir de compras?',
                        name: '2. Ir de compras?',
                        id: 'test003IrCompras',
                        items: [
                            {boxLabel: 'Realiza todas las compras necesarias independientemente', name: 'strIrCompras', inputValue: 'Realiza todas las compras necesarias independientemente'},
                            {boxLabel: 'Realiza independientemente pequeñas compras', name: 'strIrCompras', inputValue: 'Realiza independientemente pequeñas compras'},
                            {boxLabel: 'Necesita ir acompañado para realizar pequeñas compras', name: 'strIrCompras', inputValue: 'Necesita ir acompañado para realizar pequeñas compras'},
                            {boxLabel: 'Totalmente Incapaz', name: 'strIrCompras', inputValue: 'Totalmente Incapaz'}
                        ],
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalcularTest003();
                            }
                        }
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'radiogroup',
                        allowBlank: false,
                        anchor: '100%',
                        columns: 1,
                        labelStyle: 'font-weight: bold;',
                        fieldLabel: '3. Preparar comida?',
                        name: '3. Preparar comida?',
                        id: 'test003PrepararComidas',
                        items: [
                            {boxLabel: 'Organiza, prepara y sirve las comidas por si mismo adecuadamente', name: 'strPrepararComida', inputValue: 'Organiza, prepara y sirve las comidas por si mismo adecuadamente'},
                            {boxLabel: 'Prepara adecuadamente las comidas si se le dan los ingredientes', name: 'strPrepararComida', inputValue: 'Prepara adecuadamente las comidas si se le dan los ingredientes'},
                            {boxLabel: 'Prepara, caliente y sirve las comidas pero no sigue una dieta adecuada', name: 'strPrepararComida', inputValue: 'Prepara, caliente y sirve las comidas pero no sigue una dieta adecuada'},
                            {boxLabel: 'Necesita que le preparen y le sirvan las comidas', name: 'strPrepararComida', inputValue: 'Necesita que le preparen y le sirvan las comidas'}
                        ],
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalcularTest003();
                            }
                        }
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'radiogroup',
                        allowBlank: false,
                        anchor: '100%',
                        columns: 1,
                        labelStyle: 'font-weight: bold;',
                        fieldLabel: '4. Cuidado de la casa/Tareas domesticas?',
                        name: '4. Cuidado de la casa/Tareas domesticas?',
                        id: 'test003CuidadoCasa',
                        items: [
                            {boxLabel: 'Mantiene la casa solo/a o con ayuda ocacional (con trabajos pesados)', name: 'strCuidadoCasa', inputValue: 'Mantiene la casa solo/a o con ayuda ocacional (con trabajos pesados)'},
                            {boxLabel: 'Realiza tareas domesticas ligeras, como lavar los platos o hacer las camas', name: 'strCuidadoCasa', inputValue: 'Realiza tareas domesticas ligeras, como lavar los platos o hacer las camas'},
                            {boxLabel: 'Idem. anterior, pero no puede mantener un nivel de limpieza aceptable', name: 'strCuidadoCasa', inputValue: 'Idem. anterior, pero no puede mantener un nivel de limpieza aceptable'},
                            {boxLabel: 'Necesita ayuda en todas las labores de la casa', name: 'strCuidadoCasa', inputValue: 'Necesita ayuda en todas las labores de la casa'},
                            {boxLabel: 'No participa en ninguna labor de la casa', name: 'strCuidadoCasa', inputValue: 'No participa en ninguna labor de la casa'}
                        ],
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalcularTest003();
                            }
                        }
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'radiogroup',
                        allowBlank: false,
                        anchor: '100%',
                        columns: 1,
                        labelStyle: 'font-weight: bold;',
                        fieldLabel: '5. Lavado de la ropa?',
                        name: '5. Lavado de la ropa?',
                        id: 'test003LavadoRopa',
                        items: [
                            {boxLabel: 'Lava por si mismo toda la ropa', name: 'strLavadoRopa', inputValue: 'Lava por si mismo toda la ropa'},
                            {boxLabel: 'Lava por si mismo pequeñas prendas (ropa interior, etc)', name: 'strLavadoRopa', inputValue: 'Lava por si mismo pequeñas prendas (ropa interior, etc)'},
                            {boxLabel: 'Todo el lavado de ropa debe ser realizado por otro', name: 'strLavadoRopa', inputValue: 'Todo el lavado de ropa debe ser realizado por otro'}
                        ],
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalcularTest003();
                            }
                        }
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'radiogroup',
                        allowBlank: false,
                        anchor: '100%',
                        columns: 1,
                        labelStyle: 'font-weight: bold;',
                        fieldLabel: '6. Uso de transporte?',
                        name: '6. Uso de transporte?',
                        id: 'test003Usotransporte',
                        items: [
                            {boxLabel: 'Viaja solo en transporte publico o conduce su propio coche', name: 'strUsoTransporte', inputValue: 'Viaja solo en transporte publico o conduce su propio coche'},
                            {boxLabel: 'Es capaz de tomar un taxi, pero no usa otro medio de transporte', name: 'strUsoTransporte', inputValue: 'Es capaz de tomar un taxi, pero no usa otro medio de transporte'},
                            {boxLabel: 'Viaja en transporte publico cuando va acompañado por otra persona', name: 'strUsoTransporte', inputValue: 'Viaja en transporte publico cuando va acompañado por otra persona'},
                            {boxLabel: 'Utiliza el taxi o el automovil solo con ayuda de otros', name: 'strUsoTransporte', inputValue: 'Utiliza el taxi o el automovil solo con ayuda de otros'},
                            {boxLabel: 'No viaja en absoluto', name: 'strUsoTransporte', inputValue: 'No viaja en absoluto'}
                        ],
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalcularTest003();
                            }
                        }
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'radiogroup',
                        allowBlank: false,
                        anchor: '100%',
                        columns: 1,
                        labelStyle: 'font-weight: bold;',
                        fieldLabel: '7. Medicacion?',
                        name: '7. Medicacion?',
                        id: 'test003Medicacion',
                        items: [
                            {boxLabel: 'Es capaz de tomar su medicacion a la hora y dosis correctas', name: 'strUsoMedicacion', inputValue: 'Es capaz de tomar su medicacion a la hora y dosis correctas'},
                            {boxLabel: 'Toma su medicacion si se prepara con antelacion y en dosis separadas', name: 'strUsoMedicacion', inputValue: 'Toma su medicacion si se prepara con antelacion y en dosis separadas'},
                            {boxLabel: 'No es capaz de administrarse su medicacion', name: 'strUsoMedicacion', inputValue: 'No es capaz de administrarse su medicacion'}
                        ],
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalcularTest003();
                            }
                        }
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'radiogroup',
                        allowBlank: false,
                        anchor: '100%',
                        columns: 1,
                        labelStyle: 'font-weight: bold;',
                        fieldLabel: '8. Manejo de dinero?',
                        name: '8. Manejo de dinero?',
                        id: 'test003ManejoDinero',
                        items: [
                            {boxLabel: 'Maneja asuntos financieros con independencia, recoge y conoce sus ingresos', name: 'strManejoDinero', inputValue: 'Maneja asuntos financieros con independencia, recoge y conoce sus ingresos'},
                            {boxLabel: 'Realizada las compras diaras, pero necesita ayuda en grandes compras, bancos', name: 'strManejoDinero', inputValue: 'Realizada las compras diaras, pero necesita ayuda en grandes compras, bancos'},
                            {boxLabel: 'Incapaz de manejar dinero', name: 'strManejoDinero', inputValue: 'Incapaz de manejar dinero'}
                        ],
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalcularTest003();
                            }
                        }
                    }
                ]
            },
            {
                html: '<br><hr><br>'
            },
            {
                xtype: 'numberfield',
                name: 'Puntaje Total',
                fieldLabel: '<b>Puntaje Total</b>',
                width: 50,
                minValue: 0,
                decimalPrecision: 0,
                allowBlank: true,
                value: 0,
                id: 'intAnexo3PuntajeTotal'
            }
        ];
        fsEscalaLawtonUi.superclass.initComponent.call(this);
    }
});

function CalcularTest003(){
    var preg1 = 0;
    var preg2 = 0;
    var preg3 = 0;
    var preg4 = 0;
    var preg5 = 0;
    var preg6 = 0;
    var preg7 = 0;
    var preg8 = 0;
    Ext.getCmp('intAnexo3PuntajeTotal').setValue(0);
    
    Ext.getCmp('test003UsaTelefono').items.each(function(item) {
        if(item.getValue() === true || item.getValue() === "true"){
            switch(item.getRawValue()){
                case "Lo Usa por iniciativa propia, busca y marca los numero, etc":
                    preg1 = 1;
                    break;
                case "Es capaz de marcar bien algunos numeros conocidos":
                    preg1 = 1;
                    break;
                case "Es capaz de contestar al telefono, pero no de marcar":
                    preg1 = 1;
                    break;
                case "No utiliza el telefono en Absoluto":
                    preg1 = 0;
                    break;
                default:
                    preg1 = 0;
                    break;
            }
        }
    });
    
    Ext.getCmp('test003IrCompras').items.each(function(item) {
        if(item.getValue() === true || item.getValue() === "true"){
            switch(item.getRawValue()){
                case "Realiza todas las compras necesarias independientemente":
                    preg2 = 1;
                    break;
                case "Realiza independientemente pequeñas compras":
                    preg2 = 0;
                    break;
                case "Necesita ir acompañado para realizar pequeñas compras":
                    preg2 = 0;
                    break;
                case "Totalmente Incapaz":
                    preg2 = 0;
                    break;
                default:
                    preg2 = 0;
                    break;
            }
        }
    });
    
    Ext.getCmp('test003PrepararComidas').items.each(function(item) {
        if(item.getValue() === true || item.getValue() === "true"){
            switch(item.getRawValue()){
                case "Organiza, prepara y sirve las comidas por si mismo adecuadamente":
                    preg3 = 1;
                    break;
                case "Prepara adecuadamente las comidas si se le dan los ingredientes":
                    preg3 = 0;
                    break;
                case "Prepara, caliente y sirve las comidas pero no sigue una dieta adecuada":
                    preg3 = 0;
                    break;
                case "Necesita que le preparen y le sirvan las comidas":
                    preg3 = 0;
                    break;
                default:
                    preg3 = 0;
                    break;
            }
        }
    });
    
    Ext.getCmp('test003CuidadoCasa').items.each(function(item) {
        if(item.getValue() === true || item.getValue() === "true"){
            switch(item.getRawValue()){
                case "Mantiene la casa solo/a o con ayuda ocacional (con trabajos pesados)":
                    preg4 = 1;
                    break;
                case "Realiza tareas domesticas ligeras, como lavar los platos o hacer las camas":
                    preg4 = 1;
                    break;
                case "Idem. anterior, pero no puede mantener un nivel de limpieza aceptable":
                    preg4 = 1;
                    break;
                case "Necesita ayuda en todas las labores de la casa":
                    preg4 = 0;
                    break;
                case "No participa en ninguna labor de la casa":
                    preg4 = 0;
                    break;
                default:
                    preg4 = 0;
                    break;
            }
        }
    });
    
    Ext.getCmp('test003LavadoRopa').items.each(function(item) {
        if(item.getValue() === true || item.getValue() === "true"){
            switch(item.getRawValue()){
                case "Lava por si mismo toda la ropa":
                    preg5 = 1;
                    break;
                case "Lava por si mismo pequeñas prendas (ropa interior, etc)":
                    preg5 = 1;
                    break;
                case "Todo el lavado de ropa debe ser realizado por otro":
                    preg5 = 0;
                    break;
                default:
                    preg5 = 0;
                    break;
            }
        }
    });
    
    Ext.getCmp('test003Usotransporte').items.each(function(item) {
        if(item.getValue() === true || item.getValue() === "true"){
            switch(item.getRawValue()){
                case "Viaja solo en transporte publico o conduce su propio coche":
                    preg6 = 1;
                    break;
                case "Es capaz de tomar un taxi, pero no usa otro medio de transporte":
                    preg6 = 1;
                    break;
                case "Viaja en transporte publico cuando va acompañado por otra persona":
                    preg6 = 1;
                    break;
                case "Utiliza el taxi o el automovil solo con ayuda de otros":
                    preg6 = 0;
                    break;
                case "No viaja en absoluto":
                    preg6 = 0;
                    break;
                default:
                    preg6 = 0;
                    break;
            }
        }
    });
   
    Ext.getCmp('test003Medicacion').items.each(function(item) {
        if(item.getValue() === true || item.getValue() === "true"){
            switch(item.getRawValue()){
                case "Es capaz de tomar su medicacion a la hora y dosis correctas":
                    preg7 = 1;
                    break;
                case "Toma su medicacion si se prepara con antelacion y en dosis separadas":
                    preg7 = 0;
                    break;
                case "No es capaz de administrarse su medicacion":
                    preg7 = 0;
                    break;
                default:
                    preg7 = 0;
                    break;
            }
        }
    });
    
    Ext.getCmp('test003ManejoDinero').items.each(function(item) {
        if(item.getValue() === true || item.getValue() === "true"){
            switch(item.getRawValue()){
                case "Maneja asuntos financieros con independencia, recoge y conoce sus ingresos":
                    preg8 = 1;
                    break;
                case "Realizada las compras diaras, pero necesita ayuda en grandes compras, bancos":
                    preg8 = 1;
                    break;
                case "Incapaz de manejar dinero":
                    preg8 = 0;
                    break;
                default:
                    preg8 = 0;
                    break;
            }
        }
    });
    Ext.getCmp('intAnexo3PuntajeTotal').setValue(preg1 + preg2 + preg3 + preg4 + preg5 + preg6 + preg7 + preg8);
}