/*
* @category    Fieldset ESCALA AUTOEFICACIA RELACIONADA CON CAIDAS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsEscalaAutoeficaciaUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'FES-1 ESCALA AUTOEFICACIA RELACIONADA CON CAIDAS',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    labelWidth: 470,
    padding: 0,
    id: 'fsEscalaAutoeficacia',
    initComponent: function() {
        
        var dataAnexo1 = [
            [1,'Nada Preocupado'],
            [2,'Poco Preocupado'],
            [3,'Regular'],
            [4,'Mucho']
        ];
        var stAnexo1 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo1.loadData(dataAnexo1);
        
        this.tbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Guardar Test',
                iconCls: 'btnGuardar',
                listeners:{
                    click : function(){
                        alert("Guardar Test");
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                html: '<br>Ahora le queremos hacer algunas preguntas relacionadas con su <b>preocupacion sobre la posibilidad de caerse.</b><br><br>'
            },
            {
                xtype: 'combo',
                name: 'Limpiar la casa (ej. barrer, pasar la aspiradora o limpiar el polvo)',
                fieldLabel: 'Limpiar la casa (ej. barrer, pasar la aspiradora o limpiar el polvo)',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1LimpiarCasa',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Vestirse o Desvestirse',
                fieldLabel: 'Vestirse o Desvestirse',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1VestirseDesvestirse',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Preparar comidas cada dia',
                fieldLabel: 'Preparar comidas cada dia',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1PrepararComida',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Banarse o Ducharse',
                fieldLabel: 'Bañarse o Ducharse',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1Banarse',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Ir a la compra',
                fieldLabel: 'Ir a la compra',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1Compra',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Sentarse o Levantarse de la Silla',
                fieldLabel: 'Sentarse o Levantarse de la Silla',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1SentarseLevantarse',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Subir o Bajar escaleras',
                fieldLabel: 'Subir o Bajar escaleras',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1SubirBajarEscaleras',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Caminar por el barrio(o vecindad, fuera de casa)',
                fieldLabel: 'Caminar por el barrio(o vecindad, fuera de casa)',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1CaminarBarrio',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Coger algo alto(por encima de la cabeza) o en el suelo',
                fieldLabel: 'Coger algo alto(por encima de la cabeza) o en el suelo',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1CogerAltooSuelo',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Ir a contestar el telefono antes de que deje de sonar',
                fieldLabel: 'Ir a contestar el telefono antes de que deje de sonar',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1ContestarTelefono',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Caminar sobre una superficie resbaladiza (ej. mojada o con helo)',
                fieldLabel: 'Caminar sobre una superficie resbaladiza (ej. mojada o con helo)',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1CaminarSuperficieResbaladiza',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Visitar a un amigo o familiar',
                fieldLabel: 'Visitar a un amigo o familiar',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1VisitarAmigo',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Caminar en un lugar con mucha gente',
                fieldLabel: 'Caminar en un lugar con mucha gente',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1CaminarMultitud',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Caminar en una superficie irregular (ej. pavimento en mal estado, sin asfaltar)',
                fieldLabel: 'Caminar en una superficie irregular (ej. pavimento en mal estado, sin asfaltar)',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1CaminarSuperficieIrregular',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Subir o Bajar una rampa',
                fieldLabel: 'Subir o Bajar una rampa',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1SubirBajarRampa',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Salir a un evento social (ej. religioso, reunion familiar o reunion social)',
                fieldLabel: 'Salir a un evento social (ej. religioso, reunion familiar o reunion social)',
                width: 150,
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1EventoSocial',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew !== null || pNew !== ''){
                            CalcularTest001();
                        }
                    }
                }
            },
            {
                html: '<br><hr><br>'
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        html: '<b>Puntaje Total:</b>'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'Puntaje Total',
                        width: 50,
                        minValue: 0,
                        decimalPrecision: 0,
                        allowBlank: true,
                        value: 0,
                        id: 'intAnexo1PuntajeTotal'
                    }
                ]
            }
        ];
        fsEscalaAutoeficaciaUi.superclass.initComponent.call(this);
    }
});

function CalcularTest001(){
    var preg1 = 0;
    var preg2 = 0;
    var preg3 = 0;
    var preg4 = 0;
    var preg5 = 0;
    var preg6 = 0;
    var preg7 = 0;
    var preg8 = 0;
    var preg9 = 0;
    var preg10 = 0;
    var preg11 = 0;
    var preg12 = 0;
    var preg13 = 0;
    var preg14 = 0;
    var preg15 = 0;
    var preg16 = 0;
    
    Ext.getCmp('intAnexo1PuntajeTotal').setValue(0);
    if(Ext.getCmp('intAnexo1LimpiarCasa').getValue() !== null && Ext.getCmp('intAnexo1LimpiarCasa').getValue() !== ""){
        preg1 = parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue());
    }
    if(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue() !== null && Ext.getCmp('intAnexo1VestirseDesvestirse').getValue() !== ""){
        preg2 = parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue());
    }
    if(Ext.getCmp('intAnexo1PrepararComida').getValue() !== null && Ext.getCmp('intAnexo1PrepararComida').getValue() !== ""){
        preg3 = parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue());
    }
    if(Ext.getCmp('intAnexo1Banarse').getValue() !== null && Ext.getCmp('intAnexo1Banarse').getValue() !== ""){
        preg4 = parseInt(Ext.getCmp('intAnexo1Banarse').getValue());
    }
    if(Ext.getCmp('intAnexo1Compra').getValue() !== null && Ext.getCmp('intAnexo1Compra').getValue() !== ""){
        preg5 = parseInt(Ext.getCmp('intAnexo1Compra').getValue());
    }
    if(Ext.getCmp('intAnexo1SentarseLevantarse').getValue() !== null && Ext.getCmp('intAnexo1SentarseLevantarse').getValue() !== ""){
        preg6 = parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue());
    }
    if(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue() !== null && Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue() !== ""){
        preg7 = parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue());
    }
    if(Ext.getCmp('intAnexo1CaminarBarrio').getValue() !== null && Ext.getCmp('intAnexo1CaminarBarrio').getValue() !== ""){
        preg8 = parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue());
    }
    if(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue() !== null && Ext.getCmp('intAnexo1CogerAltooSuelo').getValue() !== ""){
        preg9 = parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue());
    }
    if(Ext.getCmp('intAnexo1ContestarTelefono').getValue() !== null && Ext.getCmp('intAnexo1ContestarTelefono').getValue() !== ""){
        preg10 = parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue());
    }
    if(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue() !== null && Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue() !== ""){
        preg11 = parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue());
    }
    if(Ext.getCmp('intAnexo1VisitarAmigo').getValue() !== null && Ext.getCmp('intAnexo1VisitarAmigo').getValue() !== ""){
        preg12 = parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue());
    }
    if(Ext.getCmp('intAnexo1CaminarMultitud').getValue() !== null && Ext.getCmp('intAnexo1CaminarMultitud').getValue() !== ""){
        preg13 = parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue());
    }
    if(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue() !== null && Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue() !== ""){
        preg14 = parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue());
    }
    if(Ext.getCmp('intAnexo1SubirBajarRampa').getValue() !== null && Ext.getCmp('intAnexo1SubirBajarRampa').getValue() !== ""){
        preg15 = parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue());
    }
    if(Ext.getCmp('intAnexo1EventoSocial').getValue() !== null && Ext.getCmp('intAnexo1EventoSocial').getValue() !== ""){
        preg16 = parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue());
    }
    Ext.getCmp('intAnexo1PuntajeTotal').setValue(preg1 + preg2 + preg3 + preg4 + preg5 + preg6 + preg7 + preg8 + preg9 + preg10 + preg11 + preg12 + preg13 + preg14 + preg15 + preg16);
}