/*
* @category    Fieldset ESCALA DE APOYO SOCIAL MOS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsApoyoSocialUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ESCALA DE APOYO SOCIAL MOS',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsEscalaMOS',
    initComponent: function() {
        
        
        var dataAnexo10MOS = [
            [1,'Nunca'],
            [2,'Pocas Veces'],
            [3,'Algunas Veces'],
            [4,'La Mayoria de las Veces'],
            [5,'Siempre']
        ];
        var stAnexo10MOS = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo10MOS.loadData(dataAnexo10MOS);
        
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Guardar Test',
                iconCls: 'btnGuardar',
                listeners:{
                    click : function(){
                        fnGuaradarTest010();
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                html: 'Con que frecuencia dispone Ud. de cada uno de los siguientes tipos de apoyo cuando lo necesita?<br><br>'
            },
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmEscalaMOS',
                padding: 10,
                labelWidth: 380,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        name: '1. Aproximadamente, ¿cuantos amigos intimos o familiares cercanos tiene Ud? (personas con las que se encuentra a gusto y puede hablar acerca de todo lo que se le ocurre) Escriba el N°. de amigos intimos y familiares cercanos. Puntaje Prueba Equilibrio',
                        fieldLabel: '1. Aproximadamente, ¿cuantos amigos intimos o familiares cercanos tiene Ud? (personas con las que se encuentra a gusto y puede hablar acerca de todo lo que se le ocurre) Escriba el N°. de amigos intimos y familiares cercanos.',
                        width: 50,
                        minValue: 0,
                        decimalPrecision: 0,
                        allowBlank: false,
                        id: 'intAnexo10AmigosIntimosFamiliares'
                    },
                    {
                        xtype: 'combo',
                        name: '2. Alguien que le ayude cuando tenga que estar en la cama',
                        fieldLabel: '2. Alguien que le ayude cuando tenga que estar en la cama',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Ayuda',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '3. Alguien con quien pueda contar cuando necesita hablar',
                        fieldLabel: '3. Alguien con quien pueda contar cuando necesita hablar',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Hablar',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '4. Alguien que le aconceje cuando tenga problemas',
                        fieldLabel: '4. Alguien que le aconceje cuando tenga problemas',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Concejo',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '5. Alguien que le lleve al medico cuando lo necesite',
                        fieldLabel: '5. Alguien que le lleve al medico cuando lo necesite',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Medico',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '6. Alguien que le muestre amor y afecto',
                        fieldLabel: '6. Alguien que le muestre amor y afecto',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Amor',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '7. Alguien con quien pasar un buen rato',
                        fieldLabel: '7. Alguien con quien pasar un buen rato',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10BuenRato',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '8. Alguien que le informe y le ayude a entender una situacion',
                        fieldLabel: '8. Alguien que le informe y le ayude a entender una situacion',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Situacion',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '9. Alguien en quien confiar o con quien hablar de si mismo y sus preocupaciones',
                        fieldLabel: '9. Alguien en quien confiar o con quien hablar de si mismo y sus preocupaciones',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Confiar',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '10. Alguien que le abrace',
                        fieldLabel: '10. Alguien que le abrace',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Abrazo',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '11. Alguien con quien pueda relajarse',
                        fieldLabel: '11. Alguien con quien pueda relajarse',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Relajarse',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '12. Alguien que le prepare comida si no puede hacerlo',
                        fieldLabel: '12. Alguien que le prepare comida si no puede hacerlo',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Comida',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '13. Alguien cuyo consejo realmente desee',
                        fieldLabel: '13. Alguien cuyo consejo realmente desee',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10ConsejoDesee',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '14. Alguien con quien hacer cosas que le sirvan para olvidar sus problemas',
                        fieldLabel: '14. Alguien con quien hacer cosas que le sirvan para olvidar sus problemas',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10OlvidarProblemas',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '15. Alguien que le ayude en sus tareas domesticas si esta enfermo',
                        fieldLabel: '15. Alguien que le ayude en sus tareas domesticas si esta enfermo',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10TareasDomesticas',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '16. Alguien con quien compartir sus temores y problemas mas intimos',
                        fieldLabel: '16. Alguien con quien compartir sus temores y problemas mas intimos',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Temores',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '17. Alguien que le aconseje como resolver sus problemas personales',
                        fieldLabel: '17. Alguien que le aconseje como resolver sus problemas personales',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10ResolverProblemas',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '18. Alguien con quien divertirse',
                        fieldLabel: '18. Alguien con quien divertirse',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10Diversion',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '19. Alguien que comprenda sus problemas',
                        fieldLabel: '19. Alguien que comprenda sus problemas',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10ComprenderProblemas',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: '20. Alguien a quien amar y hacerle sentirse querido',
                        fieldLabel: '20. Alguien a quien amar y hacerle sentirse querido',
                        width: 250,
                        allowBlank: false,
                        store: stAnexo10MOS,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo10SentirseQuerido',
                        listeners:{
                            change : function(f,pNew, pOld){
                                CalificarMOS();
                            }
                        }
                    },
                    {
                        html: '<br><hr><br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                name: 'APOYO EMOCIONAL',
                                fieldLabel: '<b>APOYO EMOCIONAL</b>',
                                width: 50,
                                minValue: 0,
                                decimalPrecision: 0,
                                allowBlank: false,
                                readOnly: true,
                                id: 'intAnexo10PuntajeApoyoEmocional'
                            },
                            {
                                html:' - '
                            },
                            {
                                xtype: 'textfield',
                                name: 'APOYO EMOCIONAL - CLASIFICACION',
                                width: 350,
                                allowBlank: false,
                                readOnly: true,
                                id: 'strAnexo10ClasificaApoyoEmocional'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                name: 'APOYO INSTRUMENTAL',
                                fieldLabel: '<b>APOYO INSTRUMENTAL</b>',
                                width: 50,
                                minValue: 0,
                                decimalPrecision: 0,
                                allowBlank: false,
                                readOnly: true,
                                id: 'intAnexo10PuntajeApoyoInstrumental'
                            },
                            {
                                html:' - '
                            },
                            {
                                xtype: 'textfield',
                                name: 'APOYO INSTRUMENTAL - CLASIFICACION',
                                width: 350,
                                allowBlank: false,
                                readOnly: true,
                                id: 'strAnexo10ClasificaApoyoInstrumental'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                name: 'APOYO INTERACCION SOCIAL POSITIVA',
                                fieldLabel: '<b>APOYO INTERACCION SOCIAL POSITIVA</b>',
                                width: 50,
                                minValue: 0,
                                decimalPrecision: 0,
                                allowBlank: false,
                                readOnly: true,
                                id: 'intAnexo10PuntajeApoyoInteraccionSocial'
                            },
                            {
                                html:' - '
                            },
                            {
                                xtype: 'textfield',
                                name: 'APOYO INTERACCION SOCIAL POSITIVA - CLASIFICACION',
                                width: 350,
                                allowBlank: false,
                                readOnly: true,
                                id: 'strAnexo10ClasificaApoyoInteraccionSocial'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                name: 'APOYO AFECTIVO',
                                fieldLabel: '<b>APOYO AFECTIVO</b>',
                                width: 50,
                                minValue: 0,
                                decimalPrecision: 0,
                                allowBlank: false,
                                readOnly: true,
                                id: 'intAnexo10PuntajeApoyoAfectivo'
                            },
                            {
                                html:' - '
                            },
                            {
                                xtype: 'textfield',
                                name: 'APOYO AFECTIVO - CLASIFICACION',
                                width: 350,
                                allowBlank: false,
                                readOnly: true,
                                id: 'strAnexo10ClasificaApoyoAfectivo'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                name: 'INDICE GLOBAL DE APOYO SOCIAL',
                                fieldLabel: '<b>INDICE GLOBAL DE APOYO SOCIAL</b>',
                                width: 50,
                                minValue: 0,
                                decimalPrecision: 0,
                                allowBlank: false,
                                readOnly: true,
                                id: 'intAnexo10PuntajeIndiceGlobal'
                            },
                            {
                                html:' - '
                            },
                            {
                                xtype: 'textfield',
                                name: 'INDICE GLOBAL DE APOYO SOCIAL - CLASIFICACION',
                                width: 350,
                                allowBlank: false,
                                readOnly: true,
                                id: 'strAnexo10ClasificaIndiceGlobal'
                            }
                        ]
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                var frm = Ext.getCmp('frmEscalaMOS').getForm();
                frm.doAction('load', {
                    url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pConsecutivoHC: wConsecutivoHC,
                        task: 'LOAD_TEST_010'
                    },
                    success:function(form, action) {
                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                    }
                });
            }}
        });
        fsApoyoSocialUi.superclass.initComponent.call(this);
    }
});

function fnGuaradarTest010(){
    var frm = Ext.getCmp('frmEscalaMOS').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
            params:{
                task: 'GUARDAR_TEST_010',
                pConsecutivoHC: wConsecutivoHC,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function CalificarMOS(){
    var p2 = 0;
    var p3 = 0;
    var p4 = 0;
    var p5 = 0;
    var p6 = 0;
    var p7 = 0;
    var p8 = 0;
    var p9 = 0;
    var p10 = 0;
    var p11 = 0;
    var p12 = 0;
    var p13 = 0;
    var p14 = 0;
    var p15 = 0;
    var p16 = 0;
    var p17 = 0;
    var p18 = 0;
    var p19 = 0;
    var p20 = 0;
    if(Ext.getCmp('intAnexo10Ayuda').getValue() !== null || Ext.getCmp('intAnexo10Ayuda').getValue() !== ''){ p2 = parseInt(Ext.getCmp('intAnexo10Ayuda').getValue());}else{ p2 = 0;}
    if(Ext.getCmp('intAnexo10Hablar').getValue() !== null || Ext.getCmp('intAnexo10Hablar').getValue() !== ''){ p3 = parseInt(Ext.getCmp('intAnexo10Hablar').getValue());}else{ p3 = 0;}
    if(Ext.getCmp('intAnexo10Concejo').getValue() !== null || Ext.getCmp('intAnexo10Concejo').getValue() !== ''){ p4 = parseInt(Ext.getCmp('intAnexo10Concejo').getValue());}else{ p4 = 0;}
    if(Ext.getCmp('intAnexo10Medico').getValue() !== null || Ext.getCmp('intAnexo10Medico').getValue() !== ''){ p5 = parseInt(Ext.getCmp('intAnexo10Medico').getValue());}else{ p5 = 0;}
    if(Ext.getCmp('intAnexo10Amor').getValue() !== null || Ext.getCmp('intAnexo10Amor').getValue() !== ''){ p6 = parseInt(Ext.getCmp('intAnexo10Amor').getValue());}else{ p6 = 0;}
    if(Ext.getCmp('intAnexo10BuenRato').getValue() !== null || Ext.getCmp('intAnexo10BuenRato').getValue() !== ''){ p7 = parseInt(Ext.getCmp('intAnexo10BuenRato').getValue());}else{ p7 = 0;}
    if(Ext.getCmp('intAnexo10Situacion').getValue() !== null || Ext.getCmp('intAnexo10Situacion').getValue() !== ''){ p8 = parseInt(Ext.getCmp('intAnexo10Situacion').getValue());}else{ p8 = 0;}
    if(Ext.getCmp('intAnexo10Confiar').getValue() !== null || Ext.getCmp('intAnexo10Confiar').getValue() !== ''){ p9 = parseInt(Ext.getCmp('intAnexo10Confiar').getValue());}else{ p9 = 0;}
    if(Ext.getCmp('intAnexo10Abrazo').getValue() !== null || Ext.getCmp('intAnexo10Abrazo').getValue() !== ''){ p10 = parseInt(Ext.getCmp('intAnexo10Abrazo').getValue());}else{ p10 = 0;}
    if(Ext.getCmp('intAnexo10Relajarse').getValue() !== null || Ext.getCmp('intAnexo10Relajarse').getValue() !== ''){ p11 = parseInt(Ext.getCmp('intAnexo10Relajarse').getValue());}else{ p11 = 0;}
    if(Ext.getCmp('intAnexo10Comida').getValue() !== null || Ext.getCmp('intAnexo10Comida').getValue() !== ''){ p12 = parseInt(Ext.getCmp('intAnexo10Comida').getValue());}else{ p12 = 0;}
    if(Ext.getCmp('intAnexo10ConsejoDesee').getValue() !== null || Ext.getCmp('intAnexo10ConsejoDesee').getValue() !== ''){ p13 = parseInt(Ext.getCmp('intAnexo10ConsejoDesee').getValue());}else{ p13 = 0;}
    if(Ext.getCmp('intAnexo10OlvidarProblemas').getValue() !== null || Ext.getCmp('intAnexo10OlvidarProblemas').getValue() !== ''){ p14 = parseInt(Ext.getCmp('intAnexo10OlvidarProblemas').getValue());}else{ p14 = 0;}
    if(Ext.getCmp('intAnexo10TareasDomesticas').getValue() !== null || Ext.getCmp('intAnexo10TareasDomesticas').getValue() !== ''){ p15 = parseInt(Ext.getCmp('intAnexo10TareasDomesticas').getValue());}else{ p15 = 0;}
    if(Ext.getCmp('intAnexo10Temores').getValue() !== null || Ext.getCmp('intAnexo10Temores').getValue() !== ''){ p16 = parseInt(Ext.getCmp('intAnexo10Temores').getValue());}else{ p16 = 0;}
    if(Ext.getCmp('intAnexo10ResolverProblemas').getValue() !== null || Ext.getCmp('intAnexo10ResolverProblemas').getValue() !== ''){ p17 = parseInt(Ext.getCmp('intAnexo10ResolverProblemas').getValue());}else{ p17 = 0;}
    if(Ext.getCmp('intAnexo10Diversion').getValue() !== null || Ext.getCmp('intAnexo10Diversion').getValue() !== ''){ p18 = parseInt(Ext.getCmp('intAnexo10Diversion').getValue());}else{ p18 = 0;}
    if(Ext.getCmp('intAnexo10ComprenderProblemas').getValue() !== null || Ext.getCmp('intAnexo10ComprenderProblemas').getValue() !== ''){ p19 = parseInt(Ext.getCmp('intAnexo10ComprenderProblemas').getValue());}else{ p19 = 0;}
    if(Ext.getCmp('intAnexo10SentirseQuerido').getValue() !== null || Ext.getCmp('intAnexo10SentirseQuerido').getValue() !== ''){ p20 = parseInt(Ext.getCmp('intAnexo10SentirseQuerido').getValue());}else{ p20 = 0;}
    Ext.getCmp('intAnexo10PuntajeApoyoEmocional').setValue(p3 + p4 + p8 + p9 + p13 + p16 + p17 + p19);
    if(parseInt(Ext.getCmp('intAnexo10PuntajeApoyoEmocional').getValue())<25){
        Ext.getCmp('strAnexo10ClasificaApoyoEmocional').setValue("FALTA DE APOYO EMOCIONAL");
    }else{
        Ext.getCmp('strAnexo10ClasificaApoyoEmocional').setValue("APOYO EMOCIONAL NORMAL");
    }
    Ext.getCmp('intAnexo10PuntajeApoyoInstrumental').setValue(p2 + p5 + p12 + p15);
    if(parseInt(Ext.getCmp('intAnexo10PuntajeApoyoInstrumental').getValue())<13){
        Ext.getCmp('strAnexo10ClasificaApoyoInstrumental').setValue("FALTA DE APOYO INSTRUMENTAL");
    }else{
        Ext.getCmp('strAnexo10ClasificaApoyoInstrumental').setValue("APOYO INSTRUMENTAL NORMAL");
    }
    Ext.getCmp('intAnexo10PuntajeApoyoInteraccionSocial').setValue(p7 + p11 + p14);
    if(parseInt(Ext.getCmp('intAnexo10PuntajeApoyoInteraccionSocial').getValue())<10){
        Ext.getCmp('strAnexo10ClasificaApoyoInteraccionSocial').setValue("FALTA DE APOYO INTERACCION SOCIAL POSITIVA");
    }else{
        Ext.getCmp('strAnexo10ClasificaApoyoInteraccionSocial').setValue("APOYO INTERACCION SOCIAL POSITIVA NORMAL");
    }
    Ext.getCmp('intAnexo10PuntajeApoyoAfectivo').setValue(p6 + p10 + p20);
    if(parseInt(Ext.getCmp('intAnexo10PuntajeApoyoAfectivo').getValue())<10){
        Ext.getCmp('strAnexo10ClasificaApoyoAfectivo').setValue("FALTA DE APOYO AFECTIVO");
    }else{
        Ext.getCmp('strAnexo10ClasificaApoyoAfectivo').setValue("APOYO AFECTIVO NORMAL");
    }
    Ext.getCmp('intAnexo10PuntajeIndiceGlobal').setValue(p2 + p3 + p4 + p5 + p6 + p7 + p8 + p9 + p10 + p11 + p12 + p13 + p14 + p15 + p16 + p17 + p18 + p19 + p20);
    if(parseInt(Ext.getCmp('intAnexo10PuntajeIndiceGlobal').getValue())<58){
        Ext.getCmp('strAnexo10ClasificaIndiceGlobal').setValue("APOYO GLOBAL ESCASO");
    }else{
        Ext.getCmp('strAnexo10ClasificaIndiceGlobal').setValue("APOYO GLOBAL NORMAL");
    }
}