/*
* @category    Fieldset ESCALA AUTOEFICACIA RELACIONADA CON CAIDAS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsDepresionGeriatricaUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ESCALA DE DEPRESION GERIATRICA. YESAVAGE (GDS)',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    labelWidth: 470,
    id: 'fsDepresionGeriatrica',
    initComponent: function() {
        
        var dataDepresionGeriatricaA = [
            [0,'SI'],
            [1,'NO']
        ];
        var stDepresionGeriatricaA = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stDepresionGeriatricaA.loadData(dataDepresionGeriatricaA);
        
        
        var dataDepresionGeriatricaB = [
            [1,'SI'],
            [0,'NO']
        ];
        var stDepresionGeriatricaB = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stDepresionGeriatricaB.loadData(dataDepresionGeriatricaB);
        
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Guardar Test',
                iconCls: 'btnGuardar',
                listeners:{
                    click : function(){
                        fnGuaradarTest006();
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                html: '<br>'
            },
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmDepresionGeriatrica',
                padding: 10,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'ESCALA',
                        layout: 'form',
                        labelWidth: 470,
                        collapsible: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'combo',
                                name: 'Esta usted satisfecho con su vida?',
                                fieldLabel: 'Esta usted satisfecho con su vida?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaA,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaA"><tpl if="Descripcion==\'NO\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'SI\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaA',
                                id: 'intTest06Escala1',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Ha abandonado cosas y actividades que antes le gustaban?',
                                fieldLabel: 'Ha abandonado cosas y actividades que antes le gustaban?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaB,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaB"><tpl if="Descripcion==\'SI\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'NO\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaB',
                                id: 'intTest06Escala2',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Siente que su vida esta vacia?',
                                fieldLabel: 'Siente que su vida esta vacia?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaB,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaB"><tpl if="Descripcion==\'SI\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'NO\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaB',
                                id: 'intTest06Escala3',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Se aburre con frecuencia?',
                                fieldLabel: 'Se aburre con frecuencia?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaB,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaB"><tpl if="Descripcion==\'SI\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'NO\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaB',
                                id: 'intTest06Escala4',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Esta Usted de buen animo la mayor parte del tiempo?',
                                fieldLabel: 'Esta Usted de buen animo la mayor parte del tiempo?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaA,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaA"><tpl if="Descripcion==\'NO\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'SI\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaA',
                                id: 'intTest06Escala5',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Siente que algo malo le va a ocurrir?',
                                fieldLabel: 'Siente que algo malo le va a ocurrir?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaB,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaB"><tpl if="Descripcion==\'SI\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'NO\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaB',
                                id: 'intTest06Escala6',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Se siente contento la mayor parte del tiempo?',
                                fieldLabel: 'Se siente contento la mayor parte del tiempo?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaA,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaA"><tpl if="Descripcion==\'NO\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'SI\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaA',
                                id: 'intTest06Escala7',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'A menudo se siente indefenso?',
                                fieldLabel: 'A menudo se siente indefenso?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaB,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaB"><tpl if="Descripcion==\'SI\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'NO\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaB',
                                id: 'intTest06Escala8',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Prefiere quedarse en la casa mas que salir y hacer cosas nuevas?',
                                fieldLabel: 'Prefiere quedarse en la casa mas que salir y hacer cosas nuevas?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaB,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaB"><tpl if="Descripcion==\'SI\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'NO\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaB',
                                id: 'intTest06Escala9',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Cree usted que tiene menos memoria que el resto de la gente?',
                                fieldLabel: 'Cree usted que tiene menos memoria que el resto de la gente?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaB,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaB"><tpl if="Descripcion==\'SI\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'NO\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaB',
                                id: 'intTest06Escala10',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Piensa que es maravilloso estar vivo?',
                                fieldLabel: 'Piensa que es maravilloso estar vivo?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaA,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaA"><tpl if="Descripcion==\'NO\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'SI\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaA',
                                id: 'intTest06Escala11',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Se siente inutil?',
                                fieldLabel: 'Se siente inutil?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaB,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaB"><tpl if="Descripcion==\'SI\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'NO\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaB',
                                id: 'intTest06Escala12',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Se siente lleno de alegria?',
                                fieldLabel: 'Se siente lleno de alegria?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaA,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaA"><tpl if="Descripcion==\'NO\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'SI\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaA',
                                id: 'intTest06Escala13',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Cree que su situacion no tiene esperanza?',
                                fieldLabel: 'Cree que su situacion no tiene esperanza?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaB,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaB"><tpl if="Descripcion==\'SI\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'NO\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaB',
                                id: 'intTest06Escala14',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                name: 'Cree que la mayoria de la gente esta mejor que usted?',
                                fieldLabel: 'Cree que la mayoria de la gente esta mejor que usted?',
                                width: 60,
                                allowBlank: false,
                                store: stDepresionGeriatricaB,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                tpl: '<tpl for="."><div class="cbDepresionGeriatricaB"><tpl if="Descripcion==\'SI\'"><b><u>{Descripcion}</b></u></tpl><tpl if="Descripcion==\'NO\'">{Descripcion}</tpl></div></tpl>',
                                itemSelector: 'div.cbDepresionGeriatricaB',
                                id: 'intTest06Escala15',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        CalcularTest006();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        html: '<br><hr><br>'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'Puntaje Total',
                        fieldLabel: '<b>Puntaje Total</b>',
                        width: 50,
                        minValue: 0,
                        decimalPrecision: 0,
                        allowBlank: false,
                        value: 0,
                        id: 'intAnexo6PuntajeTotal'
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                var frm = Ext.getCmp('frmDepresionGeriatrica').getForm();
                frm.doAction('load', {
                    url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pConsecutivoHC: wConsecutivoHC,
                        task: 'LOAD_TEST_006'
                    },
                    success:function(form, action) {
                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                    }
                });
            }}
        });
        fsDepresionGeriatricaUi.superclass.initComponent.call(this);
    }
});

function CalcularTest006(){
    var preg1 = 0;
    var preg2 = 0;
    var preg3 = 0;
    var preg4 = 0;
    var preg5 = 0;
    var preg6 = 0;
    var preg7 = 0;
    var preg8 = 0;
    var preg9 = 0;
    var preg10 = 0;
    var preg11 = 0;
    var preg12 = 0;
    var preg13 = 0;
    var preg14 = 0;
    var preg15 = 0;
    
    Ext.getCmp('intAnexo6PuntajeTotal').setValue(0);
    if(Ext.getCmp('intTest06Escala1').getValue() !== null && Ext.getCmp('intTest06Escala1').getValue() !== ""){
        preg1 = parseInt(Ext.getCmp('intTest06Escala1').getValue());
    }
    if(Ext.getCmp('intTest06Escala2').getValue() !== null && Ext.getCmp('intTest06Escala2').getValue() !== ""){
        preg2 = parseInt(Ext.getCmp('intTest06Escala2').getValue());
    }
    if(Ext.getCmp('intTest06Escala3').getValue() !== null && Ext.getCmp('intTest06Escala3').getValue() !== ""){
        preg3 = parseInt(Ext.getCmp('intTest06Escala3').getValue());
    }
    if(Ext.getCmp('intTest06Escala4').getValue() !== null && Ext.getCmp('intTest06Escala4').getValue() !== ""){
        preg4 = parseInt(Ext.getCmp('intTest06Escala4').getValue());
    }
    if(Ext.getCmp('intTest06Escala5').getValue() !== null && Ext.getCmp('intTest06Escala5').getValue() !== ""){
        preg5 = parseInt(Ext.getCmp('intTest06Escala5').getValue());
    }
    if(Ext.getCmp('intTest06Escala6').getValue() !== null && Ext.getCmp('intTest06Escala6').getValue() !== ""){
        preg6 = parseInt(Ext.getCmp('intTest06Escala6').getValue());
    }
    if(Ext.getCmp('intTest06Escala7').getValue() !== null && Ext.getCmp('intTest06Escala7').getValue() !== ""){
        preg7 = parseInt(Ext.getCmp('intTest06Escala7').getValue());
    }
    if(Ext.getCmp('intTest06Escala8').getValue() !== null && Ext.getCmp('intTest06Escala8').getValue() !== ""){
        preg8 = parseInt(Ext.getCmp('intTest06Escala8').getValue());
    }
    if(Ext.getCmp('intTest06Escala9').getValue() !== null && Ext.getCmp('intTest06Escala9').getValue() !== ""){
        preg9 = parseInt(Ext.getCmp('intTest06Escala9').getValue());
    }
    if(Ext.getCmp('intTest06Escala10').getValue() !== null && Ext.getCmp('intTest06Escala10').getValue() !== ""){
        preg10 = parseInt(Ext.getCmp('intTest06Escala10').getValue());
    }
    if(Ext.getCmp('intTest06Escala11').getValue() !== null && Ext.getCmp('intTest06Escala11').getValue() !== ""){
        preg11 = parseInt(Ext.getCmp('intTest06Escala11').getValue());
    }
    if(Ext.getCmp('intTest06Escala12').getValue() !== null && Ext.getCmp('intTest06Escala12').getValue() !== ""){
        preg12 = parseInt(Ext.getCmp('intTest06Escala12').getValue());
    }
    if(Ext.getCmp('intTest06Escala13').getValue() !== null && Ext.getCmp('intTest06Escala13').getValue() !== ""){
        preg13 = parseInt(Ext.getCmp('intTest06Escala13').getValue());
    }
    if(Ext.getCmp('intTest06Escala14').getValue() !== null && Ext.getCmp('intTest06Escala14').getValue() !== ""){
        preg14 = parseInt(Ext.getCmp('intTest06Escala14').getValue());
    }
    if(Ext.getCmp('intTest06Escala15').getValue() !== null && Ext.getCmp('intTest06Escala15').getValue() !== ""){
        preg15 = parseInt(Ext.getCmp('intTest06Escala15').getValue());
    }
    Ext.getCmp('intAnexo6PuntajeTotal').setValue(preg1 + preg2 + preg3 + preg4 + preg5 + preg6 + preg7 + preg8 + preg9 + preg10 + preg11 + preg12 + preg13 + preg14 + preg15);
}

function fnGuaradarTest006(){
    var frm = Ext.getCmp('frmDepresionGeriatrica').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
            params:{
                task: 'GUARDAR_TEST_006',
                pConsecutivoHC: wConsecutivoHC,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}