/*
* @category    Fieldset ABC SOCIAL
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsABCSocialUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ABC SOCIAL',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    labelWidth: 300,
    id: 'fsABCSocial',
    initComponent: function() {
        
        var dataABCSocial = [
            ['Participa usted al menos tres veces por semana, en alguna actividad deportiva o hace ejercicio como nadar, trotar, jugar tenis, montar bicicleta, hacer bicicros u otras actividades, que le causen sudoracion o que lo dejen sin respiracion'],
            ['Camina usted, al menos tres veces a la semana, entre 9 y 20 cuadras (1.6 Km) sin descansar'],
            ['Camina usted, al menos tres veces a la semana al menos 8 cuadras (0.5 Km) sin descansar'],
            ['Ninguna de las Anteriores']
        ];
        var stABCSocial = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stABCSocial.loadData(dataABCSocial);
        
        
        var dataActividadesSocial = [
            ['0'],
            ['1'],
            ['2'],
            ['3'],
            ['4'],
            ['5'],
            ['6'],
            ['7'],
            ['8'],
            ['9'],
            ['+9']
        ];
        var stActividadesSocial = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stActividadesSocial.loadData(dataActividadesSocial);
        
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Guardar Test',
                iconCls: 'btnGuardar',
                listeners:{
                    click : function(){
                        fnGuaradarTest004();
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                html: 'Marque solo una respuesta, la que mas se acerque a las condiciones del paciente.<br><br>'
            },
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmABCSocial',
                labelWidth: 300,
                padding: 10,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'ABC Social',
                        name: 'ABC Social',
                        anchor: '100%',
                        allowBlank: true,
                        store: stABCSocial,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strAnexo4ABC'
                    },
                    {
                        html: '<br>Cuantas veces en los ultimos 12 meses ha visitado los siguientes sitios o ha tomado parte en los siguientes eventos:<br><br>'
                    },
                    {
                        xtype: 'combo',
                        name: 'Ceremonias familiares matrimonios, funerales, cumpleanos',
                        fieldLabel: 'Ceremonias familiares matrimonios, funerales, cumpleanos',
                        width: 50,
                        allowBlank: true,
                        store: stActividadesSocial,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo4CeremoniasFamiliares'
                    },
                    {
                        xtype: 'combo',
                        name: 'Visitar Amigos',
                        fieldLabel: 'Visitar Amigos',
                        width: 50,
                        allowBlank: true,
                        store: stActividadesSocial,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo4VisitarAmigos'
                    },
                    {
                        xtype: 'combo',
                        name: 'Actividades en asociaciones y clubes',
                        fieldLabel: 'Actividades en asociaciones y clubes',
                        width: 50,
                        allowBlank: true,
                        store: stActividadesSocial,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo4ActividadesAsociacioness'
                    },
                    {
                        xtype: 'combo',
                        name: 'Competensias deportivas (mirando o tomando parte)',
                        fieldLabel: 'Competensias deportivas (mirando o tomando parte)',
                        width: 50,
                        allowBlank: true,
                        store: stActividadesSocial,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo4ActividadesDeportivas'
                    },
                    {
                        xtype: 'combo',
                        name: 'Servicios Religiosos',
                        fieldLabel: 'Servicios Religiosos',
                        width: 50,
                        allowBlank: true,
                        store: stActividadesSocial,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo4ServiciosReligiosos'
                    },
                    {
                        xtype: 'combo',
                        name: 'Viajar a otro pais',
                        fieldLabel: 'Viajar a otro pais',
                        width: 50,
                        allowBlank: true,
                        store: stActividadesSocial,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo4ViajarPais'
                    },
                    {
                        xtype: 'combo',
                        name: 'Viajar dentro del mismo pais',
                        fieldLabel: 'Viajar dentro del mismo pais',
                        width: 50,
                        allowBlank: true,
                        store: stActividadesSocial,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intAnexo4ViajarDentroPais'
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                var frm = Ext.getCmp('frmABCSocial').getForm();
                frm.doAction('load', {
                    url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pConsecutivoHC: wConsecutivoHC,
                        task: 'LOAD_TEST_004'
                    },
                    success:function(form, action) {
                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                    }
                });
            }}
        });
        fsABCSocialUi.superclass.initComponent.call(this);
    }
});

function fnGuaradarTest004(){
    var frm = Ext.getCmp('frmABCSocial').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
            params:{
                task: 'GUARDAR_TEST_004',
                pConsecutivoHC: wConsecutivoHC,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}