/*
* @category    Fieldset ESCALA AUTOEFICACIA RELACIONADA CON CAIDAS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsIndiceBarthelUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'INDICE BARTHEL (Actividades basicas cotidianas - nivel fisico)',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsIndiceBarthel',
    initComponent: function() {
        
        var dataAnexo2Deambulacion = [
            [15,'Independiente'],
            [10,'Necesita Ayuda'],
            [5,'Independiente en Silla Ruedas'],
            [0,'Inmovil']
        ];
        var stAnexo2Deambulacion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo2Deambulacion.loadData(dataAnexo2Deambulacion);
        
        
        var dataAnexo2TrasladoSilla = [
            [15,'Independiente'],
            [10,'Minima Ayuda'],
            [5,'Gran Ayuda'],
            [0,'Dependiente']
        ];
        var stAnexo2TrasladoSilla = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo2TrasladoSilla.loadData(dataAnexo2TrasladoSilla);
        
        
        var dataAnexo2Escalones = [
            [10,'Independiente'],
            [5,'Necesita Ayuda'],
            [0,'Incapaz']
        ];
        var stAnexo2Escalones = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo2Escalones.loadData(dataAnexo2Escalones);
        
        
        var dataAnexo2UsoSanitario = [
            [10,'Independiente'],
            [5,'Necesita Ayuda'],
            [0,'Dependiente']
        ];
        var stAnexo2UsoSanitario = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo2UsoSanitario.loadData(dataAnexo2UsoSanitario);
        
        
        var dataAnexo2Alimentacion = [
            [10,'Independiente'],
            [5,'Necesita Ayuda'],
            [0,'Dependiente']
        ];
        var stAnexo2Alimentacion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo2Alimentacion.loadData(dataAnexo2Alimentacion);
        
        
        var dataAnexo2Miccion = [
            [10,'Continente, ningun accidente'],
            [5,'Accidente ocacional'],
            [0,'Incontinente']
        ];
        var stAnexo2Miccion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo2Miccion.loadData(dataAnexo2Miccion);
        
        
        var dataAnexo2Deposicion = [
            [10,'Continente, ningun accidente'],
            [5,'Accidente ocacional'],
            [0,'Incontinente']
        ];
        var stAnexo2Deposicion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo2Deposicion.loadData(dataAnexo2Deposicion);
        
        
        var dataAnexo2Vestido = [
            [10,'Independiente'],
            [5,'Necesita Ayuda'],
            [0,'Dependiente']
        ];
        var stAnexo2Vestido = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo2Vestido.loadData(dataAnexo2Vestido);
        
        
        var dataAnexo2Arreglarse = [
            [5,'Independiente'],
            [0,'Dependiente']
        ];
        var stAnexo2Arreglarse = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo2Arreglarse.loadData(dataAnexo2Arreglarse);
        
        
        var dataAnexo2Bano = [
            [5,'Independiente'],
            [0,'Dependiente']
        ];
        var stAnexo2Bano = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo2Bano.loadData(dataAnexo2Bano);
        
        this.items = [
            {
                xtype: 'combo',
                name: 'Alimentacion',
                fieldLabel: 'Alimentacion',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo2Alimentacion,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2Alimentacion',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo2PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo2Alimentacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Bano').getValue()) + parseInt(Ext.getCmp('intAnexo2Vestido').getValue()) + parseInt(Ext.getCmp('intAnexo2Arreglarse').getValue()) + parseInt(Ext.getCmp('intAnexo2Deposicion').getValue()) + parseInt(Ext.getCmp('intAnexo2Miccion').getValue()) + parseInt(Ext.getCmp('intAnexo2UsoSanitario').getValue()) + parseInt(Ext.getCmp('intAnexo2TrasladoSilla').getValue()) + parseInt(Ext.getCmp('intAnexo2Deambulacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Escalones').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Bano',
                fieldLabel: 'Bano',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo2Bano,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2Bano',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo2PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo2Alimentacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Bano').getValue()) + parseInt(Ext.getCmp('intAnexo2Vestido').getValue()) + parseInt(Ext.getCmp('intAnexo2Arreglarse').getValue()) + parseInt(Ext.getCmp('intAnexo2Deposicion').getValue()) + parseInt(Ext.getCmp('intAnexo2Miccion').getValue()) + parseInt(Ext.getCmp('intAnexo2UsoSanitario').getValue()) + parseInt(Ext.getCmp('intAnexo2TrasladoSilla').getValue()) + parseInt(Ext.getCmp('intAnexo2Deambulacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Escalones').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Vestido',
                fieldLabel: 'Vestido',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo2Vestido,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2Vestido',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo2PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo2Alimentacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Bano').getValue()) + parseInt(Ext.getCmp('intAnexo2Vestido').getValue()) + parseInt(Ext.getCmp('intAnexo2Arreglarse').getValue()) + parseInt(Ext.getCmp('intAnexo2Deposicion').getValue()) + parseInt(Ext.getCmp('intAnexo2Miccion').getValue()) + parseInt(Ext.getCmp('intAnexo2UsoSanitario').getValue()) + parseInt(Ext.getCmp('intAnexo2TrasladoSilla').getValue()) + parseInt(Ext.getCmp('intAnexo2Deambulacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Escalones').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Arreglarse',
                fieldLabel: 'Arreglarse',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo2Arreglarse,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2Arreglarse',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo2PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo2Alimentacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Bano').getValue()) + parseInt(Ext.getCmp('intAnexo2Vestido').getValue()) + parseInt(Ext.getCmp('intAnexo2Arreglarse').getValue()) + parseInt(Ext.getCmp('intAnexo2Deposicion').getValue()) + parseInt(Ext.getCmp('intAnexo2Miccion').getValue()) + parseInt(Ext.getCmp('intAnexo2UsoSanitario').getValue()) + parseInt(Ext.getCmp('intAnexo2TrasladoSilla').getValue()) + parseInt(Ext.getCmp('intAnexo2Deambulacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Escalones').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Deposicion',
                fieldLabel: 'Deposicion',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo2Deposicion,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2Deposicion',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo2PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo2Alimentacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Bano').getValue()) + parseInt(Ext.getCmp('intAnexo2Vestido').getValue()) + parseInt(Ext.getCmp('intAnexo2Arreglarse').getValue()) + parseInt(Ext.getCmp('intAnexo2Deposicion').getValue()) + parseInt(Ext.getCmp('intAnexo2Miccion').getValue()) + parseInt(Ext.getCmp('intAnexo2UsoSanitario').getValue()) + parseInt(Ext.getCmp('intAnexo2TrasladoSilla').getValue()) + parseInt(Ext.getCmp('intAnexo2Deambulacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Escalones').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Miccion',
                fieldLabel: 'Miccion',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo2Miccion,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2Miccion',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo2PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo2Alimentacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Bano').getValue()) + parseInt(Ext.getCmp('intAnexo2Vestido').getValue()) + parseInt(Ext.getCmp('intAnexo2Arreglarse').getValue()) + parseInt(Ext.getCmp('intAnexo2Deposicion').getValue()) + parseInt(Ext.getCmp('intAnexo2Miccion').getValue()) + parseInt(Ext.getCmp('intAnexo2UsoSanitario').getValue()) + parseInt(Ext.getCmp('intAnexo2TrasladoSilla').getValue()) + parseInt(Ext.getCmp('intAnexo2Deambulacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Escalones').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Uso del Sanitario',
                fieldLabel: 'Uso del Sanitario',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo2UsoSanitario,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2UsoSanitario',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo2PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo2Alimentacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Bano').getValue()) + parseInt(Ext.getCmp('intAnexo2Vestido').getValue()) + parseInt(Ext.getCmp('intAnexo2Arreglarse').getValue()) + parseInt(Ext.getCmp('intAnexo2Deposicion').getValue()) + parseInt(Ext.getCmp('intAnexo2Miccion').getValue()) + parseInt(Ext.getCmp('intAnexo2UsoSanitario').getValue()) + parseInt(Ext.getCmp('intAnexo2TrasladoSilla').getValue()) + parseInt(Ext.getCmp('intAnexo2Deambulacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Escalones').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Traslado Silla',
                fieldLabel: 'Traslado Silla',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo2TrasladoSilla,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2TrasladoSilla',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo2PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo2Alimentacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Bano').getValue()) + parseInt(Ext.getCmp('intAnexo2Vestido').getValue()) + parseInt(Ext.getCmp('intAnexo2Arreglarse').getValue()) + parseInt(Ext.getCmp('intAnexo2Deposicion').getValue()) + parseInt(Ext.getCmp('intAnexo2Miccion').getValue()) + parseInt(Ext.getCmp('intAnexo2UsoSanitario').getValue()) + parseInt(Ext.getCmp('intAnexo2TrasladoSilla').getValue()) + parseInt(Ext.getCmp('intAnexo2Deambulacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Escalones').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Deambulacion',
                fieldLabel: 'Deambulacion',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo2Deambulacion,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2Deambulacion',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo2PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo2Alimentacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Bano').getValue()) + parseInt(Ext.getCmp('intAnexo2Vestido').getValue()) + parseInt(Ext.getCmp('intAnexo2Arreglarse').getValue()) + parseInt(Ext.getCmp('intAnexo2Deposicion').getValue()) + parseInt(Ext.getCmp('intAnexo2Miccion').getValue()) + parseInt(Ext.getCmp('intAnexo2UsoSanitario').getValue()) + parseInt(Ext.getCmp('intAnexo2TrasladoSilla').getValue()) + parseInt(Ext.getCmp('intAnexo2Deambulacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Escalones').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Escalones',
                fieldLabel: 'Escalones',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo2Escalones,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2Escalones',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo2PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo2Alimentacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Bano').getValue()) + parseInt(Ext.getCmp('intAnexo2Vestido').getValue()) + parseInt(Ext.getCmp('intAnexo2Arreglarse').getValue()) + parseInt(Ext.getCmp('intAnexo2Deposicion').getValue()) + parseInt(Ext.getCmp('intAnexo2Miccion').getValue()) + parseInt(Ext.getCmp('intAnexo2UsoSanitario').getValue()) + parseInt(Ext.getCmp('intAnexo2TrasladoSilla').getValue()) + parseInt(Ext.getCmp('intAnexo2Deambulacion').getValue()) + parseInt(Ext.getCmp('intAnexo2Escalones').getValue()))
                        }
                    }
                }
            },
            
            {
                html: '<br><hr><br>'
            },
            {
                xtype: 'numberfield',
                name: 'Puntaje Total',
                fieldLabel: 'Puntaje Total',
                width: 50,
                minValue: 0,
                decimalPrecision: 0,
                allowBlank: true,
                value: 0,
                id: 'intAnexo2PuntajeTotal'
            },
        ];
        fsIndiceBarthelUi.superclass.initComponent.call(this);
    }
});
