/*
* @category    Fieldset ESCALA AUTOEFICACIA RELACIONADA CON CAIDAS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsEscalaAutoeficaciaUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ESCALA AUTOEFICACIA RELACIONADA CON CAIDAS',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    labelWidth: 270,
    padding: 0,
    id: 'fsEscalaAutoeficacia',
    initComponent: function() {
        
        var dataAnexo1 = [
            [1,'Nada Preocupado'],
            [2,'Poco Preocupado'],
            [3,'Regular'],
            [4,'Mucho']
        ];
        var stAnexo1 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAnexo1.loadData(dataAnexo1);
        
        this.items = [
            {
                html: ''
            },
            {
                xtype: 'combo',
                name: 'Limpiar la casa (ej. barrer, pasar la aspiradora o limpiar el polvo)',
                fieldLabel: 'Limpiar la casa (ej. barrer, pasar la aspiradora o limpiar el polvo)',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1LimpiarCasa',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Vestirse o Desvestirse',
                fieldLabel: 'Vestirse o Desvestirse',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1VestirseDesvestirse',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Preparar comidas cada dia',
                fieldLabel: 'Preparar comidas cada dia',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1PrepararComida',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Banarse o Ducharse',
                fieldLabel: 'Bañarse o Ducharse',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1Banarse',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Ir a la compra',
                fieldLabel: 'Ir a la compra',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1Compra',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Sentarse o Levantarse de la Silla',
                fieldLabel: 'Sentarse o Levantarse de la Silla',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1SentarseLevantarse',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Subir o Bajar escaleras',
                fieldLabel: 'Subir o Bajar escaleras',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1SubirBajarEscaleras',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Caminar por el barrio(o vecindad, fuera de casa)',
                fieldLabel: 'Caminar por el barrio(o vecindad, fuera de casa)',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1CaminarBarrio',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Coger algo alto(por encima de la cabeza) o en el suelo',
                fieldLabel: 'Coger algo alto(por encima de la cabeza) o en el suelo',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1CogerAltooSuelo',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Ir a contestar el telefono antes de que deje de sonar',
                fieldLabel: 'Ir a contestar el telefono antes de que deje de sonar',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1ContestarTelefono',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Caminar sobre una superficie resbaladiza (ej. mojada o con helo)',
                fieldLabel: 'Caminar sobre una superficie resbaladiza (ej. mojada o con helo)',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1CaminarSuperficieResbaladiza',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Visitar a un amigo o familiar',
                fieldLabel: 'Visitar a un amigo o familiar',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1VisitarAmigo',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Caminar en un lugar con mucha gente',
                fieldLabel: 'Caminar en un lugar con mucha gente',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1CaminarMultitud',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Caminar en una superficie irregular (ej. pavimento en mal estado, sin asfaltar)',
                fieldLabel: 'Caminar en una superficie irregular (ej. pavimento en mal estado, sin asfaltar)',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1CaminarSuperficieIrregular',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Subir o Bajar una rampa',
                fieldLabel: 'Subir o Bajar una rampa',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1SubirBajarRampa',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                name: 'Salir a un evento social (ej. religioso, reunion familiar o reunion social)',
                fieldLabel: 'Salir a un evento social (ej. religioso, reunion familiar o reunion social)',
                anchor: '100%',
                allowBlank: true,
                store: stAnexo1,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo1EventoSocial',
                listeners:{
                    change : function(f,pNew, pOld){
                        if(pNew != null || pNew != ''){
                            Ext.getCmp('intAnexo1PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo1LimpiarCasa').getValue()) + parseInt(Ext.getCmp('intAnexo1VestirseDesvestirse').getValue()) + parseInt(Ext.getCmp('intAnexo1PrepararComida').getValue()) + parseInt(Ext.getCmp('intAnexo1Banarse').getValue()) + parseInt(Ext.getCmp('intAnexo1Compra').getValue()) + parseInt(Ext.getCmp('intAnexo1SentarseLevantarse').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarEscaleras').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarBarrio').getValue()) + parseInt(Ext.getCmp('intAnexo1CogerAltooSuelo').getValue()) + parseInt(Ext.getCmp('intAnexo1ContestarTelefono').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieResbaladiza').getValue())+ parseInt(Ext.getCmp('intAnexo1VisitarAmigo').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarMultitud').getValue()) + parseInt(Ext.getCmp('intAnexo1CaminarSuperficieIrregular').getValue()) + parseInt(Ext.getCmp('intAnexo1SubirBajarRampa').getValue()) + parseInt(Ext.getCmp('intAnexo1EventoSocial').getValue()))
                        }
                    }
                }
            },
            {
                html: '<br><hr><br>'
            },
            {
                xtype: 'numberfield',
                name: 'Puntaje Total',
                fieldLabel: 'Puntaje Total',
                width: 50,
                minValue: 0,
                decimalPrecision: 0,
                allowBlank: true,
                value: 0,
                id: 'intAnexo1PuntajeTotal'
            },
        ];
        fsEscalaAutoeficaciaUi.superclass.initComponent.call(this);
    }
});
