/*
* @category    Fieldset ABC SOCIAL
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsABCSocialUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ABC SOCIAL',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    labelWidth: 200,
    id: 'fsABCSocial',
    initComponent: function() {
        
        var dataABCSocial = [
            ['Participa usted al menos tres veces por semana, en alguna actividad deportiva o hace ejercicio como nadar, trotar, jugar tenis, montar bicicleta, hacer bicicros u otras actividades, que le causen sudoracion o que lo dejen sin respiracion'],
            ['Camina usted, al menos tres veces a la semana, entre 9 y 20 cuadras (1.6 Km) sin descansar'],
            ['Camina usted, al menos tres veces a la semana al menos 8 cuadras (0.5 Km) sin descansar'],
            ['Ninguna de las Anteriores']
        ];
        var stABCSocial = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stABCSocial.loadData(dataABCSocial);
        
        
        var dataActividadesSocial = [
            ['0'],
            ['1'],
            ['2'],
            ['3'],
            ['4'],
            ['5'],
            ['6'],
            ['7'],
            ['8'],
            ['9'],
            ['+9']
        ];
        var stActividadesSocial = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stActividadesSocial.loadData(dataActividadesSocial);
        
        
        this.items = [
            {
                html: 'Marque solo una respuesta, la que mas se acerque a las condiciones del paciente'
            },
            {
                xtype: 'combo',
                name: 'ABC Social',
                anchor: '100%',
                allowBlank: true,
                store: stABCSocial,
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intAnexo2Alimentacion'
            },
            {
                html: '<br>Cuantas veces en los ultimos 12 meses ha visitado los siguientes sitios o ha tomado parte en los siguientes eventos'
            },
            {
                xtype: 'combo',
                name: 'Ceremonias familiares matrimonios, funerales, cumpleanos',
                fieldLabel: 'Ceremonias familiares matrimonios, funerales, cumpleanos',
                anchor: '100%',
                allowBlank: true,
                store: stActividadesSocial,
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intCeremoniasFamiliares'
            },
            {
                xtype: 'combo',
                name: 'Visitar Amigos',
                fieldLabel: 'Visitar Amigos',
                anchor: '100%',
                allowBlank: true,
                store: stActividadesSocial,
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intVisitarAmigos'
            },
            {
                xtype: 'combo',
                name: 'Actividades en asociaciones y clubes',
                fieldLabel: 'Actividades en asociaciones y clubes',
                anchor: '100%',
                allowBlank: true,
                store: stActividadesSocial,
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intActividadesAsociacioness'
            },
            {
                xtype: 'combo',
                name: 'Competensias deportivas (mirando o tomando parte)',
                fieldLabel: 'Competensias deportivas (mirando o tomando parte)',
                anchor: '100%',
                allowBlank: true,
                store: stActividadesSocial,
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intActividadesDeportivas'
            },
            {
                xtype: 'combo',
                name: 'Servicios Religiosos',
                fieldLabel: 'Servicios Religiosos',
                anchor: '100%',
                allowBlank: true,
                store: stActividadesSocial,
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intServiciosReligiosos'
            },
            {
                xtype: 'combo',
                name: 'Viajar a otro pais',
                fieldLabel: 'Viajar a otro pais',
                anchor: '100%',
                allowBlank: true,
                store: stActividadesSocial,
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intViajarPais'
            },
            {
                xtype: 'combo',
                name: 'Viajar dentro del mismo pais',
                fieldLabel: 'Viajar dentro del mismo pais',
                anchor: '100%',
                allowBlank: true,
                store: stActividadesSocial,
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'intViajarDentroPais'
            }
        ];
        fsABCSocialUi.superclass.initComponent.call(this);
    }
});
