winFrmHCCIVyC002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HISTORIA CLINICA DE INESTABILIDAD, VERTIGO Y CAIDAS - UNIVERSIDAD DE CALDAS ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        if (objMX !== "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    //pPaciente: Ext.getCmp('sysPacientePlantillaHC').getValue(),
                    //pCAS: Ext.getCmp('sysCASPlantillaHC').getValue()
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA !== "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    //pPaciente: Ext.getCmp('sysPacientePlantillaHC').getValue(),
                    //pCAS: Ext.getCmp('sysCASPlantillaHC').getValue()
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM !== "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    //pPaciente: Ext.getCmp('sysPacientePlantillaHC').getValue(),
                    //pCAS: Ext.getCmp('sysCASPlantillaHC').getValue()
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var pEquilibrioPiesJuntos = 0;
        var pEquilibrioSemitandem = 0;
        var pEquilibrioTandem = 0;
        var pIncorporarseSilla = 0;
        var pVelocidadMarcha = 0;
        
        var dataEquilibrioPiesJuntos = [
            ['Mantiene 10 seg'],
            ['No mantiene 10 seg'],
            ['No lo Intenta']
        ];
        var stEquilibrioPiesJuntos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEquilibrioPiesJuntos.loadData(dataEquilibrioPiesJuntos);
               
        
        var dataEquilibrioSemitandem = [
            ['Mantiene 10 seg'],
            ['no mantiene 10 seg'],
            ['No lo Intenta']
        ];
        var stEquilibrioSemitandem = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEquilibrioSemitandem.loadData(dataEquilibrioSemitandem);
               
        
        var dataIncorporarseSilla = [
            ['Incapaz de completar 5 o lo completa en > 60seg'],
            ['16,70 seg o mas'],
            ['13,70 seg a 16,69 seg'],
            ['11,20 seg a 13,69 seg'],
            ['11,19 seg o menos']
        ];
        var stIncorporarseSilla = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stIncorporarseSilla.loadData(dataIncorporarseSilla);
               
        
        var dataEquilibrioTandem = [
            ['Mantiene 10 seg'],
            ['Mantiene 3 - 9,99 seg'],
            ['no mantiene 10 seg'],
            ['No lo Intenta']
        ];
        var stEquilibrioTandem = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEquilibrioTandem.loadData(dataEquilibrioTandem);
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Genero',
                                width: '150',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysDatBasGeneroHC'
                            },
                            {
                                html: 'Edad: '
                            },
                            {
                                xtype: 'textfield',
                                width: '350',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysDatBasEdadHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        enableTabScroll: true, 
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                anchor: '100%',
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            //**************
                                            {
                                                xtype: 'fieldset',
                                                title: 'PRUEBA DE EQUILIBRIO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelWidth: 90,
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsPruebaEquilibrio',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Pies Juntos',
                                                        fieldLabel: 'Pies Juntos',
                                                        width: 300,
                                                        allowBlank: true,
                                                        store: stEquilibrioPiesJuntos,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intEquilibrioPiesJuntos',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == ''){
                                                                    pEquilibrioPiesJuntos = 0;
                                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                }else{
                                                                    if(pNew === 'Mantiene 10 seg' ){
                                                                        pEquilibrioPiesJuntos = 1;
                                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                    }else{
                                                                        pEquilibrioPiesJuntos = 0;
                                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Semitandem',
                                                        fieldLabel: 'Semitandem',
                                                        width: 300,
                                                        allowBlank: true,
                                                        store: stEquilibrioSemitandem,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intEquilibrioSemitandem',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == ''){
                                                                    pEquilibrioSemitandem = 0;
                                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                }else{
                                                                    if(pNew === 'Mantiene 10 seg' ){
                                                                        pEquilibrioSemitandem = 1;
                                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                    }else{
                                                                        pEquilibrioSemitandem = 0;
                                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Tandem',
                                                        fieldLabel: 'Tandem',
                                                        width: 300,
                                                        allowBlank: true,
                                                        store: stEquilibrioTandem,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intEquilibrioTandem',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == ''){
                                                                    pEquilibrioTandem = 0;
                                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                }else{
                                                                    if(pNew == 'Mantiene 10 seg' ){
                                                                        pEquilibrioTandem = 2;
                                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                    }else{
                                                                        if(pNew == 'Mantiene 3 - 9,99 seg' ){
                                                                            pEquilibrioTandem = 1;
                                                                            Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                        }else{
                                                                            pEquilibrioTandem = 0;
                                                                            Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PRUEBA DE VELOCIDAD DE LA MARCHA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelWidth: 90,
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsVelocidadMarcha',
                                                items: [
                                                    {
                                                        html: 'Distancia de la pueba'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Cuatro Metros',
                                                                name: 'Distancia Cuatro Metros',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolDistanciaCuatroMetros',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == true){
                                                                            Ext.getCmp('bolDistanciaTresMetros').setValue('false')
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Tres Metros'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Distancia Tres Metros',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolDistanciaTresMetros',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == true){
                                                                            Ext.getCmp('bolDistanciaCuatroMetros').setValue('false')
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        html: 'Tiempo para recorrer 3 o 4 Metros'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Tiempo para recorrer 3 o 4 Metros Primera Prueba',
                                                        fieldLabel: 'Primera Prueba',
                                                        emptyText: '___,___seg',
                                                        width: 100,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        id: 'intTiempoPrimeraPrueba',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == ''){
                                                                    pVelocidadMarcha = 0;
                                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                }else{
                                                                    if(Ext.getCmp('bolDistanciaCuatroMetros').getValue() == true && pNew >= 8.70 ){
                                                                        pVelocidadMarcha = 1;
                                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                    }else{
                                                                        if(Ext.getCmp('bolDistanciaCuatroMetros').getValue() == true && pNew >= 6.21 && pNew <= 8.70){
                                                                            pVelocidadMarcha = 2;
                                                                            Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                        }else{
                                                                            if(Ext.getCmp('bolDistanciaCuatroMetros').getValue() == true && pNew >= 4.82 && pNew <= 6.20){
                                                                                pVelocidadMarcha = 3;
                                                                                Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                            }else{
                                                                                if(Ext.getCmp('bolDistanciaCuatroMetros').getValue() == true && pNew <= 4.82){
                                                                                    pVelocidadMarcha = 4;
                                                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                                }else{
                                                                                    if(Ext.getCmp('bolDistanciaTresMetros').getValue() == true && pNew >= 6.52 ){
                                                                                        pVelocidadMarcha = 1;
                                                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                                    }else{
                                                                                        if(Ext.getCmp('bolDistanciaTresMetros').getValue() == true && pNew >= 4.66 && pNew <= 6.51){
                                                                                            pVelocidadMarcha = 2;
                                                                                            Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                                        }else{
                                                                                            if(Ext.getCmp('bolDistanciaTresMetros').getValue() == true && pNew >= 3.62 && pNew <= 4.65){
                                                                                                pVelocidadMarcha = 3;
                                                                                                Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                                            }else{
                                                                                                if(Ext.getCmp('bolDistanciaTresMetros').getValue() == true && pNew <= 3.62){
                                                                                                    pVelocidadMarcha = 4;
                                                                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Tiempo para recorrer 3 o 4 Metros Segunda Prueba',
                                                        fieldLabel: 'Segunda Prueba',
                                                        emptyText: '___,___seg',
                                                        width: 100,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        id: 'intTiempoSegundaPrueba'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        html: 'Ayudas para caminar:'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Ninguno',
                                                                name: 'Ninguno',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAyudaNinguno'
                                                            },
                                                            {
                                                                html: 'Baston'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Baston',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAyudaBaston'
                                                            },
                                                            {
                                                                html: 'Otra'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Otra',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAyudaOtra'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PRUEBA DE INCORPORARSE DE LA SILLA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                labelWidth: 10,
                                                padding: 5,
                                                id: 'fsIncorporarseSilla',
                                                items: [
                                                    {
                                                        html: 'Incorporarse de forma repetida 5 veces. Se cuenta cuando se sienta: '
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Incorporarse de forma repetida 5 veces',
                                                        width: 350,
                                                        height: 200,
                                                        allowBlank: true,
                                                        store: stIncorporarseSilla,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intIncorporarseSilla',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == ''){
                                                                    pIncorporarseSilla = 0;
                                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                }else{
                                                                    if(pNew == 'Incapaz de completar 5 o lo completa en > 60seg'){
                                                                        pIncorporarseSilla = 0;
                                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                    }else{
                                                                        if(pNew == '16,70 seg o mas'){
                                                                            pIncorporarseSilla = 1;
                                                                            Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                        }else{
                                                                            if(pNew == '13,70 seg a 16,69 seg'){
                                                                                pIncorporarseSilla = 2;
                                                                                Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                            }else{
                                                                                if(pNew == '11,20 seg a 13,69 seg'){
                                                                                    pIncorporarseSilla = 3;
                                                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                                }else{
                                                                                    if(pNew == '11,19 seg o menos'){
                                                                                        pIncorporarseSilla = 4;
                                                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                                    }else{
                                                                                        pIncorporarseSilla = 0;
                                                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },      
                                            {
                                                html: '<br><hr><br>'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'Puntaje Total',
                                                fieldLabel: 'Puntaje Total',
                                                width: 50,
                                                minValue: 0,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                value: 0,
                                                id: 'intAnexo8PuntajeTotal'
                                            }
                                            //**************
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imprimir Formula Anteojos',
                            iconCls: 'btnImprimir',
                            id: 'btnImprimirRxAnteojosHC',
                            listeners: {
                                click : function() {
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1) 
                                        window.open ("../../controlador/asistencial/cvmprintformularx.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pConsecutivoHC=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Formula de Anteojos");
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'button',
                            text: 'Imagenes Asociadas',
                            iconCls: 'btnCargarFoto',
                            listeners:{
                                click : function(){
                                    if(!winImgxPac){
                                        winImgxPac = new winImagenAsocxPac({
                                            url:'../../controlador/pacientes/controlador_filesasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winImgxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Documentos Asociados',
                            iconCls: 'btnCargarFile',
                            listeners:{
                                click : function(){
                                    if(!winDocxPac){
                                        winDocxPac = new winDocumentoAsocxPac({
                                            url:'../../controlador/pacientes/controlador_docsasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winDocxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnGuardarRegistrosCVM001();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnModificarRegistrosCVM001();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
            }}
        });
        winFrmHCCIVyC002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosCVM001(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosCVM001(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/controlador_cardiologia.php',
            params:{
                task: 'modificar_hc',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function ValidarAgudezaVisual(){
    var wError = 0;
    if((Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej1').getValue() === null || Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej1').getValue() === "") && (Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej2').getValue() === null || Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej2').getValue() === "")){
        wError = 1;
    }else{
        wError = 0;
    }
    if(wError === 0 && (Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej3').getValue() === null || Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej3').getValue() === "") && (Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej4').getValue() === null || Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej4').getValue() === "")){
        wError = 1;
    }else{
        wError = 0;
    }
    if(wError === 0 && (Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej7').getValue() === null || Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej7').getValue() === "") && (Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej8').getValue() === null || Ext.getCmp('strREFRACTIVO_OD_AVSINRXlej8').getValue() === "")){
        wError = 1;
    }else{
        wError = 0;
    }
    if(wError === 1){
        Ext.MessageBox.show({
            title: 'A.V. OD',
            msg: 'Debe registrar completamente algun tipo de Agudeza Visual',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function ValidarAgudezaVisualOI(){
    var wError = 0;
    if((Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej1').getValue() === null || Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej1').getValue() === "") && (Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej2').getValue() === null || Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej2').getValue() === "")){
        wError = 1;
    }else{
        wError = 0;
    }
    if(wError === 0 && (Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej3').getValue() === null || Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej3').getValue() === "") && (Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej4').getValue() === null || Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej4').getValue() === "")){
        wError = 1;
    }else{
        wError = 0;
    }
    if(wError === 0 && (Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej7').getValue() === null || Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej7').getValue() === "") && (Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej8').getValue() === null || Ext.getCmp('strREFRACTIVO_OI_AVSINRXlej8').getValue() === "")){
        wError = 1;
    }else{
        wError = 0;
    }
    if(wError === 1){
        Ext.MessageBox.show({
            title: 'A.V. OI',
            msg: 'Debe registrar completamente algun tipo de Agudeza Visual',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnSolicitarParaClinicosCVM001(pAccion,pCronico){
    var pPregunta = "";
    if(pAccion === "A"){
        pPregunta = "Esta seguro que desea ADICIONAR los paraclinicos?";
    }else{
        pPregunta = "Esta seguro que desea ELIMINAR los paraclinicos?";
    }
    Ext.Msg.show({
        title: 'eOfiClinic',
        msg: pPregunta,
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn){
            if(btn === "yes"){
                Ext.Ajax.request({
                    url: '../../controlador/asistencial/controlador_cvm.php',
                    params:{
                        task: 'SolExaPreCx',
                        pTarea: pAccion,
                        pCronico: pCronico,
                        pTipo: "E",
                        pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                        pIPS: Ext.getCmp('sysIPSHC').getValue(),
                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                        pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                        pCAS: Ext.getCmp('sysCASHC').getValue(),
                        pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                        pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()   
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); // get the LOG
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                            Ext.MessageBox.show({
                                title: 'OfiClinic',
                                msg: 'Error al cargar los registros de solicitud de paraclinicos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        } else {
                            Ext.getCmp('gridSolicitudesCVMxPaciente').store.load({
                                params: {
                                    task: 'VerExaSolicitadosxHC',
                                    pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                    pIPS: Ext.getCmp('sysIPSHC').getValue(),
                                    pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                    pCAS: Ext.getCmp('sysCASHC').getValue()
                                }
                            });
                        }
                    },
                    failure: function(response,options){
                        Ext.MessageBox.show({
                            title: 'OfiClinic - Base Datos',
                            msg: 'Error al cargar los registros de solicitud de paraclinicos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    },
                    scope:this
                });
            }
        }
    });
}