/*
* @category    Formulario Modelo Historia Odontologia - Semiologia Autonoma
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCAutonomaOdo001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Semiología - Universidad Autonoma de Manizales ::.',
    //title: 'eOfiClinic ©  .:: Semiología ::.',
    width: 990,
    height: 600,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {

        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        Ext.util.Format.Currency = function(v){
            return FormatoMoneda(v);
        };
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        function DescripcionNotasEvolucion(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr>';
            mostrarHC += '<tr><td>';
            switch(store.data.Ambito){
                case "1":
                    mostrarHC += 'Ambito: 1 - Ambulatorio';
                    break;
                case "2":
                    mostrarHC += 'Ambito: 2 - Hospitalario';
                    break;
                case "3":
                    mostrarHC += 'Ambito: 3 - Urgencias';
                    break;
                default:
                    break;
            }
            mostrarHC += '</td></tr>';
            mostrarHC += '<tr><td>';
            switch(store.data.Finalidad){
                case "1":
                    mostrarHC += 'Finalidad: 1 - Diagnostico';
                    break;
                case "2":
                    mostrarHC += 'Finalidad: 2 - Terapeutico';
                    break;
                case "3":
                    mostrarHC += 'Finalidad: 3 - Proteccion Especifica';
                    break;
                case "4":
                    mostrarHC += 'Finalidad: 4 - Deteccion Temprana de Enfermedad General';
                    break;
                case "5":
                    mostrarHC += 'Finalidad: 5 - Deteccion Temprana de Enfermedad Profesional';
                    break;
                default:
                    break;
            }
            mostrarHC += '</td></tr>';
            mostrarHC += '</table>';
            return mostrarHC;
        }
        
        
        var stGridDienteActividadesRealizadas = new StoreGridDienteActividadesRealizadas();
        stGridDienteActividadesRealizadas.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridDienteActividadesProxCita = new StoreGridDienteActividadesProxCita();
        stGridDienteActividadesProxCita.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridDienteActividadesProxCitaDetalle = new StoreGridDienteActividadesProxCitaDetalle();
        stGridDienteActividadesProxCitaDetalle.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridOdontogramasxPaciente = new StoreGridOdontogramasxPaciente();
        stGridOdontogramasxPaciente.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridNecesidadesAtencion = new StoreGridNecesidadesAtencion();
        stGridNecesidadesAtencion.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function VerInfoOdontograma(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('Profesional') + '</br>Tipo Odontograma:' + record.get('TipoOdontograma') + '</br>Tipo Denticion:' + record.get('TipoDenticion');
        }
        
        function VerInfoProxCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return 'CAS: ' + record.get('CAS') + '</br>' + record.get('Profesional') + '</br>Fecha:' + record.get('FechaAtencion');
        }
                
        var OdontogramaInical = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS,
                scripts:true,
                scope:this
            },
            id:'OdontogramaInical',
            height: 480,
            autoScroll:true,
            closable:false
        });
        
        //Store Locales
        var dataTipoDenticion = [
            ['TEMPORAL'],
            ['PERMANENTE'],
            ['MIXTA']
        ];
        var stTipoDenticion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoDenticion.loadData(dataTipoDenticion);
        
        var dataHigiene = [
            ['BUENO'],
            ['REGULAR'],
            ['MALO']
        ];
        var stHigiene = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stHigiene.loadData(dataHigiene);
        
        var dataRiesgo = [
            ['ALTO'],
            ['MEDIO'],
            ['BAJO']
        ];
        var stRiesgo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRiesgo.loadData(dataRiesgo);  
        
        var dataTipoPaciente = [
            ['PACIENTE INICIO TRATAMIENTO'],
            ['PACIENTE CONTROLADO'],
            ['PACIENTE INSTRUMENTADO'],
            ['PACIENTE CX']
        ];
        var stTipoPaciente = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoPaciente.loadData(dataTipoPaciente);        
        
        var dataFluorosis = [
            ['0 - NORMAL'],
            ['1 - DUDOSO'],
            ['2 - MUY LEVE'],
            ['3 - LEVE'],
            ['4 - MODERADA'],
            ['5 - SEVERA'],
            ['9 - NO APLICABLE']
        ];
        var stFluorosis = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stFluorosis.loadData(dataFluorosis);
        
        var dataNoCumpleCriteriosInclusion = [
            ['CONDICION BUCAL'],
            ['CONDICION SISTEMICA']
        ];
        var stNoCumpleCriteriosInclusion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stNoCumpleCriteriosInclusion.loadData(dataNoCumpleCriteriosInclusion);
        
        var ConvencionesOdontograma = new winConvencionesOdontogramaUi();
        var ViewOdontogramas = new winViewOdontogramasUi();
        var IdEstudiante = new fsIDEstudianteUi();
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                //padding: 10,
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        //width: 930,
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Anamnesis y Examen',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaAnamnesis',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmAnamnesis',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        renderTo: Ext.getBody(),
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysIdCodPlantillaHC'
                                            },
                                             {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                value: 1,
                                                id: 'sysUsaGridSalida'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                                value: 0,
                                                id: 'sysYaGuardoHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysPlantillaHC',
                                                name: 'PLANTILLA'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptMx'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptExa'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptRem'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Actividad',
                                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                                id: 'sysActividadHC',
                                                name: 'PLANTILLA'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Empresa',
                                                id: 'sysEmpresaHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'IPS',
                                                id: 'sysIPSHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Usuario',
                                                id: 'sysUsuarioHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Profesional',
                                                id: 'sysProfesionalHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                id: 'sysIdPacienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Apertura',
                                                id: 'sysAperturaHC'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Cliente',
                                                id: 'sysClienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdClienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdPlanHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdSubPlanHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdContratoHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroPacHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Edad',
                                                id: 'sysEdadPacHC'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Docente',
                                                id: 'sysProfesionalAgendaHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'ConsecutivoDetalle',
                                                id: 'sysConsecutivoDetalleHC'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'CAS',
                                                        id: 'sysCASHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysFechaHC',
                                                        value: 'Fecha: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysFechaHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysHoraHC',
                                                        value: 'Hora: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysHoraHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysLegalizacionHC',
                                                        value: 'Legalización: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysLegalizaHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                                id: 'sysPacienteHC'
                                            },
                                            {
                                                html: '<hr>',
                                                style: 'background:transparent;',
                                                border: false
                                            },
                                            IdEstudiante,
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DESCRIPCION DEL MOTIVO DE CONSULTA (cuál, signos y síntomas, evolución y tratamiento)',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'DESCRIPCION DEL MOTIVO DE CONSULTA (cuál, signos y síntomas, evolución y tratamiento)',
                                                        name: 'DESCRIPCION DEL MOTIVO DE CONSULTA (cuál, signos y síntomas, evolución y tratamiento)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,            
                                                        allowBlank: false,
                                                        id: 'memDescripcionMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES MÉDICOS PERSONALES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                labelWidth: 200,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        fieldLabel: 'Cuándo fue la última vez que asistió al médico?',
                                                        name: 'Cuándo fue la última vez que asistió al médico?',
                                                        id: 'strAMP_CuandoUltimaVezAsistio'
                                                    },  
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        fieldLabel: 'Cuál fue el motivo',
                                                        name: 'Cuál fue el motivo',
                                                        id: 'strAMP_CualFueMotivo'
                                                    },  
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Usted ha presentado reacciones alérgicas',
                                                                name: 'Usted ha presentado reacciones alérgicas',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAMP_ReaccionesAlergicas'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_1',
                                                                value: 'Cual:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 500,
                                                                allowBlank: true,
                                                                name: 'Cuál?',
                                                                id: 'strAMP_ReaccionesAlergicasCual'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'form',
                                                        frame: true,
                                                        anchor: '100%',
                                                        id: 'frmDetAntecedentesMedicos',
                                                        //padding: 10,
                                                        border: false,
                                                        autoScroll: true,
                                                        renderTo: Ext.getBody(),
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Antecedentes médicos',
                                                                autoHeight: true,
                                                                autoScroll: true,
                                                                anchor: '100%',
                                                                frame: true,
                                                                border: false,
                                                                layout: 'table',
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '1. T. Cardiovasculares',
                                                                                name: '1. T. Cardiovasculares',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_TCardiovasculares',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_TCardiovasculares').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_TCardiovasculares').setValue(null);
                                                                                            Ext.getCmp('memAMP_TCardiovasculares').disable();
                                                                                            Ext.getCmp('memAMP_TCardiovasculares').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_TCardiovasculares').enable();
                                                                                            Ext.getCmp('memAMP_TCardiovasculares').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 1. T. Cardiovasculares",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_TCardiovasculares'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '2. T. Renales',
                                                                                name: '2. T. Renales',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_TRenales',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_TRenales').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_TRenales').setValue(null);
                                                                                            Ext.getCmp('memAMP_TRenales').disable();
                                                                                            Ext.getCmp('memAMP_TRenales').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_TRenales').enable();
                                                                                            Ext.getCmp('memAMP_TRenales').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 2. T. Renales",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_TRenales'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '3. T. Metabólicos Endocrinos',
                                                                                name: '3. T. Metabólicos Endocrinos',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_TMetabolicosEndocrinos',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_TMetabolicosEndocrinos').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_TMetabolicosEndocrinos').setValue(null);
                                                                                            Ext.getCmp('memAMP_TMetabolicosEndocrinos').disable();
                                                                                            Ext.getCmp('memAMP_TMetabolicosEndocrinos').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_TMetabolicosEndocrinos').enable();
                                                                                            Ext.getCmp('memAMP_TMetabolicosEndocrinos').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 3. T. Metabólicos Endocrinos",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_TMetabolicosEndocrinos'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '4. T. Hematológicos',
                                                                                name: '4. T. Hematológicos',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_THematologicos',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_THematologicos').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_THematologicos').setValue(null);
                                                                                            Ext.getCmp('memAMP_THematologicos').disable();
                                                                                            Ext.getCmp('memAMP_THematologicos').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_THematologicos').enable();
                                                                                            Ext.getCmp('memAMP_THematologicos').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 4. T. Hematológicos",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_THematologicos'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '5. T. Respiratorios',
                                                                                name: '5. T. Respiratorios',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_TRespiratorios',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_TRespiratorios').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_TRespiratorios').setValue(null);
                                                                                            Ext.getCmp('memAMP_TRespiratorios').disable();
                                                                                            Ext.getCmp('memAMP_TRespiratorios').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_TRespiratorios').enable();
                                                                                            Ext.getCmp('memAMP_TRespiratorios').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 5. T. Respiratorios",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_TRespiratorios'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '6. T. Digestivos',
                                                                                name: '6. T. Digestivos',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_TDigestivos',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_TDigestivos').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_TDigestivos').setValue(null);
                                                                                            Ext.getCmp('memAMP_TDigestivos').disable();
                                                                                            Ext.getCmp('memAMP_TDigestivos').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_TDigestivos').enable();
                                                                                            Ext.getCmp('memAMP_TDigestivos').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 6. T. Digestivos",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_TDigestivos'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '7. T. Mentales',
                                                                                name: '7. T. Mentales',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_TMentales',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_TMentales').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_TMentales').setValue(null);
                                                                                            Ext.getCmp('memAMP_TMentales').disable();
                                                                                            Ext.getCmp('memAMP_TMentales').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_TMentales').enable();
                                                                                            Ext.getCmp('memAMP_TMentales').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 7. T. Mentales",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_TMentales'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '8. T. Neurológicos',
                                                                                name: '8. T. Neurológicos',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_TNeurologicos',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_TNeurologicos').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_TNeurologicos').setValue(null);
                                                                                            Ext.getCmp('memAMP_TNeurologicos').disable();
                                                                                            Ext.getCmp('memAMP_TNeurologicos').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_TNeurologicos').enable();
                                                                                            Ext.getCmp('memAMP_TNeurologicos').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 8. T. Neurológicos",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_TNeurologicos'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '9. E. Infectocontagiosa',
                                                                                name: '9. E. Infectocontagiosa',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_EInfectocontagiosa',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_EInfectocontagiosa').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_EInfectocontagiosa').setValue(null);
                                                                                            Ext.getCmp('memAMP_EInfectocontagiosa').disable();
                                                                                            Ext.getCmp('memAMP_EInfectocontagiosa').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_EInfectocontagiosa').enable();
                                                                                            Ext.getCmp('memAMP_EInfectocontagiosa').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 9. E. Infectocontagiosa",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_EInfectocontagiosa'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '10. Neoplasias',
                                                                                name: '10. Neoplasias',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_Neoplasias',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_Neoplasias').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_Neoplasias').setValue(null);
                                                                                            Ext.getCmp('memAMP_Neoplasias').disable();
                                                                                            Ext.getCmp('memAMP_Neoplasias').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_Neoplasias').enable();
                                                                                            Ext.getCmp('memAMP_Neoplasias').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 10. Neoplasias",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_Neoplasias'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '11. Anomalías Congénitas',
                                                                                name: '11. Anomalías Congénitas',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_AnomaliasCongenitas',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_AnomaliasCongenitas').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_AnomaliasCongenitas').setValue(null);
                                                                                            Ext.getCmp('memAMP_AnomaliasCongenitas').disable();
                                                                                            Ext.getCmp('memAMP_AnomaliasCongenitas').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_AnomaliasCongenitas').enable();
                                                                                            Ext.getCmp('memAMP_AnomaliasCongenitas').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 11. Anomalías Congénitas",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_AnomaliasCongenitas'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '12. Transf. Sanguíneas',
                                                                                name: '12. Transf. Sanguíneas',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_TransfSanguineas',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_TransfSanguineas').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_TransfSanguineas').setValue(null);
                                                                                            Ext.getCmp('memAMP_TransfSanguineas').disable();
                                                                                            Ext.getCmp('memAMP_TransfSanguineas').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_TransfSanguineas').enable();
                                                                                            Ext.getCmp('memAMP_TransfSanguineas').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 12. Transf. Sanguíneas",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_TransfSanguineas'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '13. Discapacidad',
                                                                                name: '13. Discapacidad',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_Discapacidad',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_Discapacidad').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_Discapacidad').setValue(null);
                                                                                            Ext.getCmp('memAMP_Discapacidad').disable();
                                                                                            Ext.getCmp('memAMP_Discapacidad').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_Discapacidad').enable();
                                                                                            Ext.getCmp('memAMP_Discapacidad').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 13. Discapacidad",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_Discapacidad'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '14. Cirugías',
                                                                                name: '14. Cirugías',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_Cirugias',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_Cirugias').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_Cirugias').setValue(null);
                                                                                            Ext.getCmp('memAMP_Cirugias').disable();
                                                                                            Ext.getCmp('memAMP_Cirugias').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_Cirugias').enable();
                                                                                            Ext.getCmp('memAMP_Cirugias').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 14. Cirugías",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_Cirugias'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '15. Hospitalizaciones',
                                                                                name: '15. Hospitalizaciones',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_Hospitalizaciones',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_Hospitalizaciones').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_Hospitalizaciones').setValue(null);
                                                                                            Ext.getCmp('memAMP_Hospitalizaciones').disable();
                                                                                            Ext.getCmp('memAMP_Hospitalizaciones').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_Hospitalizaciones').enable();
                                                                                            Ext.getCmp('memAMP_Hospitalizaciones').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 15. Hospitalizaciones",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_Hospitalizaciones'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '16. Medicación Actual',
                                                                                name: '16. Medicación Actual',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_MedicacionActual',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_MedicacionActual').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_MedicacionActual').setValue(null);
                                                                                            Ext.getCmp('memAMP_MedicacionActual').disable();
                                                                                            Ext.getCmp('memAMP_MedicacionActual').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_MedicacionActual').enable();
                                                                                            Ext.getCmp('memAMP_MedicacionActual').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 16. Medicación Actual",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_MedicacionActual'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '17. T. Alimentarios',
                                                                                name: '17. T. Alimentarios',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_TAlimentarios',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_TAlimentarios').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_TAlimentarios').setValue(null);
                                                                                            Ext.getCmp('memAMP_TAlimentarios').disable();
                                                                                            Ext.getCmp('memAMP_TAlimentarios').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_TAlimentarios').enable();
                                                                                            Ext.getCmp('memAMP_TAlimentarios').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 17. T. Alimentarios",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_TAlimentarios'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '18. Otro',
                                                                                name: '18. Otro',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_Otro',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_Otro').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_Otro').setValue(null);
                                                                                            Ext.getCmp('memAMP_Otro').disable();
                                                                                            Ext.getCmp('memAMP_Otro').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_Otro').enable();
                                                                                            Ext.getCmp('memAMP_Otro').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 18. Otro",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_Otro'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Antecedentes Familiares',
                                                                autoHeight: true,
                                                                autoScroll: true,
                                                                anchor: '100%',
                                                                frame: true,
                                                                border: false,
                                                                layout: 'table',
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '19. Cardiopatías',
                                                                                name: '19. Cardiopatías',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMF_Cardiopatias',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMF_Cardiopatias').allowBlank = true;
                                                                                            Ext.getCmp('memAMF_Cardiopatias').setValue(null);
                                                                                            Ext.getCmp('memAMF_Cardiopatias').disable();
                                                                                            Ext.getCmp('memAMF_Cardiopatias').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMF_Cardiopatias').enable();
                                                                                            Ext.getCmp('memAMF_Cardiopatias').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 19. Cardiopatías",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMF_Cardiopatias'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '20. Hipertensión',
                                                                                name: '20. Hipertensión',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMF_HTA',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMF_HTA').allowBlank = true;
                                                                                            Ext.getCmp('memAMF_HTA').setValue(null);
                                                                                            Ext.getCmp('memAMF_HTA').disable();
                                                                                            Ext.getCmp('memAMF_HTA').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMF_HTA').enable();
                                                                                            Ext.getCmp('memAMF_HTA').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 20. Hipertensión",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMF_HTA'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '21. Diabetes',
                                                                                name: '21. Diabetes',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMF_Diabetes',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMF_Diabetes').allowBlank = true;
                                                                                            Ext.getCmp('memAMF_Diabetes').setValue(null);
                                                                                            Ext.getCmp('memAMF_Diabetes').disable();
                                                                                            Ext.getCmp('memAMF_Diabetes').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMF_Diabetes').enable();
                                                                                            Ext.getCmp('memAMF_Diabetes').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 21. Diabetes",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMF_Diabetes'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '22. Cancer',
                                                                                name: '22. Cancer',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMF_Cancer',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMF_Cancer').allowBlank = true;
                                                                                            Ext.getCmp('memAMF_Cancer').setValue(null);
                                                                                            Ext.getCmp('memAMF_Cancer').disable();
                                                                                            Ext.getCmp('memAMF_Cancer').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMF_Cancer').enable();
                                                                                            Ext.getCmp('memAMF_Cancer').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 22. Cancer",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMF_Cancer'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '23. Hepatitis',
                                                                                name: '23. Hepatitis',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMF_Hepatitis',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMF_Hepatitis').allowBlank = true;
                                                                                            Ext.getCmp('memAMF_Hepatitis').setValue(null);
                                                                                            Ext.getCmp('memAMF_Hepatitis').disable();
                                                                                            Ext.getCmp('memAMF_Hepatitis').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMF_Hepatitis').enable();
                                                                                            Ext.getCmp('memAMF_Hepatitis').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 23. Hepatitis",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMF_Hepatitis'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '24. Enf. Infectocont.',
                                                                                name: '24. Enf. Infectocont.',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMF_EInfectocontagio',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMF_EInfectocontagio').allowBlank = true;
                                                                                            Ext.getCmp('memAMF_EInfectocontagio').setValue(null);
                                                                                            Ext.getCmp('memAMF_EInfectocontagio').disable();
                                                                                            Ext.getCmp('memAMF_EInfectocontagio').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMF_EInfectocontagio').enable();
                                                                                            Ext.getCmp('memAMF_EInfectocontagio').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 24. Enf. Infectocont.",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMF_EInfectocontagio'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '25. Otros',
                                                                                name: '25. Otros',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMF_Otros',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMF_Otros').allowBlank = true;
                                                                                            Ext.getCmp('memAMF_Otros').setValue(null);
                                                                                            Ext.getCmp('memAMF_Otros').disable();
                                                                                            Ext.getCmp('memAMF_Otros').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMF_Otros').enable();
                                                                                            Ext.getCmp('memAMF_Otros').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 25. Otros",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMF_Otros'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Antecedentes Psicosociales',
                                                                autoHeight: true,
                                                                autoScroll: true,
                                                                anchor: '100%',
                                                                frame: true,
                                                                border: false,
                                                                layout: 'table',
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '26. Consumo de Sicoactivos',
                                                                                name: '26. Consumo de Sicoactivos',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_ConsumoSicoactivos',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_ConsumoSicoactivos').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_ConsumoSicoactivos').setValue(null);
                                                                                            Ext.getCmp('memAMP_ConsumoSicoactivos').disable();
                                                                                            Ext.getCmp('memAMP_ConsumoSicoactivos').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_ConsumoSicoactivos').enable();
                                                                                            Ext.getCmp('memAMP_ConsumoSicoactivos').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 26. Consumo de Sicoactivos",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_ConsumoSicoactivos'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '27. Consumo de Alcohol',
                                                                                name: '27. Consumo de Alcohol',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_ConsumoAlcohol',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_ConsumoAlcohol').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_ConsumoAlcohol').setValue(null);
                                                                                            Ext.getCmp('memAMP_ConsumoAlcohol').disable();
                                                                                            Ext.getCmp('memAMP_ConsumoAlcohol').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_ConsumoAlcohol').enable();
                                                                                            Ext.getCmp('memAMP_ConsumoAlcohol').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 27. Consumo de Alcohol",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_ConsumoAlcohol'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 210,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo', // col 2.1
                                                                                fieldLabel: '28. Consumo de Cigarrillo',
                                                                                name: '28. Consumo de Cigarrillo',
                                                                                width: 200,
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAMP_ConsumoCigarrillo',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        if(cmb.getValue() == "NO"){
                                                                                            Ext.getCmp('memAMP_ConsumoCigarrillo').allowBlank = true;
                                                                                            Ext.getCmp('memAMP_ConsumoCigarrillo').setValue(null);
                                                                                            Ext.getCmp('memAMP_ConsumoCigarrillo').disable();
                                                                                            Ext.getCmp('memAMP_ConsumoCigarrillo').clearInvalid();
                                                                                        }else{
                                                                                            Ext.getCmp('memAMP_ConsumoCigarrillo').enable();
                                                                                            Ext.getCmp('memAMP_ConsumoCigarrillo').allowBlank = false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel', // col 2.2-5
                                                                        width: 600,
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        border: false,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                emptyText: 'HALLAZGOS',
                                                                                name:"HALLAZGOS - 28. Consumo de Cigarrillo",
                                                                                disabled: true,
                                                                                height: 20,
                                                                                anchor: '99%',
                                                                                grow: true,
                                                                                growMin: 20,
                                                                                growMax: 400,
                                                                                allowBlank: true,
                                                                                id: 'memAMP_ConsumoCigarrillo'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        colspan: 2,
                                                                        labelWidth: 210,
                                                                        width: 810,
                                                                        layout: 'form',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                fieldLabel: '29. Tipo de Familia',
                                                                                name: '29. Tipo de Familia',
                                                                                allowBlank: false,
                                                                                id: 'strAMP_TipoFamilia'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        colspan: 2,
                                                                        labelWidth: 210,
                                                                        width: 810,
                                                                        layout: 'form',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                fieldLabel: '30. Rol Que Desempeña',
                                                                                name: '30. Rol Que Desempeña',
                                                                                allowBlank: false,
                                                                                id: 'strAMP_RolDesempena'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        colspan: 2,
                                                                        labelWidth: 210,
                                                                        width: 810,
                                                                        layout: 'form',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                fieldLabel: '31. Nutrición',
                                                                                name: '31. Nutrición',
                                                                                allowBlank: false,
                                                                                id: 'strAMP_Nutricion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        colspan: 2,
                                                                        labelWidth: 210,
                                                                        width: 810,
                                                                        layout: 'form',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                fieldLabel: '32. Otro',
                                                                                name: '32. Otro',
                                                                                allowBlank: false,
                                                                                id: 'strAMP_PsicoOtros'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES ODONTOLOGICOS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                labelWidth: 200,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        fieldLabel: 'Cuándo fue la última vez que asistió al odontólogo?',
                                                        name: 'Cuándo fue la última vez que asistió al odontólogo?',
                                                        id: 'strAOP_CuandoUltimaVezAsistio'
                                                    },  
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        fieldLabel: 'Cuál fue el motivo',
                                                        name: 'Cuál fue el motivo',
                                                        id: 'strAOP_CualFueMotivo'
                                                    },  
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 200,
                                                                allowBlank: false,
                                                                fieldLabel: 'Con qué frecuencia lo visita?',
                                                                name: 'Con qué frecuencia lo visita?',
                                                                id: 'strAOP_FrecuenciaVisita'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_2',
                                                                value: 'La experiencia en la atención odontológica fue:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'La experiencia en la atención odontológica fue',
                                                                allowBlank: false,
                                                                store: 'StoreBuenaRegularMalo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "BUENA",
                                                                id: 'strAOP_ExperienciaAtencion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'form',
                                                        frame: true,
                                                        anchor: '100%',
                                                        id: 'frmDetAntecedentesOdontologicos',
                                                        padding: 10,
                                                        border: false,
                                                        autoScroll: true,
                                                        renderTo: Ext.getBody(),
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Antecedentes Odontológicos',
                                                                autoHeight: true,
                                                                autoScroll: true,
                                                                anchor: '100%',
                                                                frame: true,
                                                                border: false,
                                                                layout: 'table',
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: 210,
                                                                        width: 400,
                                                                        height: 135,
                                                                        layout: 'form',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '1. Prevención',
                                                                                name: '1. Prevención',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_Prevencion'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '2. Operatoria',
                                                                                name: '2. Operatoria',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_Operatoria'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '3. Periodoncia',
                                                                                name: '3. Periodoncia',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_Periodoncia'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '4. Endodoncia',
                                                                                name: '4. Endodoncia',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_Endodoncia'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '5. Rehabilitación',
                                                                                name: '5. Rehabilitación',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_Rehabilitacion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: 210,
                                                                        width: 400,
                                                                        height: 135,
                                                                        layout: 'form',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '6. Cirugía',
                                                                                name: '6. Cirugía',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_Cirugia'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '7. Ortodoncia',
                                                                                name: '7. Ortodoncia',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_Ortodoncia'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '8. Tratamiento Temprano',
                                                                                name: '8. Tratamiento Temprano',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_Ortopedia'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '9. ATM',
                                                                                name: '9. ATM',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_ATM'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 240,
                                                                        height: 230,
                                                                        layout: 'form',
                                                                        title: 'Hábitos Orales',
                                                                        labelWidth: 145,
                                                                        frame: true,
                                                                        border: false,
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: '1. Succión Digital',
                                                                                name: '1. Succión Digital',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_SuccionDigital'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: '2. Onicofagia',
                                                                                name: '2. Onicofagia',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_Onicofagia'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: '3. Succión no nutritiva',
                                                                                name: '3. Succión no nutritiva',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_SuccionNoNutritiva'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: '4. Succión Labial',
                                                                                name: '4. Succión Labial',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_SuccionLavial'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: '5. Apretamiento',
                                                                                name: '5. Apretamiento',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_Apretamiento'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: '6. Mordedura de objetos',
                                                                                name: '6. Mordedura de objetos',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strAOP_MordeduraObjetos'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        width: 577,
                                                                        height: 230,
                                                                        labelWidth: 145,
                                                                        layout: 'form',
                                                                        title: 'Higiene Oral',
                                                                        frame: true,
                                                                        border: false,
                                                                        items: [
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 70,
                                                                                        fieldLabel: '1. Ha recibido educación  en salud oral?',
                                                                                        name: '1. Ha recibido educación  en salud oral?',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strAOP_EducacionSaludOral'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sys_3b1',
                                                                                        value: 'Qué:'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 130,
                                                                                        allowBlank: true,
                                                                                        name: 'Qué:',
                                                                                        id: 'strAOP_EducacionSaludOralQue'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 70,
                                                                                        name: '2. Se cepilla los dientes?',
                                                                                        fieldLabel: '2. Se cepilla los dientes?',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strAOP_SepillaDientes'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sys_3b2',
                                                                                        value: 'Frecuencia:'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 130,
                                                                                        allowBlank: true,
                                                                                        name: 'Frecuencia:',
                                                                                        id: 'strAOP_SepillaDientesFrecuencia'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 70,
                                                                                        fieldLabel: '3. Usa de seda dental?',
                                                                                        name: '3. Usa de seda dental?',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strAOP_UsaSedaDental'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sys_3b3',
                                                                                        value: 'Frecuencia:'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 130,
                                                                                        name: 'Frecuencia:',
                                                                                        id: 'strAOP_UsaSedaDentalFrecuencia'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 70,
                                                                                        fieldLabel: '4. Usa de crema dental?',
                                                                                        name: '4. Usa de crema dental?',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strAOP_UsaCremaDental'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sys_3b4',
                                                                                        value: 'Frecuencia:'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 130,
                                                                                        allowBlank: true,
                                                                                        name: 'Frecuencia:',
                                                                                        id: 'strAOP_UsaCremaDentalFrecuencia'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 70,
                                                                                        fieldLabel: '5. Usa enjuague oral?',
                                                                                        name: '5. Usa enjuague oral?',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strAOP_UsaEnjuagueOral'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sys_3b5',
                                                                                        value: 'Cual:'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        name: 'Cual:',
                                                                                        id: 'strAOP_UsaEnjuagueOralCual'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sys_3b5a',
                                                                                        value: 'Frecuencia:'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 130,
                                                                                        allowBlank: true,
                                                                                        name: 'Frecuencia:',
                                                                                        id: 'strAOP_UsaEnjuagueOralFrecuencia'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 70,
                                                                                        fieldLabel: '6. Usa otros elementos auxiliares?',
                                                                                        name: '6. Usa otros elementos auxiliares?',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strAOP_UsaElementosAuxiliares'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sys_3b6',
                                                                                        value: 'Cual:'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 130,
                                                                                        allowBlank: true,
                                                                                        name: 'Cual:',
                                                                                        id: 'strAOP_UsaElementosAuxiliaresCual'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FÍSICO',
                                                labelWidth: '150',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs6',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                fieldLabel: 'Presión arterial (mmHg)',
                                                                name:"Presión arterial (mmHg)",
                                                                id: 'intEF_PA'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_EF5',
                                                                value: 'Pulso (puls/min):'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name:"Pulso (puls/min)",
                                                                id: 'intEF_FC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_EF6',
                                                                value: 'Frecuencia Respiratoria:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name:"Frecuencia Respiratoria",
                                                                id: 'intEF_FR'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                fieldLabel: 'Talla (cm)',
                                                                name:"Talla (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Talla').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<18.5){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("BAJO PESO");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("PESO NORMAL");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                       Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                    }else{
                                                                                        Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_EF1',
                                                                value: 'Peso (Kg):'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(Kg)',
                                                                name:"Peso (Kg)",
                                                                id: 'intEF_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Peso').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<18.5){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("BAJO PESO");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("PESO NORMAL");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                       Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                    }else{
                                                                                        Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_EF2',
                                                                value: 'IMC:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 0,
                                                                name: "IMC",
                                                                id: 'intEF_IMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - Clasificación",
                                                                id: 'strEF_IMCClasificacon'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN EXTRAORAL E INTRAORAL',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs10',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: 'Valoración Estructuras Generales',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '1. Piel',
                                                                        name: '1. Piel',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Piel',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Piel').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Piel').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Piel').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Piel').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Piel').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Piel').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 1. Piel",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Piel'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '2. Ojos',
                                                                        name: '2. Ojos',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Ojos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ojos').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ojos').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ojos').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ojos').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ojos').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ojos').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 2. Ojos",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Ojos'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '3. Nariz',
                                                                        name: '3. Nariz',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Nariz',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Nariz').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Nariz').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Nariz').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Nariz').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Nariz').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Nariz').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 3. Nariz",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Nariz'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '4. Ganglios',
                                                                        name: '4. Ganglios',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Ganglios',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ganglios').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ganglios').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ganglios').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ganglios').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ganglios').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Ganglios').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 4. Ganglios",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Ganglios'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '5. Músculos cabeza y cuello',
                                                                        name: '5. Músculos cabeza y cuello',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_CabezaCuello',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_CabezaCuello').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_CabezaCuello').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_CabezaCuello').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_CabezaCuello').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_CabezaCuello').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_CabezaCuello').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 5. Músculos cabeza y cuello",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_CabezaCuello'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '6. ATM',
                                                                        name: '6. ATM',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_ATM',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_ATM').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_ATM').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_ATM').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_ATM').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_ATM').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_ATM').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 6. ATM",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_ATM'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '7. Respiración',
                                                                        name: '7. Respiración',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Respiracion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Respiracion').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Respiracion').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Respiracion').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Respiracion').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Respiracion').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Respiracion').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 7. Respiración",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Respiracion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '8. Deglución',
                                                                        name: '8. Deglución',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Deglucion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Deglucion').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Deglucion').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Deglucion').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Deglucion').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Deglucion').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Deglucion').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 8. Deglución",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Deglucion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '9. Labios',
                                                                        name: '9. Labios',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Labios',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Labios').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Labios').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Labios').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Labios').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Labios').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Labios').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 9. Labios",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Labios'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '10. Carrillos',
                                                                        name: '10. Carrillos',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Carrillos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Carrillos').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Carrillos').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Carrillos').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Carrillos').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Carrillos').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Carrillos').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 10. Carrillos",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Carrillos'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '11. Paladar',
                                                                        name: '11. Paladar',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Paladar',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Paladar').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Paladar').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Paladar').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Paladar').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Paladar').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Paladar').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 11. Paladar",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Paladar'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '12. Piso de Boca y lengua',
                                                                        name: '12. Piso de Boca y lengua',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_PisoBocaLengua',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PisoBocaLengua').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PisoBocaLengua').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PisoBocaLengua').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PisoBocaLengua').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PisoBocaLengua').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PisoBocaLengua').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 12. Piso de Boca y lengua",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_PisoBocaLengua'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '13.  Surco yugal',
                                                                        name: '13.  Surco yugal',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_SurcoYugal',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_SurcoYugal').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_SurcoYugal').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_SurcoYugal').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_SurcoYugal').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_SurcoYugal').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_SurcoYugal').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 13.  Surco yugal",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_SurcoYugal'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '14. Orofaringe',
                                                                        name: '14. Orofaringe',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Orofaringe',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Orofaringe').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Orofaringe').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Orofaringe').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Orofaringe').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Orofaringe').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Orofaringe').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 14. Orofaringe",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Orofaringe'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '15. Glándulas salivares',
                                                                        name: '15. Glándulas salivares',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_GlandilasSalivares',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_GlandilasSalivares').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_GlandilasSalivares').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_GlandilasSalivares').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_GlandilasSalivares').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_GlandilasSalivares').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_GlandilasSalivares').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 15. Glándulas salivares",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_GlandilasSalivares'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '16. Periodonto',
                                                                        name: '16. Periodonto',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Periodonto',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Periodonto').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Periodonto').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Periodonto').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Periodonto').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Periodonto').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Periodonto').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 16. Periodonto",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Periodonto'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '17. Placa Bacteriana',
                                                                        name: '17. Placa Bacteriana',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_PlacaBacteriana',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PlacaBacteriana').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PlacaBacteriana').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PlacaBacteriana').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PlacaBacteriana').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PlacaBacteriana').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_PlacaBacteriana').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 17. Placa Bacteriana",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_PlacaBacteriana'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '18. Bolsa',
                                                                        name: '18. Bolsa',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Bolsa',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Bolsa').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Bolsa').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Bolsa').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Bolsa').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Bolsa').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Bolsa').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 18. Bolsa",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Bolsa'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '19. Cálculos',
                                                                        name: '19. Cálculos',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Calculos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Calculos').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Calculos').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Calculos').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Calculos').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Calculos').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Calculos').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 19. Cálculos",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Calculos'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '20. Movilidad',
                                                                        name: '20. Movilidad',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Movilidad',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Movilidad').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Movilidad').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Movilidad').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Movilidad').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Movilidad').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Movilidad').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 20. Movilidad",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Movilidad'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '21. Malposición dental',
                                                                        name: '21. Malposición dental',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_MalPosicionDental',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_MalPosicionDental').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_MalPosicionDental').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_MalPosicionDental').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_MalPosicionDental').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_MalPosicionDental').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_MalPosicionDental').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 21. Malposición dental",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_MalPosicionDental'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '22. Maloclusión',
                                                                        name: '22. Maloclusión',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Maloclusion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Maloclusion').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Maloclusion').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Maloclusion').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Maloclusion').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Maloclusion').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Maloclusion').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 22. Maloclusión",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Maloclusion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '23. Alteración estructura dental',
                                                                        name: '23. Alteración estructura dental',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_AlteraEstructuraDental',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_AlteraEstructuraDental').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_AlteraEstructuraDental').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_AlteraEstructuraDental').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_AlteraEstructuraDental').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_AlteraEstructuraDental').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_AlteraEstructuraDental').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 23. Alteración estructura dental",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_AlteraEstructuraDental'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '24. Dolor dental',
                                                                        name: '24. Dolor dental',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_DolorDental',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_DolorDental').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_DolorDental').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_DolorDental').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_DolorDental').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_DolorDental').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_DolorDental').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 24. Dolor dental",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_DolorDental'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: '25. Otros',
                                                                        name: '25. Otros',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NORMAL",
                                                                        id: 'strEXAEXTRAINTRA_Otro',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Otro').allowBlank = true;
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Otro').setValue(null);
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Otro').disable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Otro').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Otro').enable();
                                                                                    Ext.getCmp('memEXAEXTRAINTRA_Otro').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 25. Otro",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXAEXTRAINTRA_Otro'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANALISIS DE RADIOGRAFIA PANORÁMICA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs21',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: 'Zona 1: NASOMAXILAR',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Piso de Orbita',
                                                                        name: 'Piso de Orbita',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_PisoOrbita',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_PisoOrbitaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_PisoOrbitaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_PisoOrbitaH').disable();
                                                                                    Ext.getCmp('memRXPANO1_PisoOrbitaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_PisoOrbitaH').enable();
                                                                                    Ext.getCmp('memRXPANO1_PisoOrbitaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Piso de Orbita",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_PisoOrbitaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Arco cigomático',
                                                                        name: 'Arco cigomático',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_ArcoCigomatico',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_ArcoCigomaticoH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_ArcoCigomaticoH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_ArcoCigomaticoH').disable();
                                                                                    Ext.getCmp('memRXPANO1_ArcoCigomaticoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_ArcoCigomaticoH').enable();
                                                                                    Ext.getCmp('memRXPANO1_ArcoCigomaticoH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Arco cigomático",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_ArcoCigomaticoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Tabique nasal',
                                                                        name: 'Tabique nasal',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_TabiqueNasal',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_TabiqueNasalH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_TabiqueNasalH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_TabiqueNasalH').disable();
                                                                                    Ext.getCmp('memRXPANO1_TabiqueNasalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_TabiqueNasalH').enable();
                                                                                    Ext.getCmp('memRXPANO1_TabiqueNasalH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Tabique nasal",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_TabiqueNasalH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Cornetes',
                                                                        name: 'Cornetes',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_Cornetes',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_CornetesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_CornetesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_CornetesH').disable();
                                                                                    Ext.getCmp('memRXPANO1_CornetesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_CornetesH').enable();
                                                                                    Ext.getCmp('memRXPANO1_CornetesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Cornetes",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_CornetesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Luz de la vía aérea',
                                                                        name: 'Luz de la vía aérea',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_LuzViaAerea',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_LuzViaAereaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_LuzViaAereaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_LuzViaAereaH').disable();
                                                                                    Ext.getCmp('memRXPANO1_LuzViaAereaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_LuzViaAereaH').enable();
                                                                                    Ext.getCmp('memRXPANO1_LuzViaAereaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Luz de la vía aérea",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_LuzViaAereaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Senos maxilares',
                                                                        name: 'Senos maxilares',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_SenosMaxilares',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_SenosMaxilaresH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_SenosMaxilaresH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_SenosMaxilaresH').disable();
                                                                                    Ext.getCmp('memRXPANO1_SenosMaxilaresH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_SenosMaxilaresH').enable();
                                                                                    Ext.getCmp('memRXPANO1_SenosMaxilaresH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Senos maxilares",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_SenosMaxilaresH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Trabeculado óseo',
                                                                        name: 'Trabeculado óseo',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_TrabeculadoOseo',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_TrabeculadoOseoH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_TrabeculadoOseoH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_TrabeculadoOseoH').disable();
                                                                                    Ext.getCmp('memRXPANO1_TrabeculadoOseoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_TrabeculadoOseoH').enable();
                                                                                    Ext.getCmp('memRXPANO1_TrabeculadoOseoH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Trabeculado óseo",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_TrabeculadoOseoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Continuidad de la cortical ósea',
                                                                        name: 'Continuidad de la cortical ósea',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_ContinuidadCorticalOsea',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_ContinuidadCorticalOseaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_ContinuidadCorticalOseaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_ContinuidadCorticalOseaH').disable();
                                                                                    Ext.getCmp('memRXPANO1_ContinuidadCorticalOseaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_ContinuidadCorticalOseaH').enable();
                                                                                    Ext.getCmp('memRXPANO1_ContinuidadCorticalOseaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Continuidad de la cortical ósea",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_ContinuidadCorticalOseaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Altura ósea',
                                                                        name: 'Altura ósea',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_AlturaOsea',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_AlturaOseaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_AlturaOseaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_AlturaOseaH').disable();
                                                                                    Ext.getCmp('memRXPANO1_AlturaOseaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_AlturaOseaH').enable();
                                                                                    Ext.getCmp('memRXPANO1_AlturaOseaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Altura ósea",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_AlturaOseaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Densidad ósea',
                                                                        name: 'Densidad ósea',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_DensidadOsea',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_DensidadOseaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_DensidadOseaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_DensidadOseaH').disable();
                                                                                    Ext.getCmp('memRXPANO1_DensidadOseaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_DensidadOseaH').enable();
                                                                                    Ext.getCmp('memRXPANO1_DensidadOseaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Densidad ósea",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_DensidadOseaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Paladar duro',
                                                                        name: 'Paladar duro',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_PaladarDuro',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_PaladarDuroH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_PaladarDuroH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_PaladarDuroH').disable();
                                                                                    Ext.getCmp('memRXPANO1_PaladarDuroH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_PaladarDuroH').enable();
                                                                                    Ext.getCmp('memRXPANO1_PaladarDuroH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Paladar duro",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_PaladarDuroH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Espina nasal anterior',
                                                                        name: 'Espina nasal anterior',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_EspinaNasalAnterior',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_EspinaNasalAnteriorH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_EspinaNasalAnteriorH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_EspinaNasalAnteriorH').disable();
                                                                                    Ext.getCmp('memRXPANO1_EspinaNasalAnteriorH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_EspinaNasalAnteriorH').enable();
                                                                                    Ext.getCmp('memRXPANO1_EspinaNasalAnteriorH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Espina nasal anterior",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_EspinaNasalAnteriorH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Presencia de lesiones radiopacas',
                                                                        name: 'Presencia de lesiones radiopacas',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_PresenciaLesionesRadiopacas',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiopacasH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiopacasH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiopacasH').disable();
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiopacasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiopacasH').enable();
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiopacasH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Presencia de lesiones radiopacas",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_PresenciaLesionesRadiopacasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Presencia de lesiones radiolúcidas',
                                                                        name: 'Presencia de lesiones radiolúcidas',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO1_PresenciaLesionesRadiolucidas',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiolucidasH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiolucidasH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiolucidasH').disable();
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiolucidasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiolucidasH').enable();
                                                                                    Ext.getCmp('memRXPANO1_PresenciaLesionesRadiolucidasH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Presencia de lesiones radiolúcidas",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO1_PresenciaLesionesRadiolucidasH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'Zona 2: ATM',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Cóndilos',
                                                                        name: 'Cóndilos',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO2_Condilos',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO2_CondilosH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO2_CondilosH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO2_CondilosH').disable();
                                                                                    Ext.getCmp('memRXPANO2_CondilosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO2_CondilosH').enable();
                                                                                    Ext.getCmp('memRXPANO2_CondilosH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Cóndilos",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO2_CondilosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Cavidad glenoidea',
                                                                        name: 'Cavidad glenoidea',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO2_CavidadGlenoidea',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO2_CavidadGlenoideaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO2_CavidadGlenoideaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO2_CavidadGlenoideaH').disable();
                                                                                    Ext.getCmp('memRXPANO2_CavidadGlenoideaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO2_CavidadGlenoideaH').enable();
                                                                                    Ext.getCmp('memRXPANO2_CavidadGlenoideaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Cavidad glenoidea",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO2_CavidadGlenoideaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Apófisis coronoides',
                                                                        name: 'Apófisis coronoides',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO2_ApofisisCoronoides',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO2_ApofisisCoronoidesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO2_ApofisisCoronoidesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO2_ApofisisCoronoidesH').disable();
                                                                                    Ext.getCmp('memRXPANO2_ApofisisCoronoidesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO2_ApofisisCoronoidesH').enable();
                                                                                    Ext.getCmp('memRXPANO2_ApofisisCoronoidesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Apófisis coronoides",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO2_ApofisisCoronoidesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Eminencia articular',
                                                                        name: 'Eminencia articular',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO2_EminenciaArticular',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO2_EminenciaArticularH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO2_EminenciaArticularH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO2_EminenciaArticularH').disable();
                                                                                    Ext.getCmp('memRXPANO2_EminenciaArticularH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO2_EminenciaArticularH').enable();
                                                                                    Ext.getCmp('memRXPANO2_EminenciaArticularH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Eminencia articular",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO2_EminenciaArticularH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'Zona 3: Mandíbula',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Cuerpo y rama de la mandíbula',
                                                                        name: 'Cuerpo y rama de la mandíbula',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_CuerpoRamaMandibula',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_CuerpoRamaMandíbulaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_CuerpoRamaMandíbulaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_CuerpoRamaMandíbulaH').disable();
                                                                                    Ext.getCmp('memRXPANO3_CuerpoRamaMandíbulaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_CuerpoRamaMandíbulaH').enable();
                                                                                    Ext.getCmp('memRXPANO3_CuerpoRamaMandíbulaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Cuerpo y rama de la mandíbula",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_CuerpoRamaMandíbulaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Contorno mandibular',
                                                                        name: 'Contorno mandibular',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_ContornoMandibular',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_ContornoMandibularH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_ContornoMandibularH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_ContornoMandibularH').disable();
                                                                                    Ext.getCmp('memRXPANO3_ContornoMandibularH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_ContornoMandibularH').enable();
                                                                                    Ext.getCmp('memRXPANO3_ContornoMandibularH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Contorno mandibular",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_ContornoMandibularH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Ángulo mandibular',
                                                                        name: 'Ángulo mandibular',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_AnguloMandibular',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_AnguloMandibularH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_AnguloMandibularH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_AnguloMandibularH').disable();
                                                                                    Ext.getCmp('memRXPANO3_AnguloMandibularH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_AnguloMandibularH').enable();
                                                                                    Ext.getCmp('memRXPANO3_AnguloMandibularH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Ángulo mandibular",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_AnguloMandibularH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Conductos dentarios inferiores',
                                                                        name: 'Conductos dentarios inferiores',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_ConductosDentariosInferiores',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_ConductosDentariosInferioresH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_ConductosDentariosInferioresH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_ConductosDentariosInferioresH').disable();
                                                                                    Ext.getCmp('memRXPANO3_ConductosDentariosInferioresH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_ConductosDentariosInferioresH').enable();
                                                                                    Ext.getCmp('memRXPANO3_ConductosDentariosInferioresH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Conductos dentarios inferiores",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_ConductosDentariosInferioresH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Agujeros mentonianos',
                                                                        name: 'Agujeros mentonianos',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_AgujerosMentonianos',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_AgujerosMentonianosH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_AgujerosMentonianosH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_AgujerosMentonianosH').disable();
                                                                                    Ext.getCmp('memRXPANO3_AgujerosMentonianosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_AgujerosMentonianosH').enable();
                                                                                    Ext.getCmp('memRXPANO3_AgujerosMentonianosH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Agujeros mentonianos",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_AgujerosMentonianosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Densidad ósea',
                                                                        name: 'Densidad ósea',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_DensidadOsea',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_DensidadOseaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_DensidadOseaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_DensidadOseaH').disable();
                                                                                    Ext.getCmp('memRXPANO3_DensidadOseaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_DensidadOseaH').enable();
                                                                                    Ext.getCmp('memRXPANO3_DensidadOseaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Densidad ósea",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_DensidadOseaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Trabeculado óseo',
                                                                        name: 'Trabeculado óseo',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_TrabeculadoOseo',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_TrabeculadoOseoH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_TrabeculadoOseoH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_TrabeculadoOseoH').disable();
                                                                                    Ext.getCmp('memRXPANO3_TrabeculadoOseoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_TrabeculadoOseoH').enable();
                                                                                    Ext.getCmp('memRXPANO3_TrabeculadoOseoH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Trabeculado óseo",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_TrabeculadoOseoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Continuidad de la cortical',
                                                                        name: 'Continuidad de la cortical',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_ContinuidadCortical',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_ContinuidadCorticalH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_ContinuidadCorticalH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_ContinuidadCorticalH').disable();
                                                                                    Ext.getCmp('memRXPANO3_ContinuidadCorticalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_ContinuidadCorticalH').enable();
                                                                                    Ext.getCmp('memRXPANO3_ContinuidadCorticalH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Continuidad de la cortical",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_ContinuidadCorticalH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Altura ósea',
                                                                        name: 'Altura ósea',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_AlturaOsea',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_AlturaOseaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_AlturaOseaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_AlturaOseaH').disable();
                                                                                    Ext.getCmp('memRXPANO3_AlturaOseaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_AlturaOseaH').enable();
                                                                                    Ext.getCmp('memRXPANO3_AlturaOseaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Altura ósea",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_AlturaOseaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Presencia de lesiones radiopacas',
                                                                        name: 'Presencia de lesiones radiopacas',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_PresenciaLesionesRadiopacas',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiopacasH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiopacasH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiopacasH').disable();
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiopacasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiopacasH').enable();
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiopacasH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Presencia de lesiones radiopacas",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_PresenciaLesionesRadiopacasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Presencia de lesiones radiolúcidas',
                                                                        name: 'Presencia de lesiones radiolúcidas',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO3_PresenciaLesionesRadiolucidas',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiolucidasH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiolucidasH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiolucidasH').disable();
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiolucidasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiolucidasH').enable();
                                                                                    Ext.getCmp('memRXPANO3_PresenciaLesionesRadiolucidasH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Presencia de lesiones radiolúcidas",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO3_PresenciaLesionesRadiolucidasH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'Zona 4 : Dientes Superiores',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Número de dientes presentes',
                                                                        name: 'Número de dientes presentes',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_DientesPresentes',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_DientesPresentesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_DientesPresentesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_DientesPresentesH').disable();
                                                                                    Ext.getCmp('memRXPANO4_DientesPresentesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_DientesPresentesH').enable();
                                                                                    Ext.getCmp('memRXPANO4_DientesPresentesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Número de dientes presentes",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_DientesPresentesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Se evalúa en caso de dentición mixta, o en niños con la dentición permanente completa',
                                                                        name: 'Se evalúa en caso de dentición mixta, o en niños con la dentición permanente completa',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_EstadioNolla',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_EstadioNollaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_EstadioNollaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_EstadioNollaH').disable();
                                                                                    Ext.getCmp('memRXPANO4_EstadioNollaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_EstadioNollaH').enable();
                                                                                    Ext.getCmp('memRXPANO4_EstadioNollaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Se evalúa en caso de dentición mixta, o en niños con la dentición permanente completa",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_EstadioNollaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Presencia de Supernumerarios',
                                                                        name: 'Presencia de Supernumerarios',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_PresenciaSupernumerarios',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_PresenciaSupernumerariosH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_PresenciaSupernumerariosH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_PresenciaSupernumerariosH').disable();
                                                                                    Ext.getCmp('memRXPANO4_PresenciaSupernumerariosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_PresenciaSupernumerariosH').enable();
                                                                                    Ext.getCmp('memRXPANO4_PresenciaSupernumerariosH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Presencia de Supernumerarios",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_PresenciaSupernumerariosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Agenesias',
                                                                        name: 'Agenesias',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_Agenesias',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_AgenesiasH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_AgenesiasH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_AgenesiasH').disable();
                                                                                    Ext.getCmp('memRXPANO4_AgenesiasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_AgenesiasH').enable();
                                                                                    Ext.getCmp('memRXPANO4_AgenesiasH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Agenesias",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_AgenesiasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Dientes retenidos incluidos  e impactados',
                                                                        name: 'Dientes retenidos incluidos  e impactados',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_DientesRetenidosIncluidosImpactados',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_DientesRetenidosIncluidosImpactadosH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_DientesRetenidosIncluidosImpactadosH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_DientesRetenidosIncluidosImpactadosH').disable();
                                                                                    Ext.getCmp('memRXPANO4_DientesRetenidosIncluidosImpactadosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_DientesRetenidosIncluidosImpactadosH').enable();
                                                                                    Ext.getCmp('memRXPANO4_DientesRetenidosIncluidosImpactadosH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Dientes retenidos incluidos  e impactados",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_DientesRetenidosIncluidosImpactadosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Malposiciones dentales',
                                                                        name: 'Malposiciones dentales',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_MalposicionesDentales',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_MalposicionesDentalesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_MalposicionesDentalesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_MalposicionesDentalesH').disable();
                                                                                    Ext.getCmp('memRXPANO4_MalposicionesDentalesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_MalposicionesDentalesH').enable();
                                                                                    Ext.getCmp('memRXPANO4_MalposicionesDentalesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Malposiciones dentales",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_MalposicionesDentalesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Imágenes Asociadas a Caries',
                                                                        name: 'Imágenes Asociadas a Caries',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_ImagenesAsociadasCaries',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasCariesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasCariesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasCariesH').disable();
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasCariesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasCariesH').enable();
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasCariesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Imágenes Asociadas a Caries",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_ImagenesAsociadasCariesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Imágenes Asociadas a la Presencia de Restauraciones',
                                                                        name: 'Imágenes Asociadas a la Presencia de Restauraciones',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_ImagenesAsociadasPresenciaRestauraciones',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesH').disable();
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesH').enable();
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Imágenes Asociadas a la Presencia de Restauraciones",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_ImagenesAsociadasPresenciaRestauracionesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Imágenes Asociadas a la Presencia de Restauraciones Coladas',
                                                                        name: 'Imágenes Asociadas a la Presencia de Restauraciones Coladas',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_ImagenesAsociadasPresenciaRestauracionesColadas',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesColadasH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesColadasH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesColadasH').disable();
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesColadasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesColadasH').enable();
                                                                                    Ext.getCmp('memRXPANO4_ImagenesAsociadasPresenciaRestauracionesColadasH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Imágenes Asociadas a la Presencia de Restauraciones Coladas",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_ImagenesAsociadasPresenciaRestauracionesColadasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Presencia de Endodoncias',
                                                                        name: 'Presencia de Endodoncias',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_PresenciaEndodoncias',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_PresenciaEndodonciasH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_PresenciaEndodonciasH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_PresenciaEndodonciasH').disable();
                                                                                    Ext.getCmp('memRXPANO4_PresenciaEndodonciasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_PresenciaEndodonciasH').enable();
                                                                                    Ext.getCmp('memRXPANO4_PresenciaEndodonciasH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Presencia de Endodoncias",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_PresenciaEndodonciasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Anomalías en la Anatomía Corono Radicular',
                                                                        name: 'Anomalías en la Anatomía Corono Radicular',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_AnomaliasAnatomiaCoronoRadicular',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_AnomaliasAnatomiaCoronoRadicularH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_AnomaliasAnatomiaCoronoRadicularH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_AnomaliasAnatomiaCoronoRadicularH').disable();
                                                                                    Ext.getCmp('memRXPANO4_AnomaliasAnatomiaCoronoRadicularH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_AnomaliasAnatomiaCoronoRadicularH').enable();
                                                                                    Ext.getCmp('memRXPANO4_AnomaliasAnatomiaCoronoRadicularH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Anomalías en la Anatomía Corono Radicular",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_AnomaliasAnatomiaCoronoRadicularH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Compromisos en furca',
                                                                        name: 'Compromisos en furca',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_CompromisosFurca',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_CompromisosFurcaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_CompromisosFurcaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_CompromisosFurcaH').disable();
                                                                                    Ext.getCmp('memRXPANO4_CompromisosFurcaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_CompromisosFurcaH').enable();
                                                                                    Ext.getCmp('memRXPANO4_CompromisosFurcaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Compromisos en furca",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_CompromisosFurcaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Lesiones periapicales',
                                                                        name: 'Lesiones periapicales',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO4_LesionesPeriapicales',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO4_LesionesPeriapicalesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO4_LesionesPeriapicalesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO4_LesionesPeriapicalesH').disable();
                                                                                    Ext.getCmp('memRXPANO4_LesionesPeriapicalesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO4_LesionesPeriapicalesH').enable();
                                                                                    Ext.getCmp('memRXPANO4_LesionesPeriapicalesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Lesiones periapicales",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO4_LesionesPeriapicalesH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'Zona 5: Dientes Inferiores',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Número de dientes presentes',
                                                                        name: 'Número de dientes presentes',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_DientesPresentes',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_DientesPresentesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_DientesPresentesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_DientesPresentesH').disable();
                                                                                    Ext.getCmp('memRXPANO5_DientesPresentesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_DientesPresentesH').enable();
                                                                                    Ext.getCmp('memRXPANO5_DientesPresentesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Número de dientes presentes",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_DientesPresentesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Se evalúa en caso de dentición mixta, o en niños con la dentición permanente completa',
                                                                        name: 'Se evalúa en caso de dentición mixta, o en niños con la dentición permanente completa',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_EstadioNolla',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_EstadioNollaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_EstadioNollaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_EstadioNollaH').disable();
                                                                                    Ext.getCmp('memRXPANO5_EstadioNollaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_EstadioNollaH').enable();
                                                                                    Ext.getCmp('memRXPANO5_EstadioNollaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Se evalúa en caso de dentición mixta, o en niños con la dentición permanente completa",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_EstadioNollaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Presencia de Supernumerarios',
                                                                        name: 'Presencia de Supernumerarios',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_PresenciaSupernumerarios',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_PresenciaSupernumerariosH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_PresenciaSupernumerariosH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_PresenciaSupernumerariosH').disable();
                                                                                    Ext.getCmp('memRXPANO5_PresenciaSupernumerariosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_PresenciaSupernumerariosH').enable();
                                                                                    Ext.getCmp('memRXPANO5_PresenciaSupernumerariosH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Presencia de Supernumerarios",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_PresenciaSupernumerariosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Agenesias',
                                                                        name: 'Agenesias',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_Agenesias',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_AgenesiasH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_AgenesiasH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_AgenesiasH').disable();
                                                                                    Ext.getCmp('memRXPANO5_AgenesiasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_AgenesiasH').enable();
                                                                                    Ext.getCmp('memRXPANO5_AgenesiasH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Agenesias",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_AgenesiasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Dientes retenidos incluidos  e impactados',
                                                                        name: 'Dientes retenidos incluidos  e impactados',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_DientesRetenidosIncluidosImpactados',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_DientesRetenidosIncluidosImpactadosH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_DientesRetenidosIncluidosImpactadosH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_DientesRetenidosIncluidosImpactadosH').disable();
                                                                                    Ext.getCmp('memRXPANO5_DientesRetenidosIncluidosImpactadosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_DientesRetenidosIncluidosImpactadosH').enable();
                                                                                    Ext.getCmp('memRXPANO5_DientesRetenidosIncluidosImpactadosH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Dientes retenidos incluidos  e impactados",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_DientesRetenidosIncluidosImpactadosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Malposiciones dentales',
                                                                        name: 'Malposiciones dentales',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_MalposicionesDentales',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_MalposicionesDentalesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_MalposicionesDentalesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_MalposicionesDentalesH').disable();
                                                                                    Ext.getCmp('memRXPANO5_MalposicionesDentalesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_MalposicionesDentalesH').enable();
                                                                                    Ext.getCmp('memRXPANO5_MalposicionesDentalesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Malposiciones dentales",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_MalposicionesDentalesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Imágenes Asociadas a Caries',
                                                                        name: 'Imágenes Asociadas a Caries',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_ImagenesAsociadasCaries',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasCariesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasCariesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasCariesH').disable();
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasCariesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasCariesH').enable();
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasCariesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Imágenes Asociadas a Caries",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_ImagenesAsociadasCariesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Imágenes Asociadas a la Presencia de Restauraciones',
                                                                        name: 'Imágenes Asociadas a la Presencia de Restauraciones',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_ImagenesAsociadasPresenciaRestauraciones',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesH').disable();
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesH').enable();
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Imágenes Asociadas a la Presencia de Restauraciones",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_ImagenesAsociadasPresenciaRestauracionesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Imágenes Asociadas a la Presencia de Restauraciones Coladas',
                                                                        name: 'Imágenes Asociadas a la Presencia de Restauraciones Coladas',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_ImagenesAsociadasPresenciaRestauracionesColadas',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesColadasH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesColadasH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesColadasH').disable();
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesColadasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesColadasH').enable();
                                                                                    Ext.getCmp('memRXPANO5_ImagenesAsociadasPresenciaRestauracionesColadasH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Imágenes Asociadas a la Presencia de Restauraciones Coladas",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_ImagenesAsociadasPresenciaRestauracionesColadasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Presencia de Endodoncias',
                                                                        name: 'Presencia de Endodoncias',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_PresenciaEndodoncias',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_PresenciaEndodonciasH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_PresenciaEndodonciasH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_PresenciaEndodonciasH').disable();
                                                                                    Ext.getCmp('memRXPANO5_PresenciaEndodonciasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_PresenciaEndodonciasH').enable();
                                                                                    Ext.getCmp('memRXPANO5_PresenciaEndodonciasH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Presencia de Endodoncias",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_PresenciaEndodonciasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Anomalías en la Anatomía Corono Radicular',
                                                                        name: 'Anomalías en la Anatomía Corono Radicular',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_AnomaliasAnatomiaCoronoRadicular',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_AnomaliasAnatomiaCoronoRadicularH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_AnomaliasAnatomiaCoronoRadicularH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_AnomaliasAnatomiaCoronoRadicularH').disable();
                                                                                    Ext.getCmp('memRXPANO5_AnomaliasAnatomiaCoronoRadicularH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_AnomaliasAnatomiaCoronoRadicularH').enable();
                                                                                    Ext.getCmp('memRXPANO5_AnomaliasAnatomiaCoronoRadicularH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Anomalías en la Anatomía Corono Radicular",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_AnomaliasAnatomiaCoronoRadicularH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Compromisos en furca',
                                                                        name: 'Compromisos en furca',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_CompromisosFurca',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_CompromisosFurcaH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_CompromisosFurcaH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_CompromisosFurcaH').disable();
                                                                                    Ext.getCmp('memRXPANO5_CompromisosFurcaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_CompromisosFurcaH').enable();
                                                                                    Ext.getCmp('memRXPANO5_CompromisosFurcaH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Compromisos en furca",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_CompromisosFurcaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 210,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Lesiones periapicales',
                                                                        name: 'Lesiones periapicales',
                                                                        width: 200,
                                                                        allowBlank: false,
                                                                        store: 'StoreAparenteNormalAnormal',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "APARENTE NORMALIDAD",
                                                                        id: 'strRXPANO5_LesionesPeriapicales',
                                                                        listeners:{
                                                                            /*select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "APARENTE NORMALIDAD"){
                                                                                    Ext.getCmp('memRXPANO5_LesionesPeriapicalesH').allowBlank = true;
                                                                                    Ext.getCmp('memRXPANO5_LesionesPeriapicalesH').setValue(null);
                                                                                    Ext.getCmp('memRXPANO5_LesionesPeriapicalesH').disable();
                                                                                    Ext.getCmp('memRXPANO5_LesionesPeriapicalesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memRXPANO5_LesionesPeriapicalesH').enable();
                                                                                    Ext.getCmp('memRXPANO5_LesionesPeriapicalesH').allowBlank = false;
                                                                                }
                                                                            }*/
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 600,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - Lesiones periapicales",
                                                                        disabled: false,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memRXPANO5_LesionesPeriapicalesH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        title: 'Fluorosis Dental - (Pacienes 12, 25, 35, 45, 55 y 65 Años)',
                                        frame: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        id: 'pnFLUOROSISDENTAL',
                                        border: true,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        layoutConfig: {
                                            columns: 12
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                anchor: '100%',
                                                layout: 'form',
                                                border: false,
                                                autoHeight: true,
                                                colspan: 12,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Cumple criterios de inclusión',
                                                                name: 'Cumple criterios de inclusión',
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strFLUOROSISCumpleCriteriosInclusion'
                                                            },
                                                            {
                                                                html: '¿Por que no cumple?'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Por que no cumple',
                                                                name: 'Por que no cumple',
                                                                allowBlank: true,
                                                                store: stNoCumpleCriteriosInclusion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strFLUOROSISCumpleCriteriosInclusionPorqueNo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '16',
                                                        name: 'Fluorosis Diente Nro: 16',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS16',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '15',
                                                        name: 'Fluorosis Diente Nro: 15',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS15',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '13',
                                                        name: 'Fluorosis Diente Nro: 13',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS13',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '12',
                                                        name: 'Fluorosis Diente Nro: 12',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS12',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '11',
                                                        name: 'Fluorosis Diente Nro: 11',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS11',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '21',
                                                        name: 'Fluorosis Diente Nro: 21',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS21',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '22',
                                                        name: 'Fluorosis Diente Nro: 22',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS22',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '23',
                                                        name: 'Fluorosis Diente Nro: 23',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS23',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '25',
                                                        name: 'Fluorosis Diente Nro: 25',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS25',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '26',
                                                        name: 'Fluorosis Diente Nro: 26',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS26',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '46',
                                                        name: 'Fluorosis Diente Nro: 46',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS46',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        html: ''
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 76,
                                                layout: 'form',
                                                labelAlign: 'top',
                                                border: false,
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '36',
                                                        name: 'Fluorosis Diente Nro: 36',
                                                        width: 75,
                                                        allowBlank: true,
                                                        store: stFluorosis,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFLUOROSIS36',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    CalcularIndiceDEAN();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                width: 150,
                                                layout: 'form',
                                                border: false,
                                                autoHeight: true,
                                                colspan: 12,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Indice DEAN',
                                                        name: 'Fluorosis Indice DEAN',
                                                        id: 'intFLUOROSISIndiceDEAN'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'form',
                                        title: 'Diagnosticos Presuntivos',
                                        frame: true,
                                        anchor: '100%',
                                        //height: 480,
                                        autoHeight: true,
                                        id: 'frmDxPresuntivos',
                                        padding: 10,
                                        border: true,
                                        autoScroll: true,
                                        renderTo: Ext.getBody(),
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: false,
                                                        fieldLabel: 'Diagnostico Principal',
                                                        id: 'sysDiagPpalHC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagPpalHCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Principal',
                                                        id: 'btnSearchDiagPpalHC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                        id: 'sysDiagRel1HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel1HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado1',
                                                        id: 'btnSearchDiagRel1HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                        id: 'sysDiagRel2HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel2HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado2',
                                                        id: 'btnSearchDiagRel2HC1',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                        id: 'sysDiagRel3HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel3HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado3',
                                                        id: 'btnSearchDiagRel3HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.4',
                                                        id: 'sysDiagRel4HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    Ext.Ajax.request(
                                                                    {
                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                        params:{
                                                                            task: 'BUSCAR',
                                                                            pCodigo: f.getValue().toUpperCase()
                                                                        },
                                                                        success: function(response,options)
                                                                        {
                                                                            var el = Ext.get('response'); // get the LOG
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                Ext.getCmp('sysDiagRel4HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel4CNom').setValue(null);
                                                                            } else {
                                                                                Ext.getCmp('sysDiagRel4HC').setValue(Contenido[0]);
                                                                                Ext.getCmp('sysDiagRel4HCNom').setValue(Contenido[1]);
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            var el = Ext.get('response');
                                                                            Ext.getCmp('sysDiagRel4HC').setValue(null);
                                                                            Ext.getCmp('sysDiagRel4HCNom').setValue(null);
                                                                        },
                                                                        scope:this //bind the callbacks
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel4HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado4',
                                                        id: 'btnSearchDiagRel4HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel4HC','sysDiagRel4HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.5',
                                                        id: 'sysDiagRel5HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    Ext.Ajax.request(
                                                                    {
                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                        params:{
                                                                            task: 'BUSCAR',
                                                                            pCodigo: f.getValue().toUpperCase()
                                                                        },
                                                                        success: function(response,options)
                                                                        {
                                                                            var el = Ext.get('response'); // get the LOG
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                Ext.getCmp('sysDiagRel5HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel5CNom').setValue(null);
                                                                            } else {
                                                                                Ext.getCmp('sysDiagRel5HC').setValue(Contenido[0]);
                                                                                Ext.getCmp('sysDiagRel5HCNom').setValue(Contenido[1]);
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            var el = Ext.get('response');
                                                                            Ext.getCmp('sysDiagRel5HC').setValue(null);
                                                                            Ext.getCmp('sysDiagRel5HCNom').setValue(null);
                                                                        },
                                                                        scope:this //bind the callbacks
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel5HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado5',
                                                        id: 'btnSearchDiagRel5HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel5HC','sysDiagRel5HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.6',
                                                        id: 'sysDiagRel6HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    Ext.Ajax.request(
                                                                    {
                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                        params:{
                                                                            task: 'BUSCAR',
                                                                            pCodigo: f.getValue().toUpperCase()
                                                                        },
                                                                        success: function(response,options)
                                                                        {
                                                                            var el = Ext.get('response'); // get the LOG
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                Ext.getCmp('sysDiagRel6HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel6CNom').setValue(null);
                                                                            } else {
                                                                                Ext.getCmp('sysDiagRel6HC').setValue(Contenido[0]);
                                                                                Ext.getCmp('sysDiagRel6HCNom').setValue(Contenido[1]);
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            var el = Ext.get('response');
                                                                            Ext.getCmp('sysDiagRel6HC').setValue(null);
                                                                            Ext.getCmp('sysDiagRel6HCNom').setValue(null);
                                                                        },
                                                                        scope:this //bind the callbacks
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel6HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado6',
                                                        id: 'btnSearchDiagRel6HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel6HC','sysDiagRel6HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.7',
                                                        id: 'sysDiagRel7HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    Ext.Ajax.request(
                                                                    {
                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                        params:{
                                                                            task: 'BUSCAR',
                                                                            pCodigo: f.getValue().toUpperCase()
                                                                        },
                                                                        success: function(response,options)
                                                                        {
                                                                            var el = Ext.get('response'); // get the LOG
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                Ext.getCmp('sysDiagRel7HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel7CNom').setValue(null);
                                                                            } else {
                                                                                Ext.getCmp('sysDiagRel7HC').setValue(Contenido[0]);
                                                                                Ext.getCmp('sysDiagRel7HCNom').setValue(Contenido[1]);
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            var el = Ext.get('response');
                                                                            Ext.getCmp('sysDiagRel7HC').setValue(null);
                                                                            Ext.getCmp('sysDiagRel7HCNom').setValue(null);
                                                                        },
                                                                        scope:this //bind the callbacks
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel7HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado7',
                                                        id: 'btnSearchDiagRel7HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel7HC','sysDiagRel7HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.8',
                                                        id: 'sysDiagRel8HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    Ext.Ajax.request(
                                                                    {
                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                        params:{
                                                                            task: 'BUSCAR',
                                                                            pCodigo: f.getValue().toUpperCase()
                                                                        },
                                                                        success: function(response,options)
                                                                        {
                                                                            var el = Ext.get('response'); // get the LOG
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                Ext.getCmp('sysDiagRel8HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel8CNom').setValue(null);
                                                                            } else {
                                                                                Ext.getCmp('sysDiagRel8HC').setValue(Contenido[0]);
                                                                                Ext.getCmp('sysDiagRel8HCNom').setValue(Contenido[1]);
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            var el = Ext.get('response');
                                                                            Ext.getCmp('sysDiagRel8HC').setValue(null);
                                                                            Ext.getCmp('sysDiagRel8HCNom').setValue(null);
                                                                        },
                                                                        scope:this //bind the callbacks
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel8HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado8',
                                                        id: 'btnSearchDiagRel8HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel8HC','sysDiagRel8HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.9',
                                                        id: 'sysDiagRel9HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    Ext.Ajax.request(
                                                                    {
                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                        params:{
                                                                            task: 'BUSCAR',
                                                                            pCodigo: f.getValue().toUpperCase()
                                                                        },
                                                                        success: function(response,options)
                                                                        {
                                                                            var el = Ext.get('response'); // get the LOG
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                Ext.getCmp('sysDiagRel9HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel9CNom').setValue(null);
                                                                            } else {
                                                                                Ext.getCmp('sysDiagRel9HC').setValue(Contenido[0]);
                                                                                Ext.getCmp('sysDiagRel9HCNom').setValue(Contenido[1]);
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            var el = Ext.get('response');
                                                                            Ext.getCmp('sysDiagRel9HC').setValue(null);
                                                                            Ext.getCmp('sysDiagRel9HCNom').setValue(null);
                                                                        },
                                                                        scope:this //bind the callbacks
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel9HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado9',
                                                        id: 'btnSearchDiagRel9HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel9HC','sysDiagRel9HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.10',
                                                        id: 'sysDiagRel10HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    Ext.Ajax.request(
                                                                    {
                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                        params:{
                                                                            task: 'BUSCAR',
                                                                            pCodigo: f.getValue().toUpperCase()
                                                                        },
                                                                        success: function(response,options)
                                                                        {
                                                                            var el = Ext.get('response'); // get the LOG
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                Ext.getCmp('sysDiagRel10HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel10CNom').setValue(null);
                                                                            } else {
                                                                                Ext.getCmp('sysDiagRel10HC').setValue(Contenido[0]);
                                                                                Ext.getCmp('sysDiagRel10HCNom').setValue(Contenido[1]);
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            var el = Ext.get('response');
                                                                            Ext.getCmp('sysDiagRel10HC').setValue(null);
                                                                            Ext.getCmp('sysDiagRel10HCNom').setValue(null);
                                                                        },
                                                                        scope:this //bind the callbacks
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel10HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado10',
                                                        id: 'btnSearchDiagRel10HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel10HC','sysDiagRel10HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo de Diagnostico',
                                                width:750,
                                                name: 'Tipo de Diagnostico',
                                                allowBlank: false,
                                                store: 'StoreTipoDiagnostico',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                value: 1,
                                                readOnly: true,
                                                id: 'sysTipoDiagosticoHC'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Finalidad Consulta',
                                                width:750,
                                                name: 'Finalidad Consulta',
                                                allowBlank: false,
                                                store: 'StoreFinalidadConsulta',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                value: 10,
                                                id: 'sysFinalidadConsultaHC'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Causa Externa',
                                                width:750,
                                                name: 'Causa Externa',
                                                allowBlank: false,
                                                store: 'StoreCausaExterna',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                value: 13,
                                                id: 'sysCausaExternaHC'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Carta Dental Inicial (LEY 38/93)',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaCartaDentalInicial',
                                tbar:{
                                    items: [
                                        {
                                            html: 'Tipo Denticion:'
                                        },
                                        {
                                            xtype: 'combo',
                                            width: 110,
                                            allowBlank: true,
                                            store: stTipoDenticion,
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'sysBtnTipoDenticion'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Crear Odontograma',
                                            iconCls: 'btnDiente',
                                            id: 'btnCrearOdontograma',
                                            listeners:{
                                                click : function(){
                                                    if (Ext.getCmp('sysYaGuardoHC').getValue() === 0){
                                                        Ext.Msg.show({
                                                            title: 'eOfiClinic',
                                                            msg: 'Debe guardar la evolucion antes de gererar el odontograma',
                                                            buttons: Ext.Msg.OK,
                                                            icon: Ext.Msg.ERROR
                                                        });
                                                    }else{
                                                        if(Ext.getCmp('sysBtnTipoDenticion').getValue() === "" || Ext.getCmp('sysBtnTipoDenticion').getValue() === null){
                                                            Ext.Msg.show({
                                                                title: 'eOfiClinic',
                                                                msg: 'Debe seleccionar el tipo de denticion',
                                                                buttons: Ext.Msg.OK,
                                                                icon: Ext.Msg.ERROR
                                                            });
                                                        }else{
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/odontograma/controlador_odontograma.php',
                                                                params:{
                                                                    task: 'OBTENER_ULTIMO_ODONTOGRAMA',
                                                                    pPaciente: wPaciente
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                        Ext.MessageBox.show({
                                                                            title: 'eOfiClinic',
                                                                            msg: 'Ocurrio un error al validar el odontograma del paciente.',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    } else {
                                                                        var idOdontograma = parseInt(Contenido[0]);
                                                                        var tipoOdontograma = "Inicial";
                                                                        if(idOdontograma !== 0){
                                                                            tipoOdontograma = "Control";
                                                                        }
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/odontograma/controlador_odontograma.php',
                                                                            params:{
                                                                                task: 'CREAR_ODONTOGRAMA',
                                                                                pPaciente: wPaciente,
                                                                                pIdOdontograma: idOdontograma,
                                                                                pTipoOdontograma: tipoOdontograma,
                                                                                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                                                                                pProfesional:  Ext.getCmp('sysProfesionalHC').getValue(),
                                                                                pCAS: wCAS,
                                                                                pCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                                                                                pTipoDenticion: Ext.getCmp('sysBtnTipoDenticion').getValue(),
                                                                                pUsuario: ID_USUARIO
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'eOfiClinic',
                                                                                        msg: 'Ocurrio un error al crear el odontograma del paciente.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                } else {
                                                                                    Ext.getCmp('gridOdontogramasxPaciente').store.reload();
                                                                                    var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                                                    updater.setDefaultUrl('../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS + '&pOdontograma=0');
                                                                                    updater.refresh();
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                Ext.MessageBox.show({
                                                                                    title: 'eOfiClinic',
                                                                                    msg: 'No podemos crear el odontograma y/o No se pudo establecer conexión con el servidor',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                            },
                                                                            scope:this 
                                                                        });
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error Conexión',
                                                                        msg: 'No podemos crear el odontograma y/o No se pudo establecer conexión con el servidor',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Ver Convenciones Odontograma',
                                            iconCls: 'btnDiente',
                                            listeners:{
                                                click : function(){
                                                    Ext.getCmp('winConvencionesOdontograma').show();
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                items: [
                                    {
                                        xtype: 'panel',
                                        border: false, 
                                        autoHeight: true,
                                        layout: {
                                            columns: 2,
                                            type: 'table'
                                        },
                                        items:[
                                            {
                                                xtype: 'panel',
                                                //title: 'Odontogramas',
                                                //autoHeight: true,
                                                autoScroll: true,
                                                width: 215,
                                                height: 470,
                                                frame: true,
                                                border: false,
                                                tbar:{
                                                    items: [
                                                        {
                                                            xtype: 'button',
                                                            text: 'Editar',
                                                            iconCls: 'btnEditRow',
                                                            id: 'btnEditOdontograma',
                                                            listeners:{
                                                                click : function(){
                                                                    if(Ext.getCmp('gridOdontogramasxPaciente').selModel.getCount() === 1){
                                                                        var selections = Ext.getCmp('gridOdontogramasxPaciente').selModel.getSelections();
                                                                        if(selections[0].json.CAS === wCAS){
                                                                            var oGridOdontograma = new GridEditOdontogramaUi();
                                                                            Ext.getCmp('gridEditOdontogramaHC').title = "CAS: " + selections[0].json.CAS + " Fecha: " + selections[0].json.FecReporte + " -Denticion: " + selections[0].json.TipoDenticion;
                                                                            Ext.getCmp('sysIdOdontogramaItemOdontograma').setValue(selections[0].json.IdConsecutivoOdontograma);
                                                                            Ext.getCmp('sysTipoDenticionItemOdontograma').setValue(selections[0].json.TipoDenticion);
                                                                            Ext.getCmp('gridEditOdontogramaHC').store.load({
                                                                                params: {
                                                                                    task: 'LOAD_DETALLEODONTOGRAMA',
                                                                                    pOdontograma: Ext.getCmp('sysIdOdontogramaItemOdontograma').getValue()
                                                                                }
                                                                            });
                                                                            oGridOdontograma.show();
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                            title: 'Odontograma',
                                                                            msg: 'Este Odontograma no se puede editar en estos momentos, porque pertenece a otra atencion ya realizada',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                        }
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'Debe seleccionar un registro',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        }
                                                    ]
                                                },
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        layout: 'fit',
                                                        id: 'gridOdontogramasxPaciente',
                                                        store: stGridOdontogramasxPaciente,
                                                        anchor: "98%",
                                                        height: 390,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Id',
                                                                sortable: false,
                                                                width: 100,
                                                                hidden: true,
                                                                hideable: false,
                                                                dataIndex: 'CAS',
                                                                id: 'CAS'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Fecha',
                                                                sortable: true,
                                                                width: 205,
                                                                dataIndex: 'FecReporte',
                                                                renderer: VerInfoOdontograma,
                                                                id: 'FecReporte'
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        listeners:{
                                                            rowclick : function(grid, fila, e){
                                                                var selections = grid.selModel.getSelections();
                                                                var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                                updater.setDefaultUrl('../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + selections[0].json.CAS + '&pOdontograma=' + selections[0].json.IdConsecutivoOdontograma);
                                                                updater.refresh();
                                                                if(selections[0].json.TipoDenticion === "PERMANENTE"){
                                                                    CalcularCOP(Ext.getCmp('sysIdPacienteHC').getValue(),"SI");
                                                                }else{
                                                                    if(selections[0].json.TipoDenticion === "TEMPORAL"){
                                                                        CalcularCEO(Ext.getCmp('sysIdPacienteHC').getValue(),"SI");
                                                                    }else{
                                                                        CalcularCOP(Ext.getCmp('sysIdPacienteHC').getValue(),"NO");
                                                                        CalcularCEO(Ext.getCmp('sysIdPacienteHC').getValue(),"NO");
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 745,
                                                height: 470,
                                                items: [
                                                    OdontogramaInical
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        title: 'Calculo Indices COP-D y COP-D Modificado',
                                        frame: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        id: 'pnCOP',
                                        padding: 10,
                                        border: true,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP - Sanos',
                                                        fieldLabel: 'Dientes - Sanos',
                                                        id: 'sysCOPSanos'
                                                    },
                                                    {
                                                        html: 'C1:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP - Caries No Cavitacional',
                                                        id: 'sysCOPC1'
                                                    },
                                                    {
                                                        html: 'C2:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP - Caries Cavitacional',
                                                        id: 'sysCOPC2'
                                                    },
                                                    {
                                                        html: 'O:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP - Obturados',
                                                        id: 'sysCOPO'
                                                    },
                                                    {
                                                        html: 'P:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP - Perdidos por Caries',
                                                        id: 'sysCOPP'
                                                    },
                                                    {
                                                        html: 'K:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP - No Presentes Otra Razon',
                                                        id: 'sysCOPK'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        html: 'Total Dientes Presentes (S+C1+C2+O)'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        fieldLabel: 'Calculo',
                                                        name: 'COP - Total Dientes Presentes (S+C1+C2+O)',
                                                        id: 'sysCOPTotalDientesPresentes'
                                                    },
                                                    {
                                                        html: 'COP (C2+O+P):'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP - (C2+O+P)',
                                                        id: 'sysCOPCOP'
                                                    },
                                                    {
                                                        html: 'COP MODIFICADO (C1+C2+O+P):'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP MODIFICADO - (C1+C2+O+P)',
                                                        id: 'sysCOPCOPM'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        title: 'Calculo Indices ceo-D y ceo-D Modificado',
                                        frame: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        id: 'pnCEO',
                                        padding: 10,
                                        border: true,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'ceo - Sanos',
                                                        fieldLabel: 'Dientes - Sanos',
                                                        id: 'sysceoSanos'
                                                    },
                                                    {
                                                        html: 'C1:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'ceo - Caries No Cavitacional',
                                                        id: 'sysceoC1'
                                                    },
                                                    {
                                                        html: 'C2:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'ceo - Caries Cavitacional',
                                                        id: 'sysceoC2'
                                                    },
                                                    {
                                                        html: 'O:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'ceo - Obturados',
                                                        id: 'sysceoO'
                                                    },
                                                    {
                                                        html: 'P:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'ceo - Perdidos por Caries',
                                                        id: 'sysceoP'
                                                    },
                                                    {
                                                        html: 'K:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'ceo - No Presentes Otra Razon',
                                                        id: 'sysceoK'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        html: 'Total Dientes Presentes (S+C1+C2+O)'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        fieldLabel: 'Calculo',
                                                        name: 'ceo - Total Dientes Presentes (S+C1+C2+O)',
                                                        id: 'sysceoTotalDientesPresentes'
                                                    },
                                                    {
                                                        html: 'ceo (C2+O+P):'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'ceo - (C2+O+P)',
                                                        id: 'sysceoceo'
                                                    },
                                                    {
                                                        html: 'ceo MODIFICADO (C1+C2+O+P):'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'ceo MODIFICADO - (C1+C2+O+P)',
                                                        id: 'sysceoceoM'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Necesidades de Atencion',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                layout: 'form',
                                id: 'fichaNecesidaeesAtencion',
                                items: [
                                    {
                                        xtype: 'grid',
                                        id: 'gridNecesidadesAtencion',
                                        store: stGridNecesidadesAtencion,
                                        anchor: "100%",
                                        height: 270,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoDientesActividad',
                                                id: 'IdConsecutivoDientesActividad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Sol',
                                                sortable: false,
                                                width: 110,
                                                dataIndex: 'FecSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Servicio',
                                                sortable: false,
                                                width: 270,
                                                dataIndex: 'Servicio'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Prioridad',
                                                sortable: false,
                                                width: 60,
                                                dataIndex: 'Prioridad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Necesidades Atencion',
                                                sortable: false,
                                                width: 370,
                                                dataIndex: 'NecesidadesAtencion',
                                                renderer: DescripcionGrid
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Estado',
                                                sortable: false,
                                                width: 80,
                                                dataIndex: 'Estado'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Quien Remite',
                                                sortable: false,
                                                width: 200,
                                                dataIndex: 'ProfeRemite'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Inicio',
                                                sortable: false,
                                                width: 110,
                                                dataIndex: 'FechaInicio'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Cierre',
                                                sortable: false,
                                                width: 110,
                                                dataIndex: 'FechaCierre'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Motivo Cierre',
                                                sortable: false,
                                                width: 2500,
                                                dataIndex: 'MotivoCierre',
                                                renderer: DescripcionGrid
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        viewConfig: {
                                            getRowClass: function(record, index) {
                                                switch (record.get('EstadoRegistro')){
                                                    case "0":
                                                        return 'NeceAten0';
                                                        break;
                                                    case "1":
                                                        return 'NeceAten1';
                                                        break;
                                                    case "2":
                                                        return 'NeceAten2';
                                                        break;
                                                    case "3":
                                                        return 'NeceAten3';
                                                        break;
                                                    default:
                                                        return;
                                                        break;
                                                }
                                            }
                                        },
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar',
                                                        iconCls: 'btnAddRow',
                                                        id: 'btnAddNecesidadAtencion',
                                                        listeners: {
                                                            click : function() {
                                                                if (Ext.getCmp('sysYaGuardoHC').getValue() === 1 || Ext.getCmp('sysYaGuardoHC').getValue() === "1"){
                                                                    var winAddNecesidadAtencion = new winAddNecesidadAtencionUi();
                                                                    Ext.getCmp('sysNuevoNesecidad').setValue(0);
                                                                    Ext.getCmp('intPrestadorNesecidad').setValue(ID_EMPRESA);
                                                                    Ext.getCmp('intIPSNesecidad').setValue(ID_IPS);
                                                                    Ext.getCmp('intProfesionalNesecidad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                    Ext.getCmp('intCASNesecidad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                    Ext.getCmp('intPacienteNesecidad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                    Ext.getCmp('intUsuarioNesecidad').setValue(ID_USUARIO);
                                                                    Ext.getCmp('strFechaSolNesecidad').setValue(Ext.getCmp('sysFechaHC').getValue());
                                                                    winAddNecesidadAtencion.show();
                                                                }else{
                                                                    Ext.Msg.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'Usted No ha Guardado la Evolución',
                                                                        buttons: Ext.Msg.OK,
                                                                        icon: Ext.Msg.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Editar',
                                                        iconCls: 'btnEditRow',
                                                        id: 'btnEditNecesidadAtencion',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(Ext.getCmp('gridNecesidadesAtencion').selModel.getCount()) === 1){
                                                                    var selections = Ext.getCmp('gridNecesidadesAtencion').selModel.getSelections();
                                                                    if(selections[0].json.EstadoRegistro === "1"){
                                                                        Ext.Msg.show({
                                                                            title: 'Necesidades Atencion',
                                                                            msg: 'Esta Seguro que Desea Modificar el Registro ' + selections[0].json.Servicio + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn === "yes"){
                                                                                    var winAddNecesidadAtencion = new winAddNecesidadAtencionUi();
                                                                                    Ext.getCmp('sysNuevoNesecidad').setValue(1);
                                                                                    Ext.getCmp('sysIdConsecutivoNesecidad').setValue(selections[0].json.IdConsecutivoNecesidad);
                                                                                    Ext.getCmp('intPrestadorNesecidad').setValue(ID_EMPRESA);
                                                                                    Ext.getCmp('intIPSNesecidad').setValue(ID_IPS);
                                                                                    Ext.getCmp('intProfesionalNesecidad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                                    Ext.getCmp('intCASNesecidad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                    Ext.getCmp('intPacienteNesecidad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                    Ext.getCmp('intUsuarioNesecidad').setValue(ID_USUARIO);
                                                                                    Ext.getCmp('strFechaSolNesecidad').setValue(Ext.getCmp('sysFechaHC').getValue());
                                                                                    Ext.getCmp('intServicioNesecidad').setValue(selections[0].json.Programa);
                                                                                    Ext.getCmp('intPrioridadNesecidad').setValue(selections[0].json.Prioridad);
                                                                                    Ext.getCmp('memNesecidad').setValue(selections[0].json.NecesidadesAtencion);
                                                                                    winAddNecesidadAtencion.show();
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'El registro no esta disponible para ser modificado',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos modificar el registro en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar',
                                                        iconCls: 'btnDelRow',
                                                        id: 'btnDelNecesidadAtencion',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(Ext.getCmp('gridNecesidadesAtencion').selModel.getCount()) === 1){
                                                                    var selections = Ext.getCmp('gridNecesidadesAtencion').selModel.getSelections();
                                                                    if(selections[0].json.EstadoRegistro === "1"){
                                                                        Ext.Msg.show({
                                                                            title: 'Necesidades Atencion',
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.Servicio + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn === "yes"){
                                                                                    fnEliminarRegItemNecesidadAtencion("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_NECESIDAD_ATENCION", pIdRegistroNecesidad: selections[0].json.IdConsecutivoNecesidad}, 'gridNecesidadesAtencion');
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'El registro no esta disponible para ser eliminado',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar el registro en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    new Ext.app.SearchField({
                                                        id: 'qryNecesidadesAtencion',
                                                        store: stGridNecesidadesAtencion,
                                                        ValparamP1: wPaciente,
                                                        emptyText: 'Escriba el criterio que desea buscar',
                                                        width: 120,
                                                        pLoadGrid: false,
                                                        pGrid: 'gridNecesidadesAtencion',
                                                        parrParam: {params:{pPaciente: wPaciente}}
                                                    })
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones Externas',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imagenes Asociadas',
                            iconCls: 'btnCargarFoto',
                            listeners:{
                                click : function(){
                                    if(!winImgxPac){
                                        winImgxPac = new winImagenAsocxPac({
                                            url:'../../controlador/pacientes/controlador_filesasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winImgxPac.show();
                                    ////// BORRAR DATA ANTERIOR
                                    Ext.getCmp('searchImgxPacNom').setValue(null);
                                    Ext.getCmp('searchImgxPacNota').setValue(null);
                                    Ext.getCmp('searchImgxPacSort').setValue("Nombre");
                                    stImagenxPac.removeAll(true);
                                    stImagenxPac.load({
                                        params:{
                                            task: 'LISTAR_IMAGENES',
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                            pNom: null,
                                            pNota: null,
                                            pOrden: 'Nombre'
                                        }
                                    });
                                    var detailEl = Ext.getCmp('img-detail-panel').body;
                                    detailEl.update('');
                                    ///////
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Documentos Asociados',
                            iconCls: 'btnCargarFile',
                            listeners:{
                                click : function(){
                                    if(!winDocxPac){
                                        winDocxPac = new winDocumentoAsocxPac({
                                            url:'../../controlador/pacientes/controlador_docsasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winDocxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCAutonomaOdo001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var infoValida = true;
    var frmANAM = Ext.getCmp('frmAnamnesis').getForm();
    var frmAM = Ext.getCmp('frmDetAntecedentesMedicos').getForm();
    var frmAO = Ext.getCmp('frmDetAntecedentesOdontologicos').getForm();
    var frmDX = Ext.getCmp('frmDxPresuntivos').getForm();
    
    if(!frmANAM.isValid()){
        infoValida = false;
    }
    if(!frmAM.isValid()){
        infoValida = false;
    }
    if(!frmAO.isValid()){
        infoValida = false;
    }
    if(!frmDX.isValid()){
        infoValida = false;
    }
    
    
    if (infoValida)
    {
        var listacampos = ExtraerCamposFrmHC(frmANAM);
        var listacamposAM = ExtraerCamposFrmHC(frmAM);
        var listacamposAO = ExtraerCamposFrmHC(frmAO);
        var listacamposDX = ExtraerCamposFrmHC(frmDX);
        frmANAM.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                CAMPOSAM: listacamposAM,
                CAMPOSAO: listacamposAO,
                CAMPOSDX: listacamposDX,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var infoValida = true;
    var frmANAM = Ext.getCmp('frmAnamnesis').getForm();
    var frmAM = Ext.getCmp('frmDetAntecedentesMedicos').getForm();
    var frmAO = Ext.getCmp('frmDetAntecedentesOdontologicos').getForm();
    var frmDX = Ext.getCmp('frmDxPresuntivos').getForm();
    //var frmEVO = Ext.getCmp('frmEvolucion').getForm();
    if(!frmANAM.isValid()){
        infoValida = false;
    }
    if(!frmAM.isValid()){
        infoValida = false;
    }
    if(!frmAO.isValid()){
        infoValida = false;
    }
    if(!frmDX.isValid()){
        infoValida = false;
    }
    //if(!frmEVO.isValid()){
    //    infoValida = false;
    //}
    
    if (infoValida)
    {
        var listacampos = ExtraerCamposFrmHC(frmANAM);
        var listacamposAM = ExtraerCamposFrmHC(frmAM);
        var listacamposAO = ExtraerCamposFrmHC(frmAO);
        var listacamposDX = ExtraerCamposFrmHC(frmDX);
        frmANAM.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                CAMPOSAM: listacamposAM,
                CAMPOSAO: listacamposAO,
                CAMPOSDX: listacamposDX,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnEliminarRegItemNecesidadAtencion(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function CalcularIndiceDEAN(){
    var FD16 = 0;
    var FD15 = 0;
    var FD13 = 0;
    var FD12 = 0;
    var FD11 = 0;
    var FD21 = 0;
    var FD22 = 0;
    var FD23 = 0;
    var FD25 = 0;
    var FD26 = 0;
    var FD36 = 0;
    var FD46 = 0;
    
    if(parseInt(Ext.getCmp('strFLUOROSIS16').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS16').getValue()) < 9){
        FD16 = parseInt(Ext.getCmp('strFLUOROSIS16').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS15').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS15').getValue()) < 9){
        FD15 = parseInt(Ext.getCmp('strFLUOROSIS15').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS13').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS13').getValue()) < 9){
        FD13 = parseInt(Ext.getCmp('strFLUOROSIS13').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS12').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS12').getValue()) < 9){
        FD12 = parseInt(Ext.getCmp('strFLUOROSIS12').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS11').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS11').getValue()) < 9){
        FD11 = parseInt(Ext.getCmp('strFLUOROSIS11').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS21').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS21').getValue()) < 9){
        FD21 = parseInt(Ext.getCmp('strFLUOROSIS21').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS22').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS22').getValue()) < 9){
        FD22 = parseInt(Ext.getCmp('strFLUOROSIS22').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS23').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS23').getValue()) < 9){
        FD23 = parseInt(Ext.getCmp('strFLUOROSIS23').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS25').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS25').getValue()) < 9){
        FD25 = parseInt(Ext.getCmp('strFLUOROSIS25').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS26').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS26').getValue()) < 9){
        FD26 = parseInt(Ext.getCmp('strFLUOROSIS26').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS36').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS36').getValue()) < 9){
        FD36 = parseInt(Ext.getCmp('strFLUOROSIS36').getValue());
    }
    if(parseInt(Ext.getCmp('strFLUOROSIS46').getValue()) > 0 && parseInt(Ext.getCmp('strFLUOROSIS46').getValue()) < 9){
        FD46 = parseInt(Ext.getCmp('strFLUOROSIS46').getValue());
    }
    Ext.getCmp('intFLUOROSISIndiceDEAN').setValue(FD16+FD15+FD13+FD12+FD11+FD21+FD22+FD23+FD25+FD26+FD36+FD46);
    if(parseInt(Ext.getCmp('intFLUOROSISIndiceDEAN').getValue()) === 0){
        Ext.getCmp('intFLUOROSISIndiceDEAN').setValue(null);
    }
}