/*
* @category    Formulario Modelo Evolucion Anexo Endodoncia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCAutonomaOdo006Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Evolución Tratamiento - Universidad Autonoma de Manizales::.',
    width: 1004,
    height: 600,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
            
        //Alertas Medicas
        var xAlertasxPaciente = new AlertasxPaciente001Ui();
        Ext.getCmp('gridAlertasPacientes').store.baseParams = {
            task: 'LISTAR_ALERTAS',
            pPaciente: myPaciente,
            pIPS: ID_IPS
        };
        /*Ext.getCmp('gridAlertasPacientes').store.load({
            params: {
                pPaciente: myPaciente
            }
        });*/
        
        var dataTipoPaciente = [
            ['PACIENTE EN TRATAMIENTO'],
            ['PACIENTE CONTROLADO']
        ];
        var stTipoPaciente = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoPaciente.loadData(dataTipoPaciente);      
        
        var stGridDienteActividadesRealizadas = new StoreGridDienteActividadesRealizadas();
        stGridDienteActividadesRealizadas.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        /*
        var stGridOdontogramasxPaciente = new StoreGridOdontogramasxPaciente();
        stGridOdontogramasxPaciente.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function VerInfoOdontograma(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('Profesional') + '</br>Tipo Odontograma:' + record.get('TipoOdontograma') + '</br>Tipo Denticion:' + record.get('TipoDenticion');
        }
        */
       
        var stGridNecesidadesAtencion = new StoreGridNecesidadesAtencion();
        stGridNecesidadesAtencion.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function VerInfoProxCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return 'CAS: ' + record.get('CAS') + '</br>' + record.get('Profesional') + '</br>Fecha:' + record.get('FechaAtencion');
        }
                
        var dataHigiene = [
            ['BUENO'],
            ['REGULAR'],
            ['MALO']
        ];
        var stHigiene = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stHigiene.loadData(dataHigiene);
        
        var dataRiesgo = [
            ['ALTO'],
            ['MEDIO'],
            ['BAJO']
        ];
        var stRiesgo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRiesgo.loadData(dataRiesgo);  
        
        function DescripcionNotasEvolucion(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr>';
            mostrarHC += '<tr><td>';
            switch(store.data.Ambito){
                case "1":
                    mostrarHC += 'Ambito: 1 - Ambulatorio';
                    break;
                case "2":
                    mostrarHC += 'Ambito: 2 - Hospitalario';
                    break;
                case "3":
                    mostrarHC += 'Ambito: 3 - Urgencias';
                    break;
                default:
                    break;
            }
            mostrarHC += '</td></tr>';
            mostrarHC += '<tr><td>';
            switch(store.data.Finalidad){
                case "1":
                    mostrarHC += 'Finalidad: 1 - Diagnostico';
                    break;
                case "2":
                    mostrarHC += 'Finalidad: 2 - Terapeutico';
                    break;
                case "3":
                    mostrarHC += 'Finalidad: 3 - Proteccion Especifica';
                    break;
                case "4":
                    mostrarHC += 'Finalidad: 4 - Deteccion Temprana de Enfermedad General';
                    break;
                case "5":
                    mostrarHC += 'Finalidad: 5 - Deteccion Temprana de Enfermedad Profesional';
                    break;
                default:
                    break;
            }
            mostrarHC += '</td></tr>';
            mostrarHC += '</table>';
            return mostrarHC;
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        var ConvencionesOdontograma = new winConvencionesOdontogramaUi();
        var ViewOdontogramas = new winViewOdontogramasUi();
        //var IdEstudiante = new fsIDEstudianteUi();
        //var NecesidadesAtencionTratamiento = new fsNecesidadesAtencionTratamientoUi();
        
        var xAsignarProximaCita = new fsAsignarProximaCita001Ui();
        
        var xCartaDental = new CartaDental001Ui();
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                //padding: 10,
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        //width: 930,
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolucion',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '99%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                value: 0,
                                                id: 'sysVerificarDocenteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysIdCodPlantillaHC'
                                            },
                                             {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                value: 1,
                                                id: 'sysUsaGridSalida'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                                value: 0,
                                                id: 'sysYaGuardoHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                                value: 0,
                                                id: 'sysYaAsignoCitaHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysPlantillaHC',
                                                name: 'PLANTILLA'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptMx'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptExa'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptRem'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Actividad',
                                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                                id: 'sysActividadHC',
                                                name: 'PLANTILLA'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Empresa',
                                                id: 'sysEmpresaHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'IPS',
                                                id: 'sysIPSHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Usuario',
                                                id: 'sysUsuarioHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Profesional',
                                                id: 'sysProfesionalHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                id: 'sysIdPacienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Apertura',
                                                id: 'sysAperturaHC'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Cliente',
                                                id: 'sysClienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdClienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdPlanHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdSubPlanHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdContratoHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroPacHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Edad',
                                                id: 'sysEdadPacHC'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Profesional',
                                                id: 'sysProfesionalAgendaHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'ConsecutivoDetalle',
                                                id: 'sysConsecutivoDetalleHC'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'CAS',
                                                        id: 'sysCASHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysFechaHC',
                                                        value: 'Fecha: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysFechaHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysHoraHC',
                                                        value: 'Hora: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysHoraHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysLegalizacionHC',
                                                        value: 'Legalización: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysLegalizaHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                                id: 'sysPacienteHC'
                                            },
                                            {
                                                html: '<hr>',
                                                style: 'background:transparent;',
                                                border: false
                                            },
                                            //IdEstudiante,
                                            {
                                                xtype: 'fieldset',
                                                title: '1. EVOLUCION',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        emptyText: 'Registre: 1. El servicio  2. Procedimiento realizado: a. Técnica anestésica y tipo de anestésico. b. Procedimiento clínico especifico. c. Materiales utilizados. d. Observaciones y complicaciones. e. Prescripciones (genérico,  comercial, presentación).  f. Inasistencias. g. Próxima cita.   h. Controles (3 meses,  6 meses o 1 año).',
                                                        grow: true,
                                                        allowBlank: false,
                                                        id: 'memHistoriaDolor'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Estado Atencion',
                                                fieldLabel: 'Estado Atencion',
                                                anchor: '100%',
                                                allowBlank: false,
                                                store: stTipoPaciente,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strTipoPaciente',
                                                listeners:{
                                                    select : function(cmb, rec, idx){
                                                        if(cmb.getValue() !== "PACIENTE CONTROLADO"){
                                                            Ext.getCmp('memEpicrisis').allowBlank = true;
                                                            Ext.getCmp('memEpicrisis').setValue(null);
                                                            Ext.getCmp('memEpicrisis').clearInvalid();
                                                            Ext.getCmp('fsCierreNecesidadAtencion').setVisible(false);
                                                        }else{
                                                            Ext.getCmp('memEpicrisis').allowBlank = false;
                                                            Ext.getCmp('fsCierreNecesidadAtencion').setVisible(true);
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CIERRE NECESIDAD ATENCION',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsCierreNecesidadAtencion',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 760,
                                                        fieldLabel: 'Epicrisis',
                                                        name: 'Epicrisis',
                                                        emptyText: 'Registre: fecha de inicio y final y a satisfacción del paciente.',
                                                        grow: false,
                                                        allowBlank: true,
                                                        id: 'memEpicrisis'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Carta Dental Inicial (LEY 38/93)',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaCartaDentalInicial',
                                items: [
                                    xCartaDental
                                ]
                            },
                            /*{
                                xtype: 'panel',
                                title: 'Plan de Tratamiento',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaTto',
                                items: [
                                    NecesidadesAtencionTratamiento
                                ]
                            },*/
                            {
                                xtype: 'panel',
                                title: 'Actividades Realizadas',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaActividades',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        id: 'IdOdontogramaUltimo'
                                    },
                                    {
                                        xtype: 'grid',
                                        layout: 'fit',
                                        id: 'gridDientesActividadesRealizadas',
                                        store: stGridDienteActividadesRealizadas,
                                        anchor: "100%",
                                        height: 470,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoDientesActividad',
                                                id: 'IdConsecutivoDientesActividad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: true,
                                                width: 110,
                                                dataIndex: 'FechaAtencion',
                                                id: 'FechaAtencion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Profesional',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'Profesional',
                                                id: 'Profesional'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Diente',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Diente',
                                                id: 'Diente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Superficie',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Superficie',
                                                id: 'Superficie'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Procedimiento/Actividad',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'DesProced',
                                                renderer: DescripcionGrid,
                                                id: 'DesProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Notas Evolución',
                                                sortable: false,
                                                width: 270,
                                                dataIndex: 'NotasEvolucion',
                                                renderer: DescripcionNotasEvolucion,
                                                id: 'NotasEvolucion'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                        {
                                            xtype: 'toolbar',
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Adicionar Registro',
                                                    iconCls: 'btnAddRow',
                                                    id: 'btnAddActividadDiente',
                                                    listeners: {
                                                        click : function() {
                                                            if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                                                var winAddDienteActividadRealizada = new winAddDienteActividadRealizadaUi();
                                                                Ext.getCmp('intPacienteDienteActividad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                Ext.getCmp('intCASDienteActividad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                Ext.getCmp('intNroDienteDienteActividad').store.load({
                                                                    params: {
                                                                        pTipo: "MIXTA"
                                                                    }
                                                                });
                                                                //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                Ext.getCmp('intIdProcedDienteActividad').store.load({
                                                                    params: {
                                                                        pServicio: "%ODONTOLO%",
                                                                        pCAS: myCAS
                                                                    }
                                                                });
                                                                winAddDienteActividadRealizada.show();
                                                            }else{
                                                                Ext.Msg.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Usted No ha Guardado la Historia',
                                                                    buttons: Ext.Msg.OK,
                                                                    icon: Ext.Msg.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Eliminar Registro',
                                                    iconCls: 'btnDelRow',
                                                    id: 'btnDelActividadDiente',
                                                    listeners: {
                                                        click : function() {
                                                            if(parseInt(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount()) === 1){
                                                                var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                                                if(selections[0].json.CAS === Ext.getCmp('sysCASHC').getValue()){
                                                                    Ext.Msg.show({
                                                                        title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                                        buttons: Ext.Msg.YESNO,
                                                                        icon: Ext.Msg.QUESTION,
                                                                        fn: function(btn)
                                                                        {
                                                                            if(btn === "yes")
                                                                            {
                                                                                fnEliminarRegistrosOdo("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                                            }
                                                                        }
                                                                    });
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Odontograma',
                                                    iconCls: 'btnDiente',
                                                    listeners:{
                                                        click : function(){
                                                            /*var RecordOdontogramaIni = Ext.getCmp('gridOdontogramasxPaciente').store.getAt(0); 
                                                            Ext.getCmp('IdOdontogramaUltimo').setValue(RecordOdontogramaIni.get('IdConsecutivoOdontograma'));
                                                            Ext.getCmp('IdOdontogramaViewOdontogramas').setValue(RecordOdontogramaIni.get('IdConsecutivoOdontograma'));
                                                            Ext.getCmp('winViewOdontogramas').show();*/
                                                            window.open ("../../controlador/asistencial/imprimirodontograma.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pEvolucion=0" + "&pConsecutivoDetalle=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Odontograma");
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Convenciones',
                                                    iconCls: 'btnDiente',
                                                    listeners:{
                                                        click : function(){
                                                            Ext.getCmp('winConvencionesOdontograma').show();
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Necesidades de Atencion',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                layout: 'form',
                                id: 'fichaNecesidaeesAtencion',
                                items: [
                                    {
                                        xtype: 'grid',
                                        id: 'gridNecesidadesAtencion',
                                        store: stGridNecesidadesAtencion,
                                        anchor: "100%",
                                        height: 270,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoDientesActividad',
                                                id: 'IdConsecutivoDientesActividad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Sol',
                                                sortable: false,
                                                width: 110,
                                                dataIndex: 'FecSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Servicio',
                                                sortable: false,
                                                width: 270,
                                                dataIndex: 'Servicio'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Prioridad',
                                                sortable: false,
                                                width: 60,
                                                dataIndex: 'Prioridad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Necesidades Atencion',
                                                sortable: false,
                                                width: 370,
                                                dataIndex: 'NecesidadesAtencion',
                                                renderer: DescripcionGrid
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Estado',
                                                sortable: false,
                                                width: 80,
                                                dataIndex: 'Estado'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Quien Remite',
                                                sortable: false,
                                                width: 200,
                                                dataIndex: 'ProfeRemite'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Inicio',
                                                sortable: false,
                                                width: 110,
                                                dataIndex: 'FechaInicio'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Cierre',
                                                sortable: false,
                                                width: 110,
                                                dataIndex: 'FechaCierre'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Motivo Cierre',
                                                sortable: false,
                                                width: 2500,
                                                dataIndex: 'MotivoCierre',
                                                renderer: DescripcionGrid
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        viewConfig: {
                                            getRowClass: function(record, index) {
                                                switch (record.get('EstadoRegistro')){
                                                    case "0":
                                                        return 'NeceAten0';
                                                        break;
                                                    case "1":
                                                        return 'NeceAten1';
                                                        break;
                                                    case "2":
                                                        return 'NeceAten2';
                                                        break;
                                                    case "3":
                                                        return 'NeceAten3';
                                                        break;
                                                    default:
                                                        return;
                                                        break;
                                                }
                                            }
                                        },
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar',
                                                        iconCls: 'btnAddRow',
                                                        id: 'btnAddNecesidadAtencion',
                                                        listeners: {
                                                            click : function() {
                                                                if (Ext.getCmp('sysYaGuardoHC').getValue() === 1 || Ext.getCmp('sysYaGuardoHC').getValue() === "1"){
                                                                    var winAddNecesidadAtencion = new winAddNecesidadAtencionUi();
                                                                    Ext.getCmp('sysNuevoNesecidad').setValue(0);
                                                                    Ext.getCmp('intPrestadorNesecidad').setValue(ID_EMPRESA);
                                                                    Ext.getCmp('intIPSNesecidad').setValue(ID_IPS);
                                                                    Ext.getCmp('intProfesionalNesecidad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                    Ext.getCmp('intCASNesecidad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                    Ext.getCmp('intPacienteNesecidad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                    Ext.getCmp('intUsuarioNesecidad').setValue(ID_USUARIO);
                                                                    Ext.getCmp('strFechaSolNesecidad').setValue(Ext.getCmp('sysFechaHC').getValue());
                                                                    winAddNecesidadAtencion.show();
                                                                }else{
                                                                    Ext.Msg.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'Usted No ha Guardado la Evolución',
                                                                        buttons: Ext.Msg.OK,
                                                                        icon: Ext.Msg.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Editar',
                                                        iconCls: 'btnEditRow',
                                                        id: 'btnEditNecesidadAtencion',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(Ext.getCmp('gridNecesidadesAtencion').selModel.getCount()) === 1){
                                                                    var selections = Ext.getCmp('gridNecesidadesAtencion').selModel.getSelections();
                                                                    if(selections[0].json.EstadoRegistro === "1"){
                                                                        Ext.Msg.show({
                                                                            title: 'Necesidades Atencion',
                                                                            msg: 'Esta Seguro que Desea Modificar el Registro ' + selections[0].json.Servicio + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn === "yes"){
                                                                                    var winAddNecesidadAtencion = new winAddNecesidadAtencionUi();
                                                                                    Ext.getCmp('sysNuevoNesecidad').setValue(1);
                                                                                    Ext.getCmp('sysIdConsecutivoNesecidad').setValue(selections[0].json.IdConsecutivoNecesidad);
                                                                                    Ext.getCmp('intPrestadorNesecidad').setValue(ID_EMPRESA);
                                                                                    Ext.getCmp('intIPSNesecidad').setValue(ID_IPS);
                                                                                    Ext.getCmp('intProfesionalNesecidad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                                    Ext.getCmp('intCASNesecidad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                    Ext.getCmp('intPacienteNesecidad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                    Ext.getCmp('intUsuarioNesecidad').setValue(ID_USUARIO);
                                                                                    Ext.getCmp('strFechaSolNesecidad').setValue(Ext.getCmp('sysFechaHC').getValue());
                                                                                    Ext.getCmp('intServicioNesecidad').setValue(selections[0].json.Programa);
                                                                                    Ext.getCmp('intPrioridadNesecidad').setValue(selections[0].json.Prioridad);
                                                                                    Ext.getCmp('memNesecidad').setValue(selections[0].json.NecesidadesAtencion);
                                                                                    winAddNecesidadAtencion.show();
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'El registro no esta disponible para ser modificado',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos modificar el registro en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar',
                                                        iconCls: 'btnDelRow',
                                                        id: 'btnDelNecesidadAtencion',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(Ext.getCmp('gridNecesidadesAtencion').selModel.getCount()) === 1){
                                                                    var selections = Ext.getCmp('gridNecesidadesAtencion').selModel.getSelections();
                                                                    if(selections[0].json.EstadoRegistro === "1"){
                                                                        Ext.Msg.show({
                                                                            title: 'Necesidades Atencion',
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.Servicio + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn === "yes"){
                                                                                    fnEliminarRegItemNecesidadAtencion("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_NECESIDAD_ATENCION", pIdRegistroNecesidad: selections[0].json.IdConsecutivoNecesidad}, 'gridNecesidadesAtencion');
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'El registro no esta disponible para ser eliminado',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar el registro en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    new Ext.app.SearchField({
                                                        id: 'qryNecesidadesAtencion',
                                                        store: stGridNecesidadesAtencion,
                                                        ValparamP1: wPaciente,
                                                        emptyText: 'Escriba el criterio que desea buscar',
                                                        width: 120,
                                                        pLoadGrid: false,
                                                        pGrid: 'gridNecesidadesAtencion',
                                                        parrParam: {params:{pPaciente: wPaciente}}
                                                    })
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Registro de Alertas',
                                height: 380,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaAlertas',
                                items: [
                                    xAlertasxPaciente
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Asignar Proxima Cita',
                                height: 380,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaProximaCita',
                                items: [
                                    xAsignarProximaCita
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones Externas',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn=="yes"){
                                                    if(parseInt(Ext.getCmp('sysYaAsignoCitaHC').getValue()) === 1){
                                                        if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                            Ext.getCmp('gridFormulario').store.reload();
                                                        }
                                                        Ext.getCmp('winHC').close();
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: 'Asignar Proxima Cita',
                                                            msg: 'Debe Asignar la proxima cita para poder cerrar la historia clinica.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imagenes Asociadas',
                            iconCls: 'btnCargarFoto',
                            listeners:{
                                click : function(){
                                    if(!winImgxPac){
                                        winImgxPac = new winImagenAsocxPac({
                                            url:'../../controlador/pacientes/controlador_filesasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winImgxPac.show();
                                    ////// BORRAR DATA ANTERIOR
                                    Ext.getCmp('searchImgxPacNom').setValue(null);
                                    Ext.getCmp('searchImgxPacNota').setValue(null);
                                    Ext.getCmp('searchImgxPacSort').setValue("Nombre");
                                    stImagenxPac.removeAll(true);
                                    stImagenxPac.load({
                                        params:{
                                            task: 'LISTAR_IMAGENES',
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                            pNom: null,
                                            pNota: null,
                                            pOrden: 'Nombre'
                                        }
                                    });
                                    var detailEl = Ext.getCmp('img-detail-panel').body;
                                    detailEl.update('');
                                    ///////
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Documentos Asociados',
                            iconCls: 'btnCargarFile',
                            listeners:{
                                click : function(){
                                    if(!winDocxPac){
                                        winDocxPac = new winDocumentoAsocxPac({
                                            url:'../../controlador/pacientes/controlador_docsasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winDocxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosOdo006();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosOdo006();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                /*Ext.getCmp('gridNecesidadesAtencionTratamiento').store.load({
                    params: {
                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                        pIdConsecutivoNecesidad: Ext.getCmp('IdConsecutivoNecesidad').getValue()
                    }
                });*/
                //RAFA
                Ext.getCmp('fsCierreNecesidadAtencion').setVisible(false);
                //Cargar Alertas del Paciente
                Ext.getCmp('gridAlertasPacientes').store.baseParams = {
                    task: 'LISTAR_ALERTAS',
                    pPaciente: myPaciente,
                    pIPS: ID_IPS
                };
                Ext.getCmp('gridAlertasPacientes').store.load({
                    params: {
                        pPaciente: myPaciente
                    },
                    callback: function(){
                        var contador = 0;
                        var html = '<table>';
                        Ext.getCmp('gridAlertasPacientes').store.each(function(record){
                            //record.get('citaID') + "^" + record.get('citaInfoAdd') + "^" + record.get('TipoHorario') + "¬";
                            html += '<tr><td width="750"><span style="color: #003333;font-weight: bold;">' + record.get('TipoAlerta') + ':&nbsp&nbsp' + record.get('Alerta') + '</span></td></tr>';
                            contador ++;
                        });
                        html += '</table>';
                        if(contador > 0){
                            Ext.MessageBox.show({
                                title: 'Alertas',
                                msg: html,
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.WARNING
                            });
                        }
                    }
                });
            }}
        }); 
        winHCAutonomaOdo006Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosOdo006(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhcuam.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pVerificarDocente: Ext.getCmp('sysVerificarDocenteHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosOdo006(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhcuam.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pVerificarDocente: Ext.getCmp('sysVerificarDocenteHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnEliminarRegItemNecesidadAtencion(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}