/*
* @category    Formulario Modelo Evolucion Anexo Rehabilitacion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCAutonomaOdo004Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Examen Rehabilitacion - Universidad Autonoma de Manizales::.',
    width: 1004,
    height: 600,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var dataSistemaOseoCraneo = [
            ['1. MESOCEFALICO'],
            ['2. BRAQUICEFALICO'],
            ['3. DOLICOCEFALICO']
        ];
        var stSistemaOseoCraneo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSistemaOseoCraneo.loadData(dataSistemaOseoCraneo);
        
        var dataSistemaOseoCara = [
            ['1. MESOPROSOPO'],
            ['2. EURIPROSOPO'],
            ['3. LEPTOPROSOPO']
        ];
        var stSistemaOseoCara = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSistemaOseoCara.loadData(dataSistemaOseoCara);
        
        var dataSistemaOseoPerfil = [
            ['1. RECTO'],
            ['2. CONCAVO'],
            ['3. CONVEXO']
        ];
        var stSistemaOseoPerfil = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSistemaOseoPerfil.loadData(dataSistemaOseoPerfil);
        
        var dataLineaSonrira = [
            ['1. ALTA'],
            ['2. MEDIA'],
            ['3. BAJA']
        ];
        var stLineaSonrira = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stLineaSonrira.loadData(dataLineaSonrira);
        
        var dataPlanoIncisal = [
            ['1. PARALELO'],
            ['2. INVERTIDO'],
            ['3. RECTO'],
            ['4. IRREGULAR'],
            ['5. OTRO']
        ];
        var stPlanoIncisal = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stPlanoIncisal.loadData(dataPlanoIncisal);
        
        var dataTamanoLabios = [
            ['1. DELGADOS'],
            ['2. MEDIOS'],
            ['3. GRUESOS']
        ];
        var stTamanoLabios = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stTamanoLabios.loadData(dataTamanoLabios);
        
        var dataSistemaArticularTipoDolor = [
            ['CONSTANTE'],
            ['ESPONTANEO'],
            ['PROVOCADO'],
            ['OTRO']
        ];
        var stSistemaArticularTipoDolor = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSistemaArticularTipoDolor.loadData(dataSistemaArticularTipoDolor);
        
        var dataSistemaArticularTipoActividadDolor = [
            ['AL MASTICAR'],
            ['AL BOSTEZAR'],
            ['AL ABRIR'],
            ['AL CERRAR'],
            ['OTRO']
        ];
        var stSistemaArticularTipoActividadDolor = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSistemaArticularTipoActividadDolor.loadData(dataSistemaArticularTipoActividadDolor);
        
        var dataAperturaCierre = [
            ['APERTURA'],
            ['CIERRE']
        ];
        var stAperturaCierre = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stAperturaCierre.loadData(dataAperturaCierre);
        
        var dataIntensidadDolor = [
            ['LEVE'],
            ['MODERADO'],
            ['SEVERO']
        ];
        var stIntensidadDolor = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stIntensidadDolor.loadData(dataIntensidadDolor);
        
        var dataSobremordida = [
            ['LEVE'],
            ['MODERADO'],
            ['SEVERO']
        ];
        var stSobremordida = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSobremordida.loadData(dataSobremordida);
        
        var dataRelacionMolar = [
            ['CLASE I'],
            ['CLASE II'],
            ['CLASE III'],
            ['NO APLICA']
        ];
        var stRelacionMolar = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stRelacionMolar.loadData(dataRelacionMolar);
        
        var dataFormaArco = [
            ['TRIANGULAR'],
            ['CUADRANGULAR'],
            ['OVOIDE'],
            ['MIXTO']
        ];
        var stFormaArco = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stFormaArco.loadData(dataFormaArco);
        
        var dataPlanoOclusal = [
            ['RECTO'],
            ['CONVEXO'],
            ['CONCAVO'],
            ['ESCALONADO']
        ];
        var stPlanoOclusal = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stPlanoOclusal.loadData(dataPlanoOclusal);
        
               
        var dataConcavoConvexo = [
            ['CONVEXO'],
            ['CONCAVO']
        ];
        var stConcavoConvexo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stConcavoConvexo.loadData(dataConcavoConvexo);

        var dataSistemaArticularUbucacion = [
            ['IZQUIRDA'],
            ['DERECHA'],
            ['BILATERAL']
        ];
        var stSistemaArticularUbucacion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSistemaArticularUbucacion.loadData(dataSistemaArticularUbucacion);
        
        var dataATMTipoRuido = [
            ['CLICK'],
            ['CREPITACION'],
            ['BRINCO']
        ];
        var stATMTipoRuido = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stATMTipoRuido.loadData(dataATMTipoRuido);
        
        var dataATMTipoEndFeel = [
            ['FIRME'],
            ['DURO'],
            ['CAPSULAR'],
            ['OTRO']
        ];
        var stATMTipoEndFeel = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stATMTipoEndFeel.loadData(dataATMTipoEndFeel);
        
        var dataTipoDesviacion1 = [
            ['APERTURA'],
            ['CIERRE'],
            ['RETRUSION'],
            ['PROTRUSION']
        ];
        var stTipoDesviacion1 = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stTipoDesviacion1.loadData(dataTipoDesviacion1);
        
        var dataTipoDesviacion2 = [
            ['LINEAL'],
            ['DESVIACION'],
            ['DEFLEXION']
        ];
        var stTipoDesviacion2 = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stTipoDesviacion2.loadData(dataTipoDesviacion2);
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
            
        //Alertas Medicas
        var xAlertasxPaciente = new AlertasxPaciente001Ui();
        Ext.getCmp('gridAlertasPacientes').store.baseParams = {
            task: 'LISTAR_ALERTAS',
            pPaciente: myPaciente,
            pIPS: ID_IPS
        };
        
        var stGridDienteActividadesRealizadas = new StoreGridDienteActividadesRealizadas();
        stGridDienteActividadesRealizadas.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridNecesidadesAtencion = new StoreGridNecesidadesAtencion();
        stGridNecesidadesAtencion.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function VerInfoProxCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return 'CAS: ' + record.get('CAS') + '</br>' + record.get('Profesional') + '</br>Fecha:' + record.get('FechaAtencion');
        }
                
        function DescripcionNotasEvolucion(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr>';
            mostrarHC += '<tr><td>';
            switch(store.data.Ambito){
                case "1":
                    mostrarHC += 'Ambito: 1 - Ambulatorio';
                    break;
                case "2":
                    mostrarHC += 'Ambito: 2 - Hospitalario';
                    break;
                case "3":
                    mostrarHC += 'Ambito: 3 - Urgencias';
                    break;
                default:
                    break;
            }
            mostrarHC += '</td></tr>';
            mostrarHC += '<tr><td>';
            switch(store.data.Finalidad){
                case "1":
                    mostrarHC += 'Finalidad: 1 - Diagnostico';
                    break;
                case "2":
                    mostrarHC += 'Finalidad: 2 - Terapeutico';
                    break;
                case "3":
                    mostrarHC += 'Finalidad: 3 - Proteccion Especifica';
                    break;
                case "4":
                    mostrarHC += 'Finalidad: 4 - Deteccion Temprana de Enfermedad General';
                    break;
                case "5":
                    mostrarHC += 'Finalidad: 5 - Deteccion Temprana de Enfermedad Profesional';
                    break;
                default:
                    break;
            }
            mostrarHC += '</td></tr>';
            mostrarHC += '</table>';
            return mostrarHC;
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        var ConvencionesOdontograma = new winConvencionesOdontogramaUi();
        var ViewOdontogramas = new winViewOdontogramasUi();
        //var IdEstudiante = new fsIDEstudianteUi();
        //var NecesidadesAtencionTratamiento = new fsNecesidadesAtencionTratamientoUi();
        
        var xCartaDental = new CartaDental001Ui();
        
        //combos
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                //padding: 10,
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        //width: 930,
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Valoración',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 0,
                                        id: 'sysVerificarDocenteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaAsignoCitaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Docente',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    },
                                    //IdEstudiante,
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '99%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'SISTEMA OSEO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 230,
                                                                fieldLabel: 'Craneo',
                                                                name: 'Craneo',
                                                                allowBlank: false,
                                                                store: stSistemaOseoCraneo,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaOseoCreneo'
                                                            },
                                                            {
                                                                html: 'Cara:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 230,
                                                                name: 'Cara',
                                                                allowBlank: false,
                                                                store: stSistemaOseoCara,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaOseoCara'
                                                            },
                                                            {
                                                                html: 'Perfil:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 230,
                                                                name: 'Perfil',
                                                                allowBlank: false,
                                                                store: stSistemaOseoPerfil,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaOseoPerfil'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'FACIAL',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 270,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Simetría facial',
                                                                        name: 'Simetría facial',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strSistemaOseoFacial_Simietria',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('strSistemaOseoFacial_SimietriaH').allowBlank = true;
                                                                                    Ext.getCmp('strSistemaOseoFacial_SimietriaH').setValue(null);
                                                                                    Ext.getCmp('strSistemaOseoFacial_SimietriaH').disable();
                                                                                    Ext.getCmp('strSistemaOseoFacial_SimietriaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strSistemaOseoFacial_SimietriaH').enable();
                                                                                    Ext.getCmp('strSistemaOseoFacial_SimietriaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: 'Observaciones'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 320,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        name: 'Simetria Facial Observaciones',
                                                                        id: 'strSistemaOseoFacial_SimietriaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'Simetricos'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        fieldLabel: 'Quintos faciales',
                                                                        name: 'Quintos faciales Simetricos',
                                                                        id: 'strSistemaOseoFacial_QuintosSimetricos'
                                                                    },
                                                                    {
                                                                        html: 'Asimetricos'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: 'Quintos faciales Asimetricos',
                                                                        id: 'strSistemaOseoFacial_QuintosAsimetricos'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'Simetricos'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Tercios faciales',
                                                                        name: 'Tercios faciales Simetricos',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strSistemaOseoFacial_TerciosSimetricos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('strSistemaOseoFacial_TerciosSimetricosH').allowBlank = true;
                                                                                    Ext.getCmp('strSistemaOseoFacial_TerciosSimetricosH').setValue(null);
                                                                                    Ext.getCmp('strSistemaOseoFacial_TerciosSimetricosH').disable();
                                                                                    Ext.getCmp('strSistemaOseoFacial_TerciosSimetricosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strSistemaOseoFacial_TerciosSimetricosH').enable();
                                                                                    Ext.getCmp('strSistemaOseoFacial_TerciosSimetricosH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 320,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        name: 'Simetria Facial Observaciones',
                                                                        id: 'strSistemaOseoFacial_TerciosSimetricosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'Asimetricos'
                                                                    },
                                                                    {
                                                                        html: '- Tercio Sup:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 70,
                                                                        allowBlank: true,
                                                                        name: 'Tercios Asimetricos Sup',
                                                                        id: 'strSistemaOseoFacial_TerciosAsimetricosSup'
                                                                    },
                                                                    {
                                                                        html: '- Tercio Med:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 70,
                                                                        allowBlank: true,
                                                                        name: 'Tercios Asimetricos Med',
                                                                        id: 'strSistemaOseoFacial_TerciosAsimetricosMed'
                                                                    },
                                                                    {
                                                                        html: '- Tercio Inf:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 70,
                                                                        allowBlank: true,
                                                                        name: 'Tercios Asimetricos Inf',
                                                                        id: 'strSistemaOseoFacial_TerciosAsimetricosInf'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 220,
                                                                allowBlank: true,
                                                                fieldLabel: 'Espacio libre',
                                                                name: 'Espacio libre',
                                                                emptyText: 'mm',
                                                                id: 'strSistemaOseoFacial_EspacioLibre'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Perdida dimensión vertical',
                                                                        name: 'Perdida dimensión vertical',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strSistemaOseoFacial_PerdidaDimensionVertical',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "SI"){
                                                                                    Ext.getCmp('strSistemaOseoFacial_PerdidaDimensionVerticalH').allowBlank = true;
                                                                                    Ext.getCmp('strSistemaOseoFacial_PerdidaDimensionVerticalH').setValue(null);
                                                                                    Ext.getCmp('strSistemaOseoFacial_PerdidaDimensionVerticalH').disable();
                                                                                    Ext.getCmp('strSistemaOseoFacial_PerdidaDimensionVerticalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strSistemaOseoFacial_PerdidaDimensionVerticalH').enable();
                                                                                    Ext.getCmp('strSistemaOseoFacial_PerdidaDimensionVerticalH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 220,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        name: 'Perdida Dimension Vertical',
                                                                        emptyText: 'mm',
                                                                        id: 'strSistemaOseoFacial_PerdidaDimensionVerticalH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Paralelismo entre planos horizontales de referencia',
                                                                        name: 'Paralelismo entre planos horizontales de referencia',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strSistemaOseoFacial_ParalelismoPlanosHorizonta',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('strSistemaOseoFacial_ParalelismoPlanosHorizontaH').allowBlank = true;
                                                                                    Ext.getCmp('strSistemaOseoFacial_ParalelismoPlanosHorizontaH').setValue(null);
                                                                                    Ext.getCmp('strSistemaOseoFacial_ParalelismoPlanosHorizontaH').disable();
                                                                                    Ext.getCmp('strSistemaOseoFacial_ParalelismoPlanosHorizontaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strSistemaOseoFacial_ParalelismoPlanosHorizontaH').enable();
                                                                                    Ext.getCmp('strSistemaOseoFacial_ParalelismoPlanosHorizontaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 320,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        name: 'Paralelismo entre planos horizontales de referencia',
                                                                        emptyText: 'mm',
                                                                        id: 'strSistemaOseoFacial_ParalelismoPlanosHorizontaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '99%',
                                                                fieldLabel: 'Descripcion',
                                                                name: 'Descripcion',
                                                                allowBlank: true,
                                                                id: 'memSistemaOseoFacial'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SISTEMA MUSCULAR',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: false,
                                                anchor: '99%',
                                                autoHeight: true,
                                                layout: {
                                                    columns: 8,
                                                    type: 'table'
                                                },
                                                items: [
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 200,
                                                        style: 'background:transparent;',
                                                        labelStyle: 'text-align:right;',
                                                        title: '<center>MUSCULOS</center>',
                                                        layout: {
                                                            columns: 1,
                                                            type: 'table'
                                                        },
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Masetero. Haz. Superficial',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Masetero Haz. Profundo',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Pterigiodeo externo',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM3'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Pterigiodeo interno',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM4'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Digástrico vientre anterior',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM5'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Digástrico vientre posterior',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM6'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Temporal',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM7'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Occipital',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM8'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Esterno. esternal',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM9'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Esterno. clavicular',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM10'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Trapecios',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM11'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 195,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Escalenos',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysSistemaMuscularM12'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 80,
                                                        title: '<center>D(EAD)</center>',
                                                        layout: {
                                                            columns: 1,
                                                            type: 'table'
                                                        },
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM1_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM2_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM3_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM4_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM5_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM6_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM7_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM8_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM9_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM10_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM11_ReposoD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - D(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM12_ReposoD_EAD'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 80,
                                                        title: '<center>I(EAD)</center>',
                                                        layout: {
                                                            columns: 1,
                                                            type: 'table'
                                                        },
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM1_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM2_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM3_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM4_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM5_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM6_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM7_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM8_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM9_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM10_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM11_ReposoI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Reposo - I(EAD)',
                                                                emptyText: 'Reposo',
                                                                id: 'strSistemaMuscularM12_ReposoI_EAD'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 80,
                                                        title: '<center>D</center>',
                                                        layout: {
                                                            columns: 1,
                                                            type: 'table'
                                                        },
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM1_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM2_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM3_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM4_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM5_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM6_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM7_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM8_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM9_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM10_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM11_FuncionD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - D',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM12_FuncionD'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 80,
                                                        title: '<center>EAD</center>',
                                                        layout: {
                                                            columns: 1,
                                                            type: 'table'
                                                        },
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM1_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM2_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM3_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM4_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM5_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM6_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM7_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM8_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM9_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM10_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM11_FuncionD_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM12_FuncionD_EAD'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 80,
                                                        title: '<center>I</center>',
                                                        layout: {
                                                            columns: 1,
                                                            type: 'table'
                                                        },
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM1_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM2_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM3_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM4_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM5_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM6_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM7_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM8_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM9_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM10_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM11_FuncionI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - I',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM12_FuncionI'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 80,
                                                        title: '<center>EAD</center>',
                                                        layout: {
                                                            columns: 1,
                                                            type: 'table'
                                                        },
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM1_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM2_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM3_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM4_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM5_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM6_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM7_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM8_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM9_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM10_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM11_FuncionI_EAD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Funcion - EAD',
                                                                emptyText: 'Funcion',
                                                                id: 'strSistemaMuscularM12_FuncionI_EAD'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 150,
                                                        title: '<center>OBSERVACIONES</center>',
                                                        layout: {
                                                            columns: 1,
                                                            type: 'table'
                                                        },
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM1_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM2_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM3_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM4_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM5_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM6_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM7_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM8_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM9_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM10_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM11_Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strSistemaMuscularM12_Observaciones'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANALISIS DE SONRISA',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        width: 250,
                                                        fieldLabel: 'Línea sonrisa',
                                                        name: 'Línea sonrisa',
                                                        allowBlank: false,
                                                        store: stLineaSonrira, //rafa
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strAnalisisSonrisaLinea'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 250,
                                                                fieldLabel: 'Plano incisal',
                                                                name: 'Plano incisal',
                                                                allowBlank: false,
                                                                store: stPlanoIncisal,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAnalisisSonrisaPlanoIncisal',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() != "5. OTRO"){
                                                                            Ext.getCmp('strAnalisisSonrisaPlanoIncisalH').allowBlank = true;
                                                                            Ext.getCmp('strAnalisisSonrisaPlanoIncisalH').setValue(null);
                                                                            Ext.getCmp('strAnalisisSonrisaPlanoIncisalH').disable();
                                                                            Ext.getCmp('strAnalisisSonrisaPlanoIncisalH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAnalisisSonrisaPlanoIncisalH').enable();
                                                                            Ext.getCmp('strAnalisisSonrisaPlanoIncisalH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 420,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strAnalisisSonrisaPlanoIncisalH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 250,
                                                        fieldLabel: 'Tamaño de los labios',
                                                        name: 'Tamaño de los labios',
                                                        allowBlank: false,
                                                        store: stTamanoLabios,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strAnalisisSonrisaTamanoLabios'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '1. Competencia labial',
                                                                name: '1. Competencia labial',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAnalisisSonrisaCompetenciaLabial',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAnalisisSonrisaCompetenciaLabialH').allowBlank = true;
                                                                            Ext.getCmp('strAnalisisSonrisaCompetenciaLabialH').setValue(null);
                                                                            Ext.getCmp('strAnalisisSonrisaCompetenciaLabialH').disable();
                                                                            Ext.getCmp('strAnalisisSonrisaCompetenciaLabialH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAnalisisSonrisaCompetenciaLabialH').enable();
                                                                            Ext.getCmp('strAnalisisSonrisaCompetenciaLabialH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 420,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Observaciones',
                                                                emptyText: 'Observaciones',
                                                                id: 'strAnalisisSonrisaCompetenciaLabialH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '2. Coincidencia línea media facial vs dental superior',
                                                                name: '2. Coincidencia línea media facial vs dental superior',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAnalisisSonrisaCoincienciaLineaMediaFacialDentalSup',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaMediaFacialDentalSupH').allowBlank = true;
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaMediaFacialDentalSupH').setValue(null);
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaMediaFacialDentalSupH').disable();
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaMediaFacialDentalSupH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaMediaFacialDentalSupH').enable();
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaMediaFacialDentalSupH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 420,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Observaciones',
                                                                emptyText: 'Observaciones',
                                                                id: 'strAnalisisSonrisaCoincienciaLineaMediaFacialDentalSupH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '3. Coincidencia línea media dental superior e inferior',
                                                                name: '3. Coincidencia línea media dental superior e inferior',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAnalisisSonrisaCoincienciaLineaDentalSupInf',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaDentalSupInfH').allowBlank = true;
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaDentalSupInfH').setValue(null);
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaDentalSupInfH').disable();
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaDentalSupInfH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaDentalSupInfH').enable();
                                                                            Ext.getCmp('strAnalisisSonrisaCoincienciaLineaDentalSupInfH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 400,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Observaciones',
                                                                emptyText: 'Observaciones',
                                                                id: 'strAnalisisSonrisaCoincienciaLineaDentalSupInfH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '4. Exposición dental en reposo',
                                                                name: '4. Exposición dental en reposo',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAnalisisSonrisaExposicionDentalReposo',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAnalisisSonrisaExposicionDentalReposoH').allowBlank = true;
                                                                            Ext.getCmp('strAnalisisSonrisaExposicionDentalReposoH').setValue(null);
                                                                            Ext.getCmp('strAnalisisSonrisaExposicionDentalReposoH').disable();
                                                                            Ext.getCmp('strAnalisisSonrisaExposicionDentalReposoH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAnalisisSonrisaExposicionDentalReposoH').enable();
                                                                            Ext.getCmp('strAnalisisSonrisaExposicionDentalReposoH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 400,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Observaciones',
                                                                emptyText: 'Observaciones',
                                                                id: 'strAnalisisSonrisaExposicionDentalReposoH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Plano de Rickets',
                                                        name: 'Plano de Rickets',
                                                        id: 'strAnalisisSonrisaPlanoRickets'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SISTEMA ARTICULAR',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Dolor',
                                                                name: 'Dolor',
                                                                width: 50,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strSistemaArticularDolor1',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strSistemaArticularDolor1H').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularDolor1H').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularDolor1H').disable();
                                                                            Ext.getCmp('strSistemaArticularDolor1H').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strSistemaArticularUbicacion1').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularUbicacion1').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularUbicacion1').disable();
                                                                            Ext.getCmp('strSistemaArticularUbicacion1').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strSistemaArticularDolor1Actividad').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularDolor1Actividad').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularDolor1Actividad').disable();
                                                                            Ext.getCmp('strSistemaArticularDolor1Actividad').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strSistemaArticularDolor1ActividadH').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularDolor1ActividadH').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularDolor1ActividadH').disable();
                                                                            Ext.getCmp('strSistemaArticularDolor1ActividadH').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strSistemaArticularDolor1Tipo').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularDolor1Tipo').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularDolor1Tipo').disable();
                                                                            Ext.getCmp('strSistemaArticularDolor1Tipo').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strSistemaArticularDolor1TipoH').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularDolor1TipoH').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularDolor1TipoH').disable();
                                                                            Ext.getCmp('strSistemaArticularDolor1TipoH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strSistemaArticularDolor1H').enable();
                                                                            Ext.getCmp('strSistemaArticularDolor1H').allowBlank = false;
                                                                            
                                                                            Ext.getCmp('strSistemaArticularUbicacion1').enable();
                                                                            Ext.getCmp('strSistemaArticularUbicacion1').allowBlank = false;
                                                                            
                                                                            Ext.getCmp('strSistemaArticularDolor1Actividad').enable();
                                                                            Ext.getCmp('strSistemaArticularDolor1Actividad').allowBlank = false;
                                                                            
                                                                            Ext.getCmp('strSistemaArticularDolor1Tipo').enable();
                                                                            Ext.getCmp('strSistemaArticularDolor1Tipo').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 720,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strSistemaArticularDolor1H'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Ubicacion',
                                                        name: 'Ubicacion',
                                                        width: 120,
                                                        allowBlank: true,
                                                        disabled: true,
                                                        store: stSistemaArticularUbucacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSistemaArticularUbicacion1'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo',
                                                                name: 'Tipo',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stSistemaArticularTipoDolor,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaArticularDolor1Tipo',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() != "OTRO"){
                                                                            Ext.getCmp('strSistemaArticularDolor1TipoH').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularDolor1TipoH').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularDolor1TipoH').disable();
                                                                            Ext.getCmp('strSistemaArticularDolor1TipoH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strSistemaArticularDolor1TipoH').enable();
                                                                            Ext.getCmp('strSistemaArticularDolor1TipoH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 650,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strSistemaArticularDolor1TipoH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Actividad',
                                                                name: 'Actividad que acompaña el dolor articular',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stSistemaArticularTipoActividadDolor,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaArticularDolor1Actividad',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() != "OTRO"){
                                                                            Ext.getCmp('strSistemaArticularDolor1ActividadH').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularDolor1ActividadH').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularDolor1ActividadH').disable();
                                                                            Ext.getCmp('strSistemaArticularDolor1ActividadH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strSistemaArticularDolor1ActividadH').enable();
                                                                            Ext.getCmp('strSistemaArticularDolor1ActividadH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 650,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strSistemaArticularDolor1ActividadH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Trayectoria de movimiento',
                                                                name: 'Trayectoria de movimiento',
                                                                width: 50,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strSistemaArticularTrayectoria',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strSistemaArticularTrayectoriaH').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularTrayectoriaH').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularTrayectoriaH').disable();
                                                                            Ext.getCmp('strSistemaArticularTrayectoriaH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strSistemaArticularTrayectoriaH').enable();
                                                                            Ext.getCmp('strSistemaArticularTrayectoriaH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 720,
                                                                allowBlank: true,
                                                                emptyText: 'Observaciones',
                                                                disabled: true,
                                                                id: 'strSistemaArticularTrayectoriaH'
                                                            }
                                                        ]
                                                    },
                                                    { 
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Desviación',
                                                                name: 'Desviación',
                                                                width: 50,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strSistemaArticularDesviacion',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strSistemaArticularDesviacionH').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularDesviacionH').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularDesviacionH').disable();
                                                                            Ext.getCmp('strSistemaArticularDesviacionH').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo1').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo1').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo1').disable();
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo1').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo2').allowBlank = true;
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo2').setValue(null);
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo2').disable();
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo2').clearInvalid();
                                                                            
                                                                            
                                                                        }else{
                                                                            Ext.getCmp('strSistemaArticularDesviacionH').enable();
                                                                            Ext.getCmp('strSistemaArticularDesviacionH').allowBlank = false;
                                                                            
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo1').enable();
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo1').allowBlank = false;
                                                                            
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo2').enable();
                                                                            Ext.getCmp('strSistemaArticularDesviacionTipo2').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 720,
                                                                allowBlank: true,
                                                                emptyText: 'Observaciones',
                                                                disabled: true,
                                                                id: 'strSistemaArticularDesviacionH'
                                                            }
                                                        ]
                                                    },
                                                    { //RAFA
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo',
                                                                name: 'Tipo',
                                                                width: 150,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stTipoDesviacion1,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaArticularDesviacionTipo1'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Tipo',
                                                                width: 150,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stTipoDesviacion2,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaArticularDesviacionTipo2'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ATM',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                labelWidth: 60,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Ruido',
                                                                name: 'Ruido',
                                                                width: 50,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strATMRuido',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strATMRuidoTipo').allowBlank = true;
                                                                            Ext.getCmp('strATMRuidoTipo').setValue(null);
                                                                            Ext.getCmp('strATMRuidoTipo').disable();
                                                                            Ext.getCmp('strATMRuidoTipo').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strATMUbicacion1').allowBlank = true;
                                                                            Ext.getCmp('strATMUbicacion1').setValue(null);
                                                                            Ext.getCmp('strATMUbicacion1').disable();
                                                                            Ext.getCmp('strATMUbicacion1').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strATMTipo').allowBlank = true;
                                                                            Ext.getCmp('strATMTipo').setValue(null);
                                                                            Ext.getCmp('strATMTipo').disable();
                                                                            Ext.getCmp('strATMTipo').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strATMRuidoMomentoDer').allowBlank = true;
                                                                            Ext.getCmp('strATMRuidoMomentoDer').setValue(null);
                                                                            Ext.getCmp('strATMRuidoMomentoDer').disable();
                                                                            Ext.getCmp('strATMRuidoMomentoDer').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strATMRuidoMomentoIzq').allowBlank = true;
                                                                            Ext.getCmp('strATMRuidoMomentoIzq').setValue(null);
                                                                            Ext.getCmp('strATMRuidoMomentoIzq').disable();
                                                                            Ext.getCmp('strATMRuidoMomentoIzq').clearInvalid();
                                                                            
                                                                            
                                                                        }else{
                                                                            Ext.getCmp('strATMRuidoTipo').enable();
                                                                            Ext.getCmp('strATMRuidoTipo').allowBlank = false;
                                                                            
                                                                            Ext.getCmp('strATMUbicacion1').enable();
                                                                            Ext.getCmp('strATMUbicacion1').allowBlank = false;
                                                                            
                                                                            Ext.getCmp('strATMTipo').enable();
                                                                            Ext.getCmp('strATMTipo').allowBlank = false;
                                                                            
                                                                            Ext.getCmp('strATMRuidoMomentoDer').enable();
                                                                            Ext.getCmp('strATMRuidoMomentoDer').allowBlank = false;
                                                                            
                                                                            Ext.getCmp('strATMRuidoMomentoIzq').enable();
                                                                            Ext.getCmp('strATMRuidoMomentoIzq').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: '-'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'TipoRuido',
                                                                width: 105,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stATMTipoRuido, 
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strATMRuidoTipo'
                                                            },
                                                            {
                                                                html: 'Ubicacion:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Ubicacion',
                                                                width: 100,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stSistemaArticularUbucacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strATMUbicacion1'
                                                            },
                                                            {
                                                                html: 'Tipo Movimiento:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Tipo',
                                                                width: 100,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stTipoDesviacion1,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strATMTipo'
                                                            },
                                                            {
                                                                html: 'Momento - Der:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Derecha',
                                                                width: 70,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strATMRuidoMomentoDer'
                                                            },
                                                            {
                                                                html: 'Izq:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Izquierda',
                                                                width: 70,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strATMRuidoMomentoIzq'
                                                            }
                                                        ]
                                                    },
                                                    
                                                    
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'End Feel',
                                                                name: 'End Feel',
                                                                width: 50,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strATMEndFeel',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strATMEndFeelTipo').allowBlank = true;
                                                                            Ext.getCmp('strATMEndFeelTipo').setValue(null);
                                                                            Ext.getCmp('strATMEndFeelTipo').disable();
                                                                            Ext.getCmp('strATMEndFeelTipo').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strATMEndFeelTipoH').allowBlank = true;
                                                                            Ext.getCmp('strATMEndFeelTipoH').setValue(null);
                                                                            Ext.getCmp('strATMEndFeelTipoH').disable();
                                                                            Ext.getCmp('strATMEndFeelTipoH').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strATMEndFeelTipo1').allowBlank = true;
                                                                            Ext.getCmp('strATMEndFeelTipo1').setValue(null);
                                                                            Ext.getCmp('strATMEndFeelTipo1').disable();
                                                                            Ext.getCmp('strATMEndFeelTipo1').clearInvalid();
                                                                            
                                                                            Ext.getCmp('strATMEndFeelTipo1H').allowBlank = true;
                                                                            Ext.getCmp('strATMEndFeelTipo1H').setValue(null);
                                                                            Ext.getCmp('strATMEndFeelTipo1H').disable();
                                                                            Ext.getCmp('strATMEndFeelTipo1H').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strATMEndFeelTipo').enable();
                                                                            Ext.getCmp('strATMEndFeelTipo').allowBlank = false;
                                                                            
                                                                            Ext.getCmp('strATMEndFeelTipo1').enable();
                                                                            Ext.getCmp('strATMEndFeelTipo1').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Cierre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'TipoEndFeel',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stATMTipoEndFeel, 
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strATMEndFeelTipo',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() != "OTRO"){
                                                                            Ext.getCmp('strATMEndFeelTipoH').allowBlank = true;
                                                                            Ext.getCmp('strATMEndFeelTipoH').setValue(null);
                                                                            Ext.getCmp('strATMEndFeelTipoH').disable();
                                                                            Ext.getCmp('strATMEndFeelTipoH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strATMEndFeelTipoH').enable();
                                                                            Ext.getCmp('strATMEndFeelTipoH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 220,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strATMEndFeelTipoH'
                                                            },
                                                            {
                                                                html: 'Apertura:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'TipoEndFeel',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stATMTipoEndFeel, 
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strATMEndFeelTipo1',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() != "OTRO"){
                                                                            Ext.getCmp('strATMEndFeelTipo1H').allowBlank = true;
                                                                            Ext.getCmp('strATMEndFeelTipo1H').setValue(null);
                                                                            Ext.getCmp('strATMEndFeelTipo1H').disable();
                                                                            Ext.getCmp('strATMEndFeelTipo1H').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strATMEndFeelTipo1H').enable();
                                                                            Ext.getCmp('strATMEndFeelTipo1H').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 220,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strATMEndFeelTipo1H'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'RANGO DE MOVIMIENTO',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: false,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        layout: {
                                                            columns: 3,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {           
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 300,
                                                                style: 'background:transparent;',
                                                                labelStyle: 'text-align:right;',
                                                                title: '...',
                                                                layout: {
                                                                    columns: 1,
                                                                    type: 'table'
                                                                },
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 298,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: 'Apertura',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysRangoMovApertura'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 298,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: 'Protrusion',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysRangoMovProtrusion'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 298,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: 'Lateral Izquierdo',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysRangoMovLatIzq'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 298,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: 'Lateral Derecho',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysRangoMovLatDer'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 270,
                                                                style: 'background:transparent;',
                                                                labelStyle: 'text-align:right;',
                                                                title: '<center>Inicial</center>',
                                                                layout: {
                                                                    columns: 1,
                                                                    type: 'table'
                                                                },
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 269,
                                                                        allowBlank: true,
                                                                        id: 'strRangoMovAperturaIni'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 269,
                                                                        allowBlank: true,
                                                                        id: 'strRangoMovProtrusionIni'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 269,
                                                                        allowBlank: true,
                                                                        id: 'sysRangoMovLatIzqIni'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 269,
                                                                        allowBlank: true,
                                                                        id: 'strRangoMovLatDerFin'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 270,
                                                                style: 'background:transparent;',
                                                                labelStyle: 'text-align:right;',
                                                                title: '<center>Inicial</center>',
                                                                layout: {
                                                                    columns: 1,
                                                                    type: 'table'
                                                                },
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 269,
                                                                        allowBlank: true,
                                                                        id: 'strRangoMovAperturaFin'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 269,
                                                                        allowBlank: true,
                                                                        id: 'strRangoMovProtrusionFin'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 269,
                                                                        allowBlank: true,
                                                                        id: 'sysRangoMovLatIzqFin'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 269,
                                                                        allowBlank: true,
                                                                        id: 'strRangoMovLatDerFin'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SISTEMA OCLUSAL',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'SOBREMORDIDA',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 210,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Sobremordida',
                                                                        name: 'Sobremordida',
                                                                        width: 50,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strSistemaOclusalSobremordida',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaH').allowBlank = true;
                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaH').setValue(null);
                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaH').disable();
                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaH').clearInvalid();

                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaAlturaDienteInf').allowBlank = true;
                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaAlturaDienteInf').setValue(null);
                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaAlturaDienteInf').disable();
                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaAlturaDienteInf').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaH').enable();
                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaH').allowBlank = false;

                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaAlturaDienteInf').enable();
                                                                                    Ext.getCmp('strSistemaOclusalSobremordidaAlturaDienteInf').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 220,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        emptyText: 'Observaciones',
                                                                        id: 'strSistemaOclusalSobremordidaH'
                                                                    },
                                                                    {
                                                                        html: 'Altura Diente Inferior %:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        emptyText: 'mm',
                                                                        id: 'strSistemaOclusalSobremordidaAlturaDienteInf'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Sobremordida vertical',
                                                                        name: 'Sobremordida vertical',
                                                                        width: 50,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strSistemaOclusalSobremordidaV'
                                                                    },
                                                                    {
                                                                        html: '%:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: '%',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalSobremordidaVPorcen'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Sobremordida horizontal',
                                                                        name: 'Sobremordida horizontal',
                                                                        width: 50,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strSistemaOclusalSobremordidaH'
                                                                    },
                                                                    {
                                                                        html: '%:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: '%',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalSobremordidaHPorcen'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'RELACIONES ANTEROPOSTERIOR',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 210,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Relación Molar Derecha',
                                                                name: 'Relación Molar Derecha',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRelacionMolar,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaOclusalRelaMolarD'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Relación Molar Izquierda',
                                                                name: 'Relación Molar Izquierda',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRelacionMolar,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaOclusalRelaMolarI'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Relación Canina Derecha',
                                                                name: 'Relación Canina Derecha',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRelacionMolar,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaOclusalRelaCaninaD'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Relación Canina Izquierda',
                                                                name: 'Relación Canina Izquierda',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRelacionMolar,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaOclusalRelaCaninaI'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'RELACIONES TRANSVERSALES',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 210,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Mordida Cruzada unilateral',
                                                                        name: 'Mordida Cruzada unilateral',
                                                                        width: 90,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNoAplica',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO APLICA',
                                                                        id: 'strSistemaOclusalRelaTransversa1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Observaciones',
                                                                        emptyText: 'Observaciones',
                                                                        width: 500,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalRelaTransversa1H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Mordida Cruzada bilateral',
                                                                        name: 'Mordida Cruzada bilateral',
                                                                        width: 90,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNoAplica',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO APLICA',
                                                                        id: 'strSistemaOclusalRelaTransversa2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Observaciones',
                                                                        emptyText: 'Observaciones',
                                                                        width: 500,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalRelaTransversa2H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Mordida borde a borde',
                                                                        name: 'Mordida borde a borde',
                                                                        width: 90,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNoAplica',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO APLICA',
                                                                        id: 'strSistemaOclusalRelaTransversa3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Observaciones',
                                                                        emptyTet: 'Observaciones',
                                                                        width: 500,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalRelaTransversa3H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Mordida en tijera',
                                                                        name: 'Mordida en tijera',
                                                                        width: 90,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNoAplica',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO APLICA',
                                                                        id: 'strSistemaOclusalRelaTransversa4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Observaciones',
                                                                        emptyText: 'Observaciones',
                                                                        width: 500,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalRelaTransversa4H'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'SISTEMA DENTAL (Análisis Intra-arco)',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        labelWidth: 210,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Simetría del arco',
                                                                        name: 'Simetría del arco',
                                                                        width: 90,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNoAplica',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO APLICA',
                                                                        id: 'strSistemaOclusalAnalisisIntraArco1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Observaciones',
                                                                        emptyText: 'Observaciones',
                                                                        width: 500,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalAnalisisIntraArco1H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Lesiones no cariosas',
                                                                        name: 'Lesiones no cariosas',
                                                                        width: 90,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNoAplica',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO APLICA',
                                                                        id: 'strSistemaOclusalAnalisisIntraArco2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Observaciones',
                                                                        emptyText: 'Observaciones',
                                                                        width: 500,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalAnalisisIntraArco2H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Abrasión',
                                                                        name: 'Abrasión',
                                                                        width: 90,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNoAplica',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO APLICA',
                                                                        id: 'strSistemaOclusalAnalisisIntraArco3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Observaciones',
                                                                        emptyText: 'Observaciones',
                                                                        width: 500,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalAnalisisIntraArco3H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Atrisión',
                                                                        name: 'Atrisión',
                                                                        width: 90,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNoAplica',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO APLICA',
                                                                        id: 'strSistemaOclusalAnalisisIntraArco4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Observaciones',
                                                                        emptyText: 'Observaciones',
                                                                        width: 500,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalAnalisisIntraArco4H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Abfracción',
                                                                        name: 'Abfracción',
                                                                        width: 90,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNoAplica',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO APLICA',
                                                                        id: 'strSistemaOclusalAnalisisIntraArco5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Observaciones',
                                                                        emptyText: 'Observaciones',
                                                                        width: 500,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalAnalisisIntraArco5H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Erosión',
                                                                        name: 'Erosión',
                                                                        width: 90,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNoAplica',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO APLICA',
                                                                        id: 'strSistemaOclusalAnalisisIntraArco6'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Observaciones',
                                                                        emptyText: 'Observaciones',
                                                                        width: 500,
                                                                        allowBlank: true,
                                                                        id: 'strSistemaOclusalAnalisisIntraArco6H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'Superior'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        fieldLabel: 'Numero de dientes',
                                                                        name: 'Numero de dientes superior',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'intSistemaOclusalAnalisisIntraArcoDientesSup'
                                                                    },
                                                                    {
                                                                        html: 'Inferior'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Numero de dientes inferior',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'intSistemaOclusalAnalisisIntraArcoDientesinf'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Forma de Arco',
                                                                name: 'Forma de Arco',
                                                                width: 130,
                                                                allowBlank: false,
                                                                store: stFormaArco,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSistemaOclusalAnalisisIntraArcoForma'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },

                                            //////
                                            

                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Carta Dental Inicial (LEY 38/93)',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaCartaDentalInicial',
                                items: [
                                    xCartaDental
                                ]
                            },
                            
                            /*{
                                xtype: 'panel',
                                title: 'Plan de Tratamiento',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaTto',
                                items: [
                                    NecesidadesAtencionTratamiento
                                ]
                            },*/
                            {
                                xtype: 'panel',
                                title: 'Actividades Realizadas',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaActividades',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        id: 'IdOdontogramaUltimo'
                                    },
                                    {
                                        xtype: 'grid',
                                        layout: 'fit',
                                        id: 'gridDientesActividadesRealizadas',
                                        store: stGridDienteActividadesRealizadas,
                                        anchor: "100%",
                                        height: 470,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoDientesActividad',
                                                id: 'IdConsecutivoDientesActividad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: true,
                                                width: 110,
                                                dataIndex: 'FechaAtencion',
                                                id: 'FechaAtencion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Profesional',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'Profesional',
                                                id: 'Profesional'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Diente',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Diente',
                                                id: 'Diente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Superficie',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Superficie',
                                                id: 'Superficie'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Procedimiento/Actividad',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'DesProced',
                                                renderer: DescripcionGrid,
                                                id: 'DesProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Notas Evolución',
                                                sortable: false,
                                                width: 270,
                                                dataIndex: 'NotasEvolucion',
                                                renderer: DescripcionNotasEvolucion,
                                                id: 'NotasEvolucion'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                        {
                                            xtype: 'toolbar',
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Adicionar Registro',
                                                    iconCls: 'btnAddRow',
                                                    id: 'btnAddActividadDiente',
                                                    listeners: {
                                                        click : function() {
                                                            if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                                                var winAddDienteActividadRealizada = new winAddDienteActividadRealizadaUi();
                                                                Ext.getCmp('intPacienteDienteActividad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                Ext.getCmp('intCASDienteActividad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                Ext.getCmp('intNroDienteDienteActividad').store.load({
                                                                    params: {
                                                                        pTipo: "MIXTA"
                                                                    }
                                                                });
                                                                //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                Ext.getCmp('intIdProcedDienteActividad').store.load({
                                                                    params: {
                                                                        pServicio: "%ODONTOLO%",
                                                                        pCAS: myCAS
                                                                    }
                                                                });
                                                                winAddDienteActividadRealizada.show();
                                                            }else{
                                                                Ext.Msg.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Usted No ha Guardado la Historia',
                                                                    buttons: Ext.Msg.OK,
                                                                    icon: Ext.Msg.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Eliminar Registro',
                                                    iconCls: 'btnDelRow',
                                                    id: 'btnDelActividadDiente',
                                                    listeners: {
                                                        click : function() {
                                                            if(parseInt(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount()) === 1){
                                                                var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                                                if(selections[0].json.CAS === Ext.getCmp('sysCASHC').getValue()){
                                                                    Ext.Msg.show({
                                                                        title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                                        buttons: Ext.Msg.YESNO,
                                                                        icon: Ext.Msg.QUESTION,
                                                                        fn: function(btn)
                                                                        {
                                                                            if(btn === "yes")
                                                                            {
                                                                                fnEliminarRegistrosOdo("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                                            }
                                                                        }
                                                                    });
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Odontograma',
                                                    iconCls: 'btnDiente',
                                                    listeners:{
                                                        click : function(){
                                                            /*var RecordOdontogramaIni = Ext.getCmp('gridOdontogramasxPaciente').store.getAt(0); 
                                                            Ext.getCmp('IdOdontogramaUltimo').setValue(RecordOdontogramaIni.get('IdConsecutivoOdontograma'));
                                                            Ext.getCmp('IdOdontogramaViewOdontogramas').setValue(RecordOdontogramaIni.get('IdConsecutivoOdontograma'));
                                                            Ext.getCmp('winViewOdontogramas').show();*/
                                                            window.open ("../../controlador/asistencial/imprimirodontograma.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pEvolucion=0" + "&pConsecutivoDetalle=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Odontograma");
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Convenciones',
                                                    iconCls: 'btnDiente',
                                                    listeners:{
                                                        click : function(){
                                                            Ext.getCmp('winConvencionesOdontograma').show();
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Necesidades de Atencion',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                layout: 'form',
                                id: 'fichaNecesidaeesAtencion',
                                items: [
                                    {
                                        xtype: 'grid',
                                        id: 'gridNecesidadesAtencion',
                                        store: stGridNecesidadesAtencion,
                                        anchor: "100%",
                                        height: 270,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoDientesActividad',
                                                id: 'IdConsecutivoDientesActividad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Sol',
                                                sortable: false,
                                                width: 110,
                                                dataIndex: 'FecSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Servicio',
                                                sortable: false,
                                                width: 270,
                                                dataIndex: 'Servicio'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Prioridad',
                                                sortable: false,
                                                width: 60,
                                                dataIndex: 'Prioridad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Necesidades Atencion',
                                                sortable: false,
                                                width: 370,
                                                dataIndex: 'NecesidadesAtencion',
                                                renderer: DescripcionGrid
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Estado',
                                                sortable: false,
                                                width: 80,
                                                dataIndex: 'Estado'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Quien Remite',
                                                sortable: false,
                                                width: 200,
                                                dataIndex: 'ProfeRemite'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Inicio',
                                                sortable: false,
                                                width: 110,
                                                dataIndex: 'FechaInicio'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Cierre',
                                                sortable: false,
                                                width: 110,
                                                dataIndex: 'FechaCierre'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Motivo Cierre',
                                                sortable: false,
                                                width: 2500,
                                                dataIndex: 'MotivoCierre',
                                                renderer: DescripcionGrid
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        viewConfig: {
                                            getRowClass: function(record, index) {
                                                switch (record.get('EstadoRegistro')){
                                                    case "0":
                                                        return 'NeceAten0';
                                                        break;
                                                    case "1":
                                                        return 'NeceAten1';
                                                        break;
                                                    case "2":
                                                        return 'NeceAten2';
                                                        break;
                                                    case "3":
                                                        return 'NeceAten3';
                                                        break;
                                                    default:
                                                        return;
                                                        break;
                                                }
                                            }
                                        },
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar',
                                                        iconCls: 'btnAddRow',
                                                        id: 'btnAddNecesidadAtencion',
                                                        listeners: {
                                                            click : function() {
                                                                if (Ext.getCmp('sysYaGuardoHC').getValue() === 1 || Ext.getCmp('sysYaGuardoHC').getValue() === "1"){
                                                                    var winAddNecesidadAtencion = new winAddNecesidadAtencionUi();
                                                                    Ext.getCmp('sysNuevoNesecidad').setValue(0);
                                                                    Ext.getCmp('intPrestadorNesecidad').setValue(ID_EMPRESA);
                                                                    Ext.getCmp('intIPSNesecidad').setValue(ID_IPS);
                                                                    Ext.getCmp('intProfesionalNesecidad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                    Ext.getCmp('intCASNesecidad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                    Ext.getCmp('intPacienteNesecidad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                    Ext.getCmp('intUsuarioNesecidad').setValue(ID_USUARIO);
                                                                    Ext.getCmp('strFechaSolNesecidad').setValue(Ext.getCmp('sysFechaHC').getValue());
                                                                    winAddNecesidadAtencion.show();
                                                                }else{
                                                                    Ext.Msg.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'Usted No ha Guardado la Evolución',
                                                                        buttons: Ext.Msg.OK,
                                                                        icon: Ext.Msg.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Editar',
                                                        iconCls: 'btnEditRow',
                                                        id: 'btnEditNecesidadAtencion',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(Ext.getCmp('gridNecesidadesAtencion').selModel.getCount()) === 1){
                                                                    var selections = Ext.getCmp('gridNecesidadesAtencion').selModel.getSelections();
                                                                    if(selections[0].json.EstadoRegistro === "1"){
                                                                        Ext.Msg.show({
                                                                            title: 'Necesidades Atencion',
                                                                            msg: 'Esta Seguro que Desea Modificar el Registro ' + selections[0].json.Servicio + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn === "yes"){
                                                                                    var winAddNecesidadAtencion = new winAddNecesidadAtencionUi();
                                                                                    Ext.getCmp('sysNuevoNesecidad').setValue(1);
                                                                                    Ext.getCmp('sysIdConsecutivoNesecidad').setValue(selections[0].json.IdConsecutivoNecesidad);
                                                                                    Ext.getCmp('intPrestadorNesecidad').setValue(ID_EMPRESA);
                                                                                    Ext.getCmp('intIPSNesecidad').setValue(ID_IPS);
                                                                                    Ext.getCmp('intProfesionalNesecidad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                                    Ext.getCmp('intCASNesecidad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                    Ext.getCmp('intPacienteNesecidad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                    Ext.getCmp('intUsuarioNesecidad').setValue(ID_USUARIO);
                                                                                    Ext.getCmp('strFechaSolNesecidad').setValue(Ext.getCmp('sysFechaHC').getValue());
                                                                                    Ext.getCmp('intServicioNesecidad').setValue(selections[0].json.Programa);
                                                                                    Ext.getCmp('intPrioridadNesecidad').setValue(selections[0].json.Prioridad);
                                                                                    Ext.getCmp('memNesecidad').setValue(selections[0].json.NecesidadesAtencion);
                                                                                    winAddNecesidadAtencion.show();
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'El registro no esta disponible para ser modificado',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos modificar el registro en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar',
                                                        iconCls: 'btnDelRow',
                                                        id: 'btnDelNecesidadAtencion',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(Ext.getCmp('gridNecesidadesAtencion').selModel.getCount()) === 1){
                                                                    var selections = Ext.getCmp('gridNecesidadesAtencion').selModel.getSelections();
                                                                    if(selections[0].json.EstadoRegistro === "1"){
                                                                        Ext.Msg.show({
                                                                            title: 'Necesidades Atencion',
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.Servicio + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn === "yes"){
                                                                                    fnEliminarRegItemNecesidadAtencion("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_NECESIDAD_ATENCION", pIdRegistroNecesidad: selections[0].json.IdConsecutivoNecesidad}, 'gridNecesidadesAtencion');
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'El registro no esta disponible para ser eliminado',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar el registro en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    new Ext.app.SearchField({
                                                        id: 'qryNecesidadesAtencion',
                                                        store: stGridNecesidadesAtencion,
                                                        ValparamP1: wPaciente,
                                                        emptyText: 'Escriba el criterio que desea buscar',
                                                        width: 120,
                                                        pLoadGrid: false,
                                                        pGrid: 'gridNecesidadesAtencion',
                                                        parrParam: {params:{pPaciente: wPaciente}}
                                                    })
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Registro de Alertas',
                                height: 380,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaAlertas',
                                items: [
                                    xAlertasxPaciente
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones Externas',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imagenes Asociadas',
                            iconCls: 'btnCargarFoto',
                            listeners:{
                                click : function(){
                                    if(!winImgxPac){
                                        winImgxPac = new winImagenAsocxPac({
                                            url:'../../controlador/pacientes/controlador_filesasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winImgxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Documentos Asociados',
                            iconCls: 'btnCargarFile',
                            listeners:{
                                click : function(){
                                    if(!winDocxPac){
                                        winDocxPac = new winDocumentoAsocxPac({
                                            url:'../../controlador/pacientes/controlador_docsasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winDocxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosOdo004();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosOdo004();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                //Cargar Alertas del Paciente
                Ext.getCmp('gridAlertasPacientes').store.baseParams = {
                    task: 'LISTAR_ALERTAS',
                    pPaciente: myPaciente,
                    pIPS: ID_IPS
                };
                Ext.getCmp('gridAlertasPacientes').store.load({
                    params: {
                        pPaciente: myPaciente
                    },
                    callback: function(){
                        var contador = 0;
                        var html = '<table>';
                        Ext.getCmp('gridAlertasPacientes').store.each(function(record){
                            //record.get('citaID') + "^" + record.get('citaInfoAdd') + "^" + record.get('TipoHorario') + "¬";
                            html += '<tr><td width="750"><span style="color: #003333;font-weight: bold;">' + record.get('TipoAlerta') + ':&nbsp&nbsp' + record.get('Alerta') + '</span></td></tr>';
                            contador ++;
                        });
                        html += '</table>';
                        if(contador > 0){
                            Ext.MessageBox.show({
                                title: 'Alertas',
                                msg: html,
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.WARNING
                            });
                        }
                    }
                });
            }}
        }); 
        winHCAutonomaOdo004Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosOdo004(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhcuam.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pVerificarDocente: Ext.getCmp('sysVerificarDocenteHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnGuardarRegistrosOdo004(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhcuam.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pVerificarDocente: Ext.getCmp('sysVerificarDocenteHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
