/*
* @category    Formulario Modelo Anexo Reflejos - Neurodesarrollo
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winAnexoReflejosNeuroDesarrolloUi = Ext.extend(Ext.Window, {
    title: '.:: ANEXO Reflejos - Neurodesarrollo ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winAnexoReflejosNeuroDesarrollo',
    initComponent: function() {
        
    var dataAnexoReflejo = [
        ['Integrado'],
        ['Presente'],
        ['Ausente'],
        ['Esbozado'],
        ['No Evaluable']
    ];
    var stAnexoReflejo = new Ext.data.ArrayStore({
        fields: [
            {name: 'Descripcion'}
        ]
    });
    stAnexoReflejo.loadData(dataAnexoReflejo);
        
        
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '99%',
                height: 605,
                id: 'frmAnexoReflejosNeuroDesarrollo',
                padding: 5,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysCASAnexoReflejosNeuroDesarrollo'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPacienteAnexoReflejosNeuroDesarrollo'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysProfesionalAnexoReflejosNeuroDesarrollo'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexoReflejosNeuroDesarrollo'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'PRIMITIVOS',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Presion Palmar',
                                        fieldLabel: 'Presion Palmar',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND1'
                                    },
                                    {
                                        html: 'Presion Plantar'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Presion Plantar',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND2'
                                    },
                                    {
                                        html: 'Marcha Automatica'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Marcha Automatica',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND3'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Posicion de Pie Primaria',
                                        fieldLabel: 'Posicion de Pie Primaria',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND4'
                                    },
                                    {
                                        html: 'Moro'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Moro',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND5'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'ESPINALES',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Extension Cruzada',
                                        fieldLabel: 'Extension Cruzada',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND6'
                                    },
                                    {
                                        html: 'Empuje Extensor'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Empuje Extensor',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND7'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Retirada Flexora',
                                        fieldLabel: 'Retirada Flexora',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND8'
                                    },
                                    {
                                        html: 'Galant'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Galant',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND9'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'TALLO CEREBRAL',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Tonico Cervical Simetrico',
                                        fieldLabel: 'Tonico Cervical Simetrico',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND10'
                                    },
                                    {
                                        html: 'Tonico Cervical Asimetrico'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tonico Cervical Asimetrico',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND11'
                                    },
                                    {
                                        html: 'Tonico Laberintico en Prono'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tonico Laberintico en Prono',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND12'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Tonico Laberintico en Supino',
                                        fieldLabel: 'Tonico Laberintico en Supino',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND13'
                                    },
                                    {
                                        html: 'Reaccion Positiva de Soporte'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Reaccion Positiva de Soporte',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND14'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'MESENCEFALO',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Enderezamiento Optico',
                                        fieldLabel: 'Enderezamiento Optico',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND15'
                                    },
                                    {
                                        html: 'Enderezamiento Laberintico'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Enderezamiento Laberintico',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND16'
                                    },
                                    {
                                        html: 'Enderezamiento Cervical'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Enderezamiento Cervical',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND17'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Enderezamiento Cuerpo/Cuerpo',
                                        fieldLabel: 'Enderezamiento Cuerpo/Cuerpo',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND18'
                                    },
                                    {
                                        html: 'Reacciones Protectivas Anteriores'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Reacciones Protectivas Anteriores',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND19'
                                    },
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        html: 'Reacciones Protectivas Laterales'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Reacciones Protectivas Laterales',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND20'
                                    },
                                    {
                                        html: 'Reacciones Protectivas Posteriores'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Reacciones Protectivas Posteriores',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND21'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'CORTEZA CEREBRAL',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Reac. Equilibrio en Prono',
                                        fieldLabel: 'Reacciones de Equilibrio en Prono',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND22'
                                    },
                                    {
                                        html: 'Reac. Equilibrio en Supino'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Reacciones de Equilibrio en Supino',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND23'
                                    },
                                    {
                                        html: 'Reac. Equilibrio en Sedente'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Reacciones de Equilibrio en Sedente',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND24'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Reacciones de Equilibrio en Cuadrupedo',
                                        fieldLabel: 'Reacciones de Equilibrio en Cuadrupedo',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND25'
                                    },
                                    {
                                        html: 'Reacciones de Equilibrio en Bipedo'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Reacciones de Equilibrio en Bipedo',
                                        width: 150,
                                        allowBlank: false,
                                        store: stAnexoReflejo,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strARND26'
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirAnexoReflejosNeuroDesarrollo',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoReflejosNeuroDesarrollo').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoReflejosNeuroDesarrollo').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado el Anexo y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoReflejosNeuroDesarrollo').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Anexo',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAnexoReflejosNeuroDesarrollo',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoReflejosNeuroDesarrollo').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarAnexoReflejosNeuroDesarrollo();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarAnexoReflejosNeuroDesarrollo();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        
        winAnexoReflejosNeuroDesarrolloUi.superclass.initComponent.call(this);
    }
});

function fnGuardarAnexoReflejosNeuroDesarrollo(){
    var frm = Ext.getCmp('frmAnexoReflejosNeuroDesarrollo').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'GuardarAnexoReflejosNeuroDesarrollo',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoReflejosNeuroDesarrollo').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoReflejosNeuroDesarrollo').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoReflejosNeuroDesarrollo').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoReflejosNeuroDesarrollo').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarAnexoReflejosNeuroDesarrollo(){
    var frm = Ext.getCmp('frmAnexoReflejosNeuroDesarrollo').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'ModificarAnexoReflejosNeuroDesarrollo',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoReflejosNeuroDesarrollo').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoReflejosNeuroDesarrollo').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoReflejosNeuroDesarrollo').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoReflejosNeuroDesarrollo').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
