/*
* @category    Formulario Modelo Anexo Examen Muscular MMSS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winAnexoExamenMuscularMMSSUi = Ext.extend(Ext.Window, {
    title: '.:: ANEXO EXAMEN MUSCULAR MMSS ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winAnexoExamenMuscularMMSS',
    initComponent: function() {
    
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '98%',
                height: 605,
                id: 'frmAnexoMuscularMMSS',
                padding: 5,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysCASAnexoMuscularMMSS'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPacienteAnexoMuscularMMSS'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysProfesionalAnexoMuscularMMSS'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexoMuscularMMSS'
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        anchor: '99%',
                        labelWidth: 150,
                        items:[
                            {
                                xtype: 'checkboxgroup',
                                anchor: '99%',
                                fieldLabel: 'Miembro/Parte del Cuerpo?',
                                columns: 4,
                                vertical: true,
                                id: 'strRegistarAnexo2Miembro',
                                items: [
                                    {boxLabel: "Escapula", inputValue: "Escapula"},
                                    {boxLabel: "Hombro", inputValue: "Hombro"},
                                    {boxLabel: "Codo", inputValue: "Codo"},
                                    {boxLabel: "Antebrazo", inputValue: "Antebrazo"},
                                    {boxLabel: "Muñeca", inputValue: "Muneca"},
                                    {boxLabel: "Dedos", inputValue: "Dedos"},
                                    {boxLabel: "V. Dedo", inputValue: "V. Dedo"},
                                    {boxLabel: "Pulgar", inputValue: "Pulgar"}
                                ],
                                listeners:{
                                    change : function(t, itemsCheck){
                                        Ext.getCmp('strRegistarAnexo2Miembro').items.each(function(item) {
                                            if(item.getRawValue() == "Escapula"){
                                                if(item.getValue() == true){
                                                    Ext.getCmp('fsAMMSSPM1').setVisible(true);
                                                }else{
                                                    fnfsAMMSSPM1Limpiar();
                                                }
                                            }
                                            if(item.getRawValue() == "Hombro"){
                                                if(item.getValue() == true){
                                                    Ext.getCmp('fsAMMSSPM2').setVisible(true);
                                                }else{
                                                    fnfsAMMSSPM2Limpiar();
                                                }
                                            }
                                            if(item.getRawValue() == "Codo"){
                                                if(item.getValue() == true){
                                                    Ext.getCmp('fsAMMSSPM3').setVisible(true);
                                                }else{
                                                    fnfsAMMSSPM3Limpiar();
                                                }
                                            }
                                            if(item.getRawValue() == "Antebrazo"){
                                                if(item.getValue() == true){
                                                    Ext.getCmp('fsAMMSSPM4').setVisible(true);
                                                }else{
                                                    fnfsAMMSSPM4Limpiar();
                                                }
                                            }
                                            if(item.getRawValue() == "Muneca"){
                                                if(item.getValue() == true){
                                                    Ext.getCmp('fsAMMSSPM5').setVisible(true);
                                                }else{
                                                    fnfsAMMSSPM5Limpiar();
                                                }
                                            }
                                            if(item.getRawValue() == "Dedos"){
                                                if(item.getValue() == true){
                                                    Ext.getCmp('fsAMMSSPM6').setVisible(true);
                                                }else{
                                                    fnfsAMMSSPM6Limpiar();
                                                }
                                            }
                                            if(item.getRawValue() == "V. Dedo"){
                                                if(item.getValue() == true){
                                                    Ext.getCmp('fsAMMSSPM7').setVisible(true);
                                                }else{
                                                    fnfsAMMSSPM7Limpiar();
                                                }
                                            }
                                            if(item.getRawValue() == "Pulgar"){
                                                if(item.getValue() == true){
                                                    Ext.getCmp('fsAMMSSPM8').setVisible(true);
                                                }else{
                                                    fnfsAMMSSPM8Limpiar();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Espacula',
                        layout: 'form',
                        width: 925,
                        autoHeight: true,
                        padding: 5,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        id: 'fsAMMSSPM1',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'ABD Serrato Ant, C5-7 Torácico largo',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula1Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ADD Trapecio Med. C2-4 Accesorio',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula2Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Romboide: C4-5 dorsal de la escapula',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula3Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ELV Trapecio sup C2-4 Accesorio',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula4Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Elevador escap. C3-6 Accesorio',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula5Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula5Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'DEPRE Latismodel dorso C5-8 Toracorsal',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula6Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula6Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Trapecio inf. C2-4 Accesorio',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula7Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Escapula7Der'
                                            }
                                        ]   
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Hombro',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMSSPM2',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'FLEX Deltoideo ant. C5-6 Circunflejo',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro1Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXT. Latismo del dorso C6-8 Toracodorsal',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro2Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Terete mayor C5-7 Subescapular',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro3Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Abd Deltoideo med. C5-6 Circunflejo',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro4Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Abd HOR Deltoideo post. C5-6 Circunflejo',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro5Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro5Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Abd HOR Pectoral mayor C5-DI Pectoral',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro6Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro6Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ROT. EXT. Infraespinoso C4-6 Suproescapular',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro7Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro7Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Terete Menor C5-6 Circunflejo',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro8Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro8Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ROT. INT. Subescapular C5-6 Subescapular',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro9Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Hombro9Der'
                                            }
                                        ]   
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Codo',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMSSPM3',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'FLEX Biceps braquial C5-6 Musculocutaneo',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Codo1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Codo1Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Braquiorradial C5-6 Musculocutaneo',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Codo2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Codo2Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXT. Triceps braquial C5-6 Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Codo3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Codo3Der'
                                            }
                                        ]   
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Antebrazo',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMSSPM4',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'SUPI Grupo Supinador C5-6 Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Antebrazo1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Antebrazo1Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'PRONA Grupo pronador C6-DI Mediano',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Antebrazo2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Antebrazo2Der'
                                            }
                                        ]   
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Muneca',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMSSPM5',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'FLEX Flex Radial del campo C6- mediano',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Muneca1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Muneca1Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex Ulnar del carpo C6 Ulnar',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Muneca2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Muneca2Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXT Ext. Radial corto y largo del carpo C6-7 Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Muneca3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Muneca3Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext. Ulnar del carpo C7- Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Muneca4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Muneca4Der'
                                            }
                                        ]   
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Dedos',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMSSPM6',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Lubricales 1. C7-8 Mediano',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos1Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex MF 2',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos2Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex MF 3 C8 Ulnar',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos3Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex MF 4',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos4Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex Profundo de los dedos 1 C8-DI Mediano',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos5Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos5Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex IF Proximal 2',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos6Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos6Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex IF Proximal 3',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos7Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos7Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex IF Proximal 4',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos8Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos8Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex Profundo de los dedos 1 C8 - DI Mediano',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos9Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos9Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex IF Distal 2',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos10Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos10Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex IF Distal 3 C8-DI Ulnar',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos11Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos11Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex IF Distal 4',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos12Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos12Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext Comun de los dedos 1 C8 Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos13Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos13Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXT MF 2',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos14Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos14Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXT MF 3',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos15Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos15Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXT MF 4',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos16Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos16Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXT. indice EXT. del indice C7 Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos17Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos17Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Interaceos Palmares 1 C8-Ulnar',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos18Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos18Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ADD 2',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos19Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos19Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ADD 3',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos20Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos20Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'interaceos Dorsales 1 C8- Ulnar',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos21Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos21Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ABD 2',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos22Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos22Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ABD 3',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos23Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos23Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ABD 4',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos24Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Dedos24Der'
                                            }
                                        ]   
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'V Dedo',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMSSPM7',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'EXT. Ext. del dedo menique C7 Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_VDedo1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_VDedo1Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'FLEX Flex corto del dedo menique C8-DI Ulnar',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_VDedo2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_VDedo2Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ABD Abd del dedo menique C8-DI Ulnar',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_VDedo3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_VDedo3Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'OPP Opp del dedo menique C8-DI Ulnar',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_VDedo4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_VDedo4Der'
                                            }
                                        ]   
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Pulgar',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMSSPM8',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'FLEX M.F. Flex corto del pulgar C6-8 Mediano',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar1Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'FLEX I.F. Flex largo del Pulgar C6-DI Mediano',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar2Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXT. M.F. corto del pulgar C7 Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar3Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXT. L.F. Ext largo del pulgar C7 Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar4Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Abd Corto del pulgar C6-7 Mediano',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar5Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar5Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: ' ABD Abd largo del pulgar C7 Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar6Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar6Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: ' ADD Aductor del pulgar C8 Ulnar',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar7Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar7Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: ' OPO Oponente del Pulgar C6-8 DI Mediano',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                      {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar8Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 355,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMSS_Pulgar8Der'
                                            }
                                        ]   
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirAnexoExamenMuscularMMSS',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoMuscularMMSS').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoExamenMuscularMMSS').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado el Anexo y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoExamenMuscularMMSS').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Anexo',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAnexoExamenMuscularMMSS',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoMuscularMMSS').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarAnexoExamenMuscularMMSS();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarAnexoExamenMuscularMMSS();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    Ext.getCmp('fsAMMSSPM1').setVisible(false);
                    Ext.getCmp('fsAMMSSPM2').setVisible(false);
                    Ext.getCmp('fsAMMSSPM3').setVisible(false);
                    Ext.getCmp('fsAMMSSPM4').setVisible(false);
                    Ext.getCmp('fsAMMSSPM5').setVisible(false);
                    Ext.getCmp('fsAMMSSPM6').setVisible(false);
                    Ext.getCmp('fsAMMSSPM7').setVisible(false);
                    Ext.getCmp('fsAMMSSPM8').setVisible(false);
                }
            }
        });
        winAnexoExamenMuscularMMSSUi.superclass.initComponent.call(this);
    }
});

function fnGuardarAnexoExamenMuscularMMSS(){
    var frm = Ext.getCmp('frmAnexoMuscularMMSS').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'GuardarAnexoMuscularMMSS',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoMuscularMMSS').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoMuscularMMSS').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoMuscularMMSS').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoMuscularMMSS').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarAnexoExamenMuscularMMSS(){
    var frm = Ext.getCmp('frmAnexoMuscularMMSS').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'ModificarAnexoMuscularMMSS',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoMuscularMMSS').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoMuscularMMSS').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoMuscularMMSS').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoMuscularMMSS').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnfsAMMSSPM1Limpiar(){
    Ext.getCmp('strAMMSS_Escapula1Izq').setValue(null);
    Ext.getCmp('strAMMSS_Escapula1Der').setValue(null);
    Ext.getCmp('strAMMSS_Escapula2Izq').setValue(null);
    Ext.getCmp('strAMMSS_Escapula2Der').setValue(null);
    Ext.getCmp('strAMMSS_Escapula3Izq').setValue(null);
    Ext.getCmp('strAMMSS_Escapula3Der').setValue(null);
    Ext.getCmp('strAMMSS_Escapula4Izq').setValue(null);
    Ext.getCmp('strAMMSS_Escapula4Der').setValue(null);
    Ext.getCmp('strAMMSS_Escapula5Izq').setValue(null);
    Ext.getCmp('strAMMSS_Escapula5Der').setValue(null);
    Ext.getCmp('strAMMSS_Escapula6Izq').setValue(null);
    Ext.getCmp('strAMMSS_Escapula6Der').setValue(null);
    Ext.getCmp('strAMMSS_Escapula7Izq').setValue(null);
    Ext.getCmp('strAMMSS_Escapula7Der').setValue(null);
    Ext.getCmp('fsAMMSSPM1').setVisible(false);
}

function fnfsAMMSSPM2Limpiar(){
    Ext.getCmp('strAMMSS_Hombro1Izq').setValue(null);
    Ext.getCmp('strAMMSS_Hombro1Der').setValue(null);
    Ext.getCmp('strAMMSS_Hombro2Izq').setValue(null);
    Ext.getCmp('strAMMSS_Hombro2Der').setValue(null);
    Ext.getCmp('strAMMSS_Hombro3Izq').setValue(null);
    Ext.getCmp('strAMMSS_Hombro3Der').setValue(null);
    Ext.getCmp('strAMMSS_Hombro4Izq').setValue(null);
    Ext.getCmp('strAMMSS_Hombro4Der').setValue(null);
    Ext.getCmp('strAMMSS_Hombro5Izq').setValue(null);
    Ext.getCmp('strAMMSS_Hombro5Der').setValue(null);
    Ext.getCmp('strAMMSS_Hombro6Izq').setValue(null);
    Ext.getCmp('strAMMSS_Hombro6Der').setValue(null);
    Ext.getCmp('strAMMSS_Hombro7Izq').setValue(null);
    Ext.getCmp('strAMMSS_Hombro7Der').setValue(null);
    Ext.getCmp('strAMMSS_Hombro8Izq').setValue(null);
    Ext.getCmp('strAMMSS_Hombro8Der').setValue(null);
    Ext.getCmp('strAMMSS_Hombro9Izq').setValue(null);
    Ext.getCmp('strAMMSS_Hombro9Der').setValue(null);
    Ext.getCmp('fsAMMSSPM2').setVisible(false);
}

function fnfsAMMSSPM3Limpiar(){
    Ext.getCmp('strAMMSS_Codo1Izq').setValue(null);
    Ext.getCmp('strAMMSS_Codo1Der').setValue(null);
    Ext.getCmp('strAMMSS_Codo2Izq').setValue(null);
    Ext.getCmp('strAMMSS_Codo2Der').setValue(null);
    Ext.getCmp('strAMMSS_Codo3Izq').setValue(null);
    Ext.getCmp('strAMMSS_Codo3Der').setValue(null);
    Ext.getCmp('fsAMMSSPM3').setVisible(false);
}
function fnfsAMMSSPM4Limpiar(){
Ext.getCmp('fsAMMSSPM4').setVisible(false);
    Ext.getCmp('strAMMSS_Antebrazo1Izq').setValue(null);
    Ext.getCmp('strAMMSS_Antebrazo1Der').setValue(null);
    Ext.getCmp('strAMMSS_Antebrazo2Izq').setValue(null);
    Ext.getCmp('strAMMSS_Antebrazo2Der').setValue(null);
}
function fnfsAMMSSPM5Limpiar(){
Ext.getCmp('fsAMMSSPM5').setVisible(false);
    Ext.getCmp('strAMMSS_Muneca1Izq').setValue(null);
    Ext.getCmp('strAMMSS_Muneca1Der').setValue(null);
    Ext.getCmp('strAMMSS_Muneca2Izq').setValue(null);
    Ext.getCmp('strAMMSS_Muneca2Der').setValue(null);
    Ext.getCmp('strAMMSS_Muneca3Izq').setValue(null);
    Ext.getCmp('strAMMSS_Muneca3Der').setValue(null);
}
function fnfsAMMSSPM6Limpiar(){
Ext.getCmp('fsAMMSSPM6').setVisible(false);
    Ext.getCmp('strAMMSS_Dedos1Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos1Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos2Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos2Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos3Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos3Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos4Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos4Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos5Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos5Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos6Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos6Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos7Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos7Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos8Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos8Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos9Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos9Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos10Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos10Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos11Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos11Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos12Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos12Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos13Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos13Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos14Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos14Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos15Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos15Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos16Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos16Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos17Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos17Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos18Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos18Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos19Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos19Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos20Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos20Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos21Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos21Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos22Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos22Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos23Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos23Der').setValue(null);
    Ext.getCmp('strAMMSS_Dedos24Izq').setValue(null);
    Ext.getCmp('strAMMSS_Dedos24Der').setValue(null);
}

function fnfsAMMSSPM7Limpiar(){
Ext.getCmp('fsAMMSSPM7').setVisible(false);
    Ext.getCmp('strAMMSS_VDedo1Izq').setValue(null);
    Ext.getCmp('strAMMSS_VDedo1Der').setValue(null);
    Ext.getCmp('strAMMSS_VDedo2Izq').setValue(null);
    Ext.getCmp('strAMMSS_VDedo2Der').setValue(null);
    Ext.getCmp('strAMMSS_VDedo3Izq').setValue(null);
    Ext.getCmp('strAMMSS_VDedo3Der').setValue(null);
    Ext.getCmp('strAMMSS_VDedo4Izq').setValue(null);
    Ext.getCmp('strAMMSS_VDedo4Der').setValue(null);
}
function fnfsAMMSSPM8Limpiar(){
Ext.getCmp('fsAMMSSPM8').setVisible(false);
    Ext.getCmp('strAMMSS_Pulgar1Izq').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar1Der').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar2Izq').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar2Der').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar3Izq').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar3Der').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar4Izq').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar4Der').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar5Izq').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar5Der').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar6Izq').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar6Der').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar7Izq').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar7Der').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar8Izq').setValue(null);
    Ext.getCmp('strAMMSS_Pulgar8Der').setValue(null);
}
