/*
* @category    Formulario Modelo Anexo Examen Muscular MMII
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winAnexoExamenMuscularMMIIUi = Ext.extend(Ext.Window, {
    title: '.:: ANEXO Examen Muscular MMII ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winAnexoExamenMuscularMMII',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '99%',
                height: 605,
                id: 'frmAnexoExamenMuscularMMII',
                padding: 5,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysCASAnexoExamenMuscularMMII'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPacienteAnexoExamenMuscularMMII'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysProfesionalAnexoExamenMuscularMMII'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexoExamenMuscularMMII'
                    },
                    {
                        xtype: 'checkboxgroup',
                        anchor: '98%',
                        fieldLabel: 'Miembro/Parte del Cuerpo?',
                        columns: 3,
                        vertical: true,
                        id: 'strRegistarAnexo3Miembro',
                        items: [
                            {boxLabel: "Cuello", inputValue: "Cuello"},
                            {boxLabel: "Tronco", inputValue: "Tronco"},
                            {boxLabel: "Cadera", inputValue: "Cadera"},
                            {boxLabel: "Rodilla", inputValue: "Rodilla"},
                            {boxLabel: "Pie", inputValue: "Pie"},
                            {boxLabel: "Dedos", inputValue: "Dedos"},
                            {boxLabel: "Hallux", inputValue: "Hallux"}
                        ],
                        listeners:{
                            change : function(t, itemsCheck){
                                Ext.getCmp('strRegistarAnexo3Miembro').items.each(function(item) {
                                    if(item.getRawValue() == "Cuello"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMMIIPM1').setVisible(true);
                                        }else{
                                            fnfsAMMIIPM1Limpiar();
                                        }
                                    }

                                    if(item.getRawValue() == "Tronco"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMMIIPM2').setVisible(true);
                                        }else{
                                            fnfsAMMIIPM2Limpiar();
                                        }
                                    }

                                    if(item.getRawValue() == "Cadera"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMMIIPM3').setVisible(true);
                                        }else{
                                            fnfsAMMIIPM3Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Rodilla"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMMIIPM4').setVisible(true);
                                        }else{
                                            fnfsAMMIIPM4Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Pie"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMMIIPM5').setVisible(true);
                                        }else{
                                            fnfsAMMIIPM5Limpiar();
                                        }
                                    }        
                                    if(item.getRawValue() == "Dedos"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMMIIPM6').setVisible(true);
                                         }else{
                                            fnfsAMMIIPM6Limpiar();
                                        }
                                    }   
                                    if(item.getRawValue() == "Hallux"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMMIIPM7').setVisible(true);
                                        }else{
                                            fnfsAMMIIPM7Limpiar();
                                        }
                                    }
                                });
                            }
                        }
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Cuello',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMIIPM1',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flex Externocleidomasto. C2-4 Accesorio',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cuello1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cuello1Der'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext Grupo Extensor C1-5',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                              {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cuello2Izq'
                                            },   
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cuello2Der'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Tronco',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMIIPM2',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flex Recto del Abdomen D5-l2 Intercostales',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                              {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco1Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rotac. Obl. Ext. Der Obl. Ext. Izq D5-L2',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco2Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rotac. Obl. Int. Izq. Obl. Int. Der. D7-L2',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco3Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext. Grupo Toraxico D1-S3',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco4Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext. Grupo Lumbar D1-S3',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco5Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco5Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Elev. Cuadrado de los Lomos D12-L3',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco6Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Tronco6Der'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Cadera',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMIIPM3',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flex. Iliopsas L1-4 Femoral',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera1Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext Gluteo Max L5-S1 2 Gluteo int.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera2Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Abd Gluteo Med L4-S1 Gluteo Sup',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera3Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Add Grupo Aductor L2-4 Obturador',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera4Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rot. Ext. Grupo Rot. Ext. L3-5 S1-2',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera5Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera5Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rot. Int. Grupo Rot. Int. L4-5 Gluteo Sup.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera6Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera6Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rot. Int. Sartorio L2-4 Femoral',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera7Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera7Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rot. Int. Tensor. Fasc. Lata l4-5 Gluteo sup',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera8Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Cadera8Der'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Rodilla',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMIIPM4',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flex. Biceps Femoral L3 S1-3',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Rodilla1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Rodilla1Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex Inter.L4-5 S1-2 Isquiatico',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Rodilla2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Rodilla2Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext.Cuadriceps Femoral L2-4 Femoral',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Rodilla3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Rodilla3Der'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Pie ',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMIIPM5',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Plantiflex. Gastrocnemio S1-2 Tibial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                              {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie1Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Plantiflex. Soleo L5 S1-2',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie2Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Plantiflex. Inv. Tibial Posterior L4-5 S1-2 Tibial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie3Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Dorsiflex. Inv. Tibial Anterior L4-5 S1 Peroneo Comun',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie4Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ever. Peroneo Largo L4-5 S1 Peroneo Comun',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie5Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie5Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ever. Peroneo Corto L4-5 S1 Peroneo Comun',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie6Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Pie6Der'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Dedos',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMIIPM6',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flex. MF Lumbricales L5 S1-2 Tibial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Dedos1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Dedos1Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex. IFP Flexor Corto Dedos L5 S1 Tibial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Dedos2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Dedos2Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex. IFD Flexor Largo Dedos L5 S1-2 Tibial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Dedos3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Dedos3Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext. IFP Extensor Corto Dedos L4-5 S1-2 Peroneo Comun',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Dedos4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Dedos4Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext. IFD Extensor Largo Dedos L4-5 S1-2 Peroneo Comun',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Dedos5Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Dedos5Der'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Hallux',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMMIIPM7',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flex. IFP Flexor Corto Hallux L5 S1 Tibial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Hallux1Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Hallux1Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Flex. IFP Flexor Largo Hallux L5 S1-2 Tibial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Hallux2Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Hallux2Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext. MF Extensor Corto Hallux L4-5 S1 Peroneo Comun',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Hallux3Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Hallux3Der'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ext. LF Extensor Largo Hallux L4-5 S1 Peroneo Comun',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Hallux4Izq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strAMMIIPM_Hallux4Der'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '98%',
                        fieldLabel: 'Observaciones',
                        name: 'Observaciones',
                        height: 100,            
                        allowBlank: true,
                        id: 'strAMMIIPMObservaciones'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirAnexoExamenMuscularMMII',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoExamenMuscularMMII').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoExamenMuscularMMII').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado el Anexo y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoExamenMuscularMMII').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Anexo',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAnexoExamenMuscularMMII',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoExamenMuscularMMII').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarAnexoExamenMuscularMMII();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarAnexoExamenMuscularMMII();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    Ext.getCmp('fsAMMIIPM1').setVisible(false);
                    Ext.getCmp('fsAMMIIPM2').setVisible(false);
                    Ext.getCmp('fsAMMIIPM3').setVisible(false);
                    Ext.getCmp('fsAMMIIPM4').setVisible(false);
                    Ext.getCmp('fsAMMIIPM5').setVisible(false);
                    Ext.getCmp('fsAMMIIPM6').setVisible(false);
                    Ext.getCmp('fsAMMIIPM7').setVisible(false);

                }
            }
        });
        winAnexoExamenMuscularMMIIUi.superclass.initComponent.call(this);
    }
});

function fnGuardarAnexoExamenMuscularMMII(){
    var frm = Ext.getCmp('frmAnexoExamenMuscularMMII').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'GuardarAnexoExamenMuscularMMII',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoExamenMuscularMMII').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoExamenMuscularMMII').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoExamenMuscularMMII').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoExamenMuscularMMII').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarAnexoExamenMuscularMMII(){
    var frm = Ext.getCmp('frmAnexoExamenMuscularMMII').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'ModificarAnexoExamenMuscularMMII',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoExamenMuscularMMII').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoExamenMuscularMMII').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoExamenMuscularMMII').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoExamenMuscularMMII').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
function fnfsAMMIIPM1Limpiar(){
    Ext.getCmp('fsAMMIIPM1').setVisible(false);
    Ext.getCmp('strAMMIIPM_Cuello1Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Cuello1Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Cuello2Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Cuello2Der').setValue(null);
}
function fnfsAMMIIPM2Limpiar(){
    Ext.getCmp('fsAMMIIPM2').setVisible(false);
    Ext.getCmp('strAMMIIPM_Tronco1Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco1Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco2Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco2Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco3Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco3Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco4Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco4Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco5Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco5Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco6Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Tronco6Der').setValue(null);
}
function fnfsAMMIIPM3Limpiar(){
    Ext.getCmp('fsAMMIIPM3').setVisible(false);
    Ext.getCmp('strAMMIIPM_Cadera1Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera1Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera2Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera2Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera3Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera3Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera4Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera4Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera5Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera5Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera6Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera6Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera7Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera7Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera8Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Cadera8Der').setValue(null);
}
function fnfsAMMIIPM4Limpiar(){
    Ext.getCmp('fsAMMIIPM4').setVisible(false);
    Ext.getCmp('strAMMIIPM_Rodilla1Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Rodilla1Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Rodilla2Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Rodilla2Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Rodilla3Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Rodilla3Der').setValue(null);
}
function fnfsAMMIIPM5Limpiar(){
    Ext.getCmp('fsAMMIIPM5').setVisible(false);
    Ext.getCmp('strAMMIIPM_Pie1Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie1Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie2Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie2Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie3Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie3Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie4Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie4Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie5Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie5Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie6Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Pie6Der').setValue(null);
}
function fnfsAMMIIPM6Limpiar(){
    Ext.getCmp('fsAMMIIPM6').setVisible(false);
    Ext.getCmp('strAMMIIPM_Dedos1Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Dedos1Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Dedos2Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Dedos2Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Dedos3Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Dedos3Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Dedos4Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Dedos4Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Dedos5Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Dedos5Der').setValue(null);
}
function fnfsAMMIIPM7Limpiar(){
    Ext.getCmp('fsAMMIIPM7').setVisible(false);
    Ext.getCmp('strAMMIIPM_Hallux1Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Hallux1Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Hallux2Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Hallux2Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Hallux3Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Hallux3Der').setValue(null);
    Ext.getCmp('strAMMIIPM_Hallux4Izq').setValue(null);
    Ext.getCmp('strAMMIIPM_Hallux4Der').setValue(null);
}
