/*
* @category    Formulario Modelo Anexo Evalucion de la Funcion de los Musculos Faciales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winAnexoEvaluacionFuncionMusculosFacialesUi = Ext.extend(Ext.Window, {
    title: '.:: ANEXO Evalucion de la Funcion de los Musculos Faciales ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winAnexoEvaluacionFuncionMusculosFaciales',
    initComponent: function() {
    
    var dataAnexoEvaluacionMusculosFaciales = [
        ['F','Funcional; Normal o Solo Leve Dano'],
        ['FD','Funcion Debil; Dano moderado que afecta el grado de movimiento activo'],
        ['NF','No Funciona; Dano Severo'],
        ['O','Ausencia de Funcionalidad']
    ];
    var stAnexoEvaluacionMusculosFaciales = new Ext.data.ArrayStore({
        fields: [
            {name: 'Codigo'},
            {name: 'Descripcion'}
        ]
    });
    stAnexoEvaluacionMusculosFaciales.loadData(dataAnexoEvaluacionMusculosFaciales);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '99%',
                height: 605,
                id: 'frmAnexoEvaluacionFuncionMusculosFaciales',
                padding: 5,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysCASAnexoEvaluacionFuncionMusculosFaciales'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPacienteAnexoEvaluacionFuncionMusculosFaciales'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysProfesionalAnexoEvaluacionFuncionMusculosFaciales'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexoEvaluacionFuncionMusculosFaciales'
                    },
                    {
                        xtype: 'combo',
                        name: 'Frontal',
                        fieldLabel: 'Frontal',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial1"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial1',
                        id: 'strEvaluacionFacial1'
                    },
                    {
                        xtype: 'combo',
                        name: 'Superciliar',
                        fieldLabel: 'Superciliar',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial2"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial2',
                        id: 'strEvaluacionFacial2'
                    },
                    {
                        xtype: 'combo',
                        name: 'Orbicular de los Parpados',
                        fieldLabel: 'Orbicular de los Parpados',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial3"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial3',
                        id: 'strEvaluacionFacial3'
                    },
                    {
                        xtype: 'combo',
                        name: 'Palpebral',
                        fieldLabel: 'Palpebral',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial4"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial4',
                        id: 'strEvaluacionFacial4'
                    },
                    {
                        xtype: 'combo',
                        name: 'Piramidal - Triangular de la Nariz',
                        fieldLabel: 'Piramidal - Triangular de la Nariz',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial5"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial5',
                        id: 'strEvaluacionFacial5'
                    },
                    {
                        xtype: 'combo',
                        name: 'Nasal',
                        fieldLabel: 'Nasal',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial6"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial6',
                        id: 'strEvaluacionFacial6'
                    },
                    {
                        xtype: 'combo',
                        name: 'Orbicular de los Labios',
                        fieldLabel: 'Orbicular de los Labios',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial7"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial7',
                        id: 'strEvaluacionFacial7'
                    },
                    {
                        xtype: 'combo',
                        name: 'Elevador del Labio Superior',
                        fieldLabel: 'Elevador del Labio Superior',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial8"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial8',
                        id: 'strEvaluacionFacial8'
                    },
                    {
                        xtype: 'combo',
                        name: 'Canino, Elevador del Angulo Oral',
                        fieldLabel: 'Canino, Elevador del Angulo Oral',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial9"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial9',
                        id: 'strEvaluacionFacial9'
                    },
                    {
                        xtype: 'combo',
                        name: 'Cigomatico Mayor',
                        fieldLabel: 'Cigomatico Mayor',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial10"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial10',
                        id: 'strEvaluacionFacial10'
                    },
                    {
                        xtype: 'combo',
                        name: 'Risorio - Cigomatico Menor',
                        fieldLabel: 'Risorio - Cigomatico Menor',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial11"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial11',
                        id: 'strEvaluacionFacial11'
                    },
                    {
                        xtype: 'combo',
                        name: 'Buccinador',
                        fieldLabel: 'Buccinador',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial12"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial12',
                        id: 'strEvaluacionFacial12'
                    },
                    {
                        xtype: 'combo',
                        name: 'Depresor del Labio Inferior',
                        fieldLabel: 'Depresor del Labio Inferior',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial13"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial13',
                        id: 'strEvaluacionFacial13'
                    },
                    {
                        xtype: 'combo',
                        name: 'Cuadrado del Menton',
                        fieldLabel: 'Cuadrado del Menton',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial14"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial14',
                        id: 'strEvaluacionFacial14'
                    },
                    {
                        xtype: 'combo',
                        name: 'Borla de la Barba',
                        fieldLabel: 'Borla de la Barba',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial15"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial15',
                        id: 'strEvaluacionFacial15'
                    },
                    {
                        xtype: 'combo',
                        name: 'Platisma - Cutanea del Cuello',
                        fieldLabel: 'Platisma - Cutanea del Cuello',
                        width: 320,
                        allowBlank: false,
                        store: stAnexoEvaluacionMusculosFaciales,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        tpl: '<tpl for="."><div class="strEvaluacionFacial16"><h3>{Codigo}</h3><p style="font-size: 12;">{Descripcion}</p><hr /></div></tpl>',
                        itemSelector: 'div.strEvaluacionFacial16',
                        id: 'strEvaluacionFacial16'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'SIGNOS CLINICOS DE LESION DE NERVIO FACIAL',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        fieldLabel: 'Signo de Bell',
                                        name: 'Signo de Bell',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEvaluacionFacial17'
                                    },
                                    {
                                        html: 'Signo de Negro'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Signo de Negro',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEvaluacionFacial18'
                                    },
                                    {
                                        html: 'Signo de Pestanas de Souque'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Signo de Pestanas de Souque',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEvaluacionFacial19'
                                    },
                                    {
                                        html: 'Fenomeno de Revillaud'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Fenomeno de Revillaud',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEvaluacionFacial20'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [                                    
                                    {
                                        xtype: 'checkbox',
                                        fieldLabel: 'Sincinesias',
                                        name: 'Sincinesias',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEvaluacionFacial21'
                                    },
                                    {
                                        html: 'Logoftalmus'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Logoftalmus',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEvaluacionFacial22'
                                    },
                                    {
                                        html: 'Epifora'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Epifora',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEvaluacionFacial23'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        fieldLabel: 'PARALISIS FACIAL CENTRAL',
                                        name: 'PARALISIS FACIAL CENTRAL',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEvaluacionFacial24'
                                    },
                                    {
                                        html: 'PARALISIS FACIAL PERIFERICA'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'PARALISIS FACIAL PERIFERICA',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEvaluacionFacial25'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'Observaciones',
                        name: 'Observaciones',
                        height: 100,            
                        allowBlank: false,
                        id: 'memEvaluacionFacialObservaciones'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirAnexoEvaluacionFuncionMusculosFaciales',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoEvaluacionFuncionMusculosFaciales').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoEvaluacionFuncionMusculosFaciales').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado el Anexo y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoEvaluacionFuncionMusculosFaciales').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Anexo',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAnexoEvaluacionFuncionMusculosFaciales',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoEvaluacionFuncionMusculosFaciales').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarAnexoEvaluacionFuncionMusculosFaciales();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarAnexoEvaluacionFuncionMusculosFaciales();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        
        winAnexoEvaluacionFuncionMusculosFacialesUi.superclass.initComponent.call(this);
    }
});

function fnGuardarAnexoEvaluacionFuncionMusculosFaciales(){
    var frm = Ext.getCmp('frmAnexoEvaluacionFuncionMusculosFaciales').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'GuardarAnexoEvaluacionFuncionMusculosFaciales',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoEvaluacionFuncionMusculosFaciales').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoEvaluacionFuncionMusculosFaciales').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoEvaluacionFuncionMusculosFaciales').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoEvaluacionFuncionMusculosFaciales').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarAnexoEvaluacionFuncionMusculosFaciales(){
    var frm = Ext.getCmp('frmAnexoEvaluacionFuncionMusculosFaciales').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'ModificarAnexoEvaluacionFuncionMusculosFaciales',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoEvaluacionFuncionMusculosFaciales').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoEvaluacionFuncionMusculosFaciales').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoEvaluacionFuncionMusculosFaciales').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoEvaluacionFuncionMusculosFaciales').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
