/*
* @category    Formulario Modelo Anexo Escala de Percepcion de Esfuerzo con el Ejercicio Borg
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winAnexoEscalaPerscepcionEsfuerzoUi = Ext.extend(Ext.Window, {
    title: '.:: ANEXO Escala de Percepcion de Esfuerzo con el Ejercicio Borg ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winAnexoEscalaPerscepcionEsfuerzo',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '99%',
                height: 605,
                id: 'frmAnexoEscalaPerscepcionEsfuerzo',
                padding: 5,
                border: false,
                autoScroll: true,
                labelWidth: 200,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysCASAnexoEscalaPerscepcionEsfuerzo'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPacienteAnexoEscalaPerscepcionEsfuerzo'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysProfesionalAnexoEscalaPerscepcionEsfuerzo'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexoEscalaPerscepcionEsfuerzo'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(0 ) Nada',
                        name: '(0 ) nada',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE1'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(0,5) Muy, Muy suve',
                        name: '(0,5) Muy, Muy suve',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE2'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(1 ) Muy Suave',
                        name: '(1 ) Muy Suave',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE3'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(2 ) Suave',
                        name: '(2 ) Suave',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE4'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(3 ) Moderado',
                        name: '(3 ) Moderado',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE5'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(4 ) Algo Severo',
                        name: '(4 ) Algo Severo',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE6'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(5 ) Severo',
                        name: '(5 ) Severo',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE7'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(6 ) Muy Severo',
                        name: '(6 ) Muy Severo',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE8'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(7 ) Muy Severo',
                        name: '(7 ) Muy Severo',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE9'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(8 ) Muy, Muy Severo',
                        name: '(8 ) Muy, Muy Severo',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE10'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(9 ) Muy, Muy Severo',
                        name: '(9 ) Muy, Muy Severo',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE11'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(10) Muy, Muy Severo',
                        name: '(10) Muy, Muy Severo',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEPE12'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirAnexoEscalaPerscepcionEsfuerzo',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoEscalaPerscepcionEsfuerzo').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoEscalaPerscepcionEsfuerzo').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado el Anexo y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoEscalaPerscepcionEsfuerzo').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Anexo',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAnexoEscalaPerscepcionEsfuerzo',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoEscalaPerscepcionEsfuerzo').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarAnexoEscalaPerscepcionEsfuerzo();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarAnexoEscalaPerscepcionEsfuerzo();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        
        winAnexoEscalaPerscepcionEsfuerzoUi.superclass.initComponent.call(this);
    }
});

function fnGuardarAnexoEscalaPerscepcionEsfuerzo(){
    var frm = Ext.getCmp('frmAnexoEscalaPerscepcionEsfuerzo').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'GuardarAnexoEscalaPerscepcionEsfuerzo',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoEscalaPerscepcionEsfuerzo').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoEscalaPerscepcionEsfuerzo').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoEscalaPerscepcionEsfuerzo').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoEscalaPerscepcionEsfuerzo').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarAnexoEscalaPerscepcionEsfuerzo(){
    var frm = Ext.getCmp('frmAnexoEscalaPerscepcionEsfuerzo').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'ModificarAnexoEscalaPerscepcionEsfuerzo',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoEscalaPerscepcionEsfuerzo').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoEscalaPerscepcionEsfuerzo').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoEscalaPerscepcionEsfuerzo').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoEscalaPerscepcionEsfuerzo').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
