/*
* @category    Formulario Modelo Anexo AMA
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winAnexoAMAUi = Ext.extend(Ext.Window, {
    title: '.:: ANEXO AMA ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winAnexoAMA',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '99%',
                height: 605,
                id: 'frmAnexoAMA',
                padding: 5,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysCASAnexoAMA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPacienteAnexoAMA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysProfesionalAnexoAMA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexoAMA'
                    },
                    {
                        xtype: 'checkboxgroup',
                        anchor: '98%',
                        fieldLabel: 'Miembro/Parte del Cuerpo?',
                        columns: 3,
                        vertical: true,
                        name: 'strRegistarAnexo1Miembro',
                        id: 'strRegistarAnexo1Miembro',
                        items: [
                            {boxLabel: "Articululacion Temporo Mandibular", inputValue: "Articululacion Temporo Mandibular"},
                            {boxLabel: "Cabeza y Cuello", inputValue: "Cabeza y Cuello"},
                            {boxLabel: "Cuello", inputValue: "Cuello"},
                            {boxLabel: "Columna Dorsal", inputValue: "Columna Dorsal"},
                            {boxLabel: "Columna Lumbar", inputValue: "Columna Lumbar"},
                            {boxLabel: "Escapula", inputValue: "Escapula"},
                            {boxLabel: "Hombro", inputValue: "Hombro"},
                            {boxLabel: "Codo y Antebrazo", inputValue: "Codo y Antebrazo"},
                            {boxLabel: "Muñeca", inputValue: "Muneca"},
                            {boxLabel: "Metacarpo Falangicas", inputValue: "Metacarpo Falangicas"},
                            {boxLabel: "Inter Falangicas Prox. 2 al 5", inputValue: "Inter Falangicas Proximales 2 al 5"},
                            {boxLabel: "Inter Falangicas Dist. 2 al 5", inputValue: "Inter Falangicas Distales 2 al 5"},
                            {boxLabel: "Metacarpo Falangicas del Pulgar", inputValue: "Metacarpo Falangicas del Pulgar"},
                            {boxLabel: "Inter Falangicas del Pulgar", inputValue: "Inter Falangicas del Pulgar"},
                            {boxLabel: "Pulgar y Meñique", inputValue: "Pulgar y Meñique"},
                            {boxLabel: "Cadera", inputValue: "Cadera"},
                            {boxLabel: "Rodilla", inputValue: "Rodilla"},
                            {boxLabel: "Tobillo", inputValue: "Tobillo"},
                            {boxLabel: "Articulacion Subtalar", inputValue: "Articulacion Subtalar"},
                            {boxLabel: "Metatarso Falangicas", inputValue: "Metatarso Falangicas"},
                            {boxLabel: "Inter Falangicas Metatarso Prox. 2 al 5", inputValue: "Inter Falangicas Proximales Metatarso 2 al 5"},
                            {boxLabel: "Inter Falangicas Metatarso Dist. 2 al 5", inputValue: "Inter Falangicas Metatarso Distales 2 al 5"},
                            {boxLabel: "Metatarso Falangicas del Hallux", inputValue: "Metatarso Falangicas del Hallux"},
                            {boxLabel: "Inter Falangicas del Hallux", inputValue: "Inter Falangicas del Hallux"}
                        ],
                        listeners:{
                            change : function(t, itemsCheck){
                                Ext.getCmp('strRegistarAnexo1Miembro').items.each(function(item) {
                                    if(item.getRawValue() == "Articululacion Temporo Mandibular"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM1').setVisible(true);
                                        }else{
                                            fnfsAMAPM1Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Cabeza y Cuello"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM2').setVisible(true);
                                        }else{
                                            fnfsAMAPM2Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Cuello"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM3').setVisible(true);
                                        }else{
                                            fnfsAMAPM3Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Columna Dorsal"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM4').setVisible(true);
                                        }else{
                                            fnfsAMAPM4Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Columna Lumbar"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM5').setVisible(true);
                                        }else{
                                            fnfsAMAPM5Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Escapula"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM6').setVisible(true);
                                        }else{
                                            fnfsAMAPM6Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Hombro"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM7').setVisible(true);
                                        }else{
                                            fnfsAMAPM7Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Codo y Antebrazo"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM8').setVisible(true);
                                        }else{
                                            fnfsAMAPM8Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Muneca"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM9').setVisible(true);
                                        }else{
                                            fnfsAMAPM9Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Metacarpo Falangicas"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM10').setVisible(true);
                                        }else{
                                            fnfsAMAPM10Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Inter Falangicas Proximales 2 al 5"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM11').setVisible(true);
                                        }else{
                                            fnfsAMAPM11Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Inter Falangicas Distales 2 al 5"){ 
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM12').setVisible(true);
                                        }else{
                                            fnfsAMAPM12Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Metacarpo Falangicas del Pulgar"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM13').setVisible(true);
                                        }else{
                                            fnfsAMAPM13Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Inter Falangicas del Pulgar"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM14').setVisible(true);
                                        }else{
                                            fnfsAMAPM14Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Pulgar y Meñique"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM15').setVisible(true);
                                        }else{
                                            fnfsAMAPM15Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Cadera"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM16').setVisible(true);
                                        }else{
                                            fnfsAMAPM16Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Rodilla"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM17').setVisible(true);
                                        }else{
                                            fnfsAMAPM17Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Tobillo"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM18').setVisible(true);
                                        }else{
                                            fnfsAMAPM18Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Articulacion Subtalar"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM19').setVisible(true);
                                        }else{
                                            fnfsAMAPM19Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Metatarso Falangicas"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM20').setVisible(true);
                                        }else{
                                            fnfsAMAPM20Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Inter Falangicas Proximales Metatarso 2 al 5"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM21').setVisible(true);
                                        }else{
                                            fnfsAMAPM21Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Inter Falangicas Metatarso Distales 2 al 5"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM22').setVisible(true);
                                        }else{
                                            fnfsAMAPM22Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Metatarso Falangicas del Hallux"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM23').setVisible(true);
                                        }else{
                                            fnfsAMAPM23Limpiar();
                                        }
                                    }
                                    if(item.getRawValue() == "Inter Falangicas del Hallux"){
                                        if(item.getValue() == true){
                                            Ext.getCmp('fsAMAPM24').setVisible(true);
                                        }else{
                                            fnfsAMAPM24Limpiar();
                                        }
                                    }
                                });
                            }
                        }
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Articulacion Temporo Mandibular',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM1',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Apertura',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAATMAperturaIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAATMAperturaDer'
                                            }
                                        ]   
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Desv. Lateral diduccion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                              {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAATMDesvLatDiduIzq'
                                            },   
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAATMDesvLatDiduDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Protrusion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                              {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAATMProtrusionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAATMProtrusionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Cabeza y Cuello en Conjunto',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM2',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                              {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACabCuelloFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACabCuelloFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACabCuelloExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACabCuelloExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Cuello',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM3',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Inclinacion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACuelloInclinacionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACuelloInclinacionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rotacion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACuelloRotacionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACuelloRotacionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Columna Dorsal',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM4',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Inclinacion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAColDorsalInclinacionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAColDorsalInclinacionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rotacion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAColDorsalRotacionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAColDorsalRotacionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Columna Lumbar',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM5',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                              {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAColLumbarFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAColLumbarFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAColLumbarExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAColLumbarExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Escapula',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM6',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Elevacion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAEscapulaElevacionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAEscapulaElevacionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Aduccion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAEscapulaAduccionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAEscapulaAduccionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Depresion y Add.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAEscapulaDepresionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAEscapulaDepresionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Abduccion y Rot. de Cintura Escapular',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAEscapulaAbduccionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAEscapulaAbduccionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Aduccion y Rot. Inf. de Escapular',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAEscapulaAduccionRotIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAEscapulaAduccionRotDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Hombro',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM7',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Abduccion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroAbduccionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroAbduccionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Adduccion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroAdduccionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroAdduccionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Adduccion Horizontal',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroAdduccionHorIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroAdduccionHorDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Abd Hombro',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroAbdHombroIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroAbdHombroDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rotacion Media',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroRotMediaIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroRotMediaDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rotacion Lateral',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroRotLateralIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHombroRotLateralDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Codo y Antebrazo',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM8',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACodoFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACodoFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACodoExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACodoExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Supinacion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACodoSupinacionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACodoSupinacionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Pronacion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACodoPronacionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACodoPronacionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Muñeca',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM9',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMunecaFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMunecaFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMunecaExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMunecaExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Desviacion Radial',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMunecaDesviacionRadialIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMunecaDesviacionRadialDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Desviacion Ulnar',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMunecaDesviacionUlnarIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMunecaDesviacionUlnarDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Metacarpo Falangicas',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM10',
                        items: [
                            {
                                xtype: 'panel',
                                title: '2a Flexion M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo2FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo2FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Flexion M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo3FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo3FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Flexion M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo4FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo4FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Flexion M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo5FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo5FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '2a Extension M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo2ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo2ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Extension M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo3ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo3ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Extension M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo4ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo4ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Extension M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo5ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpo5ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Interfalangicas Prox 2a a 5a',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM11',
                        items: [
                            {
                                xtype: 'panel',
                                title: '2a Flexion IFP',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas2FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas2FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Flexion IFP',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas3FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas3FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Flexion IFP',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas4FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas4FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Flexion IFP',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas5FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas5FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '2a Extension IFP',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas2ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas2ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Extension IFP',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas3ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas3ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Extension IFP',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas4ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas4ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Extension IFP',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas5ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicas5ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Interfalangicas Dist. 2a a 5a',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM12',
                        items: [
                            {
                                xtype: 'panel',
                                title: '2a Flexion IFD',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist2FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist2FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Flexion IFD',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist3FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist3FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Flexion IFD',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist4FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist4FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Flexion IFD',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist5FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist5FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '2a Extension IFD',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist2ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist2ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Extension IFD',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist3ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist3ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Extension IFD',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist4ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist4ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Extension IFD',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist5ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasDist5ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Metacarpo Falangicas del Pulgar',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM13',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpoPulgarFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpoPulgarFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpoPulgarExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpoPulgarExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Abduccion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpoPulgarAbduccionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpoPulgarAbduccionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Adduccion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpoPulgarAdduccionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetacarpoPulgarAdduccionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Interfalangicas del Pulgar',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM14',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasPulgarFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasPulgarFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasPulgarExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterfalangicasPulgarExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Pulgar y Menique',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM15',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Oposicion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAPulgarMeniqueOposicionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAPulgarMeniqueOposicionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Cadera',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM16',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Abduccion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaAbduccionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaAbduccionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Aduccion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaAduccionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaAduccionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rotacion Media',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaRotacionMediaIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaRotacionMediaDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Rotacion Lateral',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaRotacionLateralIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMACaderaRotacionLateralDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Rodilla',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM17',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMARodillaFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMARodillaFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMARodillaExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMARodillaExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Tobillo',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM18',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Dorsiflexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMATobilloDorsiflexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMATobilloDorsiflexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Plantiflexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMATobilloPlantiflexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMATobilloPlantiflexionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Articulacion Subtalar',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM19',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Inversion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAArtSubtalarInversionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAArtSubtalarInversionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Eversion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAArtSubtalarEversionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAArtSubtalarEversionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Metatarso Falangica del 2 a 5',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM20',
                        items: [
                            {
                                xtype: 'panel',
                                title: '2a Flexion M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso2FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso2FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Flexion M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso3FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso3FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Flexion M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso4FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso4FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Flexion M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso5FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso5FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '2a Extension M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso2ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso2ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Extension M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso3ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso3ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Extension M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso4ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso4ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Extension M.F.',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso5ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMetatarso5ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Interfalangicas Prox. del 2 a 5',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM21',
                        items: [
                            {
                                xtype: 'panel',
                                title: '2a Flexion M.F.P',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP2FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP2FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Flexion M.F.P',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP3FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP3FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Flexion M.F.P',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP4FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP4FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Flexion M.F.P',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP5FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP5FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '2a Extension M.F.P',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP2ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP2ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Extension M.F.P',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP3ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP3ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Extension M.F.P',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP4ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP4ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Extension M.F.P',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP5ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFP5ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Interfalangicas Dist. del 2 a 5',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM22',
                        items: [
                            {
                                xtype: 'panel',
                                title: '2a Flexion M.F.D',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD2FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD2FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Flexion M.F.D',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD3FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD3FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Flexion M.F.D',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD4FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD4FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Flexion M.F.D',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD5FlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD5FlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '2a Extension M.F.D',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD2ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD2ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '3a Extension M.F.D',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD3ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD3ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '4a Extension M.F.D',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD4ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD4ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '5a Extension M.F.D',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD5ExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAMFD5ExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Metatarso Falangica del Hallux',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM23',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHalluxFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHalluxFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHalluxExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAHalluxExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Interfalangica del Hallux',
                        layout: 'form',
                        width: 925,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsAMAPM24',
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Flexion',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterHalluxFlexionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterHalluxFlexionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Extension',
                                layout: 'form',
                                anchor: '99%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Izquierdo',
                                                fieldLabel: 'Izquierdo',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterHalluxExtensionIzq'
                                            },
                                            {
                                                html: 'Derecho:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 295,
                                                name: 'Derecho',
                                                allowBlank: true,
                                                id: 'strANEXOAMAInterHalluxExtensionDer'
                                            }
                                        ]
                                    }
                                ]
                            },
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '98%',
                        fieldLabel: 'Observaciones',
                        name: 'Observaciones',
                        height: 100,            
                        allowBlank: true,
                        id: 'memANEXOAMAObservaciones'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '98%',
                        fieldLabel: 'Interpretacion de Resultados',
                        name: 'Interpretacion de Resultados',
                        height: 100,            
                        allowBlank: true,
                        id: 'memANEXOAMAInterpretacionResultados'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirAnexoExamenMuscularMMSS',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoAMA').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoAMA').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado el Anexo y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoAMA').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Anexo',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAnexoAMA',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoAMA').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarAnexoAMA();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarAnexoAMA();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    Ext.getCmp('fsAMAPM1').setVisible(false);
                    Ext.getCmp('fsAMAPM2').setVisible(false);
                    Ext.getCmp('fsAMAPM3').setVisible(false);
                    Ext.getCmp('fsAMAPM4').setVisible(false);
                    Ext.getCmp('fsAMAPM5').setVisible(false);
                    Ext.getCmp('fsAMAPM6').setVisible(false);
                    Ext.getCmp('fsAMAPM7').setVisible(false);
                    Ext.getCmp('fsAMAPM8').setVisible(false);
                    Ext.getCmp('fsAMAPM9').setVisible(false);
                    Ext.getCmp('fsAMAPM10').setVisible(false);
                    Ext.getCmp('fsAMAPM11').setVisible(false);
                    Ext.getCmp('fsAMAPM12').setVisible(false);
                    Ext.getCmp('fsAMAPM13').setVisible(false);
                    Ext.getCmp('fsAMAPM14').setVisible(false);
                    Ext.getCmp('fsAMAPM15').setVisible(false);
                    Ext.getCmp('fsAMAPM16').setVisible(false);
                    Ext.getCmp('fsAMAPM17').setVisible(false);
                    Ext.getCmp('fsAMAPM18').setVisible(false);
                    Ext.getCmp('fsAMAPM19').setVisible(false);
                    Ext.getCmp('fsAMAPM20').setVisible(false);
                    Ext.getCmp('fsAMAPM21').setVisible(false);
                    Ext.getCmp('fsAMAPM22').setVisible(false);
                    Ext.getCmp('fsAMAPM23').setVisible(false);
                    Ext.getCmp('fsAMAPM24').setVisible(false);
                }
            }
        });
        winAnexoAMAUi.superclass.initComponent.call(this);
    }
});

function fnGuardarAnexoAMA(){
    var frm = Ext.getCmp('frmAnexoAMA').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'GuardarAnexoAMA',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoAMA').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoAMA').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoAMA').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoAMA').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarAnexoAMA(){
    var frm = Ext.getCmp('frmAnexoAMA').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'ModificarAnexoAMA',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoAMA').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoAMA').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoAMA').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoAMA').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnfsAMAPM1Limpiar(){
    Ext.getCmp('strANEXOAMAATMAperturaIzq').setValue(null);
    Ext.getCmp('strANEXOAMAATMAperturaDer').setValue(null);
    Ext.getCmp('strANEXOAMAATMDesvLatDiduIzq').setValue(null);
    Ext.getCmp('strANEXOAMAATMDesvLatDiduDer').setValue(null);
    Ext.getCmp('strANEXOAMAATMProtrusionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAATMProtrusionDer').setValue(null);
    Ext.getCmp('fsAMAPM1').setVisible(false);
}
function fnfsAMAPM2Limpiar(){
    Ext.getCmp('fsAMAPM2').setVisible(false);
    Ext.getCmp('strANEXOAMACabCuelloFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACabCuelloFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMACabCuelloExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACabCuelloExtensionDer').setValue(null);
}
function fnfsAMAPM3Limpiar(){
    Ext.getCmp('fsAMAPM3').setVisible(false);
    Ext.getCmp('strANEXOAMACuelloInclinacionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACuelloInclinacionDer').setValue(null);
    Ext.getCmp('strANEXOAMACuelloRotacionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACuelloRotacionDer').setValue(null);
}
function fnfsAMAPM4Limpiar(){
    Ext.getCmp('fsAMAPM4').setVisible(false);
    Ext.getCmp('strANEXOAMAColDorsalInclinacionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAColDorsalInclinacionDer').setValue(null);
    Ext.getCmp('strANEXOAMAColDorsalRotacionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAColDorsalRotacionDer').setValue(null);
}
function fnfsAMAPM5Limpiar(){
    Ext.getCmp('fsAMAPM5').setVisible(false);
    Ext.getCmp('strANEXOAMAColLumbarFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAColLumbarFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAColLumbarExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAColLumbarExtensionDer').setValue(null);
    }
function fnfsAMAPM6Limpiar(){
    Ext.getCmp('fsAMAPM6').setVisible(false);
    Ext.getCmp('strANEXOAMAEscapulaElevacionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAEscapulaElevacionDer').setValue(null);
    Ext.getCmp('strANEXOAMAEscapulaAduccionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAEscapulaAduccionDer').setValue(null);
    Ext.getCmp('strANEXOAMAEscapulaDepresionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAEscapulaDepresionDer').setValue(null);
    Ext.getCmp('strANEXOAMAEscapulaAbduccionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAEscapulaAbduccionDer').setValue(null);
    Ext.getCmp('strANEXOAMAEscapulaAduccionRotIzq').setValue(null);
    Ext.getCmp('strANEXOAMAEscapulaAduccionRotDer').setValue(null);

}
function fnfsAMAPM7Limpiar(){
    Ext.getCmp('fsAMAPM7').setVisible(false);
    Ext.getCmp('strANEXOAMAHombroFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAHombroFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAHombroExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAHombroExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAHombroAbduccionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAHombroAbduccionDer').setValue(null);
    Ext.getCmp('strANEXOAMAHombroAdduccionHorIzq').setValue(null);
    Ext.getCmp('strANEXOAMAHombroAdduccionHorDer').setValue(null);
    Ext.getCmp('strANEXOAMAHombroAbdHombroIzq').setValue(null);
    Ext.getCmp('strANEXOAMAHombroAbdHombroDer').setValue(null);
    Ext.getCmp('strANEXOAMAHombroAbdHombroIzq').setValue(null);
    Ext.getCmp('strANEXOAMAHombroAbdHombroDer').setValue(null);
    Ext.getCmp('strANEXOAMAHombroRotMediaIzq').setValue(null);
    Ext.getCmp('strANEXOAMAHombroRotMediaDer').setValue(null);
    Ext.getCmp('strANEXOAMAHombroRotLateralIzq').setValue(null);
    Ext.getCmp('strANEXOAMAHombroRotLateralDer').setValue(null);
    }
function fnfsAMAPM8Limpiar(){
    Ext.getCmp('fsAMAPM8').setVisible(false);
    Ext.getCmp('strANEXOAMACodoFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACodoFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMACodoExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACodoExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMACodoSupinacionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACodoSupinacionDer').setValue(null);
    Ext.getCmp('strANEXOAMACodoPronacionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACodoPronacionDer').setValue(null);
}
function fnfsAMAPM9Limpiar(){
    Ext.getCmp('strANEXOAMAMunecaFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMunecaFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMunecaExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMunecaExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMunecaDesviacionRadialIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMunecaDesviacionRadialDer').setValue(null);
    Ext.getCmp('strANEXOAMAMunecaDesviacionUlnarIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMunecaDesviacionUlnarDer').setValue(null);
    Ext.getCmp('fsAMAPM9').setVisible(false);
}
function fnfsAMAPM10Limpiar(){
    Ext.getCmp('fsAMAPM10').setVisible(false);
    Ext.getCmp('strANEXOAMAMetacarpo2FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo2FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo3FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo3FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo4FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo4FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo2ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo2ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo3ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo3ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo4ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpo4ExtensionDer').setValue(null);
}
function fnfsAMAPM11Limpiar(){
    Ext.getCmp('fsAMAPM11').setVisible(false);
    Ext.getCmp('strANEXOAMAInterfalangicas2FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas2FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas3FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas3FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas4FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas4FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas2ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas2ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas3ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas3ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas4ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicas4ExtensionDer').setValue(null);
}
function fnfsAMAPM12Limpiar(){
    Ext.getCmp('fsAMAPM12').setVisible(false);
    Ext.getCmp('strANEXOAMAInterfalangicasDist2FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist2FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist3FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist3FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist4FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist4FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist2ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist2ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist3ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist3ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist4ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasDist4ExtensionDer').setValue(null);
}
function fnfsAMAPM13Limpiar(){
    Ext.getCmp('fsAMAPM13').setVisible(false);
    Ext.getCmp('strANEXOAMAMetacarpoPulgarFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpoPulgarFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpoPulgarExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpoPulgarExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpoPulgarAbduccionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpoPulgarAbduccionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpoPulgarAdduccionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetacarpoPulgarAdduccionDer').setValue(null);
}
function fnfsAMAPM14Limpiar(){
    Ext.getCmp('fsAMAPM14').setVisible(false);
    Ext.getCmp('strANEXOAMAInterfalangicasPulgarFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasPulgarFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasPulgarExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterfalangicasPulgarExtensionDer').setValue(null);
}
function fnfsAMAPM15Limpiar(){
    Ext.getCmp('fsAMAPM15').setVisible(false);
    Ext.getCmp('strANEXOAMAPulgarMeniqueOposicionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAPulgarMeniqueOposicionDer').setValue(null);
}
function fnfsAMAPM16Limpiar(){
    Ext.getCmp('fsAMAPM16').setVisible(false);
    Ext.getCmp('strANEXOAMACaderaFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACaderaFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMACaderaExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACaderaExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMACaderaAbduccionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACaderaAbduccionDer').setValue(null);
    Ext.getCmp('strANEXOAMACaderaAduccionIzq').setValue(null);
    Ext.getCmp('strANEXOAMACaderaAduccionDer').setValue(null);
    Ext.getCmp('strANEXOAMACaderaRotacionMediaIzq').setValue(null);
    Ext.getCmp('strANEXOAMACaderaRotacionMediaDer').setValue(null);
    Ext.getCmp('strANEXOAMACaderaRotacionLateralIzq').setValue(null);
    Ext.getCmp('strANEXOAMACaderaRotacionLateralDer').setValue(null);
}
function fnfsAMAPM17Limpiar(){
    Ext.getCmp('fsAMAPM17').setVisible(false);
    Ext.getCmp('strANEXOAMARodillaFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMARodillaFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMARodillaExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMARodillaExtensionDer').setValue(null);
}
function fnfsAMAPM18Limpiar(){
    Ext.getCmp('fsAMAPM18').setVisible(false);
    Ext.getCmp('strANEXOAMATobilloDorsiflexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMATobilloDorsiflexionDer').setValue(null);
    Ext.getCmp('strANEXOAMATobilloPlantiflexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMATobilloPlantiflexionDer').setValue(null);
}
function fnfsAMAPM19Limpiar(){
    Ext.getCmp('fsAMAPM19').setVisible(false);
    Ext.getCmp('strANEXOAMAMetatarso2FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso2FlexionDer').setValue(null);
}
function fnfsAMAPM20Limpiar(){
    Ext.getCmp('fsAMAPM20').setVisible(false);
    Ext.getCmp('strANEXOAMAMFP2FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFP2FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFP3FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFP3FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFP4FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFP4FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFP5FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFP5FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFP2ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFP2ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFP3ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFP3ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFP4ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFP4ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFP5ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFP5ExtensionDer').setValue(null);
}
function fnfsAMAPM21Limpiar(){
    Ext.getCmp('fsAMAPM21').setVisible(false);
    Ext.getCmp('strANEXOAMAMFD2FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFD2FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFD3FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFD3FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFD4FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFD4FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFD5FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFD5FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFD2ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFD2ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFD3ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFD3ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFD4ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFD4ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMFD5ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMFD5ExtensionDer').setValue(null);
}
function fnfsAMAPM22Limpiar(){
    Ext.getCmp('fsAMAPM22').setVisible(false);
    Ext.getCmp('strANEXOAMAMetatarso2FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso2FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso3FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso3FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso4FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso4FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso5FlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso5FlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso2ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso2ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso3ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso3ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso4ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso4ExtensionDer').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso5ExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAMetatarso5ExtensionDer').setValue(null);
}
function fnfsAMAPM23Limpiar(){
    Ext.getCmp('fsAMAPM23').setVisible(false);
    Ext.getCmp('strANEXOAMAHalluxFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAHalluxFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAHalluxExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAHalluxExtensionDer').setValue(null);

}
function fnfsAMAPM24Limpiar(){
    Ext.getCmp('fsAMAPM24').setVisible(false);
    Ext.getCmp('strANEXOAMAInterHalluxFlexionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterHalluxFlexionDer').setValue(null);
    Ext.getCmp('strANEXOAMAInterHalluxExtensionIzq').setValue(null);
    Ext.getCmp('strANEXOAMAInterHalluxExtensionDer').setValue(null);
}