/*
* @category    Formulario Grid Transcripcion Anatomopatologia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmVerTranscripcionAnatomoUi = Ext.extend(Ext.Window, {
    //title: 'OfiClinic© Web..! .:: Agenda por Profesional ::.',
    id: 'winFrmVerAgenda',
    closable:false,
    draggable : false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    padding: 5,
    maximized: true,
    frame: true,
    layout: 'form',
    initComponent: function() {
        function VerHoraLegaliza(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return '<p style="color: red; font-weight:bold; text-decoration:blink; text-align:center;">'+value + '</p>Hora Estimada Atención: </br>' + record.get('HoraAtencion');
	}
        
        function VerPaciente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br>Genero: ' + record.get('Genero') + ' FecNac: ' + record.get('FecNac') + '</br>' + record.get('Edad');  
        }
        
        function VerCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        
        function VerCAS(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('CAS') + '</br>' + record.get('NroPlacaRef') + '<br>' + record.get('EstadoTranscripcion');  
        }
        
        function VerCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('Cliente') + '</br>' + record.get('Actividad');  
        }
        
        var stGrid = new StoreGridTrascribirImgDx();
        var mybbar = new utilBbarUi();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'tabpanel',
                //width: 990,
                height: screen.height,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Anatomopatologia',
                        height: screen.height-240,
                        //width: 951,
                        frame: true,
                        border: false,
                        layout: 'form',
                        id: 'fichaDatos',
                        labelWidth: 1,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        html: 'FECHA:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        allowBlank: false,
                                        style: 'text-align:center;',
                                        emptyText: '(dia/mes/año) ',
                                        id: 'sysFechaAgendaAnatomo'
                                    },
                                    {
                                        html: ' - EXAMEN:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 60,
                                        allowBlank: true,
                                        emptyText: 'Prefijo',
                                        id: 'sysPrefijoAnatomo'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 90,
                                        allowBlank: true,
                                        emptyText: 'Nro Examen',
                                        id: 'sysExamenAnatomo'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Buscar Examen',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Examen',
                                        id: 'btnExamenAnatomo',
                                        listeners:{
                                            click: function(){
                                                if(Ext.getCmp('sysPrefijoAnatomo').getValue() !== "" && Ext.getCmp('sysPrefijoAnatomo').getValue() !== null && Ext.getCmp('sysExamenAnatomo').getValue() !== "" && Ext.getCmp('sysExamenAnatomo').getValue() !== null){
                                                    Ext.getCmp('gridFormulario').store.load({
                                                        params: {
                                                            task: 'LISTAR_TRANSCRIBIR_ANATOMO_EXA',
                                                            pPrestador: ID_EMPRESA,
                                                            pIPS: ID_IPS,
                                                            pNomBaseDatos: BD_MULTIPRESTADOR,
                                                            pExa: Ext.getCmp('sysPrefijoAnatomo').getValue() + "-" + Ext.getCmp('sysExamenAnatomo').getValue()
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - CAS:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 120,
                                        allowBlank: true,
                                        id: 'sysCASAnatomo'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Buscar CAS',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar CAS',
                                        id: 'btnCASAnatomo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        html: 'PACIENTE:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        emptyText: 'Nro Documento...!',
                                        id: 'searchpDocumentoAnatomo',
                                        width: 110
                                    },
                                    {
                                        xtype: 'textfield',
                                        emptyText: '1er Nombre...!',
                                        id: 'searchpNom1Anatomo',
                                        width: 110
                                    },
                                    {
                                        xtype: 'textfield',
                                        emptyText: '2do Nombre...!',
                                        id: 'searchpNom2Anatomo',
                                        width: 110
                                    },
                                    {
                                        xtype: 'textfield',
                                        emptyText: '1er Apellido...!',
                                        id: 'searchpApe1Anatomo',
                                        width: 110
                                    },
                                    {
                                        xtype: 'textfield',
                                        emptyText: '2do Apellido...!',
                                        id: 'searchpApe2Anatomo',
                                        width: 110
                                    },
                                    {
                                        xtype: 'button',
                                        tooltip: 'Buscar Paciente',
                                        text: 'Buscar Paciente',
                                        iconCls: 'btnBuscar',
                                        id: 'btnEjecutarSearchPacAnatomo',
                                        listeners:{
                                            click: function(){
                                                Ext.getCmp('gridFormulario').store.load({
                                                    params: {
                                                        task: 'LISTAR_TRANSCRIBIR_ANATOMO_PAC',
                                                        pPrestador: ID_EMPRESA,
                                                        pIPS: ID_IPS,
                                                        pNomBaseDatos: BD_MULTIPRESTADOR,
                                                        pDocumento: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpDocumentoAnatomo').getValue().toUpperCase()),
                                                        pNom1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom1Anatomo').getValue().toUpperCase()),
                                                        pNom2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom2Anatomo').getValue().toUpperCase()),
                                                        pApe1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe1Anatomo').getValue().toUpperCase()),
                                                        pApe2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe2Anatomo').getValue().toUpperCase())
                                                    }
                                                });
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'button',
                                        tooltip: 'Limpiar Datos del Paciente',
                                        text: 'Limpiar',
                                        iconCls: 'btnLimpiar',
                                        id: 'btnLimpiarSearchPac',
                                        listeners:{
                                            click: function(){
                                                Ext.getCmp('searchpDocumentoAnatomo').setValue(null);
                                                Ext.getCmp('searchpNom1Anatomo').setValue(null);
                                                Ext.getCmp('searchpNom2Anatomo').setValue(null);
                                                Ext.getCmp('searchpApe1Anatomo').setValue(null);
                                                Ext.getCmp('searchpApe2Anatomo').setValue(null);
                                                Ext.getCmp('sysCASAnatomo').setValue(0);
                                                Ext.getCmp('gridFormulario').store.load({
                                                    params: {
                                                        pPrestador: ID_EMPRESA,
                                                        pIPS: ID_IPS,
                                                        pCAS: Ext.getCmp('sysCASAnatomo').getValue(),
                                                        pExamen: 'NA',
                                                        pFecha: new Date().format("Y-m-d")
                                                    }
                                                });
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'grid',
                                id: 'gridFormulario',
                                store: stGrid,
                                layout: 'fit',
                                anchor: "100%",
                                height: screen.height-250,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        header: 'CAS',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'CAS',
                                        renderer: VerCAS,
                                        width: 120,
                                        hideable: false
                                    },
                                    {
                                        header: 'Hora',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'HoraAgenda',
                                        renderer: VerCita,
                                        width: 110,
                                        hideable: false
                                    },
                                    {
                                        header: 'Hora Legalización',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FechaLegaliza',
                                        width: 130,
                                        renderer: VerHoraLegaliza,
                                        hideable: false
                                    },
                                    {
                                        header: 'Paciente',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Paciente',
                                        width: 330,
                                        renderer: VerPaciente,
                                        hideable: false
                                    },
                                    {
                                        header: 'Cliente',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Cliente',
                                        width: 250,
                                        renderer: VerCliente,
                                        hideable: false
                                    },
                                    {
                                        header: 'Profesional',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Profesional',
                                        width: 250,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                viewConfig: {
                                    getRowClass: function(record, index) {
                                        switch(record.get('EstadoTranscripcion')){
                                            case "SIN TRANSCRIBIR":
                                                return 'NoApto';
                                                break;
                                            case "PENDIENTE FIRMA":
                                                return 'PasoMedico';
                                                break;
                                            case "DESCRIPCION MACROSCOPICA":
                                                return 'PasoTomaMuestras';
                                                break;
                                            case "DESCRIPCION MICROSCOPICA":
                                                return 'PasoTomaMuestras';
                                                break;
                                            case "CERRADO":
                                                return 'Apto';
                                                break;
                                            case "FIRMADO":
                                                return 'Apto';
                                                break;
                                            default:
                                                break;
                                        }
                                    }
                                },
                                /*view: new Ext.grid.GroupingView({
                                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                                    getRowClass: function(record, index, rowParams, store){
                                        //viewConfig: {
                                        //getRowClass: function(record, index) {
                                        switch(record.get('EstadoTranscripcion')){
                                            case "SIN TRANSCRIBIR":
                                                return 'NoApto';
                                                break;
                                            case "LABORATORIO":
                                                return 'PasoLaboratorio';
                                                break;
                                            case "FONOAUDIOLOGIA":
                                                return 'PasoFonoaudiologia';
                                                break;
                                            case "VALORACION MEDICA":
                                                return 'PasoMedico';
                                                break;
                                            case "TOMA MUESTRAS":
                                                return 'PasoTomaMuestras';
                                                break;
                                            case "PROCESO CERRADO":
                                                if(record.get('ConceptoFinal') == "APTO"){
                                                    return 'Apto';
                                                }else{
                                                    return 'NoApto';
                                                }
                                                break;
                                            default:
                                                break;
                                        }
                                    }
                                }),*/
                                columnLines: true,
                                tbar:
                                    {
                                        xtype: 'toolbar',
                                        items: [
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Actualizar Lista',
                                                iconCls: 'btnActualizarGrid',
                                                tooltip: 'Actualizar Lista',
                                                id: 'btnActualizarAnatomo'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Transcribir Citologia',
                                                tooltip: 'Transcribir Citologia',
                                                iconCls: 'btnLaboratorio',
                                                id: 'btnTransCitoAnatomo'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Transcribir Patologia',
                                                tooltip: 'Transcribir Patologia',
                                                iconCls: 'btnLaboratorio',
                                                id: 'btnTransPatoAnatomo'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Transcribir HER-2',
                                                tooltip: 'Transcribir HER-2',
                                                iconCls: 'btnLaboratorio',
                                                id: 'btnTransHer2Anatomo'
                                            },        
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Cerrar Transcripcion',
                                                iconCls: 'btnCerrar',
                                                tooltip: 'Cerrar Transcripcion',
                                                id: 'btnCerrarAnatomo'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            
                                            {
                                                xtype: 'tbfill'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Firmar Reporte',
                                                iconCls: 'btnFirma',
                                                tooltip: 'Firmar Reporte',
                                                id: 'btnFirmarAnatomo'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Imprimir Reporte',
                                                iconCls: 'btnImprimir',
                                                tooltip: 'Imprimir Reporte',
                                                id: 'btnimprimirAnatomo'
                                            }
                                        ]
                                    }
                            }
                        ]
                    }
                ]
            }
        ];
        winFrmVerTranscripcionAnatomoUi.superclass.initComponent.call(this);
    }
});








