/*
* @category    Formulario Grid Agenda Transcripcion Imagenes Diagnosticas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmVerTranscripcionLaboUi = Ext.extend(Ext.Window, {
    id: 'winFrmTranscripcionLabo',
    closable:false,
    draggable : false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    padding: 5,
    maximized: true,
    frame: true,
    layout: 'form',
    initComponent: function() {
        function VerHoraLegaliza(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return '<p style="color: red; font-weight:bold; text-decoration:blink; text-align:center;">'+value + '</p>Hora Estimada Atención: </br>' + record.get('HoraAtencion');
	}
        
        function VerPaciente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br>Genero: ' + record.get('Genero') + ' FecNac: ' + record.get('FecNac') + '</br>' + record.get('Edad');  
        }
        
        function VerCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        
        function VerCAS(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('CAS') + '</br>' + record.get('DescEstadoReg');  
        }
        
        function VerCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('Cliente');  
        }
        
        function VerProcedimiento(value, metaData, record, rowIndex, colIndex, store){  
            //metaData.attr = 'style="white-space:normal; color: #610B0B;"';  
            metaData.attr = 'style="white-space:normal; color: darkblue;"';  
            return '<b>' + record.get('Actividad') + '</b>';
        }
        
        var stGrid = new StoreGridTrascribirLabo();
        var mybbar = new utilBbarUi();
        this.bbar = mybbar;
        
        this.items = [
            {
                xtype: 'tabpanel',
                //width: 990,
                height: screen.height,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Consulta de Resultados',
                        height: screen.height-240,
                        //width: 951,
                        frame: true,
                        border: false,
                        layout: 'form',
                        id: 'fichaDatos',
                        labelWidth: 1,
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridFormulario',
                                store: stGrid,
                                layout: 'fit',
                                anchor: "100%",
                                height: screen.height-250,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        header: 'Paciente',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Paciente',
                                        width: 330,
                                        renderer: VerPaciente,
                                        hideable: false
                                    },
                                    {
                                        header: 'Entidad',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Cliente',
                                        width: 250,
                                        renderer: VerCliente,
                                        hideable: false
                                    },
                                    {
                                        header: 'Fecha',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FechaCita',
                                        width: 110,
                                        hideable: false
                                    },
                                    {
                                        header: 'Procedimiento',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Actividad',
                                        renderer: VerProcedimiento,
                                        width: 350,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.ux.grid.LockingGridView(),
                                columnLines: true,
                                tbar:
                                    {
                                        xtype: 'toolbar',
                                        items: [
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Actualizar Lista',
                                                iconCls: 'btnActualizarGrid',
                                                tooltip: 'Actualizar Lista',
                                                id: 'btnActualizarImgDx'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'tbfill'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Imprimir Reporte',
                                                iconCls: 'btnImprimir',
                                                tooltip: 'Imprimir Examen Seleccionado',
                                                id: 'btnimprimirImgDx'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Imprimir Todos los Examenes',
                                                iconCls: 'btnImprimir',
                                                tooltip: 'Imprimir Reporte',
                                                id: 'btnimprimirImgDxTodo'
                                            }
                                        ]
                                    }
                            }
                        ]
                    }
                ]
            }
        ];
        winFrmVerTranscripcionLaboUi.superclass.initComponent.call(this);
    }
});








